/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.data;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.InvalidTypeException;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public interface GenericMap
extends DataSerializable {
    public Entry add(String var1, GenericMap var2);

    public Entry add(String var1, Mappable var2);

    public Entry add(String var1, String var2);

    public Entry add(String var1, boolean var2);

    public Entry add(String var1, byte var2);

    public Entry add(String var1, short var2);

    public Entry add(String var1, int var2);

    public Entry add(String var1, long var2);

    public Entry add(String var1, float var2);

    public Entry add(String var1, double var2);

    public Entry addEntry(Entry var1);

    public Entry getEntry(int var1);

    public Entry getEntry(String var1);

    public Object getValue(String var1);

    public boolean getBoolean(String var1) throws NoSuchFieldException, InvalidTypeException;

    public byte getByte(String var1) throws NoSuchFieldException, InvalidTypeException;

    public char getChar(String var1) throws NoSuchFieldException, InvalidTypeException;

    public short getShort(String var1) throws NoSuchFieldException, InvalidTypeException;

    public int getInt(String var1) throws NoSuchFieldException, InvalidTypeException;

    public long getLong(String var1) throws NoSuchFieldException, InvalidTypeException;

    public float getFloat(String var1) throws NoSuchFieldException, InvalidTypeException;

    public double getDouble(String var1) throws NoSuchFieldException, InvalidTypeException;

    public String getString(String var1) throws NoSuchFieldException, InvalidTypeException;

    public Entry getEntryAt(int var1);

    public Object getValueAt(int var1);

    public String getNameAt(int var1);

    public int indexOf(String var1);

    public int lastIndexOf(String var1);

    public Entry getLastEntry();

    public Object getLastValue();

    public Entry getFirstEntry();

    public Object getFirstValue();

    public boolean hasGenericData();

    public boolean remove(Entry var1);

    public Entry remove(int var1);

    public Collection getEntries();

    public int size();

    public Entry[] getAllEntries();

    public Entry[] getAllPrimitives();

    public int getPrimitiveCount();

    public Entry[] getAllGenericData();

    public int getGenericDataCount();

    public void clear();

    public void dump(OutputStream var1);

    public Object clone();

    public static class Entry
    implements DataSerializable {
        public static final byte TYPE_GENERIC_DATA = 1;
        public static final byte TYPE_MAPPABLE = 2;
        public static final byte TYPE_BYTE = 3;
        public static final byte TYPE_CHAR = 4;
        public static final byte TYPE_DOUBLE = 5;
        public static final byte TYPE_FLOAT = 6;
        public static final byte TYPE_INTEGER = 7;
        public static final byte TYPE_LONG = 8;
        public static final byte TYPE_SHORT = 9;
        public static final byte TYPE_BOOLEAN = 10;
        public static final byte TYPE_STRING = 11;
        private byte type = 1;
        private String key;
        private Object value;

        public Entry() {
        }

        public Entry(String key2, Object value2, byte type) {
            this.key = key2;
            this.value = value2;
            this.type = type;
        }

        public Entry(String key2, GenericMap value2) {
            this(key2, value2, 1);
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public short getType() {
            return this.type;
        }

        public int intValue() throws InvalidTypeException {
            if (this.type == 7) {
                return (Integer)this.value;
            }
            if (this.type == 8) {
                return ((Long)this.value).intValue();
            }
            if (this.type == 3) {
                return ((Byte)this.value).intValue();
            }
            if (this.type == 4) {
                return Character.getNumericValue(((Character)this.value).charValue());
            }
            if (this.type == 9) {
                return ((Short)this.value).intValue();
            }
            if (this.type == 6) {
                return ((Float)this.value).intValue();
            }
            if (this.type == 5) {
                return ((Double)this.value).intValue();
            }
            if (this.type == 10) {
                if (((Boolean)this.value).booleanValue()) {
                    return 1;
                }
                return 0;
            }
            throw new InvalidTypeException(this.value.getClass() + ": Unable to convert object to int.");
        }

        public boolean isPrimitive() {
            return this.type == 3 || this.type == 4 || this.type == 5 || this.type == 6 || this.type == 7 || this.type == 8 || this.type == 9 || this.type == 10;
        }

        @Override
        public void fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
            this.type = dataInput.readByte();
            this.key = DataSerializer.readString(dataInput);
            this.value = DataSerializer.readObject(dataInput);
        }

        @Override
        public void toData(DataOutput dataOutput) throws IOException {
            dataOutput.writeByte(this.type);
            DataSerializer.writeString(this.key, dataOutput);
            DataSerializer.writeObject(this.value, dataOutput);
        }
    }
}

