/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class InstantiatorClassLoader {
    public static String loadDataSerializables() throws IOException, ClassNotFoundException {
        String dataSerializableFilePath = System.getProperty("dataSerializableFilePath", "etc/DataSerializables.txt");
        return InstantiatorClassLoader.loadDataSerializables(dataSerializableFilePath);
    }

    public static String loadDataSerializables(String filePath) throws IOException, ClassNotFoundException {
        File file;
        if ((filePath = filePath.trim()).startsWith("/") || filePath.indexOf(58) >= 0) {
            file = new File(filePath);
        } else {
            String userDir = System.getProperty("user.dir");
            file = new File(userDir, filePath);
        }
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        String line = reader.readLine();
        StringBuffer buffer = new StringBuffer(1000);
        while (line != null) {
            String className = line.trim();
            if (className.length() > 0 && !className.startsWith("#")) {
                Class.forName(className);
                buffer.append(className);
                buffer.append(", ");
            }
            line = reader.readLine();
        }
        reader.close();
        int endIndex = buffer.lastIndexOf(", ");
        String classList = endIndex == buffer.length() - 2 ? buffer.substring(0, endIndex) : buffer.toString();
        return classList;
    }
}

