/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.InstantiatorClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Properties;

public class CacheBase {
    public static final String PROPERTY_SYSTEM_REGION_PATH = "systemRegionPath";
    protected DistributedSystem distributedSystem;
    protected Cache cache;
    protected LogWriter logger;

    public static void startLocator(String address, int port, String logFile) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(address);
        Locator.startLocatorAndDS(port, new File(logFile), inetAddress, new Properties());
    }

    protected void initializeCache() throws CacheException, IOException {
        try {
            InstantiatorClassLoader.loadDataSerializables();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.open();
    }

    protected void initializeLogStatsResources() {
        String statArchive;
        String gemfirePropertyFile = System.getProperty("gemfirePropertyFile");
        Properties props = new Properties();
        try {
            File propFile;
            if (gemfirePropertyFile != null && (propFile = new File(gemfirePropertyFile)).exists()) {
                FileInputStream fis = new FileInputStream(gemfirePropertyFile);
                props.load(fis);
                fis.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String pid = String.valueOf(OSProcess.getId());
        String logFile = System.getProperty("gemfire.log-file");
        if (logFile == null && (logFile = props.getProperty("log-file")) == null) {
            String gfshLogFileFormat = System.getProperty("gfsh.log-file-format");
            logFile = MessageFormat.format(gfshLogFileFormat, pid);
            System.setProperty("gemfire.log-file", logFile);
        }
        if ((statArchive = System.getProperty("gemfire.statistic-archive-file")) == null && (statArchive = props.getProperty("statistic-archive-file")) == null) {
            String gfshLogFileFormat = System.getProperty("gfsh.stat-file-format");
            statArchive = MessageFormat.format(gfshLogFileFormat, pid);
            System.setProperty("gemfire.statistic-archive-file", statArchive);
        }
    }

    protected void open() throws IOException {
        Properties properties = new Properties();
        this.distributedSystem = DistributedSystem.connect(properties);
        try {
            this.cache = CacheFactory.create(this.distributedSystem);
            this.cache.setLockLease(10);
            int bridgeServerPort = Integer.getInteger("bridgeServerPort", 0);
            String groups = System.getProperty("serverGroups");
            String[] serverGroups = null;
            if (groups != null) {
                serverGroups = groups.split(",");
            }
            if (bridgeServerPort != 0) {
                this.cache.setIsServer(true);
                CacheServer server = this.cache.addCacheServer();
                server.setPort(bridgeServerPort);
                server.setNotifyBySubscription(true);
                server.setGroups(serverGroups);
                server.start();
            }
        }
        catch (CacheExistsException ex) {
            this.cache = CacheFactory.getAnyInstance();
        }
        if (this.cache != null) {
            this.logger = this.cache.getLogger();
        }
    }

    protected void close() {
        if (this.cache != null) {
            this.cache.close();
        }
    }

    public DistributedSystem getDistributedSystem() {
        return this.distributedSystem;
    }

    public Cache getGemFireCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForever() throws InterruptedException {
        Object obj;
        Object object = obj = new Object();
        synchronized (object) {
            obj.wait();
        }
    }

    public LogWriter getLogger() {
        return this.cache.getLogger();
    }

    public static void main(String[] args) throws Exception {
        CacheBase base = new CacheBase();
        base.initializeCache();
    }

    public Cache getCache() {
        return this.cache;
    }
}

