/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.functions.util;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LocalRegionInfoFunction
implements AggregateFunction,
DataSerializable {
    private static final long serialVersionUID = 1L;
    private String regionPath;
    private static boolean priorTo6011 = true;

    static boolean isPriorTo6011() {
        String gemfireVersion = GemFireVersion.getGemFireVersion();
        String[] split = gemfireVersion.split("\\.");
        int major = 0;
        int minor = 0;
        int update = 0;
        int update2 = 0;
        block12: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    major = Integer.parseInt(split[i]);
                    continue block12;
                }
                case 1: {
                    try {
                        minor = Integer.parseInt(split[i]);
                    }
                    catch (NumberFormatException ex) {
                        minor = Integer.parseInt(split[i].substring(0, 1));
                    }
                    continue block12;
                }
                case 2: {
                    try {
                        update = Integer.parseInt(split[i]);
                    }
                    catch (NumberFormatException ex) {}
                    continue block12;
                }
                case 3: {
                    try {
                        update2 = Integer.parseInt(split[i]);
                        continue block12;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (major < 6) {
            return true;
        }
        if (minor > 0) {
            return false;
        }
        if (update < 1) {
            return true;
        }
        if (update > 1) {
            return false;
        }
        return update2 <= 0;
    }

    public LocalRegionInfoFunction() {
    }

    public LocalRegionInfoFunction(String regionPath) {
        this.regionPath = regionPath;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public void setRegionPath(String regionPath) {
        this.regionPath = regionPath;
    }

    @Override
    public AggregateResults run(FunctionContext context) {
        AggregateResults results = new AggregateResults();
        Cache cache = CacheFactory.getAnyInstance();
        DistributedSystem ds = cache.getDistributedSystem();
        DistributedMember member = ds.getDistributedMember();
        Region region = cache.getRegion(this.regionPath);
        if (region == null) {
            results.setCode((byte)-1);
            results.setCodeMessage("Undefined region: " + this.regionPath);
            return results;
        }
        MapMessage message = new MapMessage();
        message.put("MemberId", member.getId());
        message.put("MemberName", ds.getName());
        message.put("Host", member.getHost());
        message.put("Pid", member.getProcessId());
        message.put("RegionPath", this.regionPath);
        boolean isPR = region instanceof PartitionedRegion;
        message.put("IsPR", isPR);
        if (isPR) {
            PartitionedRegion pr2 = (PartitionedRegion)region;
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy h:mm:ss.SSS a");
            message.put("LastAccessedTime", format.format(new Date(pr2.getLastAccessedTime())));
            message.put("LastModifiedTime", format.format(new Date(pr2.getLastModifiedTime())));
            int totalRegionSize = 0;
            if (pr2.getDataStore() == null) {
                message.put("IsPeerClient", true);
            } else {
                List bucketIdList = pr2.getDataStore().getLocalPrimaryBucketsListTestOnly();
                for (Integer bucketId : bucketIdList) {
                    try {
                        BucketRegion bucketRegion = pr2.getDataStore().getInitializedBucketForId(null, bucketId);
                        totalRegionSize += bucketRegion.size();
                    }
                    catch (ForceReattemptException e) {}
                }
                message.put("IsPeerClient", false);
            }
            message.put("RegionSize", totalRegionSize);
        } else {
            message.put("IsPeerClient", false);
            message.put("RegionSize", region.size());
            message.put("Scope", region.getAttributes().getScope().toString());
        }
        message.put("DataPolicy", region.getAttributes().getDataPolicy().toString());
        results.setDataObject(message);
        return results;
    }

    @Override
    public Object aggregate(List list) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            AggregateResults results = (AggregateResults)list.get(i);
            if (results.getCode() == -1 || results.getDataObject() == null) continue;
            resultList.add(results.getDataObject());
        }
        return resultList;
    }

    @Override
    public Object aggregateDistributedSystems(Object[] results) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            list.add(results[i]);
        }
        return list;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializer.readString(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializer.writeString(this.regionPath, output);
    }

    static {
        priorTo6011 = LocalRegionInfoFunction.isPriorTo6011();
    }
}

