/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.aggregator;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregateFunctionTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorException;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandException;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;

class SingleAggregator {
    private CommandClient commandClient;

    SingleAggregator(String commandRegionFullPath, String endpoints) {
        this.commandClient = new CommandClient(commandRegionFullPath, endpoints);
    }

    SingleAggregator(CommandClient commandClient) {
        this.commandClient = commandClient;
    }

    Object aggregate(AggregateFunction function, String regionFullPath) throws AggregatorException {
        try {
            CommandResults results = this.commandClient.execute(new AggregateFunctionTask(function, regionFullPath));
            if (results.getCode() != 0) {
                throw new AggregatorException(results.getCodeMessage(), results.getException());
            }
            return results.getDataObject();
        }
        catch (Exception ex) {
            throw new AggregatorException(ex);
        }
    }

    String getCommandRegionFullPath() {
        return this.commandClient.getOutboxRegionFullPath();
    }

    String getEndpoints() {
        return this.commandClient.getEndpoints();
    }

    public void close() throws AggregatorException {
        try {
            this.commandClient.close();
        }
        catch (CommandException ex) {
            throw new AggregatorException(ex);
        }
    }

    public boolean isClosed() {
        return this.commandClient.isClosed();
    }
}

