/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.aggregator;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AggregatorPeer {
    PartitionedRegion region;
    Execution execution;
    private long timeout = 30000L;
    private Set routingKeySet;

    public AggregatorPeer(String regionFullPath) {
        Cache cache = CacheFactory.getAnyInstance();
        this.region = (PartitionedRegion)cache.getRegion(regionFullPath);
        this.init();
    }

    public AggregatorPeer(Region region) {
        this.region = (PartitionedRegion)region;
        this.init();
    }

    private void init() {
        this.execution = FunctionService.onMembers(this.region.getCache().getDistributedSystem());
        int totalNumBuckets = this.region.getPartitionAttributes().getTotalNumBuckets();
        this.routingKeySet = new CopyOnWriteArraySet();
        for (int i = 0; i < totalNumBuckets; ++i) {
            this.routingKeySet.add(i);
        }
    }

    public void setRoutingKeys(Set routingKeySet) {
        this.routingKeySet = routingKeySet;
    }

    public Set getRoutingKeys() {
        return this.routingKeySet;
    }

    public Region getRegion() {
        return this.region;
    }

    public Object aggregate(AggregateFunction function) throws AggregatorException {
        return this.aggregate(function, this.routingKeySet);
    }

    private Object aggregate(AggregateFunction function, Set routingKeySet) throws AggregatorException {
        try {
            Object obj = this.execution.withArgs(function).execute("__gfsh_aggregator").getResult();
            if (obj instanceof List) {
                List list = (List)obj;
                return function.aggregate(list);
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                ArrayList list = new ArrayList();
                Collection col = map.values();
                for (List list2 : col) {
                    list.addAll(list2);
                }
                return function.aggregate(list);
            }
            throw new AggregatorException("Unsupported aggregate result type: " + obj.getClass().getName());
        }
        catch (Exception ex) {
            throw new AggregatorException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object aggregate(AggregateFunction function, Aggregator aggregatorClient) throws AggregatorException {
        if (aggregatorClient == null) {
            return this.aggregate(function);
        }
        ArrayList resultsList = new ArrayList();
        ArrayList exceptionList = new ArrayList();
        long count = 2L;
        new Thread(new LocalAggregator(function, resultsList, exceptionList)).start();
        int i = 0;
        while ((long)i < count - 1L) {
            new Thread(new DSAggregator(function, aggregatorClient, resultsList, exceptionList)).start();
            ++i;
        }
        boolean allResponded = false;
        long startTime = System.currentTimeMillis();
        do {
            try {
                this.wait(this.timeout);
                ArrayList arrayList = resultsList;
                synchronized (arrayList) {
                    boolean bl = allResponded = (long)resultsList.size() == count;
                    if (!allResponded && !exceptionList.isEmpty()) {
                        break;
                    }
                }
                if (allResponded || System.currentTimeMillis() - startTime < this.timeout) continue;
                break;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!allResponded);
        if (!allResponded) {
            if (!exceptionList.isEmpty()) {
                throw new AggregatorException("Distributed System Error. Errors from " + exceptionList.size() + " distributed system(s). See getClientExceptions()", exceptionList.toArray(new Throwable[0]));
            }
            throw new AggregatorException("The aggregate operation timedout. Not all distributed systems responded within the timeout period of " + this.timeout + " msec.");
        }
        Object[] results = resultsList.toArray();
        return function.aggregateDistributedSystems(results);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private synchronized void notifyResults() {
        this.notify();
    }

    class DSAggregator
    implements Runnable {
        private AggregateFunction function;
        private Aggregator aggregatorClient;
        private ArrayList resultsList;
        private ArrayList exceptionList;

        DSAggregator(AggregateFunction function, Aggregator aggregatorClient, ArrayList resultsList, ArrayList exceptionList) {
            this.function = function;
            this.aggregatorClient = aggregatorClient;
            this.resultsList = resultsList;
            this.exceptionList = exceptionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object results = this.aggregatorClient.aggregate(this.function, AggregatorPeer.this.region.getFullPath());
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.resultsList.add(results);
                }
                AggregatorPeer.this.notifyResults();
            }
            catch (AggregatorException ex) {
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.exceptionList.add(ex);
                }
                AggregatorPeer.this.notifyResults();
            }
        }
    }

    class LocalAggregator
    implements Runnable {
        private AggregateFunction function;
        private ArrayList resultsList;
        private ArrayList exceptionList;

        LocalAggregator(AggregateFunction function, ArrayList resultsList, ArrayList exceptionList) {
            this.function = function;
            this.resultsList = resultsList;
            this.exceptionList = exceptionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object results = AggregatorPeer.this.aggregate(this.function);
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.resultsList.add(results);
                }
                AggregatorPeer.this.notifyResults();
            }
            catch (AggregatorException ex) {
                ArrayList arrayList = this.resultsList;
                synchronized (arrayList) {
                    this.exceptionList.add(ex);
                }
                AggregatorPeer.this.notifyResults();
            }
        }
    }
}

