/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.aggregator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorPeer;
import com.gemstone.gemfire.internal.tools.gfsh.command.AbstractCommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AggregateFunctionTask
extends AbstractCommandTask {
    private static final long serialVersionUID = 1L;
    private String regionFullPath;
    private AggregateFunction function;

    public AggregateFunctionTask() {
    }

    public AggregateFunctionTask(AggregateFunction function, String regionFullPath) {
        this.function = function;
        this.regionFullPath = regionFullPath;
    }

    @Override
    public CommandResults runTask(Object userData) {
        CommandResults results = new CommandResults();
        try {
            AggregatorPeer aggregator = new AggregatorPeer(this.regionFullPath);
            results.setDataObject(aggregator.aggregate(this.function));
        }
        catch (Exception ex) {
            results.setCode((byte)-1);
            results.setException(ex);
        }
        return results;
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        super.fromData(input);
        this.regionFullPath = DataSerializer.readString(input);
        this.function = (AggregateFunction)DataSerializer.readObject(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        super.toData(output);
        DataSerializer.writeString(this.regionFullPath, output);
        DataSerializer.writeObject(this.function, output);
    }
}

