/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GfshVersion {
    protected static String RESOURCE_NAME = "GfshVersion.properties";
    private static final Pattern MAJOR_MINOR = Pattern.compile("(\\d+)\\.(\\d*)(.*)");
    private static GfshVersion instance;
    private static final String PRODUCT_NAME = "Product-Name";
    private static final String PRODUCT_VERSION = "Product-Version";
    private static final String SOURCE_DATE = "Source-Date";
    private static final String SOURCE_REVISION = "Source-Revision";
    private static final String SOURCE_REPOSITORY = "Source-Repository";
    private static final String BUILD_DATE = "Build-Date";
    private static final String BUILD_ID = "Build-Id";
    private static final String BUILD_PLATFORM = "Build-Platform";
    private static final String BUILD_JAVA_VERSION = "Build-Java-Version";
    private String error = null;
    private String productName;
    private String gfshVersion;
    private String sourceDate;
    private String sourceRevision;
    private String sourceRepository;
    private String buildDate;
    private String buildId;
    private String buildPlatform;
    private String buildJavaVersion;

    private GfshVersion() {
        String gfeVersionPath = GemFireVersion.class.getPackage().getName().replace('.', '/');
        String gfshVersionPath = GfshVersion.class.getPackage().getName().replace('.', '/');
        gfshVersionPath = gfshVersionPath + "/" + RESOURCE_NAME;
        String xtraGfshVersionPath = gfshVersionPath.substring(gfeVersionPath.length() + 1);
        InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), gfshVersionPath);
        if (is == null) {
            this.error = LocalizedStrings.GemFireVersion_COULD_NOT_FIND_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0.toLocalizedString(xtraGfshVersionPath);
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (Exception ex) {
            this.error = LocalizedStrings.GemFireVersion_COULD_NOT_READ_PROPERTIES_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0_BECAUSE_1.toLocalizedString(xtraGfshVersionPath, ex);
            return;
        }
        this.productName = props.getProperty(PRODUCT_NAME);
        if (this.productName == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_NAME, xtraGfshVersionPath);
            return;
        }
        this.gfshVersion = props.getProperty(PRODUCT_VERSION);
        if (this.gfshVersion == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_VERSION, xtraGfshVersionPath);
            return;
        }
        this.sourceDate = props.getProperty(SOURCE_DATE);
        if (this.sourceDate == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_DATE, xtraGfshVersionPath);
            return;
        }
        this.sourceRevision = props.getProperty(SOURCE_REVISION);
        if (this.sourceRevision == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REVISION, xtraGfshVersionPath);
            return;
        }
        this.sourceRepository = props.getProperty(SOURCE_REPOSITORY);
        if (this.sourceRepository == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REPOSITORY, xtraGfshVersionPath);
            return;
        }
        this.buildDate = props.getProperty(BUILD_DATE);
        if (this.buildDate == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_DATE, xtraGfshVersionPath);
            return;
        }
        this.buildId = props.getProperty(BUILD_ID);
        if (this.buildId == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_ID, xtraGfshVersionPath);
            return;
        }
        this.buildPlatform = props.getProperty(BUILD_PLATFORM);
        if (this.buildPlatform == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_PLATFORM, xtraGfshVersionPath);
            return;
        }
        this.buildJavaVersion = props.getProperty(BUILD_JAVA_VERSION);
        if (this.buildJavaVersion == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_JAVA_VERSION, xtraGfshVersionPath);
            return;
        }
    }

    private static GfshVersion getInstance() {
        if (instance == null) {
            instance = new GfshVersion();
        }
        return instance;
    }

    public static String getProductName() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.productName;
    }

    public static String getGfshVersion() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.gfshVersion;
    }

    public static String getJavaCodeVersion() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        StringBuilder result = new StringBuilder(80);
        result.append(GfshVersion.getGfshVersion()).append(' ').append(GfshVersion.getBuildId()).append(' ').append(GfshVersion.getBuildDate()).append(" javac ").append(GfshVersion.getBuildJavaVersion());
        return result.toString();
    }

    public static String getSourceDate() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceDate;
    }

    public static String getSourceRevision() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceRevision;
    }

    public static String getSourceRepository() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceRepository;
    }

    public static String getBuildDate() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildDate;
    }

    public static String getBuildId() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildId;
    }

    public static String getBuildPlatform() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildPlatform;
    }

    public static String getBuildJavaVersion() {
        GfshVersion v = GfshVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildJavaVersion;
    }

    public static String asString(boolean printSourceInfo) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        GfshVersion.print(pw, printSourceInfo);
        pw.flush();
        return sw.toString();
    }

    protected static void print(PrintWriter pw, boolean printSourceInfo) {
        String jarVersion = GfshVersion.getJavaCodeVersion().trim();
        pw.println(GfshVersion.getProductName() + " version: " + jarVersion);
        if (printSourceInfo) {
            String sourceRevision = GfshVersion.getSourceRevision();
            pw.println("Source revision: " + sourceRevision);
            String sourceRepository = GfshVersion.getSourceRepository();
            pw.println("Source repository: " + sourceRepository);
        }
        InetAddress host = null;
        try {
            host = SocketCreator.getLocalHost();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        int cpuCount = Runtime.getRuntime().availableProcessors();
        pw.println(LocalizedStrings.GemFireVersion_RUNNING_ON_0.toLocalizedString(host + ", " + cpuCount + " cpu(s)" + ", " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version")));
        pw.flush();
    }

    public static int getMajorVersion(String v) {
        String digits;
        int majorVersion = 0;
        Matcher m = MAJOR_MINOR.matcher(v);
        if (m.matches() && (digits = m.group(1)) != null && digits.length() > 0) {
            majorVersion = Integer.decode(digits);
        }
        return majorVersion;
    }

    public static int getMinorVersion(String v) {
        String digits;
        int minorVersion = 0;
        Matcher m = MAJOR_MINOR.matcher(v);
        if (m.matches() && (digits = m.group(2)) != null && digits.length() > 0) {
            minorVersion = Integer.decode(digits);
        }
        return minorVersion;
    }

    public static final void main(String[] args) {
        System.out.println(GfshVersion.asString(true));
    }

    static {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            if (cache != null && cache.isServer() && cache.getLogger() != null) {
                cache.getLogger().config("gfsh version: " + GfshVersion.getJavaCodeVersion());
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }
}

