/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.GfshVersion;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.CacheBase;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.InstantiatorClassLoader;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.LookupService;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.EchoTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RefreshAggregatorRegionTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ClassFinder;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.StringUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.ObjectUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.SimplePrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.SimpleCompletor;

public class Gfsh
extends CacheBase {
    public static final String PROPERTY_GFSH_INIT_FILE = "gfshInitFile";
    public static final String PROPERTY_DEFAULT_DATA_SERIALIZABLES_FILE = "gfsh.dataSerialiables.file";
    public static final String PROPERTY_COMMAND_JAR_PATH = "gfsh.command.jar.path";
    public static final String PROPERTY_COMMAND_OPT_JAR_PATH = "gfsh.command.opt.jar.path";
    public static final String PROPERTY_USER_COMMAND_JAR_PATHS = "gfsh.user.command.jar.paths";
    public static final String PROPERTY_USER_COMMAND_PACKAGES = "gfsh.user.command.packages";
    public static final String PROPERTY_PLUGIN_JARS = "gfsh.plugin.jars";
    private static final String PROMPT = "gfsh:";
    private static final Set<String> DISABLED_COMMANDS = new HashSet<String>();
    private boolean debug = Boolean.getBoolean("gfsh.debug");
    private String startupDir = System.getProperty("gfsh.pwd");
    private String locators;
    private String servers;
    private String inputFilePath;
    private String dataSerializableClassNames;
    private String dataSerializablesFilePath;
    private String jarDirectoryPath;
    private String jarPaths;
    private TreeSet<String> enumCommandSet = new TreeSet();
    private boolean isAdvancedMode;
    private static final String[] advancedCommands = new String[]{"bcp", "class", "db", "deploy", "gc", "rebalance"};
    private HashMap commandMap = new HashMap();
    private boolean echo = false;
    private long zoneDifference = 0L;
    private boolean showTime = true;
    private boolean showResults;
    private String queryKeyClassName;
    private Class<?> queryKeyClass;
    private String valueClassName;
    private Class<?> valueClass;
    private LookupService lookupService;
    private String endpoints = "localhost:40401";
    private int readTimeout = 300000;
    private boolean isLocator = false;
    private String serverGroup = null;
    private Pool pool;
    private Properties envProperties = new Properties();
    private CommandClient commandClient;
    private String commandRegionPath = "/__command";
    private String aggregateRegionPath = this.commandRegionPath + "/pr";
    private Aggregator aggregator;
    private String currentPath = "/";
    private Region<?, ?> currentRegion;
    private List<?> lsKeyList;
    private int selectLimit;
    private int fetchSize = 100;
    private boolean tableFormat = false;
    private boolean printType = true;
    private int collectionEntryPrintCount;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ConsoleReader consoleReader;
    private BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
    private String[] commands;
    private TreeMap<String, Mappable> memberMap = new TreeMap();

    public Gfsh(String[] args) throws Exception {
        this.parseArgs(args);
        this.println();
        this.initCommands();
        this.initJline();
        this.initializeLogStatsResources();
        this.initializeCache();
        this.setEcho(false);
        this.setShowResults(true);
        this.setShowTime(true);
        this.postInit(args);
        this.println();
        if (!this.isConnected()) {
            this.println("Warning: not connected. Use the 'connect' command to connect to");
            this.println("         locator(s) or cache server(s).");
            this.println();
        }
    }

    @Override
    protected void initializeCache() throws CacheException, IOException {
        block6: {
            block5: {
                try {
                    Class.forName("com.gemstone.gemfire.internal.tools.gfsh.app.DataSerializablesInitializer");
                }
                catch (ClassNotFoundException ex) {
                    this.println("Error: ClassNotFoundException. Unable to load the utility classes - " + ex.getMessage());
                    if (!this.isDebug()) break block5;
                    ex.printStackTrace();
                }
            }
            try {
                String defaultDataSerializablesFilePath = System.getProperty(PROPERTY_DEFAULT_DATA_SERIALIZABLES_FILE, "etc/DataSerializables.txt");
                InstantiatorClassLoader.loadDataSerializables(defaultDataSerializablesFilePath);
            }
            catch (IOException e) {
            }
            catch (ClassNotFoundException ex) {
                this.println("Error: ClassNotFoundException. Unabled to load class - " + ex.getMessage());
                if (!this.isDebug()) break block6;
                ex.printStackTrace();
            }
        }
    }

    private boolean isImplement(Class cls, Class interf) {
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != interf) continue;
            return true;
        }
        return false;
    }

    private void loadCommands(String packageName, String commandPackageName, HashSet<Class> classSet) throws Exception {
        Class[] classes = ClassFinder.getClasses(commandPackageName);
        if (classes.length == 0) {
            String jarPath = System.getProperty(packageName);
            classes = ClassFinder.getClasses(jarPath, commandPackageName);
        }
        List<String> commands = Arrays.asList(advancedCommands);
        for (int i = 0; i < classes.length; ++i) {
            if (!this.isImplement(classes[i], CommandExecutable.class)) continue;
            String commandName = classes[i].getSimpleName();
            if (!this.isAdvancedMode && commands.contains(commandName) || DISABLED_COMMANDS.contains(commandName)) continue;
            classSet.add(classes[i]);
        }
    }

    private void loadPlugins() {
        String pluginJars = System.getProperty(PROPERTY_PLUGIN_JARS);
        if (pluginJars == null) {
            return;
        }
        if ((pluginJars = pluginJars.trim()).length() == 0) {
            return;
        }
        String pathSeparator = System.getProperty("path.separator");
        String[] split = pluginJars.split(pathSeparator);
        for (int i = 0; i < split.length; ++i) {
            try {
                ClassFinder.getAllClasses(split[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initCommands() throws Exception {
        HashSet<Class> classSet = new HashSet<Class>();
        this.loadCommands(PROPERTY_COMMAND_JAR_PATH, "com.gemstone.gemfire.internal.tools.gfsh.app.commands", classSet);
        String userPackageNames = System.getProperty(PROPERTY_USER_COMMAND_PACKAGES);
        if (userPackageNames != null) {
            String jarPaths;
            userPackageNames = userPackageNames.trim();
            String[] packageSplit = null;
            if (userPackageNames.length() > 0) {
                packageSplit = userPackageNames.split(",");
                for (int i = 0; i < packageSplit.length; ++i) {
                    Class[] classes2 = ClassFinder.getClasses(packageSplit[i]);
                    for (int j = 0; j < classes2.length; ++j) {
                        if (!this.isImplement(classes2[j], CommandExecutable.class)) continue;
                        classSet.add(classes2[j]);
                    }
                }
            }
            if ((jarPaths = System.getProperty(PROPERTY_USER_COMMAND_JAR_PATHS)) != null && packageSplit != null && (jarPaths = jarPaths.trim()).length() > 0) {
                String[] split = jarPaths.split(",");
                for (int i = 0; i < split.length; ++i) {
                    for (int k = 0; k < packageSplit.length; ++k) {
                        Class[] classes2 = ClassFinder.getClasses(split[i], packageSplit[k]);
                        for (int j = 0; j < classes2.length; ++j) {
                            if (!this.isImplement(classes2[j], CommandExecutable.class)) continue;
                            classSet.add(classes2[j]);
                        }
                    }
                }
            }
        }
        ArrayList<String> commandList = new ArrayList<String>();
        for (Class class1 : classSet) {
            commandList.add(this.getCommandName(class1));
        }
        Collections.sort(commandList);
        this.commands = commandList.toArray(new String[0]);
        for (Class commandClass : classSet) {
            Constructor constructor = commandClass.getConstructor(this.getClass());
            Object commandObject = constructor.newInstance(this);
            this.commandMap.put(this.getCommandName(commandObject.getClass()), commandObject);
        }
    }

    private String getCommandName(Class class1) {
        String name = class1.getSimpleName();
        if (name.equals("classloader")) {
            name = "class";
        }
        return name;
    }

    private void initFile(String relativeFilePath) throws IOException {
        String command;
        File etcDir;
        File gfshDir;
        if (this.dataSerializableClassNames != null) {
            String[] split = this.dataSerializableClassNames.split(",");
            for (int i = 0; i < split.length; ++i) {
                try {
                    Class<?> clazz = Class.forName(split[i]);
                    this.println("Loaded " + clazz.getName());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.println(split[i] + " - " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    if (!this.isDebug()) continue;
                    e.printStackTrace();
                }
            }
        }
        File dataSerializablesFile = null;
        if (this.dataSerializablesFilePath != null) {
            dataSerializablesFile = this.dataSerializablesFilePath.startsWith("/") || this.dataSerializablesFilePath.indexOf(58) >= 0 ? new File(this.dataSerializablesFilePath) : (this.startupDir != null ? new File(this.startupDir, this.dataSerializablesFilePath) : new File(this.dataSerializablesFilePath));
        }
        if (dataSerializablesFile != null) {
            if (!dataSerializablesFile.exists()) {
                this.println();
                this.println("Error: specified file does not exist: " + dataSerializablesFile.getAbsolutePath());
                this.println();
                System.exit(-1);
            }
            this.execute("class -d " + dataSerializablesFile.getAbsolutePath());
        }
        if (this.jarDirectoryPath != null) {
            File file = new File(this.jarDirectoryPath);
            if (!file.exists()) {
                this.println();
                this.println("Error: specified file does not exist: " + this.jarDirectoryPath);
                this.println();
                System.exit(-1);
            }
            this.execute("class -dir " + this.jarDirectoryPath);
        }
        if (this.jarPaths != null) {
            this.execute("class -jar " + this.jarPaths);
        }
        this.loadPlugins();
        File gfshrcFile = null;
        if (this.inputFilePath != null) {
            gfshrcFile = this.inputFilePath.startsWith("/") || this.inputFilePath.indexOf(58) >= 0 ? new File(this.inputFilePath) : (this.startupDir != null ? new File(this.startupDir, this.inputFilePath) : new File(this.inputFilePath));
        }
        String userHomeDir = System.getProperty("user.home");
        if (gfshrcFile != null) {
            if (!gfshrcFile.exists() || !gfshrcFile.isFile()) {
                this.println();
                this.println("Error: invalid input file - " + this.inputFilePath);
                this.println();
                System.exit(-1);
            }
        } else {
            gfshrcFile = new File(userHomeDir, relativeFilePath);
            if (!gfshrcFile.exists() && !(gfshrcFile = new File(userHomeDir, ".gfshrc")).exists()) {
                gfshrcFile.createNewFile();
            }
        }
        if (!(gfshDir = new File(userHomeDir, ".gemfire")).exists()) {
            gfshDir.mkdir();
        }
        if (!(etcDir = new File(gfshDir, "etc")).exists()) {
            etcDir.mkdir();
        }
        LineNumberReader reader = new LineNumberReader(new FileReader(gfshrcFile));
        String line = reader.readLine();
        ArrayList<String> commandList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        while (line != null) {
            command = line.trim();
            if (command.length() > 0 && !command.startsWith("#")) {
                if (command.endsWith("\\")) {
                    buffer.append(command.substring(0, command.length() - 1));
                } else {
                    buffer.append(command);
                    commandList.add(buffer.toString().trim());
                    buffer = new StringBuffer();
                }
            }
            line = reader.readLine();
        }
        reader.close();
        command = null;
        if (this.locators != null) {
            command = "connect -l " + this.locators;
        } else if (this.servers != null) {
            command = "connect -s " + this.servers;
        } else {
            command = "connect -s localhost:40404";
            this.println("Connecting using defaults: -s localhost:40404");
        }
        if (command != null) {
            this.execute(command);
        }
        Object commandName = null;
        for (int i = 0; i < commandList.size(); ++i) {
            command = (String)commandList.get(i);
            command = this.expandProperties(command);
            if (this.isEcho()) {
                this.println(command);
            }
            this.execute(command);
        }
    }

    public void setDebug(boolean debug2) {
        this.debug = debug2;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void execute(String command) {
        CommandExecutable executable;
        String commandName = null;
        if (command != null) {
            command = command.trim();
            String[] split = command.split(" ");
            commandName = split[0];
        }
        if (command == null || command.startsWith("exit") || command.startsWith("quit")) {
            this.close();
            System.exit(0);
        }
        if ((executable = this.getCommand(commandName)) == null) {
            this.println("Error: undefined command: " + commandName);
        } else {
            try {
                executable.execute(command);
            }
            catch (Exception ex) {
                this.getCache().getLogger().error("While executing '" + command + "'", ex);
                this.println("Error: " + command + " -- " + this.getCauseMessage(ex));
            }
        }
    }

    public CommandExecutable getCommand(String commandName) {
        if (commandName.equals("n")) {
            commandName = "next";
        } else if (commandName.equals("class")) {
            // empty if block
        }
        return (CommandExecutable)this.commandMap.get(commandName);
    }

    public String getEnumCommands() {
        return this.enumCommandSet.toString();
    }

    public void addEnumCommand(String command) {
        this.enumCommandSet.add(command);
    }

    private void postInit(String[] args) {
        block6: {
            block5: {
                String iniFilePath = System.getProperty(PROPERTY_GFSH_INIT_FILE, ".gfshrc");
                this.zoneDifference = 0L;
                this.endpoints = null;
                this.queryKeyClassName = null;
                this.fetchSize = 100;
                this.showResults = true;
                this.showTime = true;
                this.setCollectionEntryPrintCount(5);
                this.setPrintType(true);
                this.setTableFormat(true);
                try {
                    this.initFile(iniFilePath);
                }
                catch (IOException ex) {
                    this.println("Error: reading file " + iniFilePath + " -- " + this.getCauseMessage(ex));
                    if (!this.isDebug()) break block5;
                    ex.printStackTrace();
                }
            }
            if (this.cache == null) {
                try {
                    this.open();
                }
                catch (IOException ex) {
                    this.println("Error: unable to create cache - " + ex.getMessage());
                    if (!this.isDebug()) break block6;
                    ex.printStackTrace();
                }
            }
        }
    }

    public String getLine(String prompt) throws IOException {
        boolean keepGoing;
        if (prompt == null) {
            prompt = PROMPT + this.currentPath + ">";
        }
        StringBuffer cmdBuffer = null;
        do {
            String nextLine;
            keepGoing = false;
            if (this.consoleReader == null) {
                this.print(prompt);
                nextLine = this.bufferedReader.readLine();
            } else {
                nextLine = this.consoleReader.readLine(prompt);
            }
            if (this.isEcho()) {
                if (nextLine == null) {
                    this.println("EOF");
                } else if (nextLine.length() != 0) {
                    // empty if block
                }
            }
            if (nextLine == null) break;
            if (cmdBuffer == null) {
                cmdBuffer = new StringBuffer();
            }
            if (nextLine.endsWith("\\")) {
                nextLine = nextLine.substring(0, nextLine.length() - 1);
                keepGoing = true;
            }
            cmdBuffer.append(nextLine);
        } while (keepGoing);
        return cmdBuffer == null ? null : cmdBuffer.toString();
    }

    public Date getDate(String value2) throws ParseException {
        Date date = null;
        String lowercase = value2.toLowerCase();
        boolean error = false;
        if (!lowercase.startsWith("to_date")) {
            error = true;
        } else {
            String[] split2;
            int index2 = value2.indexOf(40);
            if (index2 == -1) {
                error = true;
            }
            if ((split2 = (value2 = value2.substring(index2 + 1)).split(",")).length != 2) {
                error = true;
            } else {
                for (int j = 0; j < split2.length; ++j) {
                    split2[j] = split2[j].trim();
                }
                String dateStr = StringUtil.trim(split2[0], '\'');
                String format = StringUtil.trim(StringUtil.trimRight(split2[1], ')'), '\'');
                this.dateFormat.applyPattern(format);
                date = this.dateFormat.parse(dateStr);
            }
        }
        if (error) {
            this.println("   Invalid date macro. Must use to_date('<date>', '<format>'). Ex, to_date('10/10/08', 'MM/dd/yy')");
        }
        return date;
    }

    public void println(Object obj) {
        System.out.println(obj);
    }

    public void println() {
        System.out.println();
    }

    public void print(String s) {
        System.out.print(s);
    }

    public void showHelp() {
        PrintStream out = System.out;
        out.println();
        out.println("Commands:");
        out.println();
        for (int i = 0; i < this.commands.length; ++i) {
            CommandExecutable exe = this.getCommand(this.commands[i]);
            exe.help();
        }
        out.println("exit or quit");
        out.println("     Close the current cache and exits");
        out.println();
    }

    public void showHelp(String command) {
        PrintStream out = System.out;
        CommandExecutable exe = this.getCommand(command);
        if (exe != null) {
            exe.help();
        } else {
            out.println("Could not find command: " + command);
        }
        out.println();
    }

    public List<Mappable> setMemberList(List<Mappable> memberMapList) {
        this.memberMap.clear();
        for (Mappable mappable : memberMapList) {
            try {
                String memberId = mappable.getString("MemberId");
                this.memberMap.put(memberId, mappable);
            }
            catch (Exception ex) {}
        }
        ArrayList<Mappable> sortedList = new ArrayList<Mappable>(this.memberMap.values());
        return sortedList;
    }

    public String getMemberId(int memberNumber) {
        Set<String> set = this.memberMap.keySet();
        int index2 = memberNumber - 1;
        if (set.size() > index2) {
            int i = 0;
            for (String memberId : set) {
                if (index2 != i) continue;
                return memberId;
            }
        }
        return null;
    }

    private void initJline() throws Exception {
        this.consoleReader = new ConsoleReader();
        this.consoleReader.setBellEnabled(false);
        History history = this.consoleReader.getHistory();
        if (history == null) {
            history = new History();
            this.consoleReader.setHistory(history);
        }
        File historyFile = new File(System.getProperty("user.home"), ".gfshhistory");
        history.setHistoryFile(historyFile);
        LinkedList<SimpleCompletor> completors = new LinkedList<SimpleCompletor>();
        completors.add(new SimpleCompletor(this.commands));
        this.consoleReader.addCompletor((Completor)new ArgumentCompletor(completors));
    }

    void go() {
        this.println();
        this.println("Enter 'help' or '?' for help at the command prompt.");
        this.println("");
        String commandName = null;
        while (true) {
            try {
                while (true) {
                    CommandExecutable executable;
                    this.println();
                    String command = this.getLine(null);
                    this.println();
                    if (command != null) {
                        command = command.trim();
                        command = this.expandProperties(command);
                        if (this.isEcho()) {
                            this.println(command);
                        }
                        String[] split = command.split(" ");
                        commandName = split[0];
                    }
                    if (command == null || command.startsWith("exit") || command.startsWith("quit")) {
                        this.close();
                        System.exit(0);
                    }
                    if ((executable = this.getCommand(commandName)) != null) {
                        executable.execute(command);
                        continue;
                    }
                    if (command.matches("\\(.*select.*")) {
                        executable = this.getCommand("select");
                    } else if (command.startsWith("?")) {
                        executable = this.getCommand("help");
                    }
                    if (executable != null) {
                        executable.execute(command);
                        continue;
                    }
                    if (command.length() == 0) continue;
                    this.println("Unrecognized command. Enter 'help' or '?' to get a list of commands.");
                }
            }
            catch (Exception ex) {
                this.println("Error: " + this.getCauseMessage(ex));
                if (!this.debug) continue;
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public String getCauseMessage(Throwable ex) {
        Throwable cause = ex.getCause();
        String causeMessage = null;
        if (cause != null) {
            causeMessage = this.getCauseMessage(cause);
        } else {
            causeMessage = ex.getClass().getSimpleName();
            causeMessage = causeMessage + " -- " + ex.getMessage();
        }
        return causeMessage;
    }

    public static boolean parseCommand(String command, List list) {
        StringReader in = new StringReader(command);
        StringBuffer currToken = new StringBuffer();
        String delim = " \t\n\r\f";
        boolean inQuotes = false;
        while (true) {
            int c;
            try {
                c = ((Reader)in).read();
            }
            catch (IOException e) {
                throw new Error("unexpected exception", e);
            }
            if (c < 0) break;
            if (c == 34) {
                if (inQuotes) {
                    inQuotes = false;
                    list.add(currToken.toString().trim());
                    currToken = new StringBuffer();
                    continue;
                }
                inQuotes = true;
                continue;
            }
            if (inQuotes) {
                currToken.append((char)c);
                continue;
            }
            if (delim.indexOf((char)c) >= 0) {
                if (currToken.length() <= 0) continue;
                list.add(currToken.toString().trim());
                currToken = new StringBuffer();
                continue;
            }
            currToken.append((char)c);
        }
        if (currToken.length() > 0) {
            list.add(currToken.toString().trim());
        }
        return true;
    }

    public Object getKeyFromKeyList(int keyNum) {
        int index2 = keyNum - 1;
        if (this.getLsKeyList() == null || this.getLsKeyList().size() <= index2) {
            return null;
        }
        return this.getLsKeyList().get(index2);
    }

    public Map getKeyMap(List list, int startIndex) {
        HashMap keyMap = new HashMap();
        for (int i = startIndex; i < list.size(); ++i) {
            String val = (String)list.get(i);
            String[] split = val.split("-");
            if (split.length == 2) {
                int startI = Integer.parseInt(split[0]);
                int endIndex = Integer.parseInt(split[1]);
                if (endIndex > this.getLsKeyList().size()) {
                    if (this.getLsKeyList().size() == 0) {
                        this.println("Error: Key list empty.");
                    } else {
                        this.println("Error: Out of range. Valid range: 1-" + this.getLsKeyList().size());
                    }
                    return keyMap;
                }
                for (int j = startI; j <= endIndex; ++j) {
                    Object key2 = this.getLsKeyList().get(j - 1);
                    keyMap.put(j, key2);
                }
                continue;
            }
            int index2 = Integer.parseInt(split[0]);
            Object key3 = this.getLsKeyList().get(index2 - 1);
            keyMap.put(index2, key3);
        }
        return keyMap;
    }

    public Object getQueryKey(List list, int startIndex) throws Exception {
        String input = (String)list.get(startIndex);
        Object key2 = null;
        if (input.startsWith("'")) {
            int lastIndex = -1;
            lastIndex = !input.endsWith("'") ? input.length() : input.lastIndexOf("'");
            if (lastIndex <= 1) {
                this.println("Error: Invalid key. Empty string not allowed.");
                return null;
            }
            key2 = input.subSequence(1, lastIndex);
        } else {
            key2 = ObjectUtil.getPrimitive(this, input, false);
        }
        if (key2 != null) {
            return key2;
        }
        if (this.queryKeyClass == null) {
            this.println("Error: key undefined. Use the key command to specify the key class.");
            return null;
        }
        String queryPredicate = "";
        for (int i = startIndex; i < list.size(); ++i) {
            queryPredicate = queryPredicate + list.get(i) + " ";
        }
        String[] split = queryPredicate.split("and");
        Object queryKey = this.queryKeyClass.newInstance();
        Map setterMap = ReflectionUtil.getAllSettersMap(queryKey.getClass());
        for (int i = 0; i < split.length; ++i) {
            String token = split[i];
            String[] tokenSplit = token.split("=");
            if (tokenSplit.length < 2) {
                this.println("Error: Invalid query: " + token);
                return null;
            }
            String field = tokenSplit[0].trim();
            String value2 = tokenSplit[1].trim();
            String setterMethodName = "set" + field;
            Method setterMethod = (Method)setterMap.get(setterMethodName);
            if (setterMethod == null) {
                this.println("Error: " + setterMethodName + " undefined in " + this.queryKeyClass.getName());
                return null;
            }
            Class<?>[] types = setterMethod.getParameterTypes();
            Class<?> arg = types[0];
            if (arg == Byte.TYPE || arg == Byte.class) {
                setterMethod.invoke(queryKey, Byte.parseByte(value2));
                continue;
            }
            if (arg == Character.TYPE || arg == Character.class) {
                setterMethod.invoke(queryKey, Character.valueOf(value2.charAt(0)));
                continue;
            }
            if (arg == Short.TYPE || arg == Short.class) {
                setterMethod.invoke(queryKey, Short.parseShort(value2));
                continue;
            }
            if (arg == Integer.TYPE || arg == Integer.class) {
                setterMethod.invoke(queryKey, Integer.parseInt(value2));
                continue;
            }
            if (arg == Long.TYPE || arg == Long.class) {
                setterMethod.invoke(queryKey, Long.parseLong(value2));
                continue;
            }
            if (arg == Float.TYPE || arg == Float.class) {
                setterMethod.invoke(queryKey, Float.valueOf(Float.parseFloat(value2)));
                continue;
            }
            if (arg == Double.TYPE || arg == Double.class) {
                setterMethod.invoke(queryKey, Double.parseDouble(value2));
                continue;
            }
            if (arg == Date.class) {
                Date date = this.getDate(value2);
                if (date == null) {
                    this.println("Error: Unable to parse date.");
                    return null;
                }
                setterMethod.invoke(queryKey, date);
                continue;
            }
            if (arg == String.class) {
                if (value2.startsWith("'") && (value2 = value2.substring(1)).endsWith("'")) {
                    value2 = value2.substring(0, value2.length() - 1);
                }
                setterMethod.invoke(queryKey, value2);
                continue;
            }
            this.println("Error: Unsupported type: " + setterMethod.getName() + "(" + arg.getName() + ")");
            return null;
        }
        return queryKey;
    }

    public int printSelectResults(SelectResults sr, int rowCount) {
        if (sr == null) {
            this.println("Error: SelectResults is null");
            return 0;
        }
        StringBuffer sb = new StringBuffer();
        CollectionType type = sr.getCollectionType();
        sb.append(sr.size());
        sb.append(" results in a collection of type ");
        sb.append(type);
        sb.append("\n");
        ObjectType elementType = type.getElementType();
        int row = 1;
        if (rowCount == -1) {
            rowCount = Integer.MAX_VALUE;
        }
        Iterator iter = sr.iterator();
        while (iter.hasNext() && row <= rowCount) {
            Object element = iter.next();
            if (elementType.isStructType()) {
                StructType structType = (StructType)elementType;
                Struct struct = (Struct)element;
                ObjectType[] fieldTypes = structType.getFieldTypes();
                String[] fieldNames = structType.getFieldNames();
                Object[] fieldValues = struct.getFieldValues();
                sb.append("  Struct with ");
                sb.append(fieldTypes.length);
                sb.append(" fields\n");
                for (int i = 0; i < fieldTypes.length; ++i) {
                    ObjectType fieldType = fieldTypes[i];
                    String fieldName = fieldNames[i];
                    Object fieldValue = fieldValues[i];
                    sb.append("    ");
                    sb.append(fieldValue.getClass().getName());
                    sb.append(" ");
                    if (element.getClass().isPrimitive()) {
                        sb.append(fieldName);
                    } else {
                        sb.append(ReflectionUtil.toStringGettersAnd(fieldName));
                    }
                    sb.append(" = ");
                    if (fieldValue instanceof String || element.getClass().isPrimitive()) {
                        sb.append(fieldValue);
                    } else {
                        sb.append(ReflectionUtil.toStringGettersAnd(fieldValue));
                    }
                    sb.append("\n");
                }
            } else {
                sb.append("  ");
                sb.append(row);
                sb.append(". ");
                if (element instanceof String || element.getClass().isPrimitive()) {
                    sb.append(element);
                } else {
                    sb.append(ReflectionUtil.toStringGettersAnd(element));
                }
            }
            sb.append("\n");
            ++row;
        }
        this.println(sb);
        return row - 1;
    }

    public void refreshAggregatorRegion() {
        this.commandClient.execute(new RefreshAggregatorRegionTask());
    }

    public void printEntry(Object key2, Object value2) {
        if (key2 instanceof String || key2.getClass().isPrimitive()) {
            System.out.print(key2);
        } else {
            System.out.print(ReflectionUtil.toStringGettersAnd(key2));
        }
        System.out.print(" ==> ");
        if (value2 instanceof String || value2.getClass().isPrimitive()) {
            System.out.print(value2);
        } else {
            System.out.print(ReflectionUtil.toStringGettersAnd(value2));
        }
    }

    public String getFullPath(String newPath, String currentPath) {
        if (newPath == null) {
            return null;
        }
        if (newPath.startsWith("/")) {
            return newPath;
        }
        if (currentPath == null) {
            currentPath = "/";
        }
        String path = currentPath;
        String[] split = currentPath.split("/");
        Stack<String> pathStack = new Stack<String>();
        for (int i = 0; i < split.length; ++i) {
            if (split[i].length() == 0) continue;
            pathStack.add(split[i]);
        }
        split = newPath.split("/");
        boolean invalidPath = false;
        for (int i = 0; i < split.length; ++i) {
            if (split[i].length() == 0) continue;
            String dirName = split[i];
            if (dirName.equals("..")) {
                if (pathStack.size() == 0) {
                    invalidPath = true;
                    break;
                }
                pathStack.pop();
                continue;
            }
            if (dirName.equals(".")) continue;
            pathStack.add(dirName);
        }
        if (invalidPath) {
            return null;
        }
        String fullPath = "";
        while (pathStack.size() > 0) {
            fullPath = "/" + pathStack.pop() + fullPath;
        }
        if (fullPath.length() == 0) {
            fullPath = "/";
        }
        return fullPath;
    }

    public void reconnect() throws Exception {
        if (this.commandClient != null) {
            try {
                this.commandClient.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.lookupService != null) {
            try {
                this.lookupService.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.aggregator != null) {
            try {
                this.aggregator.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.close();
        this.open();
        PoolFactory factory = PoolManager.createFactory();
        factory.setReadTimeout(this.readTimeout);
        String[] split = this.endpoints.split(",");
        for (int i = 0; i < split.length; ++i) {
            String locator = split[i];
            String[] sp2 = locator.split(":");
            String host = sp2[0];
            int port = Integer.parseInt(sp2[1]);
            if (this.isLocator) {
                factory.addLocator(host, port);
            } else {
                factory.addServer(host, port);
            }
            if (this.serverGroup == null) continue;
            factory.setServerGroup(this.serverGroup);
        }
        this.pool = factory.create("connectionPool");
        this.commandClient = new CommandClient(this.commandRegionPath, this.pool);
        this.lookupService = new LookupService(this.commandClient);
        this.aggregator = new Aggregator(this.commandClient);
        if (this.logger != null && this.logger.configEnabled()) {
            this.logger.config("Available Commands : " + Arrays.toString(this.commands));
        }
    }

    public Pool getPool() {
        return this.pool;
    }

    public boolean isConnected() {
        try {
            CommandResults results = this.commandClient.execute(new EchoTask("hello, world"));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void close() {
        if (this.cache != null && !this.cache.isClosed()) {
            this.cache.close();
        }
    }

    public boolean isShowResults() {
        return this.showResults;
    }

    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String regionPath) {
        this.currentPath = regionPath;
    }

    public Region getCurrentRegion() {
        return this.currentRegion;
    }

    public void setCurrentRegion(Region region) {
        this.currentRegion = region;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo2) {
        this.echo = echo2;
    }

    public long getZoneDifference() {
        return this.zoneDifference;
    }

    public void setZoneDifference(long zoneDifference) {
        this.zoneDifference = zoneDifference;
    }

    public String getQueryKeyClassName() {
        return this.queryKeyClassName;
    }

    public void setQueryKeyClassName(String queryKeyClassName) {
        this.queryKeyClassName = queryKeyClassName;
    }

    public Class getQueryKeyClass() {
        return this.queryKeyClass;
    }

    public void setQueryKeyClass(Class queryKeyClass) {
        this.queryKeyClass = queryKeyClass;
    }

    public void setKeyClass(String queryKeyClassName) {
        try {
            this.queryKeyClass = Class.forName(queryKeyClassName);
            this.queryKeyClassName = queryKeyClassName;
        }
        catch (ClassNotFoundException e) {
            this.println(e.getMessage());
        }
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public void setValueClass(String valueClassName) {
        try {
            this.valueClass = Class.forName(valueClassName);
            this.valueClassName = valueClassName;
        }
        catch (ClassNotFoundException e) {
            this.println(e.getMessage());
        }
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String endpoints, boolean isLocator, String serverGroup, int readTimeout) {
        this.endpoints = endpoints;
        this.isLocator = isLocator;
        this.serverGroup = serverGroup;
        this.readTimeout = readTimeout;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getCommandRegionPath() {
        return this.commandRegionPath;
    }

    public void setCommandRegionPath(String commandRegionPath) {
        this.commandRegionPath = commandRegionPath;
        this.setAggregateRegionPath(commandRegionPath + "/pr");
    }

    public String getAggregateRegionPath() {
        return this.aggregateRegionPath;
    }

    public void setAggregateRegionPath(String aggregateRegionPath) {
        this.aggregateRegionPath = aggregateRegionPath;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int selectLimit) {
        this.selectLimit = selectLimit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(boolean tableFormat) {
        this.tableFormat = tableFormat;
        PrintUtil.setTableFormat(tableFormat);
    }

    public boolean isPrintType() {
        return this.printType;
    }

    public void setPrintType(boolean printType) {
        this.printType = printType;
        SimplePrintUtil.setPrintType(printType);
    }

    public int getCollectionEntryPrintCount() {
        return this.collectionEntryPrintCount;
    }

    public void setCollectionEntryPrintCount(int collectionEntryPrintCount) {
        this.collectionEntryPrintCount = collectionEntryPrintCount;
        SimplePrintUtil.setCollectionEntryPrintCount(collectionEntryPrintCount);
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public CommandClient getCommandClient() {
        return this.commandClient;
    }

    public boolean isShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public List getLsKeyList() {
        return this.lsKeyList;
    }

    public void setLsKeyList(List list) {
        this.lsKeyList = list;
    }

    public boolean isLocator() {
        return this.isLocator;
    }

    public String expandProperties(String value2) {
        value2 = value2.trim();
        String[] split = value2.split("\\$\\{");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < split.length; ++i) {
            int index2 = split[i].indexOf(125);
            if (index2 == -1) continue;
            list.add(split[i].substring(0, index2));
        }
        for (String key2 : list) {
            String val = this.getProperty(key2);
            if (val == null) {
                value2 = value2.replaceAll("\\$\\{" + key2 + "\\}", "");
                continue;
            }
            value2 = value2.replaceAll("\\$\\{" + key2 + "\\}", val);
        }
        return value2;
    }

    public String getProperty(String key2) {
        return this.envProperties.getProperty(key2);
    }

    public void setProperty(String key2, String value2) {
        if (value2 == null || value2.length() == 0) {
            this.envProperties.remove(key2);
        } else {
            this.envProperties.setProperty(key2, value2);
        }
    }

    public void printProperties() {
        ArrayList<Object> list = new ArrayList<Object>(this.envProperties.keySet());
        Collections.sort(list);
        for (String string : list) {
            String value2 = this.getProperty(string);
            this.println(string + "=" + value2);
        }
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-?")) {
                Gfsh.usage();
                continue;
            }
            if (arg.equalsIgnoreCase("-c")) {
                if (++i >= args.length) continue;
                this.dataSerializableClassNames = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-d")) {
                if (++i >= args.length) continue;
                this.dataSerializablesFilePath = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-dir")) {
                if (++i >= args.length) continue;
                this.jarDirectoryPath = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-i")) {
                if (++i >= args.length) continue;
                this.inputFilePath = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-jar")) {
                if (++i >= args.length) continue;
                this.jarPaths = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-l")) {
                if (++i >= args.length) continue;
                this.locators = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-s")) {
                if (++i >= args.length) continue;
                this.servers = args[i];
                continue;
            }
            if (arg.equalsIgnoreCase("-advanced")) {
                this.isAdvancedMode = true;
                continue;
            }
            System.out.println("Unknown option: '" + arg + "'");
            Gfsh.usage();
        }
    }

    private static void usage() {
        String homeDir = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   gfsh [-c <comma separated fully-qualified class names>]");
        System.out.println("        [-d <DataSerializables.txt file>]");
        System.out.println("        [-dir <directory>]");
        System.out.println("        [-i <.gfshrc file>]");
        System.out.println("        [-jar <jar paths>]");
        System.out.println("        [-l <host:port>|-s <host:port>]");
        System.out.println("        [-advanced]");
        System.out.println("        [-? | -h[elp]]");
        System.out.println();
        System.out.println("   -c <comma separated fully-qualified class names>] - specifies");
        System.out.println("        the names of classes to load. These classes typically");
        System.out.println("        contain static blocks that register GemFire data class");
        System.out.println("        ids via Instantiator.");
        System.out.println();
        System.out.println("   -d <DataSerializables.txt file>] - specifies the file path of");
        System.out.println("        DataSerializables.txt that overrides ");
        System.out.println("        " + homeDir + fileSeparator + ".gemfire" + fileSeparator + "etc" + fileSeparator + "DataSerializables.txt.");
        System.out.println("        This option is equivalent to 'class -d <DataSerializables.txt>.");
        System.out.println("        The file path can be relative or absolute.");
        System.out.println();
        System.out.println("   -dir <directory> - specifies the directory in which the jar files");
        System.out.println("        that contain data files are located. Gfsh loads all of the classes");
        System.out.println("        in the jar files including the jar files in the subdirectories.");
        System.out.println("        The directory can be relative or absolute. This options is");
        System.out.println("        equivalent to 'class -dir <directory>'.");
        System.out.println();
        System.out.println("   -i <.gfshrc path> - specifies the input file that overrides the default");
        System.out.println("        .gfshrc file in " + homeDir + ".");
        System.out.println("        The file path can be relative or absolute.");
        System.out.println();
        System.out.println("   -jar <jar paths> - specifies the jar paths separated by ',', ';',");
        System.out.println("        or ':'. Gfsh loads all the the classes in the jar files. The");
        System.out.println("        jar files can be relative or absolute. This options is equivalent");
        System.out.println("        to 'class -jar <jar paths>'.");
        System.out.println();
        System.out.println("   -advanced - enables these advanced commands : " + Arrays.toString(advancedCommands));
        System.out.println();
        System.out.println("   -l <host:port> - specifies locators.");
        System.out.println();
        System.out.println("   -s <host:port> - specifies cache servers.");
        System.out.println();
        System.out.println("   -version - shows gfsh version.");
        System.out.println();
        System.out.println("   -?  OR -help - displays this help message.");
        System.out.println();
        System.out.println("Example 1: Start gfsh using a relative path");
        System.out.println("   cd /home/foo/app");
        System.out.println("   export GEMFIRE_APP_CLASSPATH=classes");
        System.out.println("   gfsh -l localhost:37000 -jar lib/foo.jar,lib/yong.jar");
        System.out.println();
        System.out.println("Example 2: Start gfsh using an app specific .gfshrc");
        System.out.println("   export GEMFIRE_APP_JAR_DIR=/home/foo/app/lib");
        System.out.println("   gfsh -l localhost:37000 -i /home/foo/app/.gfshrc");
        System.out.println();
        System.out.println("By default, during startup, gfsh sequentially executes the commands listed");
        System.out.println("in the .gfshrc file found in your home directory. The gfsh options");
        System.out.println("specified in the command line override the commands listed in .gfshrc.");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("-help") || args[0].equals("-?")) {
                Gfsh.usage();
            } else if (args[0].equals("version") || args[0].equals("-version")) {
                boolean fullVersion = args.length > 1 && "FULL".equals(args[1].trim());
                System.out.println(GfshVersion.asString(fullVersion));
                return;
            }
        }
        Gfsh gfsh = new Gfsh(args);
        gfsh.go();
    }

    static {
        DISABLED_COMMANDS.add("look");
        DISABLED_COMMANDS.add("perf");
        DISABLED_COMMANDS.add("zone");
    }
}

