/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tcp;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.tcp.BaseMsgStreamer;
import com.gemstone.gemfire.internal.tcp.ConnectExceptions;
import com.gemstone.gemfire.internal.tcp.MsgStreamer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public final class MsgStreamerList
implements BaseMsgStreamer {
    private static final Logger logger = LogService.getLogger();
    private final List<MsgStreamer> streamers;

    MsgStreamerList(List<MsgStreamer> streamers) {
        this.streamers = streamers;
    }

    @Override
    public void reserveConnections(long startTime, long ackTimeout, long ackSDTimeout) {
        for (MsgStreamer streamer : this.streamers) {
            streamer.reserveConnections(startTime, ackTimeout, ackSDTimeout);
        }
    }

    @Override
    public int writeMessage() throws IOException {
        int result = 0;
        RuntimeException ex = null;
        IOException ioex = null;
        for (MsgStreamer streamer : this.streamers) {
            if (ex != null) {
                streamer.release();
            }
            try {
                result += streamer.writeMessage();
            }
            catch (RuntimeException e) {
                ex = e;
            }
            catch (IOException e) {
                ioex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        if (ioex != null) {
            throw ioex;
        }
        return result;
    }

    @Override
    public List<?> getSentConnections() {
        List<Object> sentCons = Collections.emptyList();
        for (MsgStreamer streamer : this.streamers) {
            if (sentCons.size() == 0) {
                sentCons = streamer.getSentConnections();
                continue;
            }
            sentCons.addAll(streamer.getSentConnections());
        }
        return sentCons;
    }

    @Override
    public ConnectExceptions getConnectExceptions() {
        ConnectExceptions ce = null;
        for (MsgStreamer streamer : this.streamers) {
            if (ce == null) {
                ce = streamer.getConnectExceptions();
                continue;
            }
            ConnectExceptions e = streamer.getConnectExceptions();
            if (e == null) continue;
            List members = e.getMembers();
            List exs = e.getCauses();
            for (int i = 0; i < exs.size(); ++i) {
                ce.addFailure((InternalDistributedMember)members.get(i), (Throwable)exs.get(i));
            }
        }
        return ce;
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (MsgStreamer m : this.streamers) {
            try {
                m.close();
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                logger.fatal("Unknown error closing streamer: {}", e.getMessage(), e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

