/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.size.ReflectionObjectSizer;
import com.gemstone.gemfire.internal.size.WellKnownClassSizer;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteWeakHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class SizeClassOnceObjectSizer
implements ObjectSizer,
Serializable,
Declarable {
    private static final SizeClassOnceObjectSizer INSTANCE = new SizeClassOnceObjectSizer();
    private final transient Map<Class, Integer> savedSizes = new CopyOnWriteWeakHashMap<Class, Integer>();
    private final transient ReflectionObjectSizer sizer = ReflectionObjectSizer.getInstance();

    @Override
    public int sizeof(Object o) {
        if (o == null) {
            return 0;
        }
        int wellKnownObjectSize = WellKnownClassSizer.sizeof(o);
        if (wellKnownObjectSize != 0) {
            return wellKnownObjectSize;
        }
        Class<?> clazz = o.getClass();
        Integer size2 = this.savedSizes.get(clazz);
        if (size2 == null) {
            size2 = this.sizer.sizeof(o);
            this.savedSizes.put(clazz, size2);
        }
        return size2;
    }

    public static SizeClassOnceObjectSizer getInstance() {
        return INSTANCE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private SizeClassOnceObjectSizer() {
    }

    @Override
    public void init(Properties props) {
    }
}

