/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SharedLibrary;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionSingleObjectSizer
implements SingleObjectSizer {
    public static final int REFERENCE_SIZE = SharedLibrary.getReferenceSize();
    public static final int OBJECT_SIZE = SharedLibrary.getObjectHeaderSize();
    private static final UnsafeWrapper unsafe;

    @Override
    public long sizeof(Object object) {
        return this.sizeof(object, true);
    }

    public long sizeof(Object object, boolean roundResult) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            long size2;
            if (unsafe != null) {
                size2 = unsafe.arrayBaseOffset(clazz);
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    int typeSize = unsafe.arrayScaleIndex(clazz);
                    if (typeSize == 0) {
                        typeSize = ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                    }
                    size2 += (long)arrayLength * (long)typeSize;
                }
            } else {
                size2 = OBJECT_SIZE + 4;
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    size2 += (long)arrayLength * (long)ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                }
            }
            if (roundResult) {
                size2 = ReflectionSingleObjectSizer.roundUpSize(size2);
            }
            return size2;
        }
        return ReflectionSingleObjectSizer.sizeof(clazz, roundResult);
    }

    public static long sizeof(Class clazz) {
        return ReflectionSingleObjectSizer.sizeof(clazz, true);
    }

    public static long sizeof(Class clazz, boolean roundResult) {
        long size2;
        Assert.assertTrue(!clazz.isArray());
        if (unsafe != null) {
            Object lastField = null;
            long lastFieldOffset = 0L;
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    long offset;
                    if (Modifier.isStatic(field.getModifiers()) || (offset = unsafe.fieldOffset(field)) < lastFieldOffset) continue;
                    lastFieldOffset = offset;
                    lastField = field;
                }
            } while (lastField == null && (clazz = clazz.getSuperclass()) != null);
            size2 = lastField != null ? lastFieldOffset + (long)ReflectionSingleObjectSizer.sizeType(lastField.getClass()) : (long)OBJECT_SIZE;
        } else {
            size2 = OBJECT_SIZE;
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    size2 += (long)ReflectionSingleObjectSizer.sizeType(field.getClass());
                }
            } while ((clazz = clazz.getSuperclass()) != null);
        }
        if (roundResult) {
            size2 = ReflectionSingleObjectSizer.roundUpSize(size2);
        }
        return size2;
    }

    public static long roundUpSize(long size2) {
        long remainder = size2 % 8L;
        if (remainder != 0L) {
            size2 = size2 - remainder + 8L;
        }
        return size2;
    }

    private static int sizeType(Class<?> t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return REFERENCE_SIZE;
    }

    static {
        UnsafeWrapper tmp = null;
        try {
            tmp = new UnsafeWrapper();
        }
        catch (RuntimeException ignore) {
        }
        catch (Error error) {
            // empty catch block
        }
        unsafe = tmp;
    }
}

