/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.size;

import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteWeakHashMap;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectIdentityHashingStrategy;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class ObjectTraverser {
    private static final Map<Class, FieldSet> FIELD_CACHE = new CopyOnWriteWeakHashMap<Class, FieldSet>();
    private static final FieldSet NON_PRIMATIVE_ARRAY = new FieldSet(null, null);

    public static void breadthFirstSearch(Object root, Visitor visitor, boolean includeStatics) throws IllegalArgumentException, IllegalAccessException {
        VisitStack stack = new VisitStack(visitor, includeStatics);
        stack.add(null, root);
        while (!stack.isEmpty()) {
            Object next2 = stack.next();
            ObjectTraverser.doSearch(next2, stack);
        }
    }

    private static void doSearch(Object root, VisitStack stack) throws IllegalArgumentException, IllegalAccessException {
        Object value2;
        Class<?> clazz = root.getClass();
        boolean includeStatics = stack.shouldIncludeStatics(clazz);
        FieldSet set = FIELD_CACHE.get(clazz);
        if (set == null) {
            set = ObjectTraverser.cacheFieldSet(clazz);
        }
        if (set == NON_PRIMATIVE_ARRAY) {
            Class<?> componentType = clazz.getComponentType();
            int length = Array.getLength(root);
            for (int i = 0; i < length; ++i) {
                Object value3 = Array.get(root, i);
                stack.add(root, value3);
            }
            return;
        }
        if (includeStatics) {
            for (Field field : set.getStaticFields()) {
                value2 = field.get(root);
                stack.add(root, value2);
            }
        }
        for (Field field : set.getNonPrimativeFields()) {
            value2 = field.get(root);
            stack.add(root, value2);
        }
    }

    private static FieldSet cacheFieldSet(Class clazz) {
        FieldSet set = ObjectTraverser.buildFieldSet(clazz);
        FIELD_CACHE.put(clazz, set);
        return set;
    }

    private static FieldSet buildFieldSet(Class clazz) {
        ArrayList<Field> staticFields = new ArrayList<Field>();
        ArrayList<Field> nonPrimativeFields = new ArrayList<Field>();
        while (clazz != null) {
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                if (!componentType.isPrimitive()) {
                    return NON_PRIMATIVE_ARRAY;
                }
                return new FieldSet(new Field[0], new Field[0]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Class<?> fieldType = field.getType();
                if (fieldType.isPrimitive()) continue;
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    staticFields.add(field);
                    continue;
                }
                nonPrimativeFields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return new FieldSet(staticFields.toArray(new Field[staticFields.size()]), nonPrimativeFields.toArray(new Field[nonPrimativeFields.size()]));
    }

    private ObjectTraverser() {
    }

    private static class FieldSet {
        private final Field[] staticFields;
        private final Field[] nonPrimativeFields;

        public FieldSet(Field[] staticFields, Field[] nonPrimativeFields) {
            this.staticFields = staticFields;
            this.nonPrimativeFields = nonPrimativeFields;
        }

        public Field[] getStaticFields() {
            return this.staticFields;
        }

        public Field[] getNonPrimativeFields() {
            return this.nonPrimativeFields;
        }
    }

    private static class VisitStack {
        private THashSet seen = new THashSet(TObjectIdentityHashingStrategy.getInstance());
        private LinkedList stack = new LinkedList();
        private Visitor visitor;
        private boolean includeStatics;

        VisitStack(Visitor visitor, boolean includeStatics) {
            this.visitor = visitor;
            this.includeStatics = includeStatics;
        }

        public void add(Object parent, Object object) {
            boolean newObject;
            if (object == null) {
                return;
            }
            boolean bl = newObject = !this.seen.contains(object);
            if (newObject) {
                this.seen.add(object);
                boolean visitChildren = this.visitor.visit(parent, object);
                if (visitChildren) {
                    this.stack.add(object);
                }
            }
        }

        public Object next() {
            return this.stack.removeFirst();
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public boolean shouldIncludeStatics(Class clazz) {
            if (!this.includeStatics) {
                return false;
            }
            boolean keyExists = this.seen.contains(clazz);
            this.seen.add(clazz);
            return !keyExists;
        }
    }

    public static interface Visitor {
        public boolean visit(Object var1, Object var2);
    }
}

