/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.sequencelog.model;

import com.gemstone.gemfire.internal.sequencelog.GraphType;
import com.gemstone.gemfire.internal.sequencelog.model.Graph;
import com.gemstone.gemfire.internal.sequencelog.model.GraphID;
import com.gemstone.gemfire.internal.sequencelog.model.GraphReaderCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class GraphSet
implements GraphReaderCallback {
    private Map<GraphID, Graph> graphs = new HashMap<GraphID, Graph>();
    private long maxTime = Long.MIN_VALUE;
    private long minTime = Long.MAX_VALUE;
    private final Map<String, Long> locations = new HashMap<String, Long>();
    private Set<EdgePattern> edgePatterns = new TreeSet<EdgePattern>();

    @Override
    public void addEdge(long timestamp, GraphType graphType, String graphName, String edgeName, String state, String source, String dest) {
        this.addEdge(timestamp, graphType, graphName, edgeName, state, source, dest, false);
    }

    private void addEdge(long timestamp, GraphType graphType, String graphName, String edgeName, String state, String source, String dest, boolean isFromPattern) {
        GraphID id;
        Graph graph;
        if (source == null) {
            source = "ERROR_NULL";
        }
        if (dest == null) {
            dest = "ERROR_NULL";
        }
        if ((graph = this.graphs.get(id = new GraphID(graphType, graphName))) == null) {
            graph = new Graph(id);
            this.graphs.put(id, graph);
        }
        graph.addEdge(timestamp, edgeName, state, source, dest, isFromPattern);
        if (timestamp < this.minTime) {
            this.minTime = timestamp;
        }
        if (timestamp > this.maxTime) {
            this.maxTime = timestamp;
        }
        if (source != null) {
            this.updateLocations(source, timestamp);
        }
        if (dest != null) {
            this.updateLocations(dest, timestamp);
        }
    }

    private void updateLocations(String location, long timestamp) {
        Long time = this.locations.get(location);
        if (time == null || time > timestamp) {
            this.locations.put(location, timestamp);
        }
    }

    @Override
    public void addEdgePattern(long timestamp, GraphType graphType, Pattern graphNamePattern, String edgeName, String state, String source, String dest) {
        this.edgePatterns.add(new EdgePattern(timestamp, graphType, graphNamePattern, edgeName, state, source, dest));
    }

    public void readingDone() {
        for (EdgePattern edgePattern : this.edgePatterns) {
            for (GraphID graphId : this.graphs.keySet()) {
                if (!edgePattern.graphNamePattern.matcher(graphId.getGraphName()).matches() || !edgePattern.graphType.equals((Object)graphId.getType())) continue;
                this.addEdge(edgePattern.timestamp, graphId.getType(), graphId.getGraphName(), edgePattern.edgeName, edgePattern.state, edgePattern.source, edgePattern.dest, true);
            }
        }
    }

    public Map<GraphID, Graph> getMap() {
        return this.graphs;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public List<String> getLocations() {
        ArrayList<String> result = new ArrayList<String>(this.locations.keySet());
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Long time1 = (Long)GraphSet.this.locations.get(o1);
                Long time2 = (Long)GraphSet.this.locations.get(o2);
                return time1.compareTo(time2);
            }
        });
        return result;
    }

    private static class EdgePattern
    implements Comparable<EdgePattern> {
        private final long timestamp;
        private final GraphType graphType;
        private final Pattern graphNamePattern;
        private final String edgeName;
        private final String state;
        private final String source;
        private final String dest;

        public EdgePattern(long timestamp, GraphType graphType, Pattern graphNamePattern, String edgeName, String state, String source, String dest) {
            this.timestamp = timestamp;
            this.graphType = graphType;
            this.graphNamePattern = graphNamePattern;
            this.edgeName = edgeName;
            this.state = state;
            this.source = source;
            this.dest = dest;
        }

        @Override
        public int compareTo(EdgePattern o) {
            int timeDifference = Long.signum(this.timestamp - o.timestamp);
            if (timeDifference != 0) {
                return timeDifference;
            }
            return System.identityHashCode(this) - System.identityHashCode(o);
        }
    }
}

