/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.security;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.operations.PutOperationContext;
import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.CqEntry;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionWrapper;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.ObjectWithAuthz;
import com.gemstone.gemfire.security.AccessControl;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.security.Principal;
import java.util.ArrayList;

public class FilterPostAuthorization
implements AccessControl {
    private String principalName = null;
    private LogWriterI18n logger = null;

    public static AccessControl create() {
        return new FilterPostAuthorization();
    }

    @Override
    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        this.principalName = principal == null ? "" : principal.getName();
        this.logger = cache.getSecurityLoggerI18n();
    }

    private byte[] checkObjectAuth(byte[] serializedObj, boolean isObject) {
        Object obj;
        if (!isObject) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(serializedObj);
        DataInputStream dis = new DataInputStream(bis);
        try {
            obj = DataSerializer.readObject(dis);
            if (this.logger.finerEnabled()) {
                this.logger.finer("FilterPostAuthorization: successfully read object from serialized object: " + obj);
            }
        }
        catch (Exception ex) {
            this.logger.severe(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_AN_EXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE, ex);
            return null;
        }
        obj = this.checkObjectAuth(obj);
        if (obj != null) {
            HeapDataOutputStream hos = new HeapDataOutputStream(serializedObj.length + 32, Version.CURRENT);
            try {
                DataSerializer.writeObject(obj, hos);
                return hos.toByteArray();
            }
            catch (Exception ex) {
                this.logger.severe(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_AN_EXCEPTION_WAS_THROWN_WHILE_TRYING_TO_SERIALIZE, ex);
            }
        }
        return null;
    }

    private Object checkObjectAuth(Object value2) {
        Object obj = value2;
        if (value2 instanceof CqEntry) {
            obj = ((CqEntry)value2).getValue();
        }
        if (obj instanceof ObjectWithAuthz) {
            int lastChar = this.principalName.charAt(this.principalName.length() - 1) - 48;
            ObjectWithAuthz authzObj = (ObjectWithAuthz)obj;
            int authzIndex = (Integer)authzObj.getAuthz() - 48;
            if ((lastChar %= 10) == 0 || (authzIndex %= 10) % lastChar != 0) {
                this.logger.warning(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_THE_USER_0_IS_NOT_AUTHORIZED_FOR_THE_OBJECT_1, new Object[]{this.principalName, authzObj.getVal()});
                return null;
            }
            if (this.logger.fineEnabled()) {
                this.logger.fine("FilterPostAuthorization: user [" + this.principalName + "] authorized for object: " + authzObj.getVal());
            }
            if (value2 instanceof CqEntry) {
                return new CqEntry(((CqEntry)value2).getKey(), authzObj.getVal());
            }
            return authzObj.getVal();
        }
        this.logger.warning(LocalizedStrings.FilterPostAuthorization_FILTERPOSTAUTHORIZATION_THE_OBJECT_OF_TYPE_0_IS_NOT_AN_INSTANCE_OF_1, new Object[]{obj.getClass(), ObjectWithAuthz.class});
        return null;
    }

    @Override
    public boolean authorizeOperation(String regionName, OperationContext context) {
        assert (context.isPostOperation());
        OperationContext.OperationCode opCode = context.getOperationCode();
        if (opCode.isGet()) {
            GetOperationContext getContext = (GetOperationContext)context;
            Object value2 = getContext.getObject();
            boolean isObject = getContext.isObject();
            if (value2 != null) {
                if ((value2 = this.checkObjectAuth(value2)) != null) {
                    getContext.setObject(value2, isObject);
                    return true;
                }
            } else {
                byte[] serializedValue = getContext.getSerializedValue();
                if ((serializedValue = this.checkObjectAuth(serializedValue, isObject)) != null) {
                    getContext.setSerializedValue(serializedValue, isObject);
                    return true;
                }
            }
        } else if (opCode.isPut()) {
            PutOperationContext putContext = (PutOperationContext)context;
            byte[] serializedValue = putContext.getSerializedValue();
            boolean isObject = putContext.isObject();
            if ((serializedValue = this.checkObjectAuth(serializedValue, isObject)) != null) {
                putContext.setSerializedValue(serializedValue, isObject);
                return true;
            }
        } else if (!opCode.equals(OperationContext.OperationCode.PUTALL) && (opCode.isQuery() || opCode.isExecuteCQ())) {
            QueryOperationContext queryContext = (QueryOperationContext)context;
            Object value3 = queryContext.getQueryResult();
            if (value3 instanceof SelectResults) {
                SelectResults results = (SelectResults)value3;
                ArrayList newResults = new ArrayList();
                for (Object obj : results) {
                    if ((obj = this.checkObjectAuth(obj)) == null) continue;
                    newResults.add(obj);
                }
                if (results.isModifiable()) {
                    results.clear();
                    results.addAll(newResults);
                } else {
                    ObjectType constraint = results.getCollectionType().getElementType();
                    results = new ResultsCollectionWrapper(constraint, newResults);
                    queryContext.setQueryResult(results);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void close() {
        this.principalName = null;
    }

    static {
        Instantiator.register(new Instantiator(ObjectWithAuthz.class, 57){

            @Override
            public DataSerializable newInstance() {
                return new ObjectWithAuthz();
            }
        }, false);
    }
}

