/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.logging.LogService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;

public final class ProcessStreamReader
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private final InputStream inputStream;
    private final InputListener listener;
    private Thread thread;

    public ProcessStreamReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.listener = new InputListener(){

            @Override
            public void notifyInputLine(String line) {
            }

            public String toString() {
                return "NullInputListener";
            }
        };
    }

    public ProcessStreamReader(InputStream inputStream, InputListener listener) {
        this.inputStream = inputStream;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block19: {
            BufferedReader reader;
            boolean isDebugEnabled;
            block15: {
                String line;
                isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("Running {}", this);
                }
                reader = null;
                reader = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = reader.readLine()) != null) {
                    this.listener.notifyInputLine(line);
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (!isDebugEnabled) break block15;
                    logger.debug("Failure closing buffered input stream reader: {}", e.getMessage(), e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("Terminating {}", this);
            }
            break block19;
            catch (IOException e) {
                block17: {
                    block16: {
                        try {
                            if (!isDebugEnabled) break block16;
                            logger.debug("Failure reading from buffered input stream: {}", e.getMessage(), e);
                        }
                        catch (Throwable throwable) {
                            block18: {
                                try {
                                    reader.close();
                                }
                                catch (IOException e2) {
                                    if (!isDebugEnabled) break block18;
                                    logger.debug("Failure closing buffered input stream reader: {}", e2.getMessage(), e2);
                                }
                            }
                            if (isDebugEnabled) {
                                logger.debug("Terminating {}", this);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        if (!isDebugEnabled) break block17;
                        logger.debug("Failure closing buffered input stream reader: {}", e3.getMessage(), e3);
                    }
                }
                if (isDebugEnabled) {
                    logger.debug("Terminating {}", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader start() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                if (this.thread.isAlive()) {
                    throw new IllegalStateException(this + " has already started");
                }
                throw new IllegalStateException(this + " was stopped and cannot be restarted");
            }
            this.thread = new Thread((Runnable)this, this.createThreadName());
            this.thread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader stop() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            } else if (this.thread != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} has already been stopped", this);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("{} has not been started", this);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                return this.thread.isAlive();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long millis) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(long millis, int nanos) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis, nanos);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" Thread").append(" #").append(System.identityHashCode(this));
        sb.append(" alive=").append(this.isRunning());
        sb.append(" listener=").append(this.listener);
        return sb.toString();
    }

    private String createThreadName() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    public static interface InputListener {
        public void notifyInputLine(String var1);
    }
}

