/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.process;

import com.gemstone.gemfire.internal.process.FileProcessController;
import com.gemstone.gemfire.internal.process.MBeanProcessController;
import com.gemstone.gemfire.internal.process.ProcessController;
import com.gemstone.gemfire.internal.process.ProcessControllerParameters;
import com.gemstone.gemfire.internal.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;

public final class ProcessControllerFactory {
    public static final String PROPERTY_DISABLE_ATTACH_API = "gemfire.test.ProcessControllerFactory.DisableAttachApi";
    private final boolean disableAttachApi = Boolean.getBoolean("gemfire.test.ProcessControllerFactory.DisableAttachApi");

    public ProcessController createProcessController(ProcessControllerParameters arguments, int pid) {
        if (pid < 1) {
            throw new IllegalArgumentException("Invalid pid '" + pid + "' specified");
        }
        try {
            if (this.isAttachAPIFound()) {
                return new MBeanProcessController(arguments, pid);
            }
            return new FileProcessController(arguments, pid);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return null;
        }
    }

    public ProcessController createProcessController(ProcessControllerParameters arguments, File pidFile) throws IOException {
        return this.createProcessController(arguments, ProcessControllerFactory.readPid(pidFile));
    }

    public ProcessController createProcessController(ProcessControllerParameters arguments, File directory, String pidFilename) throws IOException {
        return this.createProcessController(arguments, ProcessControllerFactory.readPid(directory, pidFilename));
    }

    public boolean isAttachAPIFound() {
        if (this.disableAttachApi) {
            return false;
        }
        boolean found = false;
        try {
            Class<?> virtualMachineClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            found = virtualMachineClass != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return found;
    }

    private static int readPid(File pidFile) throws IOException {
        int n;
        BufferedReader fileReader = null;
        String pidValue = null;
        try {
            fileReader = new BufferedReader(new FileReader(pidFile));
            pidValue = fileReader.readLine();
            int pid = Integer.parseInt(pidValue);
            if (pid < 1) {
                throw new IllegalArgumentException("Invalid pid '" + pid + "' found in " + pidFile.getCanonicalPath());
            }
            n = pid;
        }
        catch (NumberFormatException e) {
            try {
                throw new IllegalArgumentException("Invalid pid '" + pidValue + "' found in " + pidFile.getCanonicalPath());
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
        }
        IOUtils.close(fileReader);
        return n;
    }

    private static int readPid(File directory, final String pidFilename) throws IOException {
        if (!directory.isDirectory() && directory.exists()) {
            throw new IllegalArgumentException("Argument '" + directory + "' must be an existing directory!");
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                return filename.equals(pidFilename);
            }
        });
        if (files.length == 0) {
            throw new FileNotFoundException("Unable to find PID file '" + pidFilename + "' in directory " + directory);
        }
        return ProcessControllerFactory.readPid(files[0]);
    }
}

