/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.memcached.Reply;
import com.gemstone.gemfire.internal.memcached.RequestReader;
import com.gemstone.gemfire.internal.memcached.ResponseStatus;
import com.gemstone.gemfire.internal.memcached.ValueWrapper;
import com.gemstone.gemfire.internal.memcached.commands.StorageCommand;
import java.nio.ByteBuffer;

public class ReplaceCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key2, byte[] value2, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = ReplaceCommand.getMemcachedRegion(cache);
        ValueWrapper oldVal = r.replace(key2, ValueWrapper.getWrappedValue(value2, flags));
        String reply = null;
        reply = oldVal == null ? Reply.NOT_STORED.toString() : Reply.STORED.toString();
        return asciiCharset.encode(reply);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key2, byte[] value2, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = ReplaceCommand.getMemcachedRegion(cache);
        ValueWrapper val = ValueWrapper.getWrappedValue(value2, flags);
        boolean success = false;
        try {
            if (cas != 0L) {
                ValueWrapper expected = ValueWrapper.getDummyValue(cas);
                success = r.replace(key2, expected, val);
            } else {
                success = r.replace(key2, val) != null;
            }
        }
        catch (Exception e) {
            return this.handleBinaryException(key2, request, response, "replace", e);
        }
        if (this.getLogger().fineEnabled()) {
            this.getLogger().fine("replace:key:" + key2 + " cas:" + cas + " success:" + success);
        }
        if (success) {
            if (this.isQuiet()) {
                return null;
            }
            response.putShort(6, ResponseStatus.NO_ERROR.asShort());
            response.putLong(16, val.getVersion());
        } else if (cas != 0L) {
            response.putShort(6, ResponseStatus.KEY_EXISTS.asShort());
        } else {
            response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

