/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ValueWrapper
implements DataSerializable {
    private static final long serialVersionUID = 7931598505833835569L;
    private long casVersion;
    private byte[] value;
    private int flags;
    private static final AtomicLong versionGenerator = new AtomicLong();

    public ValueWrapper() {
    }

    private ValueWrapper(byte[] value2, long version, int flags) {
        this.value = value2;
        this.casVersion = version;
        this.flags = flags;
    }

    public static ValueWrapper getWrappedValue(byte[] value2, int flags) {
        return new ValueWrapper(value2, versionGenerator.incrementAndGet(), flags);
    }

    public static ValueWrapper getDummyValue(long cas) {
        return new ValueWrapper(null, cas, 0);
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getVersion() {
        return this.casVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueWrapper) {
            ValueWrapper other = (ValueWrapper)obj;
            if (this.casVersion == other.casVersion) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.casVersion).hashCode();
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.casVersion = in.readLong();
        this.value = DataSerializer.readByteArray(in);
        this.flags = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.casVersion);
        DataSerializer.writeByteArray(this.value, out);
        out.writeInt(this.flags);
    }
}

