/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.memcached;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class KeyWrapper
implements DataSerializable {
    private static final long serialVersionUID = -3241981993525734772L;
    private byte[] key;

    public KeyWrapper() {
    }

    private KeyWrapper(byte[] key2) {
        this.key = key2;
    }

    public static KeyWrapper getWrappedKey(byte[] key2) {
        return new KeyWrapper(key2);
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.key, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readByteArray(in);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyWrapper) {
            KeyWrapper other = (KeyWrapper)obj;
            return Arrays.equals(this.key, other.key);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getCanonicalName()).append("@").append(System.identityHashCode(this));
        str.append(" key:").append(Arrays.toString(this.key));
        str.append(" hashCode:").append(this.hashCode());
        return str.toString();
    }
}

