/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.logging.GemFireHandler;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.Configurator;
import com.gemstone.gemfire.internal.logging.log4j.FastLogger;
import com.gemstone.gemfire.internal.logging.log4j.GemFireLogger;
import com.gemstone.org.apache.logging.log4j.message.GemFireParameterizedMessageFactory;
import java.util.logging.Handler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public final class LogWriterLogger
extends FastLogger
implements InternalLogWriter,
GemFireLogger {
    private static final long serialVersionUID = 446081244292135L;
    public static final String SECURITY_PREFIX = "security-";
    private final ExtendedLoggerWrapper logWrapper = this;
    private final String connectionName;
    private final String loggerName;
    private final boolean isSecure;

    private LogWriterLogger(Logger logger, String connectionName, boolean isSecure) {
        super((AbstractLogger)logger, logger.getName(), logger.getMessageFactory());
        this.connectionName = connectionName;
        this.loggerName = this.getName();
        this.isSecure = isSecure;
    }

    public static LogWriterLogger create(String name, boolean isSecure) {
        return LogWriterLogger.create(name, null, isSecure);
    }

    public static LogWriterLogger create(String name, String connectionName, boolean isSecure) {
        Logger wrapped = LogManager.getLogger(name, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE);
        return new LogWriterLogger(wrapped, connectionName, isSecure);
    }

    public static LogWriterLogger create(Logger logger) {
        return new LogWriterLogger(logger, null, false);
    }

    public void setLevel(Level level) {
        if (this.getLevel().isLessSpecificThan(Level.DEBUG) || level.isLessSpecificThan(Level.DEBUG)) {
            this.debug("Changing level for Logger '{}' from {} to {}", this.loggerName, this.getLevel(), level);
        }
        if ("com.gemstone.gemfire".equals(this.loggerName)) {
            Configurator.setLevel("com.gemstone", level);
            Configurator.setLevel("com.gemstone.gemfire", level);
        } else {
            Configurator.setLevel("com.gemstone.gemfire.security", level);
        }
    }

    @Override
    public void setLogWriterLevel(int logWriterLevel) {
        this.setLevel(LogWriterLogger.logWriterLeveltoLog4jLevel(logWriterLevel));
    }

    @Override
    public void finest(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, msg, (Throwable)null);
    }

    @Override
    public void finest(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, msg, t);
    }

    @Override
    public void finest(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finest(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, t);
    }

    @Override
    public void finest(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finest(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, params);
    }

    @Override
    public void finest(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, t);
    }

    @Override
    public void finest(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, msg, (Throwable)null);
    }

    @Override
    public void finest(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, msg, t);
    }

    @Override
    public void finest(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    @Override
    public void finest(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, t);
    }

    @Override
    public void finest(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void finest(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, params);
    }

    @Override
    public void finest(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, (Marker)null, message, t);
    }

    @Override
    public void finer(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, msg, (Throwable)null);
    }

    @Override
    public void finer(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, msg, t);
    }

    @Override
    public void finer(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finer(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, t);
    }

    @Override
    public void finer(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, (Throwable)null);
    }

    @Override
    public void finer(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, params);
    }

    @Override
    public void finer(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, marker, message, t);
    }

    @Override
    public void finer(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, msg, (Throwable)null);
    }

    @Override
    public void finer(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, msg, t);
    }

    @Override
    public void finer(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, (Throwable)null);
    }

    @Override
    public void finer(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, t);
    }

    @Override
    public void finer(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void finer(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, null, message, params);
    }

    @Override
    public void finer(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.TRACE, (Marker)null, message, t);
    }

    @Override
    public void fine(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, msg, (Throwable)null);
    }

    @Override
    public void fine(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, msg, t);
    }

    @Override
    public void fine(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, (Throwable)null);
    }

    @Override
    public void fine(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, t);
    }

    @Override
    public void fine(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, (Throwable)null);
    }

    @Override
    public void fine(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, params);
    }

    @Override
    public void fine(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, marker, message, t);
    }

    @Override
    public void fine(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, msg, (Throwable)null);
    }

    @Override
    public void fine(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, msg, t);
    }

    @Override
    public void fine(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, (Throwable)null);
    }

    @Override
    public void fine(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, t);
    }

    @Override
    public void fine(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void fine(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, null, message, params);
    }

    @Override
    public void fine(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.DEBUG, (Marker)null, message, t);
    }

    @Override
    public void config(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, (Throwable)null);
    }

    @Override
    public void config(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, t);
    }

    @Override
    public void config(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void config(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    @Override
    public void config(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void config(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, params);
    }

    @Override
    public void config(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    @Override
    public void config(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, (Throwable)null);
    }

    @Override
    public void config(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, t);
    }

    @Override
    public void config(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    @Override
    public void config(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    @Override
    public void config(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void config(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, params);
    }

    @Override
    public void config(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, (Marker)null, message, t);
    }

    @Override
    public void info(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, (Throwable)null);
    }

    @Override
    public void info(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, msg, t);
    }

    @Override
    public void info(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void info(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    @Override
    public void info(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, (Throwable)null);
    }

    @Override
    public void info(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, params);
    }

    @Override
    public void info(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, marker, message, t);
    }

    @Override
    public void info(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, (Throwable)null);
    }

    @Override
    public void info(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, msg, t);
    }

    @Override
    public void info(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, (Throwable)null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, t);
    }

    @Override
    public void info(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void info(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, null, message, params);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.INFO, (Marker)null, message, t);
    }

    @Override
    public void warning(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, msg, (Throwable)null);
    }

    @Override
    public void warning(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, msg, t);
    }

    @Override
    public void warning(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, (Throwable)null);
    }

    @Override
    public void warning(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, t);
    }

    @Override
    public void warning(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, (Throwable)null);
    }

    @Override
    public void warning(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, params);
    }

    @Override
    public void warning(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, marker, message, t);
    }

    @Override
    public void warning(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, msg, (Throwable)null);
    }

    @Override
    public void warning(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, msg, t);
    }

    @Override
    public void warning(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, (Throwable)null);
    }

    @Override
    public void warning(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, t);
    }

    @Override
    public void warning(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void warning(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, null, message, params);
    }

    @Override
    public void warning(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.WARN, (Marker)null, message, t);
    }

    @Override
    public void error(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, (Throwable)null);
    }

    @Override
    public void error(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, msg, t);
    }

    @Override
    public void error(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, (Throwable)null);
    }

    @Override
    public void error(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    @Override
    public void error(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, (Throwable)null);
    }

    @Override
    public void error(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, params);
    }

    @Override
    public void error(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, marker, message, t);
    }

    @Override
    public void error(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, (Throwable)null);
    }

    @Override
    public void error(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, msg, t);
    }

    @Override
    public void error(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, (Throwable)null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, t);
    }

    @Override
    public void error(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void error(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, null, message, params);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.ERROR, (Marker)null, message, t);
    }

    @Override
    public void severe(Marker marker, Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, msg, (Throwable)null);
    }

    @Override
    public void severe(Marker marker, Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, msg, t);
    }

    @Override
    public void severe(Marker marker, Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, (Throwable)null);
    }

    @Override
    public void severe(Marker marker, Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, t);
    }

    @Override
    public void severe(Marker marker, String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, (Throwable)null);
    }

    @Override
    public void severe(Marker marker, String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, params);
    }

    @Override
    public void severe(Marker marker, String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, marker, message, t);
    }

    @Override
    public void severe(Message msg) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, msg, (Throwable)null);
    }

    @Override
    public void severe(Message msg, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, msg, t);
    }

    @Override
    public void severe(Object message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, (Throwable)null);
    }

    @Override
    public void severe(Object message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, t);
    }

    @Override
    public void severe(String message) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, (Marker)null, message, (Throwable)null);
    }

    @Override
    public void severe(String message, Object ... params) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, null, message, params);
    }

    @Override
    public void severe(String message, Throwable t) {
        this.logWrapper.logIfEnabled(this.loggerName, Level.FATAL, (Marker)null, message, t);
    }

    public static Level logWriterLeveltoLog4jLevel(int logWriterLevel) {
        switch (logWriterLevel) {
            case 1000: {
                return Level.FATAL;
            }
            case 950: {
                return Level.ERROR;
            }
            case 900: {
                return Level.WARN;
            }
            case 700: {
                return Level.INFO;
            }
            case 800: {
                return Level.INFO;
            }
            case 500: {
                return Level.DEBUG;
            }
            case 400: {
                return Level.DEBUG;
            }
            case 300: {
                return Level.TRACE;
            }
            case -2147483648: {
                return Level.ALL;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown LogWriter level [" + logWriterLevel + "].");
    }

    public static Level logWriterNametoLog4jLevel(String levelName) {
        if ("all".equalsIgnoreCase(levelName)) {
            return Level.ALL;
        }
        if ("finest".equalsIgnoreCase(levelName)) {
            return Level.TRACE;
        }
        if ("finer".equalsIgnoreCase(levelName)) {
            return Level.DEBUG;
        }
        if ("fine".equalsIgnoreCase(levelName)) {
            return Level.DEBUG;
        }
        if ("config".equalsIgnoreCase(levelName)) {
            return Level.INFO;
        }
        if ("info".equalsIgnoreCase(levelName)) {
            return Level.INFO;
        }
        if ("warning".equalsIgnoreCase(levelName)) {
            return Level.WARN;
        }
        if ("error".equalsIgnoreCase(levelName)) {
            return Level.ERROR;
        }
        if ("severe".equalsIgnoreCase(levelName)) {
            return Level.FATAL;
        }
        if ("none".equalsIgnoreCase(levelName)) {
            return Level.OFF;
        }
        throw new IllegalArgumentException("Unknown LogWriter level [" + levelName + "].");
    }

    public static int log4jLevelToLogWriterLevel(Level log4jLevel) {
        if (log4jLevel == Level.FATAL) {
            return 1000;
        }
        if (log4jLevel == Level.ERROR) {
            return 950;
        }
        if (log4jLevel == Level.WARN) {
            return 900;
        }
        if (log4jLevel == Level.INFO) {
            return 800;
        }
        if (log4jLevel == Level.DEBUG) {
            return 500;
        }
        if (log4jLevel == Level.TRACE) {
            return 300;
        }
        if (log4jLevel == Level.ALL) {
            return Integer.MIN_VALUE;
        }
        if (log4jLevel == Level.OFF) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unknown Log4J level [" + log4jLevel + "].");
    }

    public void log(int logWriterLevel, String message, Throwable t) {
        Level level = LogWriterLogger.logWriterLeveltoLog4jLevel(logWriterLevel);
        this.logWrapper.logIfEnabled(this.loggerName, level, (Marker)null, message, t);
    }

    @Override
    public boolean severeEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    @Override
    public boolean errorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @Override
    public boolean warningEnabled() {
        return this.isEnabled(Level.WARN);
    }

    @Override
    public boolean infoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public boolean configEnabled() {
        return this.isEnabled(Level.INFO);
    }

    @Override
    public boolean fineEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public boolean finerEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public boolean finestEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.finer("ENTRY {}:{}", sourceClass, sourceMethod);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.finer("RETURN {}:{}", sourceClass, sourceMethod);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.finer("THROW {}:{}", sourceClass, sourceMethod, thrown);
    }

    @Override
    public Handler getHandler() {
        return new GemFireHandler(this);
    }

    @Override
    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }

    @Override
    public void severe(Throwable ex) {
        this.severe((String)null, ex);
    }

    @Override
    public void error(Throwable ex) {
        this.error((String)null, ex);
    }

    @Override
    public void warning(Throwable ex) {
        this.warning((String)null, ex);
    }

    @Override
    public void info(Throwable ex) {
        this.info((String)null, ex);
    }

    @Override
    public void config(Throwable ex) {
        this.config((String)null, ex);
    }

    @Override
    public void fine(Throwable ex) {
        this.fine((String)null, ex);
    }

    @Override
    public void finer(Throwable ex) {
        this.finer((String)null, ex);
    }

    @Override
    public void finest(Throwable ex) {
        this.finest((String)null, ex);
    }

    @Override
    public void severe(StringId msgID, Object[] params, Throwable ex) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString(params), ex);
        }
    }

    @Override
    public void severe(StringId msgID, Object param, Throwable ex) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString(param), ex);
        }
    }

    @Override
    public void severe(StringId msgID, Throwable ex) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString(), ex);
        }
    }

    @Override
    public void severe(StringId msgID, Object[] params) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString(params));
        }
    }

    @Override
    public void severe(StringId msgID, Object param) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString(param));
        }
    }

    @Override
    public void severe(StringId msgID) {
        if (this.isEnabled(Level.FATAL)) {
            this.severe(msgID.toLocalizedString());
        }
    }

    @Override
    public void error(StringId msgID, Object[] params, Throwable ex) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString(params), ex);
        }
    }

    @Override
    public void error(StringId msgID, Object param, Throwable ex) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString(param), ex);
        }
    }

    @Override
    public void error(StringId msgID, Throwable ex) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString(), ex);
        }
    }

    @Override
    public void error(StringId msgID, Object[] params) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString(params));
        }
    }

    @Override
    public void error(StringId msgID, Object param) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString(param));
        }
    }

    @Override
    public void error(StringId msgID) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(msgID.toLocalizedString());
        }
    }

    @Override
    public void warning(StringId msgID, Object[] params, Throwable ex) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString(params), ex);
        }
    }

    @Override
    public void warning(StringId msgID, Object param, Throwable ex) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString(param), ex);
        }
    }

    @Override
    public void warning(StringId msgID, Throwable ex) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString(), ex);
        }
    }

    @Override
    public void warning(StringId msgID, Object[] params) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString(params));
        }
    }

    @Override
    public void warning(StringId msgID, Object param) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString(param));
        }
    }

    @Override
    public void warning(StringId msgID) {
        if (this.isEnabled(Level.WARN)) {
            this.warning(msgID.toLocalizedString());
        }
    }

    @Override
    public void info(StringId msgID, Object[] params, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString(params), ex);
        }
    }

    @Override
    public void info(StringId msgID, Object param, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString(param), ex);
        }
    }

    @Override
    public void info(StringId msgID, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString(), ex);
        }
    }

    @Override
    public void info(StringId msgID, Object[] params) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString(params));
        }
    }

    @Override
    public void info(StringId msgID, Object param) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString(param));
        }
    }

    @Override
    public void info(StringId msgID) {
        if (this.isEnabled(Level.INFO)) {
            this.info(msgID.toLocalizedString());
        }
    }

    @Override
    public void config(StringId msgID, Object[] params, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString(params), ex);
        }
    }

    @Override
    public void config(StringId msgID, Object param, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString(param), ex);
        }
    }

    @Override
    public void config(StringId msgID, Throwable ex) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString(), ex);
        }
    }

    @Override
    public void config(StringId msgID, Object[] params) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString(params));
        }
    }

    @Override
    public void config(StringId msgID, Object param) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString(param));
        }
    }

    @Override
    public void config(StringId msgID) {
        if (this.isEnabled(Level.INFO)) {
            this.config(msgID.toLocalizedString());
        }
    }

    @Override
    public LogWriter convertToLogWriter() {
        return this;
    }

    @Override
    public int getLogWriterLevel() {
        Level log4jLevel = this.logWrapper.getLevel();
        if (log4jLevel == Level.OFF) {
            return Integer.MAX_VALUE;
        }
        if (log4jLevel == Level.FATAL) {
            return 1000;
        }
        if (log4jLevel == Level.ERROR) {
            return 950;
        }
        if (log4jLevel == Level.WARN) {
            return 900;
        }
        if (log4jLevel == Level.INFO) {
            return 800;
        }
        if (log4jLevel == Level.DEBUG) {
            return 500;
        }
        if (log4jLevel == Level.TRACE) {
            return 400;
        }
        if (log4jLevel == Level.ALL) {
            return Integer.MIN_VALUE;
        }
        throw new IllegalStateException("Level " + log4jLevel + " could not be mapped to LogWriter level.");
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void put(int msgLevel, String msg, Throwable exception) {
        this.log(msgLevel, msg, exception);
    }

    @Override
    public void put(int msgLevel, StringId msgId, Object[] params, Throwable exception) {
        this.log(msgLevel, msgId.toLocalizedString(params), exception);
    }

    @Override
    public String getConnectionName() {
        return this.connectionName;
    }
}

