/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogConfig;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.ManagerLogWriter;
import com.gemstone.gemfire.internal.logging.SecurityManagerLogWriter;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.AppenderContext;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppender;
import com.gemstone.gemfire.internal.process.ProcessLauncherContext;
import com.gemstone.gemfire.internal.util.LogFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LogWriterAppenders {
    public static final String APPEND_TO_LOG_FILE = "gemfire.append-log";
    private static final boolean ALLOW_REDIRECT = true;
    private static Map<Identifier, LogWriterAppender> appenders = new HashMap<Identifier, LogWriterAppender>();
    private static Map<Identifier, AtomicInteger> references = new HashMap<Identifier, AtomicInteger>();

    public static synchronized LogWriterAppender getAppender(Identifier id) {
        return appenders.get((Object)id);
    }

    public static synchronized LogWriterAppender getOrCreateAppender(Identifier id, boolean appendToFile, boolean isLoner, LogConfig config, boolean logConfig) {
        LogWriterAppender appender = appenders.get((Object)id);
        if (appender == null) {
            appender = LogWriterAppenders.createLogWriterAppender(appendToFile, isLoner, id.isSecure(), config, logConfig);
            appenders.put(id, appender);
            references.put(id, new AtomicInteger(1));
        } else {
            appender.setConfig(config);
            references.get((Object)id).incrementAndGet();
        }
        return appender;
    }

    public static LogWriterAppender getOrCreateAppender(Identifier id, boolean isLoner, LogConfig config, boolean logConfig) {
        boolean appendToFile = Boolean.getBoolean(APPEND_TO_LOG_FILE);
        return LogWriterAppenders.getOrCreateAppender(id, appendToFile, isLoner, config, logConfig);
    }

    static LogWriterAppender createLogWriterAppender(boolean appendToFile, boolean isLoner, boolean isSecurity, LogConfig config, boolean logConfig) {
        FileOutputStream fos;
        boolean isDistributionConfig = config instanceof DistributionConfig;
        DistributionConfig dsConfig = isDistributionConfig ? (DistributionConfig)config : null;
        File logFile = config.getLogFile();
        String firstMsg = null;
        boolean firstMsgWarning = false;
        AlertAppender.getInstance().setAlertingDisabled(isLoner);
        if (isSecurity) {
            if (isDistributionConfig) {
                File tmpLogFile = dsConfig.getSecurityLogFile();
                if (tmpLogFile != null && !tmpLogFile.equals(new File(""))) {
                    logFile = tmpLogFile;
                }
            } else {
                throw new IllegalArgumentException("DistributionConfig is expected for SecurityLogWriter");
            }
        }
        if (logFile == null || logFile.equals(new File(""))) {
            return null;
        }
        if (logFile.exists()) {
            boolean statArchivesRolling;
            boolean useChildLogging = config.getLogFile() != null && !config.getLogFile().equals(new File("")) && config.getLogFileSizeLimit() != 0;
            boolean bl = statArchivesRolling = isDistributionConfig && dsConfig.getStatisticArchiveFile() != null && !dsConfig.getStatisticArchiveFile().equals(new File("")) && dsConfig.getArchiveFileSizeLimit() != 0 && dsConfig.getStatisticSamplingEnabled();
            if (!appendToFile || useChildLogging || statArchivesRolling) {
                File oldMain = ManagerLogWriter.getLogNameForOldMainLog(logFile, isSecurity || useChildLogging || statArchivesRolling);
                boolean succeeded = LogFileUtils.renameAggressively(logFile, oldMain);
                if (succeeded) {
                    firstMsg = LocalizedStrings.InternalDistributedSystem_RENAMED_OLD_LOG_FILE_TO_0.toLocalizedString(oldMain);
                } else {
                    firstMsgWarning = true;
                    firstMsg = LocalizedStrings.InternalDistributedSystem_COULD_NOT_RENAME_0_TO_1.toLocalizedString(logFile, oldMain);
                }
            }
        }
        try {
            fos = new FileOutputStream(logFile, true);
        }
        catch (FileNotFoundException ex) {
            String s = LocalizedStrings.InternalDistributedSystem_COULD_NOT_OPEN_LOG_FILE_0.toLocalizedString(logFile);
            throw new GemFireIOException(s, ex);
        }
        PrintStream out = new PrintStream(fos);
        ManagerLogWriter mlw = null;
        String logWriterLoggerName = null;
        if (isSecurity) {
            mlw = new SecurityManagerLogWriter(dsConfig.getSecurityLogLevel(), out, config.getName());
            logWriterLoggerName = "com.gemstone.gemfire.security";
        } else {
            mlw = new ManagerLogWriter(config.getLogLevel(), out, config.getName());
            logWriterLoggerName = "com.gemstone.gemfire";
        }
        mlw.setConfig(config);
        AppenderContext[] appenderContext = new AppenderContext[]{isSecurity ? LogService.getAppenderContext("com.gemstone.gemfire.security") : LogService.getAppenderContext()};
        LogWriterAppender appender = LogWriterAppender.create(appenderContext, logWriterLoggerName, mlw, fos);
        if (!isSecurity && "com.gemstone.gemfire".equals(logWriterLoggerName) && LogService.isUsingGemFireDefaultConfig()) {
            LogService.removeConsoleAppender();
        }
        ManagerLogWriter logWriter = mlw;
        if (firstMsg != null) {
            if (firstMsgWarning) {
                logWriter.warning(firstMsg);
            } else {
                logWriter.info(firstMsg);
            }
        }
        if (logConfig) {
            if (isLoner) {
                logWriter.info(LocalizedStrings.InternalDistributedSystem_RUNNING_IN_LOCAL_MODE_SINCE_MCASTPORT_WAS_0_AND_LOCATORS_WAS_EMPTY);
            } else {
                logWriter.info(LocalizedStrings.InternalDistributedSystem_STARTUP_CONFIGURATIONN_0, config.toLoggerString());
            }
        }
        if (ProcessLauncherContext.isRedirectingOutput()) {
            try {
                OSProcess.redirectOutput(config.getLogFile());
            }
            catch (IOException e) {
                logWriter.error(e);
            }
        }
        return appender;
    }

    public static synchronized void startupComplete(Identifier id) {
        LogWriterAppender appender = appenders.get((Object)id);
        if (appender != null) {
            appender.startupComplete();
        }
    }

    public static synchronized void destroy(Identifier id) {
        LogWriterAppender appender = appenders.get((Object)id);
        if (appender == null) {
            return;
        }
        AtomicInteger count = references.get((Object)id);
        if (count == null) {
            throw new IllegalStateException("Count is null for " + (Object)((Object)id));
        }
        if (count.get() < 0) {
            throw new IllegalStateException("Count is non-positive integer for " + (Object)((Object)id) + ": " + count.get());
        }
        if (count.decrementAndGet() > 0) {
            return;
        }
        appenders.remove((Object)id);
        references.remove((Object)id);
        appender.destroy();
    }

    public static synchronized void stop(Identifier id) {
        LogWriterAppender appender = appenders.get((Object)id);
        if (appender != null) {
            appender.stop();
        }
    }

    public static synchronized void configChanged(Identifier id) {
        LogWriterAppender appender = appenders.get((Object)id);
        if (appender != null) {
            appender.configChanged();
        }
    }

    public static enum Identifier {
        MAIN(false),
        SECURITY(true);

        private final boolean isSecure;

        private Identifier(boolean isSecure) {
            this.isSecure = isSecure;
        }

        public boolean isSecure() {
            return this.isSecure;
        }
    }
}

