/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging.log4j;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.apache.logging.log4j.status.StatusLogger;

public class FastLogger
extends ExtendedLoggerWrapper {
    private static final long serialVersionUID = 7084130827962463327L;
    private static volatile boolean debugAvailable = true;

    public FastLogger(Logger logger) {
        this((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
    }

    public FastLogger(ExtendedLogger logger, String name, MessageFactory messageFactory) {
        super(logger, name, messageFactory);
    }

    public static void setDebugAvailable(boolean newValue) {
        StatusLogger.getLogger().debug("Setting debugAvailable to {}", newValue);
        debugAvailable = newValue;
    }

    @Override
    public boolean isDebugEnabled() {
        return debugAvailable && super.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return debugAvailable && super.isDebugEnabled(marker);
    }

    @Override
    public boolean isTraceEnabled() {
        return debugAvailable && super.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return debugAvailable && super.isTraceEnabled(marker);
    }

    public boolean isDebugAvailable() {
        return debugAvailable;
    }

    public Logger getExtendedLogger() {
        return this.logger;
    }
}

