/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.internal.logging.log4j.AppenderContext;
import com.gemstone.gemfire.internal.logging.log4j.Configurator;
import com.gemstone.gemfire.internal.logging.log4j.FastLogger;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.org.apache.logging.log4j.message.GemFireParameterizedMessageFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public class LogService
extends LogManager {
    public static final String BASE_LOGGER_NAME = "com.gemstone";
    public static final String MAIN_LOGGER_NAME = "com.gemstone.gemfire";
    public static final String SECURITY_LOGGER_NAME = "com.gemstone.gemfire.security";
    public static final String GEMFIRE_VERBOSE_FILTER = "{GEMFIRE_VERBOSE}";
    protected static final String STDOUT = "STDOUT";
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeListenerImpl();
    private static final String DEFAULT_CONFIG = "/com/gemstone/gemfire/internal/logging/log4j/log4j2-default.xml";
    private static Appender stdoutAppender;

    private static void init() {
        LogService.setLog4jConfigFileProperty();
        LoggerContext context = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger(BASE_LOGGER_NAME, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext();
        context.reconfigure();
        context.removePropertyChangeListener(propertyChangeListener);
        context.addPropertyChangeListener(propertyChangeListener);
        LogService.setFastLoggerDebugAvailableFlag();
        LogService.configureLoggers(false, false);
    }

    public static void initialize() {
        new LogService();
    }

    public static void reconfigure() {
        LogService.init();
    }

    public static void configureLoggers(boolean hasLogFile, boolean hasSecurityLogFile) {
        Configurator.getOrCreateLoggerConfig(BASE_LOGGER_NAME, true, false);
        Configurator.getOrCreateLoggerConfig(MAIN_LOGGER_NAME, true, hasLogFile);
        boolean useMainLoggerForSecurity = !hasSecurityLogFile;
        Configurator.getOrCreateLoggerConfig(SECURITY_LOGGER_NAME, useMainLoggerForSecurity, hasSecurityLogFile);
    }

    public static AppenderContext getAppenderContext() {
        return new AppenderContext();
    }

    public static AppenderContext getAppenderContext(String name) {
        return new AppenderContext(name);
    }

    public static boolean isUsingGemFireDefaultConfig() {
        String configFileName = new StrSubstitutor(new Interpolator()).replace(PropertiesUtil.getProperties().getStringProperty("log4j.configurationFile"));
        return configFileName == null ? false : configFileName.contains(DEFAULT_CONFIG);
    }

    private static final void setLog4jConfigFileProperty() {
        String configFileName = new StrSubstitutor(new Interpolator()).replace(PropertiesUtil.getProperties().getStringProperty("log4j.configurationFile"));
        if (configFileName != null) {
            URL configUrl = LogService.class.getResource(configFileName);
            if (configUrl == null) {
                StatusLogger.getLogger().info("Using log4j configuration file '{}'", configFileName);
                return;
            }
            StatusLogger.getLogger().info("Using log4j configuration file '{}'", configUrl.getPath());
            System.setProperty("log4j.configurationFile", configUrl.toString());
            return;
        }
        File log4jConfigFile = LogService.findLog4jConfigInCurrentDir();
        if (log4jConfigFile != null) {
            String filePath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(log4jConfigFile);
            String value2 = new File(filePath).toURI().toString();
            System.setProperty("log4j.configurationFile", new File(filePath).toURI().toString());
            StatusLogger.getLogger().debug("Using log4j configuration file '{}'", value2);
            return;
        }
        URL configUrl = LogService.class.getResource(DEFAULT_CONFIG);
        StatusLogger.getLogger().info("Using log4j configuration file '{}'", configUrl.getPath());
        System.setProperty("log4j.configurationFile", configUrl.toString());
    }

    public static File findLog4jConfigInCurrentDir() {
        for (String fileExtension : new String[]{"-test.json", "-test.jsn", "-test.xml", "-test.yaml", "-test.yml", ".json", ".jsn", ".xml", ".yaml", ".yml"}) {
            File log4jConfigFile = new File(System.getProperty("user.dir"), "log4j2" + fileExtension);
            if (!log4jConfigFile.isFile()) continue;
            return log4jConfigFile;
        }
        return null;
    }

    public static Logger getLogger() {
        return new FastLogger(LogManager.getLogger(LogService.getClassName(2), (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE));
    }

    public static Logger getLogger(String name) {
        return new FastLogger(LogManager.getLogger(name, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE));
    }

    public static LogWriterLogger createLogWriterLogger(String name, String connectionName, boolean isSecure) {
        return LogWriterLogger.create(name, connectionName, isSecure);
    }

    public static Level toLevel(int intLevel) {
        for (Level level : Level.values()) {
            if (level.intLevel() != intLevel) continue;
            return level;
        }
        throw new IllegalArgumentException("Unknown int level [" + intLevel + "].");
    }

    public static String getClassName(int depth) {
        return new Throwable().getStackTrace()[depth].getClassName();
    }

    public static void setFastLoggerDebugAvailableFlag() {
        Configuration config = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger(BASE_LOGGER_NAME, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext().getConfiguration();
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            if (!loggerConfig.getName().startsWith(BASE_LOGGER_NAME) || (!loggerConfig.hasFilter() || GEMFIRE_VERBOSE_FILTER.equals(loggerConfig.getFilter().toString())) && !loggerConfig.getLevel().isLessSpecificThan(Level.DEBUG)) continue;
            FastLogger.setDebugAvailable(true);
            return;
        }
        if (config.hasFilter()) {
            FastLogger.setDebugAvailable(true);
        } else {
            FastLogger.setDebugAvailable(false);
        }
    }

    public static void setBaseLogLevel(Level level) {
        Configurator.setLevel(BASE_LOGGER_NAME, level);
        Configurator.setLevel(MAIN_LOGGER_NAME, level);
    }

    public static Level getBaseLogLevel() {
        return Configurator.getLevel(BASE_LOGGER_NAME);
    }

    public static LoggerConfig getRootLoggerConfig() {
        return Configurator.getLoggerConfig(LogManager.getRootLogger().getName());
    }

    public static synchronized void removeConsoleAppender() {
        AppenderContext appenderContext = LogService.getAppenderContext("");
        LoggerConfig config = appenderContext.getLoggerConfig();
        Appender stdout = config.getAppenders().get(STDOUT);
        if (stdout != null) {
            config.removeAppender(STDOUT);
            stdoutAppender = stdout;
            appenderContext.getLoggerContext().updateLoggers();
        }
    }

    public static synchronized void restoreConsoleAppender() {
        if (stdoutAppender == null) {
            return;
        }
        AppenderContext appenderContext = LogService.getAppenderContext("");
        LoggerConfig config = appenderContext.getLoggerConfig();
        Appender stdout = config.getAppenders().get(STDOUT);
        if (stdout == null) {
            config.addAppender(stdoutAppender, Level.ALL, null);
            appenderContext.getLoggerContext().updateLoggers();
        }
    }

    private LogService() {
    }

    static {
        LogService.init();
    }

    private static class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StatusLogger.getLogger().debug("LogService responding to a property change event. Property name is {}.", evt.getPropertyName());
            if (evt.getPropertyName().equals("config")) {
                LogService.setFastLoggerDebugAvailableFlag();
            }
        }
    }
}

