/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.DateFormatter;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class GemFireFormatter
extends Formatter {
    private final LogWriter logWriter;
    private final DateFormat dateFormat = DateFormatter.createDateFormat();

    public GemFireFormatter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public String format(LogRecord record) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.print('[');
        pw.print(record.getLevel().getName());
        pw.print(' ');
        pw.print(this.dateFormat.format(new Date(record.getMillis())));
        String threadName = Thread.currentThread().getName();
        if (threadName != null) {
            pw.print(' ');
            pw.print(threadName);
        }
        pw.print(" tid=0x");
        pw.print(Long.toHexString(Thread.currentThread().getId()));
        pw.print("] ");
        pw.print("(msgTID=");
        pw.print(record.getThreadID());
        pw.print(" msgSN=");
        pw.print(record.getSequenceNumber());
        pw.print(") ");
        String msg = record.getMessage();
        if (msg != null) {
            try {
                LogWriterImpl.formatText(pw, msg, 40);
            }
            catch (RuntimeException e) {
                pw.println(msg);
                pw.println(LocalizedStrings.GemFireFormatter_IGNORING_THE_FOLLOWING_EXCEPTION.toLocalizedString());
                e.printStackTrace(pw);
            }
        } else {
            pw.println();
        }
        if (record.getThrown() != null) {
            record.getThrown().printStackTrace(pw);
        }
        pw.close();
        try {
            sw.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        String result = sw.toString();
        return result;
    }
}

