/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.licensing.LicenseEngine;
import com.gemstone.gemfire.internal.licensing.LogWriterAdapter;
import com.gemstone.gemfire.internal.licensing.UpgradeType;
import com.springsource.vfabric.licensing.client.LicenseManager;
import com.springsource.vfabric.licensing.client.LicenseManagerFactory;
import com.springsource.vfabric.licensing.client.MasterLicenseManager;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.InstanceState;
import com.springsource.vfabric.licensing.state.LicenseState;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VFabricLicenseEngine
implements LicenseEngine {
    public static final String DEFAULT_EVAL_SERIAL_DMN = "G04E0-MFK43-M8E1H-0ZARK-AV25A";
    public static final String DEFAULT_EVAL_SERIAL_ADVANCED = "C10EH-H4LD1-48DKR-04AKK-2PHQF";
    static final String PREVENT_OS_CHECK_FAILURE_PROPERTY = "gemfire.licensing.preventOSCheckFailure";
    static final String DEFAULT_PREVENT_OS_CHECK_FAILURE = "false";
    public static final String ENABLE_LICENSING_CLIENT_LOG_PROPERTY = "gemfire.licensing.enableLicensingClientLog";
    static final String DEFAULT_ENABLE_LICENSING_CLIENT_LOG = "true";
    public static final String LICENSING_CLIENT_LOG_VERBOSE_PROPERTY = "gemfire.licensing.licensingClientLogVerbose";
    static final String DEFAULT_LICENSING_CLIENT_LOG_VERBOSE = "false";
    static final String LICENSING_CLIENT_STATE_FILE_PROPERTY = "gemfire.licensing.licensingClientStateFile";
    static final String LICENSING_CLIENT_EVENTS_FILE_PROPERTY = "gemfire.licensing.licensingClientEventsFile";
    static final String LICENSE_SERVER_TIMEOUT_PROPERTY = "gemfire.licensing.licenseServerTimeout";
    private final LicenseChecker licenseChecker;
    private final int licenseServerTimeout;
    private LicenseManager licenseManager;
    private boolean licenseAcquired = false;
    private LicenseState licenseState;
    private Map<Object, InstanceState> managedComponentStates;

    static int determineLicenseServerTimeout(DistributionConfig config) {
        int licenseServerTimeoutValue;
        int value2 = 10000;
        value2 = Integer.getInteger("gemfire.license-server-timeout", value2);
        if (config != null) {
            value2 = config.getLicenseServerTimeout();
        }
        if ((licenseServerTimeoutValue = Integer.getInteger(LICENSE_SERVER_TIMEOUT_PROPERTY, value2).intValue()) < 1000 || licenseServerTimeoutValue > 3600000) {
            licenseServerTimeoutValue = value2;
        }
        return licenseServerTimeoutValue;
    }

    public VFabricLicenseEngine(LicenseChecker licenseChecker) {
        this.licenseChecker = licenseChecker;
        this.licenseServerTimeout = VFabricLicenseEngine.determineLicenseServerTimeout(licenseChecker.getDistributionConfig());
        this.configureLicensingClientLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLicense() throws LicenseException {
        long start;
        if (!this.licenseAcquired) {
            start = System.currentTimeMillis();
            RuntimeException runtimeException = null;
            int maxAttempts = 10;
            for (int i = 0; i < maxAttempts && !this.licenseAcquired; ++i) {
                runtimeException = null;
                boolean interrupted = Thread.interrupted();
                try {
                    this.getLicenseManager().setComponentState("on");
                    this.licenseAcquired = true;
                    continue;
                }
                catch (RuntimeException e) {
                    runtimeException = e;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.licenseChecker.getCancelCriterion().checkCancelInProgress(ie);
                    }
                    continue;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (!this.licenseAcquired) {
                if (runtimeException instanceof LicenseException) {
                    throw runtimeException;
                }
                throw new LicenseException("Failed to acquire license using vFabric Licensing Client", runtimeException);
            }
        } else {
            throw new IllegalStateException("License already acquired.");
        }
        long stop = System.currentTimeMillis();
        this.licenseChecker.getLogWriter().config("vFabric Licensing Client activation of license required " + (stop - start) + " milliseconds.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLicense() {
        if (this.licenseAcquired) {
            RuntimeException runtimeException = null;
            int maxAttempts = 10;
            for (int i = 0; i < maxAttempts && this.licenseAcquired; ++i) {
                runtimeException = null;
                boolean interrupted = Thread.interrupted();
                try {
                    this.getLicenseManager().setComponentState("off");
                    this.licenseAcquired = false;
                    continue;
                }
                catch (RuntimeException e) {
                    runtimeException = e;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.licenseChecker.getCancelCriterion().checkCancelInProgress(ie);
                    }
                    continue;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.licenseAcquired) {
                this.licenseAcquired = false;
                this.getLogWriter().config("vFabric Licensing Client failed to releaseLicense", runtimeException);
            }
        }
    }

    @Override
    public boolean acquiredLicense() {
        return this.licenseAcquired;
    }

    @Override
    public boolean includesUpgrade(UpgradeType type) {
        return this.getLicenseState().getAddonFeatures().contains(type.getId());
    }

    @Override
    public int getQuantity() {
        return this.getLicenseState().getTotalAvailable();
    }

    @Override
    public String getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getExpiration() {
        return this.getLicenseState().getExpirationDate();
    }

    @Override
    public Date getTimestamp() {
        return this.getLicenseState().getTimestamp();
    }

    @Override
    public String getHostToken() {
        Properties extendedParams = this.getLicenseState().getExtendedParameters();
        return extendedParams == null ? null : extendedParams.getProperty("host.token");
    }

    @Override
    public boolean isExpired() {
        Date expDate = this.getLicenseState().getExpirationDate();
        return expDate != null && new Date().after(expDate);
    }

    @Override
    public boolean isDefaultEvaluation() {
        return "default".equals(this.getLicenseState().getLicenseType()) || this.licenseChecker.getSerialNumber() != null && this.licenseChecker.getSerialNumber().contains(DEFAULT_EVAL_SERIAL_DMN) || this.licenseChecker.getSerialNumber() != null && this.licenseChecker.getSerialNumber().contains(DEFAULT_EVAL_SERIAL_ADVANCED);
    }

    @Override
    public boolean isServerLicense() {
        return "server".equals(this.getLicenseState().getLicenseType());
    }

    @Override
    public void shutdown() {
        this.releaseAllManagedLicenses();
        if (this.licenseManager != null && this.licenseManager instanceof MasterLicenseManager) {
            ((MasterLicenseManager)this.licenseManager).shutdown();
        }
        LogWriterAdapter.shutdown();
    }

    LicenseState getLicenseState() throws LicenseException {
        if (this.licenseState == null) {
            this.licenseState = this.licenseChecker.requestDynamicSerialNumber() ? this.fetchDynamicLicenseState() : this.fetchLicenseState();
        }
        return this.licenseState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseState fetchLicenseState() throws LicenseException {
        LicenseState newLicenseState = null;
        RuntimeException runtimeException = null;
        boolean pollAgain = true;
        int maxAttempts = 10;
        for (int i = 0; i < maxAttempts && pollAgain; ++i) {
            runtimeException = null;
            boolean interrupted = Thread.interrupted();
            try {
                newLicenseState = this.getLicenseManager().getComponentLicenseState();
                pollAgain = newLicenseState == null;
                continue;
            }
            catch (RuntimeException e) {
                runtimeException = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.licenseChecker.getCancelCriterion().checkCancelInProgress(ie);
                }
                continue;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (newLicenseState == null) {
            throw new LicenseException("Failed to acquire LicenseState from vFabric Licensing Client", runtimeException);
        }
        return newLicenseState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseState fetchDynamicLicenseState() throws LicenseException {
        Assert.assertTrue(this.licenseChecker.requestDynamicSerialNumber());
        LicenseState newLicenseState = null;
        RuntimeException runtimeException = null;
        boolean pollAgain = true;
        boolean timedOut = false;
        long begin = System.currentTimeMillis();
        long end = begin + (long)this.licenseServerTimeout;
        while (pollAgain && !timedOut) {
            runtimeException = null;
            boolean interrupted = Thread.interrupted();
            try {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.licenseChecker.getCancelCriterion().checkCancelInProgress(ie);
                }
                newLicenseState = this.getLicenseManager().getComponentLicenseState();
                pollAgain = newLicenseState == null || "default".equals(newLicenseState.getLicenseType());
            }
            catch (RuntimeException e) {
                try {
                    runtimeException = e;
                }
                catch (Throwable throwable) {
                    boolean bl = timedOut = pollAgain && System.currentTimeMillis() > end;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                boolean bl = timedOut = pollAgain && System.currentTimeMillis() > end;
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            boolean bl = timedOut = pollAgain && System.currentTimeMillis() > end;
            if (!interrupted) continue;
            Thread.currentThread().interrupt();
        }
        if (timedOut && "default".equals(newLicenseState.getLicenseType())) {
            String msg = "Timeout: vFabric Licensing Client waited for more than " + this.licenseServerTimeout / 1000 + " seconds to get license from vFabric License Server.";
            this.getLogWriter().config(msg);
        }
        if (newLicenseState == null) {
            throw new LicenseException("Failed to acquire LicenseState from vFabric Licensing Client", runtimeException);
        }
        return newLicenseState;
    }

    private LogWriter getLogWriter() {
        return this.licenseChecker.getLogWriter();
    }

    private void configureLicensingClientLogger() {
        try {
            boolean enableLicensingClientLog = Boolean.parseBoolean(System.getProperty(ENABLE_LICENSING_CLIENT_LOG_PROPERTY, DEFAULT_ENABLE_LICENSING_CLIENT_LOG));
            if (enableLicensingClientLog) {
                boolean licensingClientLogVerbose = Boolean.parseBoolean(System.getProperty(LICENSING_CLIENT_LOG_VERBOSE_PROPERTY, "false"));
                LogWriterAdapter logWriterAdapter = LogWriterAdapter.getLogWriterAdapter(this.getLogWriter(), licensingClientLogVerbose);
                Logger.setLogFactory(logWriterAdapter);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    File getStateFile() {
        String defaultName = this.licenseChecker.getComponentType().getId() + "-license.cfg";
        return this.getFile(defaultName, LICENSING_CLIENT_STATE_FILE_PROPERTY);
    }

    File getEventsFile() {
        String defaultName = this.licenseChecker.getComponentType().getId() + "-events.txt";
        return this.getFile(defaultName, LICENSING_CLIENT_EVENTS_FILE_PROPERTY);
    }

    private boolean hasOverriddenFile() {
        return System.getProperty(LICENSING_CLIENT_STATE_FILE_PROPERTY) != null || System.getProperty(LICENSING_CLIENT_EVENTS_FILE_PROPERTY) != null;
    }

    private File getFile(String defaultName, String overrideProperty) {
        String dir = this.licenseChecker.getDirectory().getAbsolutePath().toString();
        String fileName = defaultName;
        String propValue = System.getProperty(overrideProperty);
        if (propValue != null && !propValue.equals("")) {
            if (propValue.contains(File.separator)) {
                return new File(propValue);
            }
            fileName = propValue;
        }
        return new File(dir + File.separator + fileName);
    }

    private LicenseManager getLicenseManager() throws LicenseException {
        if (this.licenseManager == null) {
            boolean preventOSCheckFailure = Boolean.parseBoolean(System.getProperty(PREVENT_OS_CHECK_FAILURE_PROPERTY, "false"));
            String osName = System.getProperty("os.name");
            try {
                if (preventOSCheckFailure && !osName.toLowerCase().contains("windows") && !osName.toLowerCase().contains("linux") && !osName.toLowerCase().contains("mac os")) {
                    this.licenseChecker.getLogWriter().config("Using gemfire.licensing.preventOSCheckFailure");
                    System.setProperty("os.name", "unix");
                }
                this.licenseManager = this.hasOverriddenFile() ? LicenseManagerFactory.getLicenseManager(this.licenseChecker.getComponentType().getId(), this.licenseChecker.getVersion(), this.licenseChecker.createSerialNumberArray(), this.getStateFile(), this.getEventsFile()) : LicenseManagerFactory.getLicenseManager(this.licenseChecker.getComponentType().getId(), this.licenseChecker.getVersion(), this.licenseChecker.createSerialNumberArray(), this.licenseChecker.getDirectory());
            }
            catch (com.springsource.vfabric.licensing.client.LicenseException e) {
                throw new LicenseException(e);
            }
            finally {
                if (preventOSCheckFailure) {
                    System.setProperty("os.name", osName);
                }
            }
        }
        return this.licenseManager;
    }

    @Override
    public int getLicenseServerTimeout() {
        return this.licenseServerTimeout;
    }

    @Override
    public boolean acquiredManagedLicenses() {
        return this.managedComponentStates != null && this.managedComponentStates.size() > 0;
    }

    @Override
    public void acquireManagedLicense(Object identifier) {
        InstanceState runningState;
        if (this.managedComponentStates == null) {
            this.managedComponentStates = new HashMap<Object, InstanceState>();
        }
        if ((runningState = this.managedComponentStates.get(identifier)) == null) {
            runningState = new InstanceState(identifier.toString(), "ipmac", "on", null);
            this.managedComponentStates.put(identifier, runningState);
            this.updateManagedLicenseStates(Arrays.asList(runningState));
        }
    }

    @Override
    public void releaseManagedLicense(Object identifier) {
        InstanceState runningState;
        if (this.managedComponentStates != null && (runningState = this.managedComponentStates.remove(identifier)) != null) {
            InstanceState stoppingState = new InstanceState(runningState.getIdentifier(), runningState.getIdentifierType(), "off", null);
            this.updateManagedLicenseStates(Arrays.asList(stoppingState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManagedLicenseStates(Collection<InstanceState> states2) {
        boolean updatedManagedLicense = false;
        RuntimeException runtimeException = null;
        int maxAttempts = 10;
        for (int i = 0; i < maxAttempts && !updatedManagedLicense; ++i) {
            runtimeException = null;
            boolean interrupted = Thread.interrupted();
            try {
                this.getLicenseManager().setManagedComponentStates(states2);
                updatedManagedLicense = true;
                continue;
            }
            catch (RuntimeException e) {
                runtimeException = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.licenseChecker.getCancelCriterion().checkCancelInProgress(ie);
                }
                continue;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (!updatedManagedLicense) {
            if (runtimeException instanceof LicenseException) {
                throw runtimeException;
            }
            throw new LicenseException("Failed to update managed license(s) using vFabric Licensing Client", runtimeException);
        }
    }

    private void releaseAllManagedLicenses() {
        if (this.managedComponentStates != null) {
            ArrayList<InstanceState> stoppingStates = new ArrayList<InstanceState>();
            for (InstanceState runningState : this.managedComponentStates.values()) {
                stoppingStates.add(new InstanceState(runningState.getIdentifier(), runningState.getIdentifierType(), "off", null));
            }
            this.managedComponentStates.clear();
            this.updateManagedLicenseStates(stoppingStates);
        }
    }
}

