/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.SystemAdmin;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.licensing.ComponentType;
import com.gemstone.gemfire.internal.licensing.LicenseEngine;
import com.gemstone.gemfire.internal.licensing.LicenseListener;
import com.gemstone.gemfire.internal.licensing.UnlicensedPeerLimiter;
import com.gemstone.gemfire.internal.licensing.UpgradeType;
import com.gemstone.gemfire.internal.licensing.VFabricLicenseEngine;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.SerialNumberReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class LicenseChecker {
    static final int UNLICENSED_PEER_LIMIT = 3;
    static final int UNLICENSED_CLIENT_LIMIT = 3;
    public static final String PROPERTY_SERIAL_NUMBER = "serial-number";
    public static final String PROPERTY_UNLICENSED = "unlicensed";
    public static final String PROPERTY_COMPONENT_TYPE = "component-type";
    static final String VERSION_PROPERTY = "gemfire.licensing.Version";
    static final String LICENSE_ENGINE_PROPERTY = "gemfire.licensing.LicenseEngine";
    static final String DEFAULT_LICENSE_ENGINE = "com.gemstone.gemfire.internal.licensing.VFabricLicenseEngine";
    public static final String IGNORE_HIDDEN_PROPERTY = "gemfire.licensing.ignoreHidden";
    public static final String ADD_EXPECTED_EXCEPTION_ANNOTATIONS = "gemfire.licensing.addExpectedExceptions";
    public static final String ALERT_LEVEL_PROPERTY = "gemfire.licensing.alertLevel";
    public static final String DEFAULT_ALERT_LEVEL = "config";
    static final String TEST_LICENSE_EVERY_INSTANCE_PROPERTY = "gemfire.licensing.test.licenseEveryInstance";
    static final String USE_VFABRIC_WORKING_DIR_PROPERTY = "gemfire.licensing.useVFabricWorkingDir";
    static final boolean useVFabricWorkingDir = Boolean.getBoolean("gemfire.licensing.useVFabricWorkingDir");
    static final String USE_EVAL_IF_SERIAL_NUMBER_FAILS_PROPERTY = "gemfire.licensing.useEvalIfSerialNumberFails";
    static final boolean useEvalIfSerialNumberFails = Boolean.getBoolean("gemfire.licensing.useEvalIfSerialNumberFails");
    public static final String DYNAMIC_SERIAL_NUMBER = "dynamic";
    private static Set<LicenseListener> licenseListeners;
    private final InternalDistributedSystem ids;
    private final File dir;
    private final LogWriter log;
    private final int alertLevel;
    private final boolean requestDynamicSerialNumber;
    private final boolean licenseEveryInstance;
    private final UnlicensedPeerLimiter unlicensedPeerLimiter;
    protected final ComponentType componentType;
    protected String serialNumber;
    private LicenseEngine licenseEngine;

    public static File determineLicenseWorkingDir() {
        if (useVFabricWorkingDir) {
            boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
            String path = isWindows ? System.getenv("ALLUSERSPROFILE") + "\\VMware\\vFabric" : "/opt/vmware/vFabric";
            File writableWorkingDir = new File(path);
            if (!writableWorkingDir.exists()) {
                writableWorkingDir = new File("");
            }
            return writableWorkingDir;
        }
        return new File("");
    }

    public static synchronized void addLicenseListener(LicenseListener listener) {
        if (licenseListeners == null) {
            licenseListeners = new HashSet<LicenseListener>(1);
        }
        licenseListeners.add(listener);
    }

    public static synchronized void removeLicenseListener(LicenseListener listener) {
        if (licenseListeners == null) {
            return;
        }
        licenseListeners.remove(listener);
    }

    public static synchronized void clearLicenseListeners() {
        if (licenseListeners == null) {
            return;
        }
        licenseListeners.clear();
        licenseListeners = null;
    }

    static synchronized Set<LicenseListener> getLicenseListeners() {
        if (licenseListeners == null) {
            return Collections.emptySet();
        }
        return licenseListeners;
    }

    LicenseChecker(InternalDistributedSystem ids, File dir, LogWriter log, String serialNumber, ComponentType componentType, UnlicensedPeerLimiter unlicensedPeerLimiter) {
        File serialFile;
        this.componentType = componentType;
        this.unlicensedPeerLimiter = null;
        this.licenseEveryInstance = Boolean.getBoolean(TEST_LICENSE_EVERY_INSTANCE_PROPERTY);
        this.ids = ids;
        this.log = log;
        int alertLevelInt = 1000;
        try {
            String alertLevelValue = System.getProperty(ALERT_LEVEL_PROPERTY, DEFAULT_ALERT_LEVEL);
            alertLevelInt = LogWriterImpl.levelNameToCode(alertLevelValue);
        }
        catch (Exception e) {
            alertLevelInt = 1000;
        }
        this.alertLevel = alertLevelInt;
        if (!(dir == null || dir.toString().equals("") || dir.exists() && dir.canWrite())) {
            this.dir = new File(System.getProperty("user.dir"));
            if (dir.getAbsolutePath().equals(this.dir.getAbsolutePath())) {
                this.log.config("The license-working-dir \"" + dir + "\" is the current working directory which is read-only.");
            } else {
                this.log.config("The license-working-dir \"" + dir + "\" does not exist or is read-only. Defaulting to current working directory \"" + this.dir + "\".");
            }
        } else if (dir == null || dir.toString().equals("")) {
            this.dir = new File(System.getProperty("user.dir"));
            this.log.config("Defaulting license-working-dir to current working directory \"" + this.dir + "\".");
        } else {
            this.dir = dir;
            this.log.config("Using license-working-dir \"" + this.dir + "\".");
        }
        if ((serialNumber == null || serialNumber.equals("")) && (serialFile = this.getHiddenSerialFile()) != null) {
            boolean success = false;
            try {
                this.log.config("LicenseChecker found hidden serial file \"" + serialFile + "\".");
                SerialNumberReader holder = new SerialNumberReader(serialFile);
                Collection<String> serials = holder.getSerialNumbers();
                boolean comma = false;
                StringBuilder sb = new StringBuilder();
                for (String serial : serials) {
                    if (comma) {
                        sb.append(",");
                    }
                    sb.append(serial);
                    comma = true;
                }
                this.serialNumber = sb.toString();
                success = true;
            }
            catch (LocalLicenseConfigurationException e) {
                // empty catch block
            }
            if (success) {
                this.log.config("LicenseChecker using hidden serial number \"" + this.serialNumber + "\".");
                this.requestDynamicSerialNumber = false;
                return;
            }
        }
        if (serialNumber != null && serialNumber.trim().equals(DYNAMIC_SERIAL_NUMBER)) {
            this.requestDynamicSerialNumber = true;
            this.serialNumber = serialNumber.trim();
        } else {
            this.requestDynamicSerialNumber = false;
            if (serialNumber != null && !serialNumber.trim().equals("")) {
                if (serialNumber.contains(",")) {
                    StringBuilder sb = new StringBuilder();
                    String[] snArray = LicenseChecker.createSerialNumberArray(serialNumber);
                    for (int i = 0; i < snArray.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(snArray[i].trim());
                    }
                    this.serialNumber = sb.toString();
                } else {
                    this.serialNumber = serialNumber.trim();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLicense() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            String msg;
            if ("".equals(this.serialNumber) || this.serialNumber == null) {
                return;
            }
            if (this.licenseEngine == null) {
                this.ensureLicenseEngineExists();
            }
            if (this.log.configEnabled()) {
                if (!this.isDefaultEvaluationSerialNumber()) {
                    this.log.config("Acquiring " + this.getComponentType().getShortName() + " license with serial number \"" + this.serialNumber + "\".");
                } else if (this.requestDynamicSerialNumber) {
                    this.log.config("Acquiring " + this.getComponentType().getShortName() + " license dynamically from vFabric installation or vFabric License Server.");
                } else {
                    this.log.config("Acquiring default evaluation license.");
                }
            }
            this.acquireLicense(this.licenseEngine);
            if (this.unlicensed() && !this.serialNumber.equals("") && !this.isDefaultEvaluationSerialNumber()) {
                msg = null;
                msg = useEvalIfSerialNumberFails ? (this.requestDynamicSerialNumber ? "Failed to dynamically acquire a " + this.getComponentType().getShortName() + " license within the " + this.getLicenseEngine().getLicenseServerTimeout() / 1000 + " second timeout. Consider increasing license-server-timeout. Using default evaluation license." : "The specified serial number \"" + this.serialNumber + "\" may be expired or invalid for " + this.getComponentType().getShortName() + " license. Using default evaluation license.") : (this.requestDynamicSerialNumber ? "Failed to dynamically acquire a " + this.getComponentType().getShortName() + " license within the " + this.getLicenseEngine().getLicenseServerTimeout() / 1000 + " second timeout. Consider increasing license-server-timeout or remove \"dynamic\" from configuration in order to use the default evaluation license." : "The specified serial number \"" + this.serialNumber + "\" may be expired or invalid for " + this.getComponentType().getShortName() + " license. Remove serial number from configuration in order to use the default evaluation license.");
                this.logError(msg);
                for (LicenseListener listener : LicenseChecker.getLicenseListeners()) {
                    try {
                        listener.serialNumberFailed(this.serialNumber);
                    }
                    catch (Exception e) {
                        this.log.config("LicenseListener " + listener + " serialNumberFailed threw " + e.getMessage(), e);
                    }
                }
                if (!useEvalIfSerialNumberFails) {
                    this.releaseLicense();
                }
            }
            if (this.log.fineEnabled()) {
                Date expiration;
                boolean hasUnlimitedClients = this.includesUpgrade(UpgradeType.UNLIMITED_CLIENT);
                boolean isWanEnabled = this.isWanEnabled();
                boolean hasAddons = hasUnlimitedClients || isWanEnabled;
                Date date = expiration = this.unlicensed() ? null : this.getExpiration();
                if (this.log.fineEnabled()) {
                    this.log.fine(this + " activated " + (this.unlicensed() ? "default evaluation license with quantity " : (expiration == null ? "permanent " : "evaluation ") + "license with quantity ") + this.getQuantity() + (hasAddons ? " and addons" : " and no addons") + (hasUnlimitedClients ? " unlimited-clients-upgrade" : "") + (isWanEnabled ? " global-wan-upgrade" : "") + (expiration != null ? " which expires on " + expiration : ""));
                }
            } else if (this.unlicensed() && this.isDefaultEvaluationSerialNumber()) {
                msg = "Using the default evaluation license.";
                this.log.config(msg);
            }
            if (this.requestDynamicSerialNumber && this.getLicenseEngine().isServerLicense()) {
                this.log.config("Using " + this.getComponentType().getShortName() + " license acquired from vFabric License Server.");
            }
            for (LicenseListener listener : LicenseChecker.getLicenseListeners()) {
                try {
                    listener.acquiredLicense();
                }
                catch (Exception e) {
                    this.log.config("LicenseListener " + listener + " acquiredLicense threw " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLicense() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            if (this.licenseEngine != null) {
                try {
                    this.releaseLicense(this.licenseEngine);
                    for (LicenseListener listener : LicenseChecker.getLicenseListeners()) {
                        try {
                            listener.releasedLicense();
                        }
                        catch (Exception e) {
                            this.log.config("LicenseListener " + listener + " releasedLicense threw " + e.getMessage(), e);
                        }
                    }
                }
                finally {
                    this.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getLicenseProperties() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            Properties props = new Properties();
            props.setProperty(PROPERTY_UNLICENSED, String.valueOf(false));
            props.setProperty(PROPERTY_COMPONENT_TYPE, this.getComponentType().name());
            if (this.serialNumber != null && this.serialNumber.trim().length() > 0 && !this.isDefaultEvaluationSerialNumber()) {
                props.setProperty(PROPERTY_SERIAL_NUMBER, this.serialNumber);
            } else {
                props.setProperty(PROPERTY_SERIAL_NUMBER, Version.CURRENT.toString());
            }
            return props;
        }
    }

    public void checkMembershipRequest(InternalDistributedMember other, Properties props) {
    }

    public void checkSerialNumber(InternalDistributedMember other, Properties props) {
    }

    public void checkPeerLimit(InternalDistributedMember member) throws LicenseException {
    }

    void checkPeerLimit(int peers) throws LicenseException {
    }

    public void checkBridgeEnabled() throws LicenseException {
    }

    public boolean allowsUnlimitedClients() {
        return true;
    }

    public void checkWanEnabled() throws LicenseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostToken() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.licenseEngine == null ? null : this.licenseEngine.getHostToken();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("componentType=").append((Object)this.getComponentType());
        sb.append(", dir=").append(this.dir);
        sb.append(", serialNumber=").append(this.getSerialNumber());
        sb.append(", acquiredLicense=").append(this.acquiredLicense());
        if (this.acquiredLicense()) {
            sb.append(", licensed=").append(!this.unlicensed());
        }
        return sb.append("}").toString();
    }

    public void checkUnlicensedClientLimit(int clients) throws LicenseException {
    }

    abstract void acquireLicense(LicenseEngine var1);

    abstract void releaseLicense(LicenseEngine var1);

    public abstract int getQuantity();

    public ComponentType getComponentType() {
        return this.componentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBridgeEnabled() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.unlicensed() || this.getComponentType() == ComponentType.DATA_MANAGEMENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWanEnabled() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.includesUpgrade(UpgradeType.GLOBAL_WAN) || this.includesUpgrade(UpgradeType.SQLF_ENTERPRISE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isExpired() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.getLicenseEngine().isExpired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDefaultEvaluation() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.getLicenseEngine().isDefaultEvaluation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.serialNumber;
        }
    }

    String getVersion() {
        String version = System.getProperty(VERSION_PROPERTY, "7.5");
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LicenseEngine getLicenseEngine() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            this.ensureLicenseEngineExists();
            return this.licenseEngine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date getExpiration() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.getLicenseEngine().getExpiration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlicensed() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            if (this.licenseEngine != null) {
                return this.licenseEngine.isDefaultEvaluation() || this.isExpired() || !this.licenseEngine.acquiredLicense() && !this.licenseEngine.acquiredManagedLicenses();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquiredLicense() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.licenseEngine != null && this.licenseEngine.acquiredLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquiredManagedLicenses() {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            return this.licenseEngine != null && this.licenseEngine.acquiredManagedLicenses();
        }
    }

    boolean enforceLimits() {
        return this.unlicensed();
    }

    LogWriter getLogWriter() {
        return this.log;
    }

    boolean requestDynamicSerialNumber() {
        return this.requestDynamicSerialNumber;
    }

    File getDirectory() {
        return this.dir;
    }

    void logViolation(String msg) {
        boolean annotate = Boolean.getBoolean(ADD_EXPECTED_EXCEPTION_ANNOTATIONS);
        if (annotate) {
            this.log.info("<ExpectedException action=add>" + msg + "</ExpectedException>");
        }
        this.log.config(msg);
        if (annotate) {
            this.log.info("<ExpectedException action=remove>" + msg + "</ExpectedException>");
        }
    }

    void logError(String msg) {
        boolean annotate = Boolean.getBoolean(ADD_EXPECTED_EXCEPTION_ANNOTATIONS);
        if (annotate) {
            this.log.info("<ExpectedException action=add>" + msg + "</ExpectedException>");
        }
        this.log.config(msg);
        if (annotate) {
            this.log.info("<ExpectedException action=remove>" + msg + "</ExpectedException>");
        }
    }

    void logFine(String msg) {
        boolean annotate = Boolean.getBoolean(ADD_EXPECTED_EXCEPTION_ANNOTATIONS);
        if (annotate) {
            this.log.info("<ExpectedException action=add>" + msg + "</ExpectedException>");
        }
        this.log.fine(this.toString() + "  " + msg);
        if (annotate) {
            this.log.info("<ExpectedException action=remove>" + msg + "</ExpectedException>");
        }
    }

    int getAlertLevel() {
        return this.alertLevel;
    }

    Map<String, Set<InternalDistributedMember>> getSerialNumberUsageSnapshot() {
        return null;
    }

    CancelCriterion getCancelCriterion() {
        return this.ids.getDistributionManager().getCancelCriterion();
    }

    public InternalDistributedSystem getInternalDistributedSystem() {
        return this.ids;
    }

    private void shutdown() {
        this.licenseEngine.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean includesUpgrade(UpgradeType type) {
        LicenseChecker licenseChecker = this;
        synchronized (licenseChecker) {
            if (this.licenseEngine == null) {
                return true;
            }
            return this.licenseEngine.includesUpgrade(type);
        }
    }

    private File getHiddenSerialFile() {
        try {
            boolean ignoreHidden = Boolean.getBoolean(IGNORE_HIDDEN_PROPERTY);
            if (ignoreHidden) {
                return null;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            String serialFileName;
            File serialFile;
            File hiddenDir = SystemAdmin.getHiddenDir();
            if (hiddenDir != null && hiddenDir.exists() && (serialFile = new File(hiddenDir, serialFileName = this.getComponentType().getId() + "-serial-numbers.txt")).exists()) {
                return serialFile;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    void ensureLicenseEngineExists() {
        if (this.licenseEngine == null) {
            try {
                String className = System.getProperty(LICENSE_ENGINE_PROPERTY);
                if (className != null && !className.equals(DEFAULT_LICENSE_ENGINE)) {
                    this.licenseEngine = this.createLicenseEngine(className);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (this.licenseEngine == null) {
                this.licenseEngine = new VFabricLicenseEngine(this);
            }
        }
    }

    public static String[] createSerialNumberArray(String serialNumbers) {
        if (serialNumbers == null || serialNumbers.contains(DYNAMIC_SERIAL_NUMBER)) {
            return null;
        }
        String comma = ",";
        if (serialNumbers.contains(comma)) {
            HashSet<String> serials = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(serialNumbers, comma);
            while (st.hasMoreTokens()) {
                serials.add(st.nextToken().trim());
            }
            return serials.toArray(new String[serials.size()]);
        }
        return new String[]{serialNumbers.trim()};
    }

    String[] createSerialNumberArray() {
        return LicenseChecker.createSerialNumberArray(this.serialNumber);
    }

    DistributionConfig getDistributionConfig() {
        if (this.ids == null) {
            return null;
        }
        return this.ids.getConfig();
    }

    private LicenseEngine createLicenseEngine(String className) {
        LicenseEngine licenseEngine = null;
        if (className != null) {
            try {
                Class<?> clazz = ClassPathLoader.getLatest().forName(className);
                Constructor<?> constructor = clazz.getConstructor(LicenseChecker.class);
                if (constructor != null) {
                    licenseEngine = (LicenseEngine)constructor.newInstance(this);
                }
            }
            catch (ClassNotFoundException e) {
                this.log.config("Unable to find " + className);
            }
            catch (NoSuchMethodException e) {
                this.log.config("Unable to construct " + className);
            }
            catch (NoClassDefFoundError e) {
                this.log.config("Unable to link to classes for " + className);
            }
            catch (IllegalArgumentException e) {
                this.log.config("Unable to use " + className, e);
            }
            catch (InstantiationException e) {
                this.log.config("Unable to use " + className, e);
            }
            catch (IllegalAccessException e) {
                this.log.config("Unable to use " + className, e);
            }
            catch (InvocationTargetException e) {
                this.log.config("Unable to use " + className, e);
            }
        }
        return licenseEngine;
    }

    private boolean isDefaultEvaluationSerialNumber() {
        return LicenseChecker.isDefaultEvaluationSerialNumber(this.serialNumber);
    }

    public static boolean isDefaultEvaluationSerialNumber(String serial) {
        return "G04E0-MFK43-M8E1H-0ZARK-AV25A".equals(serial) || "C10EH-H4LD1-48DKR-04AKK-2PHQF".equals(serial);
    }

    class DefaultUnlicensedPeerLimiter
    implements UnlicensedPeerLimiter {
        static final int UNLICENSED_PEER_LIMIT = 3;

        @Override
        public int calcPeerOrder(InternalDistributedMember member) {
            NetView view = LicenseChecker.this.getInternalDistributedSystem().getDistributionManager().getMembershipManager().getView();
            int peerOrder = 1;
            for (InternalDistributedMember other : view) {
                if (other.getVmKind() == 12 || other.getVmKind() == 11) continue;
                if (member.equals(other)) break;
                ++peerOrder;
            }
            return peerOrder;
        }

        @Override
        public int getUnlicensedPeerLimit() {
            return 3;
        }

        @Override
        public String createFailureMessage(int peerOrder, int peerLimit) {
            return "The number of peers, " + peerOrder + ", exceeds the limit of " + peerLimit + " allowed by the default evaluation license.";
        }
    }
}

