/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.licensing.ComponentType;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.licensing.LicenseEngine;
import com.gemstone.gemfire.internal.licensing.UnlicensedPeerLimiter;
import java.io.File;

public class CacheLicenseChecker
extends LicenseChecker {
    public CacheLicenseChecker(InternalDistributedSystem ids, File dir, LogWriter log, String serialNumber) {
        this(ids, dir, log, serialNumber, ComponentType.APPLICATION_CACHE, null);
    }

    public CacheLicenseChecker(InternalDistributedSystem ids, File dir, LogWriter log, String serialNumber, ComponentType componentType, UnlicensedPeerLimiter unlicensedPeerLimiter) {
        super(ids, dir, log, serialNumber, componentType, unlicensedPeerLimiter);
    }

    @Override
    void acquireLicense(LicenseEngine licenseEngine) throws LicenseException {
        if (!this.acquiredLicense()) {
            licenseEngine.acquireLicense();
        }
    }

    @Override
    void releaseLicense(LicenseEngine licenseEngine) {
        if (this.acquiredLicense()) {
            licenseEngine.releaseLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQuantity() {
        CacheLicenseChecker cacheLicenseChecker = this;
        synchronized (cacheLicenseChecker) {
            return this.unlicensed() ? 3 : this.getLicenseEngine().getQuantity();
        }
    }
}

