/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.lang;

import com.gemstone.gemfire.internal.lang.ObjectUtils;

public abstract class StringUtils {
    public static final String COMMA_DELIMITER = ",";
    public static final String EMPTY_STRING = "";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SPACE = " ";
    public static final String UTF_8 = "UTF-8";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String[] SPACES = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};

    public static String concat(Object ... values) {
        return StringUtils.concat(values, EMPTY_STRING);
    }

    public static String concat(Object[] values, String delimiter) {
        delimiter = ObjectUtils.defaultIfNull(delimiter, EMPTY_STRING);
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        if (values != null) {
            for (Object value2 : values) {
                buffer.append(count++ > 0 ? delimiter : EMPTY_STRING);
                buffer.append(value2);
            }
        }
        return buffer.toString();
    }

    public static String defaultIfBlank(String ... values) {
        if (values != null) {
            for (String value2 : values) {
                if (StringUtils.isBlank(value2)) continue;
                return value2;
            }
        }
        return null;
    }

    public static String getDigitsOnly(String value2) {
        StringBuilder buffer = new StringBuilder();
        if (value2 != null) {
            for (char chr : value2.toCharArray()) {
                if (!Character.isDigit(chr)) continue;
                buffer.append(chr);
            }
        }
        return buffer.toString();
    }

    public static String getLettersOnly(String value2) {
        StringBuilder buffer = new StringBuilder();
        if (value2 != null) {
            for (char chr : value2.toCharArray()) {
                if (!Character.isLetter(chr)) continue;
                buffer.append(chr);
            }
        }
        return buffer.toString();
    }

    public static String getSpaces(int number) {
        StringBuilder spaces = new StringBuilder(SPACES[Math.min(number, SPACES.length - 1)]);
        do {
            number -= SPACES.length - 1;
            number = Math.max(number, 0);
            spaces.append(SPACES[Math.min(number, SPACES.length - 1)]);
        } while (number > 0);
        return spaces.toString();
    }

    public static boolean isBlank(String value2) {
        return value2 == null || EMPTY_STRING.equals(value2.trim());
    }

    public static boolean isEmpty(String value2) {
        return EMPTY_STRING.equals(value2);
    }

    public static String padEnding(String value2, char paddingCharacter, int length) {
        if (value2 == null) {
            throw new NullPointerException("The String value to pad cannot be null!");
        }
        StringBuilder buffer = new StringBuilder(value2);
        for (int valueLength = value2.length(); valueLength < length; ++valueLength) {
            buffer.append(paddingCharacter);
        }
        return buffer.toString();
    }

    public static String toLowerCase(String value2) {
        return value2 == null ? null : value2.toLowerCase();
    }

    public static String toUpperCase(String value2) {
        return value2 == null ? null : value2.toUpperCase();
    }

    public static String trim(String value2) {
        return value2 == null ? null : value2.trim();
    }

    public static String truncate(String value2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be greater than equal to 0!");
        }
        return value2 == null ? null : value2.substring(0, Math.min(value2.length(), length));
    }

    public static String valueOf(Object value2, String ... defaultValues) {
        if (value2 != null) {
            return value2.toString();
        }
        if (defaultValues != null) {
            for (String defaultValue : defaultValues) {
                if (defaultValue == null) continue;
                return defaultValue;
            }
        }
        return String.valueOf(value2);
    }

    public static String wrap(String line, int widthInCharacters, String indent) {
        StringBuilder buffer = new StringBuilder();
        int lineCount = 1;
        int spaceIndex = -1;
        indent = StringUtils.valueOf(indent, EMPTY_STRING);
        while (line.length() > widthInCharacters) {
            spaceIndex = line.substring(0, widthInCharacters).lastIndexOf(SPACE);
            buffer.append(lineCount++ > 1 ? indent : EMPTY_STRING);
            buffer.append(line.substring(0, spaceIndex));
            buffer.append(LINE_SEPARATOR);
            line = line.substring(spaceIndex + 1);
        }
        buffer.append(lineCount > 1 ? indent : EMPTY_STRING);
        buffer.append(line);
        return buffer.toString();
    }

    public static String forceToString(Object o) {
        try {
            return o.toString();
        }
        catch (RuntimeException ex) {
            return "Conversion to a string failed because " + ex;
        }
    }
}

