/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.datasource;

import com.gemstone.gemfire.internal.datasource.AbstractPoolCache;
import com.gemstone.gemfire.internal.datasource.ConfiguredDataSourceProperties;
import com.gemstone.gemfire.internal.datasource.PoolException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.logging.log4j.Logger;

public class TranxPoolCacheImpl
extends AbstractPoolCache {
    private static final long serialVersionUID = 3295652525163658888L;
    private static final Logger logger = LogService.getLogger();
    private XADataSource m_xads;

    public TranxPoolCacheImpl(XADataSource xads, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super(eventListner, configs);
        this.m_xads = xads;
        this.initializePool();
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((PooledConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((PooledConnection)connectionObject).close();
                connectionObject = null;
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("AbstractPoolcache::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", ex.getMessage(), ex);
            }
        }
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        if (this.m_xads != null) {
            XAConnection poolConn = null;
            try {
                poolConn = this.m_xads.getXAConnection(this.configProps.getUser(), this.configProps.getPassword());
            }
            catch (SQLException sqx) {
                throw new PoolException(LocalizedStrings.TranxPoolCacheImpl_TRANXPOOLCACHEIMPLGETNEWCONNECTION_EXCEPTION_IN_CREATING_NEW_TRANSACTION_POOLEDCONNECTION.toLocalizedString(), sqx);
            }
            poolConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
            return poolConn;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TranxPoolCacheImpl::getNewConnection: ConnectionPoolCache not intialized with XADatasource");
        }
        throw new PoolException(LocalizedStrings.TranxPoolCacheImpl_TRANXPOOLCACHEIMPLGETNEWCONNECTION_CONNECTIONPOOLCACHE_NOT_INTIALIZED_WITH_XADATASOURCE.toLocalizedString());
    }
}

