/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class CompactConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    protected final Segment<E>[] segments;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<E> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public CompactConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public CompactConcurrentHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 16);
    }

    public CompactConcurrentHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public CompactConcurrentHashSet() {
        this(16, 0.75f, 16);
    }

    public CompactConcurrentHashSet(Collection<? extends E> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f, 16);
        this.addAll(m);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment<E>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<E>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    private boolean containsValue(Object value2) {
        int hash = CompactConcurrentHashSet.hash(value2.hashCode());
        return this.segmentFor(hash).containsValue(value2, hash);
    }

    @Override
    public boolean contains(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        return this.containsValue(value2);
    }

    @Override
    public boolean add(E value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash = CompactConcurrentHashSet.hash(value2.hashCode());
        return this.segmentFor(hash).add(hash, value2) == null;
    }

    @Override
    public boolean remove(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash = CompactConcurrentHashSet.hash(value2.hashCode());
        return this.segmentFor(hash).remove(value2, hash) != null;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    public Enumeration<E> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment<E> seg = this.segments[k];
            seg.lock();
            try {
                HashValue<E>[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashValue e = tab[i];
                    while (e != null) {
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object value2;
        s.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashValue[1]);
        }
        while ((value2 = s.readObject()) != null) {
            this.add(value2);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ValueIterator();
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<E>,
    Enumeration<E> {
        ValueIterator() {
        }

        @Override
        public E next() {
            return super.nextValue().value;
        }

        @Override
        public E nextElement() {
            return super.nextValue().value;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashValue<E>[] currentTable;
        HashValue<E> nextEntry;
        HashValue<E> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CompactConcurrentHashSet.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = CompactConcurrentHashSet.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashValue<E> nextValue() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            CompactConcurrentHashSet.this.remove(this.lastReturned.value);
            this.lastReturned = null;
        }
    }

    protected static final class Segment<E>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashValue<E>[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(HashValue.newArray(initialCapacity));
        }

        static final <E> Segment<E>[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(HashValue<E>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashValue<E> getFirst(int hash) {
            HashValue<E>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        E readValueUnderLock(HashValue<E> e) {
            this.lock();
            try {
                Object e2 = e.value;
                return e2;
            }
            finally {
                this.unlock();
            }
        }

        boolean containsValue(Object value2, int hash) {
            if (this.count != 0) {
                HashValue<E> e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && value2.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        E add(int hash, E value2) {
            this.lock();
            try {
                E oldValue;
                HashValue<E> first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashValue<E>[] tab = this.table;
                int index2 = hash & tab.length - 1;
                HashValue<E> e = first = tab[index2];
                while (!(e == null || e.hash == hash && value2.equals(e.value))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index2] = new HashValue<E>(value2, hash, first);
                    this.count = c;
                }
                E e2 = oldValue;
                return e2;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashValue<E>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashValue<E>[] newTable = HashValue.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashValue<E> e = oldTable[i];
                if (e == null) continue;
                HashValue next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashValue<E> lastRun = e;
                int lastIdx = idx;
                HashValue last = next2;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashValue<E> p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashValue n = newTable[k];
                    newTable[k] = new HashValue(p.value, p.hash, n);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        E remove(Object value2, int hash) {
            this.lock();
            try {
                HashValue<E> first;
                int c = this.count - 1;
                HashValue<E>[] tab = this.table;
                int index2 = hash & tab.length - 1;
                HashValue<E> e = first = tab[index2];
                while (!(e == null || e.hash == hash && value2.equals(e.value))) {
                    e = e.next;
                }
                E oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    ++this.modCount;
                    HashValue newFirst = e.next;
                    HashValue<E> p = first;
                    while (p != e) {
                        newFirst = new HashValue(p.value, p.hash, newFirst);
                        p = p.next;
                    }
                    tab[index2] = newFirst;
                    this.count = c;
                }
                E e2 = oldValue;
                return e2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashValue<E>[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        public int getCount() {
            return this.count;
        }
    }

    static final class HashValue<E> {
        volatile E value;
        final int hash;
        final HashValue<E> next;

        HashValue(E value2, int hash, HashValue<E> next2) {
            this.value = value2;
            this.hash = hash;
            this.next = next2;
        }

        static final <E> HashValue<E>[] newArray(int i) {
            return new HashValue[i];
        }
    }
}

