/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.compression;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SharedLibrary;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.gemstone.gemfire.internal.logging.PureLogWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.xerial.snappy.SnappyError;

public class SnappyUtils {
    public static final String SNAPPY_SYSTEM_PROPERTIES_FILE = "org-xerial-snappy.properties";
    public static final String KEY_SNAPPY_LIB_PATH = "org.xerial.snappy.lib.path";
    public static final String KEY_SNAPPY_LIB_NAME = "org.xerial.snappy.lib.name";
    public static final String KEY_SNAPPY_TEMPDIR = "org.xerial.snappy.tempdir";
    public static final String KEY_SNAPPY_USE_SYSTEMLIB = "org.xerial.snappy.use.systemlib";
    public static final String KEY_SNAPPY_DISABLE_BUNDLED_LIBS = "org.xerial.snappy.disable.bundled.libs";
    public static final String DISTRIBUTED_VERSION = "1.0.4.1";
    public static final String UNKNOWN_VERSION = "unknown";

    public static String[] setSnappySystemProperties(LogWriter logWriter) {
        boolean hasSnappySystemProperties;
        String version = SnappyUtils.getNativeLibraryVersion();
        if (UNKNOWN_VERSION.equals(version) || !DISTRIBUTED_VERSION.contains(version)) {
            logWriter.info("Snappy native library version " + version + " is different than version " + DISTRIBUTED_VERSION + " distributed with GemFire.");
            return new String[0];
        }
        boolean bl = hasSnappySystemProperties = Boolean.getBoolean(SNAPPY_SYSTEM_PROPERTIES_FILE) || Boolean.getBoolean(KEY_SNAPPY_LIB_PATH) || Boolean.getBoolean(KEY_SNAPPY_LIB_NAME) || Boolean.getBoolean(KEY_SNAPPY_TEMPDIR) || Boolean.getBoolean(KEY_SNAPPY_USE_SYSTEMLIB) || Boolean.getBoolean(KEY_SNAPPY_DISABLE_BUNDLED_LIBS);
        if (hasSnappySystemProperties) {
            logWriter.info("One or more Snappy system properties are already set.");
            return new String[0];
        }
        String failureMessage = "Unable to find Snappy native library distributed with GemFire: ";
        StringBuffer sb = new StringBuffer("snappy-java-").append(DISTRIBUTED_VERSION).append("-");
        if (SharedLibrary.is64Bit()) {
            sb.append("amd64");
        } else {
            sb.append("i386");
        }
        String libraryName = sb.toString();
        String libraryDir = null;
        URL gemfireJarURL = GemFireVersion.getJarURL();
        if (gemfireJarURL == null) {
            logWriter.info(failureMessage + "Unable to locate gemfire.jar file.");
            return new String[0];
        }
        String gemfireJar = null;
        try {
            gemfireJar = URLDecoder.decode(gemfireJarURL.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int index2 = gemfireJar.lastIndexOf("/");
        if (index2 == -1) {
            logWriter.info(failureMessage + "Unable to parse gemfire.jar path.");
            return new String[0];
        }
        libraryDir = gemfireJar.substring(0, index2 + 1);
        String osLibraryName = System.mapLibraryName(libraryName);
        File libraryPath = new File(libraryDir, osLibraryName);
        File parentPath = libraryPath.getParentFile();
        String canonicalDir = null;
        try {
            canonicalDir = parentPath.getCanonicalPath();
        }
        catch (IOException e) {
            logWriter.info(failureMessage + ("Unable to get canonical path for " + parentPath));
            return new String[0];
        }
        logWriter.info("Checking for Snappy native library at " + libraryPath.getPath());
        if (libraryPath.exists()) {
            logWriter.info("Found Snappy native library at " + libraryPath);
            String snappyNativeLibraryPath = canonicalDir;
            String snappyNativeLibraryName = osLibraryName;
            System.setProperty(KEY_SNAPPY_LIB_PATH, snappyNativeLibraryPath);
            System.setProperty(KEY_SNAPPY_LIB_NAME, snappyNativeLibraryName);
            return new String[]{KEY_SNAPPY_LIB_PATH, KEY_SNAPPY_LIB_NAME};
        }
        logWriter.info(failureMessage + libraryPath);
        throw new IllegalStateException(LocalizedStrings.SnappyCompressor_UNABLE_TO_LOAD_NATIVE_SNAPPY_LIBRARY_MISSING_LIBRARY.toLocalizedString(libraryPath));
    }

    public static String getNativeLibraryVersion() {
        URL versionFile = SnappyError.class.getResource("/org/xerial/snappy/VERSION");
        String version = UNKNOWN_VERSION;
        try {
            if (versionFile != null) {
                Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                if (version.equals(UNKNOWN_VERSION)) {
                    version = versionData.getProperty("VERSION", version);
                }
                version = version.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }

    public static LogWriter getOrCreateLogWriter() {
        InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
        if (ids == null || ids.getLogWriter() == null) {
            return new PureLogWriter(LogWriterImpl.levelNameToCode("info"));
        }
        return ids.getLogWriter();
    }
}

