/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.internal.cache.xmlcache.GatewayCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class GatewayHubCreation
implements GatewayHub {
    private Cache _cache;
    private int _port;
    private String _id;
    private int _socketBufferSize;
    private int _maximumTimeBetweenPings;
    private final Object _gatewaysLock = new Object();
    private final ArrayList _gateways = new ArrayList();
    private final ArrayList _gatewayIds = new ArrayList();
    private boolean _manualStart;
    private String _startupPolicy;
    private String _bindAddress;
    private int _maxConnections;

    GatewayHubCreation(Cache cache, String id, int port) {
        this._cache = cache;
        this._id = id;
        this._port = port;
        this._socketBufferSize = 32768;
        this._maximumTimeBetweenPings = 60000;
        this._startupPolicy = "none";
        this._manualStart = false;
        this._bindAddress = DEFAULT_BIND_ADDRESS;
        this._maxConnections = 800;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public void setPort(int port) {
        this._port = port;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this._socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this._socketBufferSize;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this._maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this._maximumTimeBetweenPings;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void start(boolean startGateways) throws IOException {
    }

    @Override
    public void startGateways() throws IOException {
    }

    @Override
    public void stopGateways() {
        throw new UnsupportedOperationException(LocalizedStrings.GatewayHubCreation_REMOVEGATEWAY_IS_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public boolean isRunning() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isPrimary() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Cache getCache() {
        return this._cache;
    }

    @Override
    public Gateway addGateway(String id) throws GatewayException {
        return this.addGateway(id, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gateway addGateway(String id, int concurrencyLevel) throws GatewayException {
        Object object = this._gatewaysLock;
        synchronized (object) {
            if (this.alreadyDefinesGateway(id)) {
                throw new GatewayException(LocalizedStrings.GatewayHubCreation_GATEWAYHUB_0_ALREADY_DEFINES_A_GATEWAY_WITH_ID_1.toLocalizedString(this._id, id));
            }
            GatewayCreation gateway = new GatewayCreation(this, id, concurrencyLevel);
            this._gateways.add(gateway);
            this._gatewayIds.add(id);
            return gateway;
        }
    }

    @Override
    public void removeGateway(String id) throws GatewayException {
        throw new UnsupportedOperationException(LocalizedStrings.GatewayHubCreation_REMOVEGATEWAY_IS_NOT_SUPPORTED.toLocalizedString());
    }

    public List getGateways() {
        return this._gateways;
    }

    public List getGatewayIds() {
        return this._gatewayIds;
    }

    protected boolean alreadyDefinesGateway(String id) {
        boolean alreadyDefined = false;
        for (Gateway gateway : this._gateways) {
            if (!gateway.getId().equals(id)) continue;
            alreadyDefined = true;
            break;
        }
        return alreadyDefined;
    }

    @Override
    public String toDetailedString() {
        throw new UnsupportedOperationException(LocalizedStrings.GatewayHubCreation_NOT_SUPPORTED.toLocalizedString());
    }

    @Override
    public void setStartupPolicy(String startupPolicy) {
        if (!(startupPolicy.equals("none") || startupPolicy.equals("primary") || startupPolicy.equals("secondary"))) {
            throw new GatewayException(LocalizedStrings.GatewayHubCreation_AN_UNKNOWN_GATEWAY_HUB_POLICY_0_WAS_SPECIFIED_IT_MUST_BE_ONE_OF_1_2_3.toLocalizedString(startupPolicy, "none", "primary", "secondary"));
        }
        this._startupPolicy = startupPolicy;
    }

    @Override
    public String getStartupPolicy() {
        return this._startupPolicy;
    }

    @Override
    public Object getAllGatewaysLock() {
        return this._gatewaysLock;
    }

    @Override
    public void setManualStart(boolean manualStart) {
        this._manualStart = manualStart;
    }

    @Override
    public boolean getManualStart() {
        return this._manualStart;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void pauseGateways() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void resumeGateways() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public String getBindAddress() {
        return this._bindAddress;
    }

    @Override
    public void setBindAddress(String address) {
        this._bindAddress = address;
    }

    @Override
    public int getMaxConnections() {
        return this._maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this._maxConnections = maxConnections;
    }
}

