/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.DiskStoreAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ClientCacheCreation
extends CacheCreation
implements ClientCache {
    private static final RegionAttributes clientDefaults;

    public ClientCacheCreation() {
        this(false);
    }

    public ClientCacheCreation(boolean forParsing) {
        super(forParsing);
    }

    @Override
    RegionAttributes getDefaultAttributes() {
        return clientDefaults;
    }

    @Override
    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeClientRegionShortcuts(this);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getLocalQueryService() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut atts) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String regionAttributesId) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties, String poolName) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public RegionService createAuthenticatedView(Properties userSecurityProperties) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setLockLease(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setSearchTimeout(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public BridgeServer addBridgeServer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheServer addCacheServer() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public GatewayHub setGatewayHub(String id, int port) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public GatewayHub addGatewayHub(String id, int port) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setIsServer(boolean isServer) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void addBackup(File backup) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    void create(GemFireCacheImpl cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        cache.setDeclarativeCacheConfig(this.getCacheConfig());
        if (!cache.isClient()) {
            throw new IllegalStateException("You must use ClientCacheFactory when the cache.xml uses client-cache.");
        }
        Map m = this.getPools();
        if (!m.isEmpty()) {
            boolean setDefault = m.size() == 1;
            for (Pool cp : m.values()) {
                PoolFactoryImpl f = (PoolFactoryImpl)PoolManager.createFactory();
                f.init(cp);
                PoolImpl p = (PoolImpl)f.create(cp.getName());
            }
        }
        cache.determineDefaultPool();
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        for (DiskStoreAttributesCreation diskStoreAttributesCreation : this.listDiskStores()) {
            if (diskStoreAttributesCreation == pdxRegDSC) continue;
            this.createDiskStore(diskStoreAttributesCreation, cache);
        }
        for (DiskStoreAttributesCreation diskStoreAttributesCreation : this.listDiskStores()) {
            GemFireCacheImpl gfc = cache;
            DiskStoreFactory factory = gfc.createDiskStoreFactory(diskStoreAttributesCreation);
            DiskStore ds = factory.create(diskStoreAttributesCreation.getName());
        }
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.getCopyOnRead());
        }
        if (this.txMgrCreation != null && this.txMgrCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.txMgrCreation.getListeners());
        }
        if (this.txMgrCreation != null && cache.getCacheTransactionManager() != null && this.txMgrCreation.getWriter() != null) {
            throw new IllegalStateException(LocalizedStrings.TXManager_NO_WRITER_ON_CLIENT.toLocalizedString());
        }
        cache.initializePdxRegistry();
        for (String string : this.regionAttributesNames) {
            RegionAttributesCreation creation = (RegionAttributesCreation)this.getRegionAttributes(string);
            creation.inheritAttributes(cache, false);
            AttributesFactory factory = new AttributesFactory(creation);
            RegionAttributes attrs = factory.createRegionAttributes();
            cache.setRegionAttributes(string, attrs);
        }
        for (RegionCreation regionCreation : this.roots.values()) {
            regionCreation.createRoot(cache);
        }
        cache.readyDynamicRegionFactory();
        this.runInitializer();
    }

    public String getDefaultPoolName() {
        String result = null;
        Map m = this.getPools();
        if (m.size() == 1) {
            Pool p = (Pool)m.values().iterator().next();
            result = p.getName();
        } else if (m.isEmpty()) {
            result = "DEFAULT";
        }
        return result;
    }

    @Override
    public Pool getDefaultPool() {
        return (Pool)this.getPools().get(this.getDefaultPoolName());
    }

    @Override
    public boolean getPdxReadSerialized() {
        return false;
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        return Collections.EMPTY_SET;
    }

    static {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.LOCAL);
        af.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        clientDefaults = af.create();
    }
}

