/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.CustomExpiry;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DiskWriteAttributes;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationData;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.DiskWriteAttributesImpl;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.AsyncEventQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.BindingCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXml;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlVersion;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientHaQueueCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.DiskStoreAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.FunctionServiceCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.SerializerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.XmlParser;
import com.gemstone.gemfire.internal.datasource.ConfigProperty;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jndi.JNDIInvoker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class CacheXmlParser
extends CacheXml
implements ContentHandler {
    private static final Logger logger = LogService.getLogger();
    private static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    private static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private CacheCreation cache;
    protected Stack<Object> stack = new Stack();
    private HashMap<String, XmlParser> delegates = new HashMap();

    public static CacheXmlParser parse(InputStream is) {
        CacheXmlParser handler = new CacheXmlParser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, true);
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            BufferedInputStream bis = new BufferedInputStream(is);
            try {
                SAXParser parser = factory.newSAXParser();
                bis.mark((Integer)parser.getProperty(BUFFER_SIZE) * 2);
                parser.setProperty(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
                parser.parse((InputStream)bis, (DefaultHandler)new DefaultHandlerDelegate(handler));
            }
            catch (CacheXmlException e) {
                if (null != e.getCause() && e.getCause().getMessage().startsWith("DOCTYPE is disallowed")) {
                    bis.reset();
                    factory.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, false);
                    SAXParser parser = factory.newSAXParser();
                    parser.parse((InputStream)bis, (DefaultHandler)new DefaultHandlerDelegate(handler));
                }
                throw e;
            }
            return handler;
        }
        catch (Exception ex2) {
            SAXException sax;
            Exception cause;
            if (ex2 instanceof CacheXmlException) {
                CacheXmlException ex2;
                Throwable cause2;
                while ((cause2 = ex2.getCause()) instanceof CacheXmlException) {
                    ex2 = (CacheXmlException)cause2;
                }
                throw (CacheXmlException)ex2;
            }
            if (ex2 instanceof SAXException && (cause = (sax = (SAXException)ex2).getException()) instanceof CacheXmlException) {
                Throwable cause2;
                while ((cause2 = cause.getCause()) instanceof CacheXmlException) {
                    cause = (CacheXmlException)cause2;
                }
                throw (CacheXmlException)cause;
            }
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_WHILE_PARSING_XML.toLocalizedString(), ex2);
        }
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_MALFORMED_INTEGER_0.toLocalizedString(s), ex);
        }
    }

    private static long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_MALFORMED_INTEGER_0.toLocalizedString(s), ex);
        }
    }

    private static boolean parseBoolean(String s) {
        return Boolean.valueOf(s);
    }

    private static float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_MALFORMED_FLOAT_0.toLocalizedString(s), ex);
        }
    }

    public CacheCreation getCacheCreation() {
        return this.cache;
    }

    public void create(GemFireCacheImpl cache) throws TimeoutException, GatewayException, CacheWriterException, RegionExistsException {
        if (this.cache == null) {
            String s = "A cache or client-cache element is required";
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_NO_CACHE_ELEMENT_SPECIFIED.toLocalizedString());
        }
        this.cache.create(cache);
    }

    private void startCache(Attributes atts) {
        String copyOnRead;
        String isServer;
        String messageSyncInterval;
        String searchTimeout;
        String lockTimeout;
        if (this.cache != null) {
            throw new CacheXmlException("Only a single cache or client-cache element is allowed");
        }
        this.cache = new CacheCreation(true);
        String lockLease = atts.getValue("lock-lease");
        if (lockLease != null) {
            this.cache.setLockLease(CacheXmlParser.parseInt(lockLease));
        }
        if ((lockTimeout = atts.getValue("lock-timeout")) != null) {
            this.cache.setLockTimeout(CacheXmlParser.parseInt(lockTimeout));
        }
        if ((searchTimeout = atts.getValue("search-timeout")) != null) {
            this.cache.setSearchTimeout(CacheXmlParser.parseInt(searchTimeout));
        }
        if ((messageSyncInterval = atts.getValue("message-sync-interval")) != null) {
            this.cache.setMessageSyncInterval(CacheXmlParser.parseInt(messageSyncInterval));
        }
        if ((isServer = atts.getValue("is-server")) != null) {
            boolean b = Boolean.valueOf(isServer);
            this.cache.setIsServer(b);
        }
        if ((copyOnRead = atts.getValue("copy-on-read")) != null) {
            this.cache.setCopyOnRead(Boolean.valueOf(copyOnRead));
        }
        this.stack.push(this.cache);
    }

    private void startClientCache(Attributes atts) {
        if (this.cache != null) {
            throw new CacheXmlException("Only a single cache or client-cache element is allowed");
        }
        this.cache = new ClientCacheCreation(true);
        String copyOnRead = atts.getValue("copy-on-read");
        if (copyOnRead != null) {
            this.cache.setCopyOnRead(Boolean.valueOf(copyOnRead));
        }
        this.stack.push(this.cache);
    }

    private void startPool(Attributes atts) {
        PoolFactory f = this.cache.createPoolFactory();
        String name = atts.getValue("name").trim();
        this.stack.push(name);
        this.stack.push(f);
        String v = atts.getValue("free-connection-timeout");
        if (v != null) {
            f.setFreeConnectionTimeout(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("load-conditioning-interval")) != null) {
            f.setLoadConditioningInterval(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("min-connections")) != null) {
            f.setMinConnections(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("max-connections")) != null) {
            f.setMaxConnections(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("retry-attempts")) != null) {
            f.setRetryAttempts(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("idle-timeout")) != null) {
            f.setIdleTimeout(CacheXmlParser.parseLong(v));
        }
        if ((v = atts.getValue("ping-interval")) != null) {
            f.setPingInterval(CacheXmlParser.parseLong(v));
        }
        if ((v = atts.getValue("subscription-enabled")) != null) {
            f.setSubscriptionEnabled(CacheXmlParser.parseBoolean(v));
        }
        if ((v = atts.getValue("pr-single-hop-enabled")) != null) {
            f.setPRSingleHopEnabled(CacheXmlParser.parseBoolean(v));
        }
        if ((v = atts.getValue("subscription-message-tracking-timeout")) != null) {
            f.setSubscriptionMessageTrackingTimeout(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("subscription-ack-interval")) != null) {
            f.setSubscriptionAckInterval(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("subscription-redundancy")) != null) {
            f.setSubscriptionRedundancy(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("read-timeout")) != null) {
            f.setReadTimeout(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("server-group")) != null) {
            f.setServerGroup(v.trim());
        }
        if ((v = atts.getValue("socket-buffer-size")) != null) {
            f.setSocketBufferSize(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("statistic-interval")) != null) {
            f.setStatisticInterval(CacheXmlParser.parseInt(v));
        }
        if ((v = atts.getValue("thread-local-connections")) != null) {
            f.setThreadLocalConnections(CacheXmlParser.parseBoolean(v));
        }
        if ((v = atts.getValue("multiuser-authentication")) != null) {
            f.setMultiuserAuthentication(CacheXmlParser.parseBoolean(v));
        }
    }

    private void endPool() {
        PoolFactory f = (PoolFactory)this.stack.pop();
        String name = (String)this.stack.pop();
        f.create(name);
    }

    private void doLocator(Attributes atts) {
        PoolFactory f = (PoolFactory)this.stack.peek();
        String host = atts.getValue("host").trim();
        int port = CacheXmlParser.parseInt(atts.getValue("port"));
        f.addLocator(host, port);
    }

    private void doServer(Attributes atts) {
        PoolFactory f = (PoolFactory)this.stack.peek();
        String host = atts.getValue("host").trim();
        int port = CacheXmlParser.parseInt(atts.getValue("port"));
        f.addServer(host, port);
    }

    private void startCacheServer(Attributes atts) {
        String loadPollInterval;
        String messageTimeToLive;
        String maximumMessageCount;
        String maximumTimeBetweenPings;
        String tcpDelay;
        String socketBufferSize;
        String notifyBySubscription;
        String maxThreads;
        String maxConnections;
        String hostnameForClients;
        String bindAddress;
        CacheServer bridge = this.cache.addCacheServer();
        String port = atts.getValue("port");
        if (port != null) {
            bridge.setPort(CacheXmlParser.parseInt(port));
        }
        if ((bindAddress = atts.getValue("bind-address")) != null) {
            bridge.setBindAddress(bindAddress.trim());
        }
        if ((hostnameForClients = atts.getValue("hostname-for-clients")) != null) {
            bridge.setHostnameForClients(hostnameForClients.trim());
        }
        if ((maxConnections = atts.getValue("max-connections")) != null) {
            bridge.setMaxConnections(CacheXmlParser.parseInt(maxConnections));
        }
        if ((maxThreads = atts.getValue("max-threads")) != null) {
            bridge.setMaxThreads(CacheXmlParser.parseInt(maxThreads));
        }
        if ((notifyBySubscription = atts.getValue("notify-by-subscription")) != null) {
            boolean b = Boolean.valueOf(notifyBySubscription);
            bridge.setNotifyBySubscription(b);
        }
        if ((socketBufferSize = atts.getValue("socket-buffer-size")) != null) {
            bridge.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        if ((tcpDelay = atts.getValue("tcp-no-delay")) != null) {
            bridge.setTcpNoDelay(Boolean.valueOf(tcpDelay));
        }
        if ((maximumTimeBetweenPings = atts.getValue("maximum-time-between-pings")) != null) {
            bridge.setMaximumTimeBetweenPings(Integer.parseInt(maximumTimeBetweenPings));
        }
        if ((maximumMessageCount = atts.getValue("maximum-message-count")) != null) {
            bridge.setMaximumMessageCount(Integer.parseInt(maximumMessageCount));
        }
        if ((messageTimeToLive = atts.getValue("message-time-to-live")) != null) {
            bridge.setMessageTimeToLive(Integer.parseInt(messageTimeToLive));
        }
        if ((loadPollInterval = atts.getValue("load-poll-interval")) != null) {
            bridge.setLoadPollInterval(Long.parseLong(loadPollInterval));
        }
        this.stack.push(bridge);
    }

    private void startGatewayHub(Attributes atts) {
        String maxConnections;
        String manualStart;
        String maximumTimeBetweenPings;
        String socketBufferSize;
        String startupPolicy;
        String id = atts.getValue("id");
        String portStr = atts.getValue("port");
        int port = -1;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        GatewayHub hub = this.cache.addGatewayHub(id, port);
        String bindAddress = atts.getValue("bind-address");
        if (bindAddress != null) {
            hub.setBindAddress(bindAddress.trim());
        }
        if ((startupPolicy = atts.getValue("startup-policy")) != null) {
            if (startupPolicy.equals("none")) {
                hub.setStartupPolicy("none");
            } else if (startupPolicy.equals("primary")) {
                hub.setStartupPolicy("primary");
            } else if (startupPolicy.equals("secondary")) {
                hub.setStartupPolicy("secondary");
            } else {
                throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_GATEWAY_HUB_POLICY_0.toLocalizedString(startupPolicy));
            }
        }
        if ((socketBufferSize = atts.getValue("socket-buffer-size")) != null) {
            hub.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        if ((maximumTimeBetweenPings = atts.getValue("maximum-time-between-pings")) != null) {
            hub.setMaximumTimeBetweenPings(Integer.parseInt(maximumTimeBetweenPings));
        }
        if ((manualStart = atts.getValue("manual-start")) != null) {
            hub.setManualStart(Boolean.valueOf(manualStart));
        }
        if ((maxConnections = atts.getValue("max-connections")) != null) {
            hub.setMaxConnections(Integer.parseInt(maxConnections));
        }
        this.stack.push(hub);
    }

    private void startGatewaySender(Attributes atts) {
        GatewaySenderFactory gatewaySenderFactory = this.cache.createGatewaySenderFactory();
        String parallel = atts.getValue("parallel");
        if (parallel == null) {
            gatewaySenderFactory.setParallel(false);
        } else {
            gatewaySenderFactory.setParallel(Boolean.parseBoolean(parallel));
        }
        String manualStart = atts.getValue("manual-start");
        if (manualStart == null) {
            gatewaySenderFactory.setManualStart(false);
        } else {
            gatewaySenderFactory.setManualStart(Boolean.parseBoolean(manualStart));
        }
        String socketBufferSize = atts.getValue("socket-buffer-size");
        if (socketBufferSize == null) {
            gatewaySenderFactory.setSocketBufferSize(524288);
        } else {
            gatewaySenderFactory.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        String socketReadTimeout = atts.getValue("socket-read-timeout");
        if (socketReadTimeout == null) {
            gatewaySenderFactory.setSocketReadTimeout(GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT);
        } else {
            gatewaySenderFactory.setSocketReadTimeout(Integer.parseInt(socketReadTimeout));
        }
        String batchConflation = atts.getValue("enable-batch-conflation");
        if (batchConflation == null) {
            gatewaySenderFactory.setBatchConflationEnabled(false);
        } else {
            gatewaySenderFactory.setBatchConflationEnabled(Boolean.parseBoolean(batchConflation));
        }
        String batchSize = atts.getValue("batch-size");
        if (batchSize == null) {
            gatewaySenderFactory.setBatchSize(100);
        } else {
            gatewaySenderFactory.setBatchSize(Integer.parseInt(batchSize));
        }
        String batchTimeInterval = atts.getValue("batch-time-interval");
        if (batchTimeInterval == null) {
            gatewaySenderFactory.setBatchTimeInterval(1000);
        } else {
            gatewaySenderFactory.setBatchTimeInterval(Integer.parseInt(batchTimeInterval));
        }
        String enablePersistence = atts.getValue("enable-persistence");
        if (enablePersistence == null) {
            gatewaySenderFactory.setPersistenceEnabled(false);
        } else {
            gatewaySenderFactory.setPersistenceEnabled(Boolean.parseBoolean(enablePersistence));
        }
        String diskStoreName = atts.getValue("disk-store-name");
        if (diskStoreName == null) {
            gatewaySenderFactory.setDiskStoreName(null);
        } else {
            gatewaySenderFactory.setDiskStoreName(diskStoreName);
        }
        String diskSynchronous = atts.getValue("disk-synchronous");
        if (diskSynchronous == null) {
            gatewaySenderFactory.setDiskSynchronous(true);
        } else {
            gatewaySenderFactory.setDiskSynchronous(Boolean.parseBoolean(diskSynchronous));
        }
        String maxQueueMemory = atts.getValue("maximum-queue-memory");
        if (maxQueueMemory == null) {
            gatewaySenderFactory.setMaximumQueueMemory(100);
        } else {
            gatewaySenderFactory.setMaximumQueueMemory(Integer.parseInt(maxQueueMemory));
        }
        String alertThreshold = atts.getValue("alert-threshold");
        if (alertThreshold == null) {
            gatewaySenderFactory.setAlertThreshold(0);
        } else {
            gatewaySenderFactory.setAlertThreshold(Integer.parseInt(alertThreshold));
        }
        String dispatcherThreads = atts.getValue("dispatcher-threads");
        if (dispatcherThreads == null) {
            gatewaySenderFactory.setDispatcherThreads(5);
        } else {
            gatewaySenderFactory.setDispatcherThreads(Integer.parseInt(dispatcherThreads));
        }
        String id = atts.getValue("id");
        String orderPolicy = atts.getValue("order-policy");
        if (orderPolicy != null) {
            try {
                gatewaySenderFactory.setOrderPolicy(Gateway.OrderPolicy.valueOf(orderPolicy.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new InternalGemFireException(LocalizedStrings.SerialGatewaySender_UNKNOWN_GATEWAY_ORDER_POLICY_0_1.toLocalizedString(id, orderPolicy));
            }
        }
        String remoteDS = atts.getValue("remote-distributed-system-id");
        this.stack.push(id);
        this.stack.push(remoteDS);
        this.stack.push(gatewaySenderFactory);
    }

    private void startGatewayReceiver(Attributes atts) {
        GatewayReceiverFactory receiverFactory = this.cache.createGatewayReceiverFactory();
        String startPort = atts.getValue("start-port");
        if (startPort == null) {
            receiverFactory.setStartPort(5000);
        } else {
            receiverFactory.setStartPort(Integer.parseInt(startPort));
        }
        String endPort = atts.getValue("end-port");
        if (endPort == null) {
            receiverFactory.setEndPort(5500);
        } else {
            receiverFactory.setEndPort(Integer.parseInt(endPort));
        }
        String bindAddress = atts.getValue("bind-address");
        if (bindAddress == null) {
            receiverFactory.setBindAddress("");
        } else {
            receiverFactory.setBindAddress(bindAddress);
        }
        String maxTimeBetweenPings = atts.getValue("maximum-time-between-pings");
        if (maxTimeBetweenPings == null) {
            receiverFactory.setMaximumTimeBetweenPings(60000);
        } else {
            receiverFactory.setMaximumTimeBetweenPings(Integer.parseInt(maxTimeBetweenPings));
        }
        String socketBufferSize = atts.getValue("socket-buffer-size");
        if (socketBufferSize == null) {
            receiverFactory.setSocketBufferSize(524288);
        } else {
            receiverFactory.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        String manualStart = atts.getValue("manual-start");
        if (manualStart == null) {
            receiverFactory.setManualStart(false);
        } else {
            receiverFactory.setManualStart(Boolean.parseBoolean(manualStart));
        }
        String hostnameForSenders = atts.getValue("hostname-for-senders");
        if (hostnameForSenders == null) {
            receiverFactory.setHostnameForSenders("");
        } else {
            receiverFactory.setHostnameForSenders(hostnameForSenders);
        }
        this.stack.push(receiverFactory);
    }

    private void startGateway(Attributes atts) {
        String orderPolicy;
        String socketReadTimeout;
        String socketBufferSize;
        GatewayHub hub = (GatewayHub)this.stack.peek();
        String id = atts.getValue("id");
        String concurrencyLevel = atts.getValue("concurrency-level");
        int concurrencyLevelInt = 1;
        if (concurrencyLevel != null) {
            concurrencyLevelInt = Integer.parseInt(concurrencyLevel);
        }
        Gateway gateway = null;
        try {
            gateway = hub.addGateway(id, concurrencyLevelInt);
        }
        catch (GatewayException e) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_COULD_NOT_CREATE_GATEWAY_WITH_ID_0.toLocalizedString(id), e);
        }
        String earlyAck = atts.getValue("early-ack");
        if (earlyAck != null) {
            gateway.setEarlyAck(Boolean.valueOf(earlyAck));
        }
        if ((socketBufferSize = atts.getValue("socket-buffer-size")) != null) {
            gateway.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        if ((socketReadTimeout = atts.getValue("socket-read-timeout")) != null) {
            gateway.setSocketReadTimeout(Integer.parseInt(socketReadTimeout));
        }
        if ((orderPolicy = atts.getValue("order-policy")) != null) {
            try {
                gateway.setOrderPolicy(Gateway.OrderPolicy.valueOf(orderPolicy.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_GATEWAY_ORDER_POLICY_0_1.toLocalizedString(id, orderPolicy));
            }
        }
        this.stack.push(gateway);
    }

    private void startGatewayEndpoint(Attributes atts) {
        Gateway gateway = (Gateway)this.stack.peek();
        String id = atts.getValue("id");
        String host = atts.getValue("host");
        int port = Integer.parseInt(atts.getValue("port"));
        try {
            gateway.addEndpoint(id, host, port);
        }
        catch (GatewayException e) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_COULD_NOT_ADD_ENDPOINT_WITH_ID_0.toLocalizedString(id), e);
        }
    }

    private void startGatewayQueue(Attributes atts) {
        String alertThresholdStr;
        String enablePersistenceStr;
        String batchConflationStr;
        String batchTimeIntervalStr;
        String batchSizeStr;
        Gateway gateway = (Gateway)this.stack.peek();
        GatewayQueueAttributes queueAttributes = gateway.getQueueAttributes();
        String diskStoreName = atts.getValue("disk-store-name");
        if (diskStoreName != null) {
            queueAttributes.setDiskStoreName(diskStoreName);
        } else {
            String overflowDirectory = atts.getValue("overflow-directory");
            if (overflowDirectory != null) {
                queueAttributes.setOverflowDirectory(overflowDirectory);
            }
            String enableOplogRolling = atts.getValue("roll-oplogs");
            String enableOplogCompaction = atts.getValue("auto-compact");
            if (enableOplogRolling != null) {
                queueAttributes.setRollOplogs(Boolean.valueOf(enableOplogRolling));
            } else if (enableOplogCompaction != null) {
                queueAttributes.setRollOplogs(Boolean.valueOf(enableOplogCompaction));
            }
        }
        String maximumQueueMemoryStr = atts.getValue("maximum-queue-memory");
        if (maximumQueueMemoryStr != null) {
            queueAttributes.setMaximumQueueMemory(CacheXmlParser.parseInt(maximumQueueMemoryStr));
        }
        if ((batchSizeStr = atts.getValue("batch-size")) != null) {
            queueAttributes.setBatchSize(CacheXmlParser.parseInt(batchSizeStr));
        }
        if ((batchTimeIntervalStr = atts.getValue("batch-time-interval")) != null) {
            queueAttributes.setBatchTimeInterval(CacheXmlParser.parseInt(batchTimeIntervalStr));
        }
        if ((batchConflationStr = atts.getValue("batch-conflation")) != null) {
            queueAttributes.setBatchConflation(Boolean.valueOf(batchConflationStr));
        }
        if ((enablePersistenceStr = atts.getValue("enable-persistence")) != null) {
            queueAttributes.setEnablePersistence(Boolean.valueOf(enablePersistenceStr));
        }
        if ((alertThresholdStr = atts.getValue("alert-threshold")) != null) {
            queueAttributes.setAlertThreshold(CacheXmlParser.parseInt(alertThresholdStr));
        }
    }

    private void endCacheServer() {
        ArrayList<Object> groups = new ArrayList<Object>();
        ServerLoadProbe probe = null;
        ClientHaQueueCreation haCreation = null;
        if (this.stack.peek() instanceof ServerLoadProbe) {
            probe = (ServerLoadProbe)this.stack.pop();
        }
        if (this.stack.peek() instanceof ClientHaQueueCreation) {
            haCreation = (ClientHaQueueCreation)this.stack.pop();
        }
        while (this.stack.peek() instanceof String) {
            groups.add(this.stack.pop());
        }
        CacheServer bs = (CacheServer)this.stack.pop();
        if (groups.size() > 0) {
            Collections.reverse(groups);
            String[] groupArray = new String[groups.size()];
            groups.toArray(groupArray);
            bs.setGroups(groupArray);
        }
        if (probe != null) {
            bs.setLoadProbe(probe);
        }
        if (haCreation != null) {
            ClientSubscriptionConfig csc = bs.getClientSubscriptionConfig();
            String diskStoreName = haCreation.getDiskStoreName();
            if (diskStoreName != null) {
                csc.setDiskStoreName(diskStoreName);
            } else {
                csc.setOverflowDirectory(haCreation.getOverflowDirectory() == null ? "." : haCreation.getOverflowDirectory());
            }
            csc.setCapacity(haCreation.getCapacity());
            csc.setEvictionPolicy(haCreation.getEvictionPolicy());
        }
    }

    private void endLoadProbe() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof ServerLoadProbe)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "BridgeLoadProbe"));
        }
        this.stack.push(d);
    }

    private void endGatewayHub() {
        this.stack.pop();
    }

    private void endSerialGatewaySender() {
        GatewaySenderFactory senderFactory = (GatewaySenderFactory)this.stack.pop();
        String remoteDSString = (String)this.stack.pop();
        String id = (String)this.stack.pop();
        senderFactory.create(id, Integer.parseInt(remoteDSString));
    }

    private void endGatewayReceiver() {
        GatewayReceiverFactory receiverFactory = (GatewayReceiverFactory)this.stack.pop();
        receiverFactory.create();
    }

    private void startDynamicRegionFactory(Attributes atts) {
        String disablePersist = atts.getValue("disable-persist-backup");
        if (disablePersist == null) {
            this.stack.push("false");
        } else {
            this.stack.push(disablePersist);
        }
        String disableRegisterInterest = atts.getValue("disable-register-interest");
        if (disableRegisterInterest == null) {
            this.stack.push("false");
        } else {
            this.stack.push(disableRegisterInterest);
        }
        String poolName = atts.getValue("pool-name");
        if (poolName == null) {
            this.stack.push(null);
        } else {
            this.stack.push(poolName);
        }
        RegionAttributesCreation attrs = new RegionAttributesCreation(this.cache);
        this.stack.push(attrs);
    }

    private void endDynamicRegionFactory() {
        RegionAttributesCreation attrs;
        File dir = null;
        Object o = this.stack.pop();
        if (o instanceof File) {
            dir = (File)o;
            this.stack.pop();
            attrs = (RegionAttributesCreation)this.stack.pop();
        } else {
            attrs = (RegionAttributesCreation)o;
        }
        String poolName = (String)this.stack.pop();
        String disableRegisterInterest = (String)this.stack.pop();
        String disablePersistBackup = (String)this.stack.pop();
        CacheWriter cw = attrs.getCacheWriter();
        if (poolName != null && cw != null) {
            throw new CacheXmlException("You cannot specify both a poolName and a cacheWriter for a dynamic-region-factory.");
        }
        if (cw != null && !(cw instanceof BridgeWriter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_THE_DYNAMICREGIONFACTORY_CACHEWRITER_MUST_BE_AN_INSTANCE_OF_BRIDGEWRITER.toLocalizedString());
        }
        DynamicRegionFactory.Config cfg = poolName != null ? new DynamicRegionFactory.Config(dir, poolName, Boolean.valueOf(disablePersistBackup) == false, Boolean.valueOf(disableRegisterInterest) == false) : new DynamicRegionFactory.Config(dir, (BridgeWriter)cw, Boolean.valueOf(disablePersistBackup) == false, Boolean.valueOf(disableRegisterInterest) == false);
        CacheCreation cache = (CacheCreation)this.stack.peek();
        cache.setDynamicRegionFactoryConfig(cfg);
    }

    private void endGateway() {
        this.stack.pop();
    }

    private void endGatewayListener() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof GatewayEventListener)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_GATEWAYEVENTLISTENER.toLocalizedString(d.getClass().getName()));
        }
        Gateway gateway = (Gateway)this.stack.peek();
        gateway.addListener((GatewayEventListener)((Object)d));
    }

    private void endGatewayConflictResolver() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof GatewayConflictResolver)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_GATEWAYCONFLICTRESOLVER.toLocalizedString(d.getClass().getName()));
        }
        CacheCreation c = (CacheCreation)this.stack.peek();
        c.setGatewayConflictResolver((GatewayConflictResolver)((Object)d));
    }

    private void startRegion(Attributes atts) {
        String name = atts.getValue("name");
        String refid = atts.getValue("refid");
        Assert.assertTrue(name != null);
        RegionCreation region = new RegionCreation(this.cache, name, refid);
        this.stack.push(region);
    }

    private void startCacheTransactionManager() {
        this.stack.push(new CacheTransactionManagerCreation());
    }

    private void endRegion() throws RegionExistsException {
        RegionCreation region = (RegionCreation)this.stack.pop();
        boolean isRoot = false;
        if (this.stack.isEmpty()) {
            isRoot = true;
        } else if (!(this.stack.peek() instanceof RegionCreation)) {
            isRoot = true;
        }
        if (isRoot) {
            this.cache.addRootRegion(region);
        } else {
            RegionCreation parent = (RegionCreation)this.stack.peek();
            parent.addSubregion(region.getName(), region);
        }
    }

    private void endCacheTransactionManager() {
        CacheTransactionManagerCreation txMgrCreation = (CacheTransactionManagerCreation)this.stack.pop();
        this.cache.addCacheTransactionManagerCreation(txMgrCreation);
    }

    private void endTransactionListener() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof TransactionListener)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_CACHELISTENER.toLocalizedString(d.getClass().getName()));
        }
        CacheTransactionManagerCreation txMgrCreation = (CacheTransactionManagerCreation)this.stack.peek();
        txMgrCreation.addListener((TransactionListener)((Object)d));
    }

    private void startDiskStore(Attributes atts) {
        String warnPct;
        String queueSize;
        String writeBufferSize;
        String timeInterval;
        String maxOplogSize;
        String allowForceCompaction;
        String compactionThreshold;
        DiskStoreAttributesCreation attrs = new DiskStoreAttributesCreation();
        String name = atts.getValue("name");
        if (name == null) {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_NULL_DiskStoreName.toLocalizedString());
        }
        attrs.setName(name);
        String autoCompact = atts.getValue("auto-compact");
        if (autoCompact != null) {
            attrs.setAutoCompact(Boolean.valueOf(autoCompact));
        }
        if ((compactionThreshold = atts.getValue("compaction-threshold")) != null) {
            attrs.setCompactionThreshold(CacheXmlParser.parseInt(compactionThreshold));
        }
        if ((allowForceCompaction = atts.getValue("allow-force-compaction")) != null) {
            attrs.setAllowForceCompaction(Boolean.valueOf(allowForceCompaction));
        }
        if ((maxOplogSize = atts.getValue("max-oplog-size")) != null) {
            attrs.setMaxOplogSize(CacheXmlParser.parseInt(maxOplogSize));
        }
        if ((timeInterval = atts.getValue("time-interval")) != null) {
            attrs.setTimeInterval(CacheXmlParser.parseInt(timeInterval));
        }
        if ((writeBufferSize = atts.getValue("write-buffer-size")) != null) {
            attrs.setWriteBufferSize(CacheXmlParser.parseInt(writeBufferSize));
        }
        if ((queueSize = atts.getValue("queue-size")) != null) {
            attrs.setQueueSize(CacheXmlParser.parseInt(queueSize));
        }
        if ((warnPct = atts.getValue("disk-usage-warning-percentage")) != null) {
            attrs.setDiskUsageWarningPercentage(CacheXmlParser.parseFloat(warnPct));
        }
        String criticalPct = atts.getValue("disk-usage-critical-percentage");
        if (warnPct != null) {
            attrs.setDiskUsageCriticalPercentage(CacheXmlParser.parseFloat(criticalPct));
        }
        this.stack.push(attrs);
    }

    private void endTransactionWriter() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof TransactionWriter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_TRANSACTION_WRITER.toLocalizedString(d.getClass().getName()));
        }
        CacheTransactionManagerCreation txMgrCreation = (CacheTransactionManagerCreation)this.stack.peek();
        txMgrCreation.setWriter((TransactionWriter)((Object)d));
    }

    private void startRegionAttributes(Attributes atts) {
        String asyncEventQueueIds;
        String gatewaySenderIds;
        String cloningEnabledStr;
        String gatewayHubId;
        String enableAsyncConflation;
        String enableBridgeConflation;
        String enableGateway;
        String refid;
        String id;
        String isDiskSynchronous;
        String diskStoreName;
        String indexUpdateType;
        String mcastEnabled;
        String earlyAck;
        String persistBackup;
        String isLockGrantor;
        String ignoreJTA;
        String statisticsEnabled;
        String loadFactor;
        String concurrencyChecksEnabled;
        String concurrencyLevel;
        String initialCapacity;
        String dp;
        String mirror;
        RegionAttributesCreation attrs = new RegionAttributesCreation(this.cache);
        String scope = atts.getValue("scope");
        if (scope != null) {
            if (scope.equals("local")) {
                attrs.setScope(Scope.LOCAL);
            } else if (scope.equals("distributed-no-ack")) {
                attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
            } else if (scope.equals("distributed-ack")) {
                attrs.setScope(Scope.DISTRIBUTED_ACK);
            } else if (scope.equals("global")) {
                attrs.setScope(Scope.GLOBAL);
            } else {
                throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_SCOPE_0.toLocalizedString(scope));
            }
        }
        if ((mirror = atts.getValue("mirror-type")) != null) {
            if (mirror.equals("none")) {
                attrs.setMirrorType(MirrorType.NONE);
            } else if (mirror.equals("keys")) {
                attrs.setMirrorType(MirrorType.KEYS);
            } else if (mirror.equals("keys-values")) {
                attrs.setMirrorType(MirrorType.KEYS_VALUES);
            } else {
                throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_MIRROR_TYPE_0.toLocalizedString(mirror));
            }
        }
        if ((dp = atts.getValue("data-policy")) != null) {
            if (dp.equals("normal")) {
                attrs.setDataPolicy(DataPolicy.NORMAL);
            } else if (dp.equals("preloaded")) {
                attrs.setDataPolicy(DataPolicy.PRELOADED);
            } else if (dp.equals("empty")) {
                attrs.setDataPolicy(DataPolicy.EMPTY);
            } else if (dp.equals("replicate")) {
                attrs.setDataPolicy(DataPolicy.REPLICATE);
            } else if (dp.equals("persistent-replicate")) {
                attrs.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
            } else if (dp.equals("partition")) {
                attrs.setDataPolicy(DataPolicy.PARTITION);
            } else if (dp.equals("persistent-partition")) {
                attrs.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
            } else {
                throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_DATA_POLICY_0.toLocalizedString(dp));
            }
        }
        if ((initialCapacity = atts.getValue("initial-capacity")) != null) {
            attrs.setInitialCapacity(CacheXmlParser.parseInt(initialCapacity));
        }
        if ((concurrencyLevel = atts.getValue("concurrency-level")) != null) {
            attrs.setConcurrencyLevel(CacheXmlParser.parseInt(concurrencyLevel));
        }
        if ((concurrencyChecksEnabled = atts.getValue("concurrency-checks-enabled")) != null) {
            attrs.setConcurrencyChecksEnabled(Boolean.valueOf(concurrencyChecksEnabled));
        }
        if ((loadFactor = atts.getValue("load-factor")) != null) {
            attrs.setLoadFactor(CacheXmlParser.parseFloat(loadFactor));
        }
        if ((statisticsEnabled = atts.getValue("statistics-enabled")) != null) {
            attrs.setStatisticsEnabled(Boolean.valueOf(statisticsEnabled));
        }
        if ((ignoreJTA = atts.getValue("ignore-jta")) != null) {
            attrs.setIgnoreJTA(Boolean.valueOf(ignoreJTA));
        }
        if ((isLockGrantor = atts.getValue("is-lock-grantor")) != null) {
            attrs.setLockGrantor(Boolean.valueOf(isLockGrantor));
        }
        if ((persistBackup = atts.getValue("persist-backup")) != null) {
            attrs.setPersistBackup(Boolean.valueOf(persistBackup));
        }
        if ((earlyAck = atts.getValue("early-ack")) != null) {
            attrs.setEarlyAck(Boolean.valueOf(earlyAck));
        }
        if ((mcastEnabled = atts.getValue("multicast-enabled")) != null) {
            attrs.setMulticastEnabled(Boolean.valueOf(mcastEnabled));
        }
        attrs.setIndexMaintenanceSynchronous((indexUpdateType = atts.getValue("index-update-type")) == null || indexUpdateType.equals("synchronous"));
        String poolName = atts.getValue("pool-name");
        if (poolName != null) {
            attrs.setPoolName(poolName);
        }
        if ((diskStoreName = atts.getValue("disk-store-name")) != null) {
            attrs.setDiskStoreName(diskStoreName);
        }
        if ((isDiskSynchronous = atts.getValue("disk-synchronous")) != null) {
            attrs.setDiskSynchronous(Boolean.valueOf(isDiskSynchronous));
        }
        if ((id = atts.getValue("id")) != null) {
            attrs.setId(id);
        }
        if ((refid = atts.getValue("refid")) != null) {
            attrs.setRefid(refid);
        }
        if ((enableGateway = atts.getValue("enable-gateway")) != null) {
            attrs.setEnableGateway(Boolean.valueOf(enableGateway));
        } else {
            enableGateway = atts.getValue("enable-wan");
            if (enableGateway != null) {
                attrs.setEnableGateway(Boolean.valueOf(enableGateway));
            }
        }
        String enableSubscriptionConflation = atts.getValue("enable-subscription-conflation");
        if (enableSubscriptionConflation != null) {
            attrs.setEnableSubscriptionConflation(Boolean.valueOf(enableSubscriptionConflation));
        }
        if ((enableBridgeConflation = atts.getValue("enable-bridge-conflation")) != null && enableSubscriptionConflation == null) {
            attrs.setEnableSubscriptionConflation(Boolean.valueOf(enableBridgeConflation));
        }
        if (enableBridgeConflation == null && enableSubscriptionConflation == null && (enableBridgeConflation = atts.getValue("enable-conflation")) != null) {
            attrs.setEnableSubscriptionConflation(Boolean.valueOf(enableBridgeConflation));
        }
        if ((enableAsyncConflation = atts.getValue("enable-async-conflation")) != null) {
            attrs.setEnableAsyncConflation(Boolean.valueOf(enableAsyncConflation));
        }
        if ((gatewayHubId = atts.getValue("hub-id")) != null) {
            attrs.setGatewayHubId(gatewayHubId);
        }
        if ((cloningEnabledStr = atts.getValue("cloning-enabled")) != null) {
            attrs.setCloningEnable(Boolean.valueOf(cloningEnabledStr));
        }
        if ((gatewaySenderIds = atts.getValue("gateway-sender-ids")) != null && gatewaySenderIds.length() != 0) {
            StringTokenizer st = new StringTokenizer(gatewaySenderIds, ",");
            while (st.hasMoreElements()) {
                attrs.addGatewaySenderId(st.nextToken());
            }
        }
        if ((asyncEventQueueIds = atts.getValue("async-event-queue-ids")) != null && asyncEventQueueIds.length() != 0) {
            StringTokenizer st = new StringTokenizer(asyncEventQueueIds, ",");
            while (st.hasMoreElements()) {
                attrs.addAsyncEventQueueId(st.nextToken());
            }
        }
        this.stack.push(attrs);
    }

    private void endDiskStore() {
        CacheCreation cache;
        DiskStoreAttributesCreation dsac = (DiskStoreAttributesCreation)this.stack.pop();
        Object top = this.stack.peek();
        if (top instanceof CacheCreation) {
            cache = (CacheCreation)top;
        } else {
            String s = "Did not expected a " + top.getClass().getName() + " on top of the stack.";
            Assert.assertTrue(false, s);
            cache = null;
        }
        String name = dsac.getName();
        if (name != null) {
            cache.setDiskStore(name, dsac);
        }
    }

    private void endRegionAttributes() {
        CacheCreation cache;
        RegionAttributesCreation attrs = (RegionAttributesCreation)this.stack.pop();
        Object top = this.stack.peek();
        if (top instanceof RegionCreation) {
            RegionCreation region = (RegionCreation)top;
            region.setAttributes(attrs);
            cache = (CacheCreation)region.getCache();
        } else if (top instanceof CacheCreation) {
            cache = (CacheCreation)top;
        } else {
            String s = "Did not expected a " + top.getClass().getName() + " on top of the stack.";
            Assert.assertTrue(false, s);
            cache = null;
        }
        String id = attrs.getId();
        if (id != null) {
            cache.setRegionAttributes(id, (RegionAttributes)attrs);
        }
    }

    private void endCache() {
    }

    private void endClientCache() {
    }

    private void endString() {
        StringBuffer str = (StringBuffer)this.stack.pop();
        this.stack.push(str.toString());
    }

    private void endGroup() {
        StringBuffer str = (StringBuffer)this.stack.pop();
        this.stack.push(str.toString().trim());
    }

    private void endClassName() {
        StringBuffer str = (StringBuffer)this.stack.pop();
        this.stack.push(str.toString().trim());
    }

    private void endEntry() {
        Object value2 = this.stack.pop();
        Object key2 = this.stack.pop();
        RegionCreation region = (RegionCreation)this.stack.peek();
        region.put(key2, value2);
    }

    private void endKeyConstraint() {
        Class<?> c;
        String className = ((StringBuffer)this.stack.pop()).toString().trim();
        try {
            c = InternalDataSerializer.getCachedClass(className);
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_COULD_NOT_LOAD_KEYCONSTRAINT_CLASS_0.toLocalizedString(className), ex);
        }
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("key-constraint");
        attrs.setKeyConstraint(c);
    }

    private void endValueConstraint() {
        Class<?> c;
        String className = ((StringBuffer)this.stack.pop()).toString().trim();
        try {
            c = InternalDataSerializer.getCachedClass(className);
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_COULD_NOT_LOAD_VALUECONSTRAINT_CLASS_0.toLocalizedString(className), ex);
        }
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("value-constraint");
        attrs.setValueConstraint(c);
    }

    private void endRegionTimeToLive() {
        ExpirationAttributes expire = (ExpirationAttributes)this.stack.pop();
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("region-time-to-live");
        attrs.setRegionTimeToLive(expire);
    }

    private void endRegionIdleTime() {
        ExpirationAttributes expire = (ExpirationAttributes)this.stack.pop();
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("region-idle-time");
        attrs.setRegionIdleTimeout(expire);
    }

    private RegionAttributesCreation peekRegionAttributesContext(String dependentElement) {
        Object a = this.stack.peek();
        if (!(a instanceof RegionAttributesCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES.toLocalizedString(dependentElement));
        }
        return (RegionAttributesCreation)a;
    }

    private PartitionAttributesImpl peekPartitionAttributesImpl(String dependentElement) {
        Object a = this.stack.peek();
        if (!(a instanceof PartitionAttributesImpl)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_PARTITIONATTRIBUTES.toLocalizedString(dependentElement));
        }
        return (PartitionAttributesImpl)a;
    }

    private void endEntryTimeToLive() {
        Declarable custom = null;
        if (this.stack.peek() instanceof Declarable) {
            custom = (Declarable)this.stack.pop();
        }
        ExpirationAttributes expire = (ExpirationAttributes)this.stack.pop();
        Object a = this.stack.peek();
        if (a instanceof RegionAttributesCreation) {
            ((RegionAttributesCreation)a).setEntryTimeToLive(expire);
            if (custom != null) {
                ((RegionAttributesCreation)a).setCustomEntryTimeToLive((CustomExpiry)((Object)custom));
            }
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES_OR_PARTITIONATTRIBUTES.toLocalizedString("entry-time-to-live"));
        }
    }

    private void endEntryIdleTime() {
        Declarable custom = null;
        if (this.stack.peek() instanceof Declarable) {
            custom = (Declarable)this.stack.pop();
        }
        ExpirationAttributes expire = (ExpirationAttributes)this.stack.pop();
        Object a = this.stack.peek();
        if (a instanceof RegionAttributesCreation) {
            ((RegionAttributesCreation)a).setEntryIdleTimeout(expire);
            if (custom != null) {
                ((RegionAttributesCreation)a).setCustomEntryIdleTimeout((CustomExpiry)((Object)custom));
            }
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES_OR_PARTITIONATTRIBUTES.toLocalizedString("entry-idle-time"));
        }
    }

    private void endPartitionAttributes() {
        PartitionAttributesImpl paf = (PartitionAttributesImpl)this.stack.pop();
        paf.validateAttributes();
        RegionAttributesCreation rattrs = this.peekRegionAttributesContext("partition-attributes");
        if (rattrs.hasDataPolicy() && rattrs.getDataPolicy().isEmpty() && this.version.compareTo(CacheXmlVersion.VERSION_5_0) == 0) {
            rattrs.setDataPolicy(PartitionedRegionHelper.DEFAULT_DATA_POLICY);
        }
        rattrs.setPartitionAttributes(paf);
    }

    private void endFixedPartitionAttributes() {
    }

    private void endMembershipAttributes() {
        HashSet<Object> roles = new HashSet<Object>();
        Object obj = null;
        while (!(obj instanceof Object[])) {
            obj = this.stack.pop();
            if (!(obj instanceof String)) continue;
            roles.add(obj);
        }
        Object[] attrs = (Object[])obj;
        String laName = ((String)attrs[0]).toUpperCase().replace('-', '_');
        String raName = ((String)attrs[1]).toUpperCase().replace('-', '_');
        LossAction laction = LossAction.fromName(laName);
        ResumptionAction raction = ResumptionAction.fromName(raName);
        MembershipAttributes ra = new MembershipAttributes(roles.toArray(new String[roles.size()]), laction, raction);
        RegionAttributesCreation rattrs = (RegionAttributesCreation)this.stack.peek();
        rattrs.setMembershipAttributes(ra);
    }

    private void endRequiredRole() {
    }

    private void endDiskWriteAttributes() {
        DiskWriteAttributes dwa = (DiskWriteAttributes)this.stack.pop();
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("disk-write-attributes");
        attrs.setDiskWriteAttributes(dwa);
    }

    private void endDiskDir() {
        StringBuffer dirName = (StringBuffer)this.stack.pop();
        File dir = new File(dirName.toString().trim());
        if (!dir.exists()) {
            // empty if block
        }
        this.stack.push(dir);
    }

    private void endDiskDirs() {
        ArrayList<Object> dirs = new ArrayList<Object>();
        ArrayList<Object> sizes = new ArrayList<Object>();
        while (this.stack.peek() instanceof File) {
            dirs.add(this.stack.pop());
            sizes.add(this.stack.pop());
        }
        Assert.assertTrue(!dirs.isEmpty());
        Assert.assertTrue(!sizes.isEmpty());
        File[] disks = new File[dirs.size()];
        int dirsLength = dirs.size();
        for (int i = 0; i < dirsLength; ++i) {
            disks[i] = (File)dirs.get(dirsLength - 1 - i);
        }
        int[] diskSizes = new int[sizes.size()];
        for (int i = 0; i < dirsLength; ++i) {
            diskSizes[i] = (Integer)sizes.get(dirsLength - 1 - i);
        }
        Object a = this.stack.peek();
        if (a instanceof RegionAttributesCreation) {
            RegionAttributesCreation attrs = (RegionAttributesCreation)a;
            attrs.setDiskDirsAndSize(disks, diskSizes);
        } else if (a instanceof DiskStoreAttributesCreation) {
            DiskStoreAttributesCreation attrs = (DiskStoreAttributesCreation)a;
            attrs.setDiskDirsAndSize(disks, diskSizes);
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES.toLocalizedString("disk-dirs"));
        }
    }

    private void startSynchronousWrites() {
        int maxOplogSize = (Integer)this.stack.pop();
        String rollOplog = (String)this.stack.pop();
        long maxOplogSizeInBytes = maxOplogSize;
        maxOplogSizeInBytes = maxOplogSizeInBytes * 1024L * 1024L;
        Properties props = new Properties();
        props.setProperty("max-oplog-size", String.valueOf(maxOplogSizeInBytes));
        props.setProperty("roll-oplogs", rollOplog);
        props.setProperty("synchronous", "true");
        this.stack.push(new DiskWriteAttributesImpl(props));
    }

    private void startAsynchronousWrites(Attributes atts) {
        int maxOplogSize = (Integer)this.stack.pop();
        String rollOplog = (String)this.stack.pop();
        long maxOplogSizeInBytes = maxOplogSize;
        maxOplogSizeInBytes = maxOplogSizeInBytes * 1024L * 1024L;
        long timeInterval = CacheXmlParser.parseLong(atts.getValue("time-interval"));
        long bytesThreshold = CacheXmlParser.parseLong(atts.getValue("bytes-threshold"));
        Properties props = new Properties();
        props.setProperty("max-oplog-size", String.valueOf(maxOplogSizeInBytes));
        props.setProperty("roll-oplogs", rollOplog);
        props.setProperty("time-interval", String.valueOf(timeInterval));
        props.setProperty("synchronous", "false");
        props.setProperty("bytes-threshold", String.valueOf(bytesThreshold));
        this.stack.push(new DiskWriteAttributesImpl(props));
    }

    private void startPartitionAttributes(Attributes atts) {
        String startupRecoveryDelay;
        String recoveryDelay;
        String colocatedWith;
        String totalNumBuckets;
        String totalMaxMem;
        String localMaxMem;
        PartitionAttributesImpl paf = new PartitionAttributesImpl();
        String redundancy = atts.getValue("redundant-copies");
        if (redundancy != null) {
            paf.setRedundantCopies(CacheXmlParser.parseInt(redundancy));
        }
        if ((localMaxMem = atts.getValue("local-max-memory")) != null) {
            paf.setLocalMaxMemory(CacheXmlParser.parseInt(localMaxMem));
        }
        if ((totalMaxMem = atts.getValue("total-max-memory")) != null) {
            paf.setTotalMaxMemory(CacheXmlParser.parseLong(totalMaxMem));
        }
        if ((totalNumBuckets = atts.getValue("total-num-buckets")) != null) {
            paf.setTotalNumBuckets(CacheXmlParser.parseInt(totalNumBuckets));
        }
        if ((colocatedWith = atts.getValue("colocated-with")) != null) {
            paf.setColocatedWith(colocatedWith);
        }
        if ((recoveryDelay = atts.getValue("recovery-delay")) != null) {
            paf.setRecoveryDelay(CacheXmlParser.parseInt(recoveryDelay));
        }
        if ((startupRecoveryDelay = atts.getValue("startup-recovery-delay")) != null) {
            paf.setStartupRecoveryDelay(CacheXmlParser.parseInt(startupRecoveryDelay));
        }
        this.stack.push(paf);
    }

    private void startFixedPartitionAttributes(Attributes atts) {
        Object a;
        String numBuckets;
        String isPrimary;
        FixedPartitionAttributesImpl fpai = new FixedPartitionAttributesImpl();
        String partitionName = atts.getValue("partition-name");
        if (partitionName != null) {
            fpai.setPartitionName(partitionName);
        }
        if ((isPrimary = atts.getValue("is-primary")) != null) {
            fpai.isPrimary(CacheXmlParser.parseBoolean(isPrimary));
        }
        if ((numBuckets = atts.getValue("num-buckets")) != null) {
            fpai.setNumBuckets(CacheXmlParser.parseInt(numBuckets));
        }
        if ((a = this.stack.peek()) instanceof PartitionAttributesImpl) {
            ((PartitionAttributesImpl)a).addFixedPartitionAttributes(fpai);
        }
    }

    private void startMembershipAttributes(Attributes atts) {
        Object[] attrs = new Object[]{atts.getValue("loss-action") == null ? LossAction.NO_ACCESS.toString() : atts.getValue("loss-action"), atts.getValue("resumption-action") == null ? ResumptionAction.REINITIALIZE.toString() : atts.getValue("resumption-action")};
        this.stack.push(attrs);
    }

    private void startSubscriptionAttributes(Attributes atts) {
        SubscriptionAttributes sa;
        String ip = atts.getValue("interest-policy");
        if (ip == null) {
            sa = new SubscriptionAttributes();
        } else if (ip.equals("all")) {
            sa = new SubscriptionAttributes(InterestPolicy.ALL);
        } else if (ip.equals("cache-content")) {
            sa = new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT);
        } else {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_INTERESTPOLICY_0.toLocalizedString(ip));
        }
        RegionAttributesCreation rattrs = (RegionAttributesCreation)this.stack.peek();
        rattrs.setSubscriptionAttributes(sa);
    }

    private void startRequiredRole(Attributes atts) {
        this.stack.push(atts.getValue("name"));
    }

    private void startIndex(Attributes atts) {
        boolean isPrimary = false;
        String type = "";
        IndexCreationData icd = new IndexCreationData(atts.getValue("name"));
        int len = atts.getLength();
        if (len > 1) {
            if (Boolean.valueOf(atts.getValue("key-index")).booleanValue()) {
                icd.setIndexType(IndexType.PRIMARY_KEY);
                isPrimary = true;
            }
            type = atts.getValue("type");
        }
        if (len > 2) {
            String fromClause = atts.getValue("from-clause");
            String expression = atts.getValue("expression");
            String importStr = atts.getValue("imports");
            if (isPrimary) {
                icd.setIndexData(IndexType.PRIMARY_KEY, null, expression, null);
            } else {
                if (type == null) {
                    type = "range";
                }
                if (type.equals("hash")) {
                    icd.setIndexData(IndexType.HASH, fromClause, expression, importStr);
                } else if (type.equals("range")) {
                    icd.setIndexData(IndexType.FUNCTIONAL, fromClause, expression, importStr);
                } else {
                    logger.trace(LogMarker.CACHE_XML_PARSER, LocalizedMessage.create(LocalizedStrings.CacheXmlParser_UNKNOWN_INDEX_TYPE, type));
                    icd.setIndexData(IndexType.FUNCTIONAL, fromClause, expression, importStr);
                }
            }
        }
        this.stack.push(icd);
    }

    private void endIndex() {
        boolean throwExcep = false;
        IndexCreationData icd = (IndexCreationData)this.stack.pop();
        if (icd.getIndexType() == null) {
            throwExcep = true;
        } else if (icd.getIndexType().equals(IndexType.PRIMARY_KEY)) {
            if (icd.getIndexExpression() == null) {
                throwExcep = true;
            }
        } else if (icd.getIndexExpression() == null && icd.getIndexFromClause() == null) {
            throwExcep = true;
        }
        if (throwExcep) {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_CACHEXMLPARSERENDINDEXINDEX_CREATION_ATTRIBUTE_NOT_CORRECTLY_SPECIFIED.toLocalizedString());
        }
        RegionCreation rc = (RegionCreation)this.stack.peek();
        rc.addIndexData(icd);
    }

    private void startFunctionalIndex(Attributes atts) {
        boolean throwExcep = false;
        IndexCreationData icd = (IndexCreationData)this.stack.peek();
        int len = -1;
        len = atts.getLength();
        if (len > 1) {
            String fromClause = atts.getValue("from-clause");
            String expression = atts.getValue("expression");
            String importStr = null;
            if (len == 3) {
                importStr = atts.getValue("imports");
            }
            if (fromClause == null || expression == null) {
                throwExcep = true;
            } else {
                icd.setIndexData(IndexType.FUNCTIONAL, fromClause, expression, importStr);
            }
        } else {
            throwExcep = true;
        }
        if (throwExcep) {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_CACHEXMLPARSERSTARTFUNCTIONALINDEXINDEX_CREATION_ATTRIBUTE_NOT_CORRECTLY_SPECIFIED.toLocalizedString());
        }
    }

    private void startPrimaryKeyIndex(Attributes atts) {
        IndexCreationData icd = (IndexCreationData)this.stack.peek();
        boolean throwExcep = false;
        if (atts.getLength() == 1) {
            String field = atts.getValue("field");
            if (field == null) {
                throwExcep = true;
            } else {
                icd.setIndexData(IndexType.PRIMARY_KEY, null, field, null);
            }
        } else {
            throwExcep = true;
        }
        if (throwExcep) {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_CACHEXMLPARSERSTARTPRIMARYKEYINDEXPRIMARYKEY_INDEX_CREATION_FIELD_IS_NULL.toLocalizedString());
        }
    }

    private void startExpirationAttributes(Attributes atts) {
        ExpirationAttributes expire;
        int timeout = CacheXmlParser.parseInt(atts.getValue("timeout"));
        String action = atts.getValue("action");
        if (action == null) {
            expire = new ExpirationAttributes(timeout);
        } else if (action.equals("invalidate")) {
            expire = new ExpirationAttributes(timeout, ExpirationAction.INVALIDATE);
        } else if (action.equals("destroy")) {
            expire = new ExpirationAttributes(timeout, ExpirationAction.DESTROY);
        } else if (action.equals("local-invalidate")) {
            expire = new ExpirationAttributes(timeout, ExpirationAction.LOCAL_INVALIDATE);
        } else if (action.equals("local-destroy")) {
            expire = new ExpirationAttributes(timeout, ExpirationAction.LOCAL_DESTROY);
        } else {
            throw new InternalGemFireException(LocalizedStrings.CacheXmlParser_UNKNOWN_EXPIRATION_ACTION_0.toLocalizedString(action));
        }
        this.stack.push(expire);
    }

    private void startSerializerRegistration() {
        SerializerCreation sc = new SerializerCreation();
        this.stack.push(sc);
    }

    private void startInstantiator(Attributes atts) {
        int id = CacheXmlParser.parseInt(atts.getValue("id"));
        this.stack.push(id);
    }

    private Declarable createDeclarable() {
        Object o;
        Properties props = new Properties();
        Object top = this.stack.pop();
        while (top instanceof Parameter) {
            Parameter param = (Parameter)top;
            props.put(param.getName(), param.getValue());
            top = this.stack.pop();
        }
        logger.trace(LogMarker.CACHE_XML_PARSER, LocalizedMessage.create(LocalizedStrings.CacheXmlParser_XML_PARSER_CREATEDECLARABLE_PROPERTIES__0, props));
        Assert.assertTrue(top instanceof String);
        String className = (String)top;
        logger.trace(LogMarker.CACHE_XML_PARSER, LocalizedMessage.create(LocalizedStrings.CacheXmlParser_XML_PARSER_CREATEDECLARABLE_CLASS_NAME_0, className));
        try {
            Class<?> c = InternalDataSerializer.getCachedClass(className);
            o = c.newInstance();
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_WHILE_INSTANTIATING_A_0.toLocalizedString(className), ex);
        }
        if (!(o instanceof Declarable)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_CLASS_0_IS_NOT_AN_INSTANCE_OF_DECLARABLE.toLocalizedString(className));
        }
        Declarable d = (Declarable)o;
        d.init(props);
        this.cache.addDeclarableProperties(d, props);
        return d;
    }

    private void endCompressor() {
        Compressor compressor;
        Class klass = this.getClassFromStack();
        if (!Compressor.class.isAssignableFrom(klass)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_COMPRESSOR.toLocalizedString(klass.getName()));
        }
        try {
            compressor = (Compressor)klass.newInstance();
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_WHILE_INSTANTIATING_A_0.toLocalizedString(klass.getName()), ex);
        }
        Object a = this.stack.peek();
        if (!(a instanceof RegionAttributesCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES_OR_1.toLocalizedString("compressor", "dynamic-region-factory"));
        }
        RegionAttributesCreation attrs = (RegionAttributesCreation)a;
        attrs.setCompressor(compressor);
    }

    private void endCacheLoader() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof CacheLoader)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_CACHELOADER.toLocalizedString(d.getClass().getName()));
        }
        Object a = this.stack.peek();
        if (a instanceof File) {
            Object sav = this.stack.pop();
            a = this.stack.peek();
            if (!(a instanceof RegionAttributesCreation)) {
                throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_CACHELOADER_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES.toLocalizedString());
            }
            this.stack.push(sav);
            RegionAttributesCreation attrs = (RegionAttributesCreation)a;
            attrs.setCacheLoader((CacheLoader)((Object)d));
        } else if (a instanceof RegionAttributesCreation) {
            RegionAttributesCreation attrs = (RegionAttributesCreation)a;
            attrs.setCacheLoader((CacheLoader)((Object)d));
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES_OR_1.toLocalizedString("cache-loader", "dynamic-region-factory"));
        }
    }

    private void endCacheWriter() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof CacheWriter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_CACHEWRITER.toLocalizedString(d.getClass().getName()));
        }
        Object a = this.stack.peek();
        if (a instanceof File) {
            Object sav = this.stack.pop();
            Object size2 = this.stack.pop();
            a = this.stack.peek();
            if (!(a instanceof RegionAttributesCreation)) {
                throw new CacheXmlException(LocalizedStrings.CacheXmlParser_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_1.toLocalizedString("cache-writer", "dynamic-region-factory"));
            }
            this.stack.push(size2);
            this.stack.push(sav);
        } else if (!(a instanceof RegionAttributesCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_REGIONATTRIBUTES.toLocalizedString("cache-writer"));
        }
        RegionAttributesCreation attrs = (RegionAttributesCreation)a;
        attrs.setCacheWriter((CacheWriter)((Object)d));
    }

    private void endCustomExpiry() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof CustomExpiry)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_CUSTOMEXPIRY.toLocalizedString(d.getClass().getName()));
        }
        this.stack.push(d);
    }

    private void startLRUEntryCount(Attributes atts) {
        String maximum = atts.getValue("maximum");
        int max = 900;
        if (maximum != null) {
            max = CacheXmlParser.parseInt(maximum);
        }
        String lruAction = atts.getValue("action");
        EvictionAction action = EvictionAction.DEFAULT_EVICTION_ACTION;
        if (lruAction != null) {
            action = EvictionAction.parseAction(lruAction);
        }
        RegionAttributesCreation regAttrs = this.peekRegionAttributesContext("lru-entry-count");
        regAttrs.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(max, action));
    }

    private void startLRUMemorySize(Attributes atts) {
        String lruAction = atts.getValue("action");
        EvictionAction action = EvictionAction.DEFAULT_EVICTION_ACTION;
        if (lruAction != null) {
            action = EvictionAction.parseAction(lruAction);
        }
        String maximum = atts.getValue("maximum");
        int max = 10;
        if (maximum != null) {
            max = CacheXmlParser.parseInt(maximum);
        }
        this.stack.push(EvictionAttributes.createLRUMemoryAttributes(max, null, action));
    }

    private void endLRUMemorySize() {
        Object declCheck = this.stack.peek();
        Declarable d = null;
        if ((declCheck instanceof String || declCheck instanceof Parameter) && !((d = this.createDeclarable()) instanceof ObjectSizer)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_OBJECTSIZER.toLocalizedString(d.getClass().getName()));
        }
        EvictionAttributesImpl eai = (EvictionAttributesImpl)this.stack.pop();
        if (d != null) {
            eai.setObjectSizer((ObjectSizer)((Object)d));
        }
        RegionAttributesCreation regAttrs = this.peekRegionAttributesContext("lru-memory-size");
        regAttrs.setEvictionAttributes(eai);
    }

    private void startLRUHeapPercentage(Attributes atts) {
        String lruAction = atts.getValue("action");
        EvictionAction action = EvictionAction.DEFAULT_EVICTION_ACTION;
        if (lruAction != null) {
            action = EvictionAction.parseAction(lruAction);
        }
        this.stack.push(EvictionAttributes.createLRUHeapAttributes(null, action));
    }

    private void endLRUHeapPercentage() {
        Object declCheck = this.stack.peek();
        Declarable d = null;
        if ((declCheck instanceof String || declCheck instanceof Parameter) && !((d = this.createDeclarable()) instanceof ObjectSizer)) {
            String s = "A " + d.getClass().getName() + " is not an instance of a ObjectSizer";
            throw new CacheXmlException(s);
        }
        EvictionAttributesImpl eai = (EvictionAttributesImpl)this.stack.pop();
        if (d != null) {
            eai.setObjectSizer((ObjectSizer)((Object)d));
        }
        RegionAttributesCreation regAttrs = this.peekRegionAttributesContext("lru-heap-percentage");
        regAttrs.setEvictionAttributes(eai);
    }

    private void endCacheListener() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof CacheListener)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_CACHELISTENER.toLocalizedString(d.getClass().getName()));
        }
        RegionAttributesCreation attrs = this.peekRegionAttributesContext("cache-listener");
        attrs.addCacheListener((CacheListener)((Object)d));
    }

    private void startAsyncEventQueue(Attributes atts) {
        AsyncEventQueueCreation asyncEventQueueCreation = new AsyncEventQueueCreation();
        String id = atts.getValue("id");
        asyncEventQueueCreation.setId(id);
        String parallel = atts.getValue("parallel");
        if (parallel == null) {
            asyncEventQueueCreation.setParallel(false);
        } else {
            asyncEventQueueCreation.setParallel(Boolean.parseBoolean(parallel));
        }
        String batchSize = atts.getValue("batch-size");
        if (batchSize == null) {
            asyncEventQueueCreation.setBatchSize(100);
        } else {
            asyncEventQueueCreation.setBatchSize(Integer.parseInt(batchSize));
        }
        String batchTimeInterval = atts.getValue("batch-time-interval");
        if (batchTimeInterval == null) {
            asyncEventQueueCreation.setBatchTimeInterval(1000);
        } else {
            asyncEventQueueCreation.setBatchTimeInterval(Integer.parseInt(batchTimeInterval));
        }
        String batchConflation = atts.getValue("enable-batch-conflation");
        if (batchConflation == null) {
            asyncEventQueueCreation.setBatchConflationEnabled(false);
        } else {
            asyncEventQueueCreation.setBatchConflationEnabled(Boolean.parseBoolean(batchConflation));
        }
        String maxQueueMemory = atts.getValue("maximum-queue-memory");
        if (maxQueueMemory == null) {
            asyncEventQueueCreation.setMaximumQueueMemory(100);
        } else {
            asyncEventQueueCreation.setMaximumQueueMemory(Integer.parseInt(maxQueueMemory));
        }
        String persistent = atts.getValue("persistent");
        if (persistent == null) {
            asyncEventQueueCreation.setPersistent(false);
        } else {
            asyncEventQueueCreation.setPersistent(Boolean.parseBoolean(persistent));
        }
        String diskStoreName = atts.getValue("disk-store-name");
        if (diskStoreName == null) {
            asyncEventQueueCreation.setDiskStoreName(null);
        } else {
            asyncEventQueueCreation.setDiskStoreName(diskStoreName);
        }
        String diskSynchronous = atts.getValue("disk-synchronous");
        if (diskSynchronous == null) {
            asyncEventQueueCreation.setDiskSynchronous(true);
        } else {
            asyncEventQueueCreation.setDiskSynchronous(Boolean.parseBoolean(diskSynchronous));
        }
        String dispatcherThreads = atts.getValue("dispatcher-threads");
        if (dispatcherThreads == null) {
            asyncEventQueueCreation.setDispatcherThreads(5);
        } else {
            asyncEventQueueCreation.setDispatcherThreads(Integer.parseInt(dispatcherThreads));
        }
        String orderPolicy = atts.getValue("order-policy");
        if (orderPolicy != null) {
            try {
                asyncEventQueueCreation.setOrderPolicy(Gateway.OrderPolicy.valueOf(orderPolicy.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new InternalGemFireException(LocalizedStrings.AsyncEventQueue_UNKNOWN_ORDER_POLICY_0_1.toLocalizedString(id, orderPolicy));
            }
        }
        this.stack.push(asyncEventQueueCreation);
    }

    private void endAsyncEventListener() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof AsyncEventListener)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_ASYNCEVENTLISTENER.toLocalizedString(d.getClass().getName()));
        }
        AsyncEventQueueCreation eventChannel = this.peekAsyncEventQueueContext("async-event-listener");
        eventChannel.setAsyncEventListener((AsyncEventListener)((Object)d));
    }

    private AsyncEventQueueCreation peekAsyncEventQueueContext(String dependentElement) {
        Object a = this.stack.peek();
        if (!(a instanceof AsyncEventQueueCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_ASYNCEVENTQUEUE.toLocalizedString(dependentElement));
        }
        return (AsyncEventQueueCreation)a;
    }

    private void endAsyncEventQueue() {
        AsyncEventQueueCreation asyncEventChannelCreation = (AsyncEventQueueCreation)this.stack.peek();
        AsyncEventQueueFactory factory = this.cache.createAsyncEventQueueFactory();
        factory.setParallel(asyncEventChannelCreation.isParallel());
        factory.setBatchSize(asyncEventChannelCreation.getBatchSize());
        factory.setBatchTimeInterval(asyncEventChannelCreation.getBatchTimeInterval());
        factory.setBatchConflationEnabled(asyncEventChannelCreation.isBatchConflationEnabled());
        factory.setPersistent(asyncEventChannelCreation.isPersistent());
        factory.setDiskStoreName(asyncEventChannelCreation.getDiskStoreName());
        factory.setDiskSynchronous(asyncEventChannelCreation.isDiskSynchronous());
        factory.setMaximumQueueMemory(asyncEventChannelCreation.getMaximumQueueMemory());
        factory.setDispatcherThreads(asyncEventChannelCreation.getDispatcherThreads());
        factory.setOrderPolicy(asyncEventChannelCreation.getOrderPolicy());
        List<GatewayEventFilter> gatewayEventFilters = asyncEventChannelCreation.getGatewayEventFilters();
        for (GatewayEventFilter gatewayEventFilter : gatewayEventFilters) {
            factory.addGatewayEventFilter(gatewayEventFilter);
        }
        factory.setGatewayEventSubstitutionListener(asyncEventChannelCreation.getGatewayEventSubstitutionFilter());
        AsyncEventQueue asyncEventChannel = factory.create(asyncEventChannelCreation.getId(), asyncEventChannelCreation.getAsyncEventListener());
        this.stack.pop();
    }

    private void endPartitionResolver() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof PartitionResolver)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "PartitionResolver"));
        }
        PartitionAttributesImpl pai = this.peekPartitionAttributesImpl("partition-attributes");
        pai.setPartitionResolver((PartitionResolver)((Object)d));
    }

    private void endPartitionListener() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof PartitionListener)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "PartitionListener"));
        }
        PartitionAttributesImpl pai = this.peekPartitionAttributesImpl("partition-attributes");
        pai.addPartitionListener((PartitionListener)((Object)d));
    }

    private void startFunctionService() {
        this.stack.push(new FunctionServiceCreation());
    }

    private void endFunctionService() {
        Object top = this.stack.pop();
        if (!(top instanceof FunctionServiceCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_EXPECTED_A_FUNCTIONSERVICECREATION_INSTANCE.toLocalizedString());
        }
        FunctionServiceCreation fsc = (FunctionServiceCreation)top;
        fsc.create();
    }

    private void startResourceManager(Attributes atts) {
        ResourceManagerCreation rmc = new ResourceManagerCreation();
        String chp = atts.getValue("critical-heap-percentage");
        if (chp != null) {
            rmc.setCriticalHeapPercentage(CacheXmlParser.parseFloat(chp));
        } else {
            rmc.setCriticalHeapPercentageToDefault();
        }
        String ehp = atts.getValue("eviction-heap-percentage");
        if (ehp != null) {
            rmc.setEvictionHeapPercentage(CacheXmlParser.parseFloat(ehp));
        } else {
            rmc.setEvictionHeapPercentageToDefault();
        }
        this.stack.push(rmc);
    }

    private void endResourceManager() {
        Object top = this.stack.pop();
        if (!(top instanceof ResourceManagerCreation)) {
            throw new CacheXmlException("Expected a ResourceManagerCreation instance");
        }
        ResourceManagerCreation rmc = (ResourceManagerCreation)top;
        this.cache.setResourceManagerCreation(rmc);
    }

    private void endBackup() {
        StringBuffer str = (StringBuffer)this.stack.pop();
        File backup = new File(str.toString().trim());
        this.cache.addBackup(backup);
    }

    private void endFunctionName() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof Function)) {
            String s = LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_FUNCTION.toLocalizedString(d.getClass().getName());
            throw new CacheXmlException(s);
        }
        Object fs = this.stack.peek();
        if (!(fs instanceof FunctionServiceCreation)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_ONLY_ALLOWED_IN_THE_CONTEXT_OF_1_MJTDEBUG_E_2.toLocalizedString("function", "function-service", fs));
        }
        FunctionServiceCreation funcService = (FunctionServiceCreation)fs;
        funcService.registerFunction((Function)((Object)d));
    }

    private Class getClassFromStack() {
        Object o = this.stack.peek();
        if (!(o instanceof String)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_NO_CLASSNAME_FOUND.toLocalizedString());
        }
        String className = (String)this.stack.pop();
        try {
            Class<?> c = InternalDataSerializer.getCachedClass(className);
            return c;
        }
        catch (Exception e) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_CLASS_NOT_FOUND.toLocalizedString(className), e);
        }
    }

    private void endSerializerRegistration() {
        SerializerCreation sc = (SerializerCreation)this.stack.pop();
        sc.create();
        this.cache.setSerializerCreation(sc);
    }

    private void endSerializer() {
        Class c = this.getClassFromStack();
        if (!DataSerializer.class.isAssignableFrom(c)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_NOT_A_SERIALIZER.toLocalizedString(c.getName()));
        }
        SerializerCreation sr = (SerializerCreation)this.stack.peek();
        sr.registerSerializer(c);
    }

    private void endInstantiator() {
        Class c = this.getClassFromStack();
        Class<?>[] ifaces = c.getInterfaces();
        boolean found = false;
        for (Class<?> clazz : ifaces) {
            if (clazz != DataSerializable.class) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_DATA_SERIALIZABLE.toLocalizedString(c.getName()));
        }
        Object o = this.stack.peek();
        if (!(o instanceof Integer)) {
            String s = LocalizedStrings.CacheXmlParser_NO_SERIALIZATION_ID.toLocalizedString();
            throw new CacheXmlException(s);
        }
        Integer id = (Integer)this.stack.pop();
        SerializerCreation sc = (SerializerCreation)this.stack.peek();
        sc.registerInstantiator(c, id);
    }

    private void startParameter(Attributes atts) {
        String name = atts.getValue("name");
        Assert.assertTrue(name != null);
        this.stack.push(name);
    }

    private void endParameter() {
        Object value2 = this.stack.pop();
        String name = (String)this.stack.pop();
        this.stack.push(new Parameter(name, value2));
    }

    private void endDeclarable() {
        Declarable d = this.createDeclarable();
        this.stack.push(d);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("cache")) {
            this.startCache(atts);
        } else if (qName.equals("client-cache")) {
            this.startClientCache(atts);
        } else if (qName.equals("bridge-server")) {
            this.startCacheServer(atts);
        } else if (qName.equals("cache-server")) {
            this.startCacheServer(atts);
        } else if (!qName.equals("custom-load-probe")) {
            if (qName.equals("pool")) {
                this.startPool(atts);
            } else if (qName.equals("client-subscription")) {
                this.startClientHaQueue(atts);
            } else if (qName.equals("dynamic-region-factory")) {
                this.startDynamicRegionFactory(atts);
            } else if (qName.equals("gateway-hub")) {
                this.startGatewayHub(atts);
            } else if (qName.equals("gateway-sender")) {
                this.startGatewaySender(atts);
            } else if (qName.equals("gateway-receiver")) {
                this.startGatewayReceiver(atts);
            } else if (!(qName.equals("gateway-event-filter") || qName.equals("gateway-transport-filter") || qName.equals("gateway-event-listener") || qName.equals("gateway-event-substitution-filter"))) {
                if (qName.equals("gateway")) {
                    this.startGateway(atts);
                } else if (qName.equals("gateway-endpoint")) {
                    this.startGatewayEndpoint(atts);
                } else if (!qName.equals("gateway-listener")) {
                    if (qName.equals("gateway-queue")) {
                        this.startGatewayQueue(atts);
                    } else if (qName.equals("async-event-queue")) {
                        this.startAsyncEventQueue(atts);
                    } else if (!qName.equals("gateway-conflict-resolver")) {
                        if (qName.equals("locator")) {
                            this.doLocator(atts);
                        } else if (qName.equals("region")) {
                            this.startRegion(atts);
                        } else if (qName.equals("vm-root-region")) {
                            this.startRegion(atts);
                        } else if (qName.equals("region-attributes")) {
                            this.startRegionAttributes(atts);
                        } else if (qName.equals("disk-store")) {
                            this.startDiskStore(atts);
                        } else if (!(qName.equals("key-constraint") || qName.equals("value-constraint") || qName.equals("index-update-type") || qName.equals("region-time-to-live") || qName.equals("region-idle-time") || qName.equals("entry-time-to-live") || qName.equals("entry-idle-time"))) {
                            if (qName.equals("expiration-attributes")) {
                                this.startExpirationAttributes(atts);
                            } else if (qName.equals("server")) {
                                this.doServer(atts);
                            } else if (!qName.equals("custom-expiry")) {
                                if (qName.equals("subscription-attributes")) {
                                    this.startSubscriptionAttributes(atts);
                                } else if (!qName.equals("entry") && !qName.equals("class-name")) {
                                    if (qName.equals("parameter")) {
                                        this.startParameter(atts);
                                    } else if (qName.equals("disk-write-attributes")) {
                                        this.startDiskWriteAttributes(atts);
                                    } else if (qName.equals("synchronous-writes")) {
                                        this.startSynchronousWrites();
                                    } else if (qName.equals("asynchronous-writes")) {
                                        this.startAsynchronousWrites(atts);
                                    } else if (!qName.equals("disk-dirs")) {
                                        if (qName.equals("disk-dir")) {
                                            this.startDiskDir(atts);
                                        } else if (!qName.equals("group")) {
                                            if (qName.equals("partition-attributes")) {
                                                this.startPartitionAttributes(atts);
                                            } else if (qName.equals("fixed-partition-attributes")) {
                                                this.startFixedPartitionAttributes(atts);
                                            } else if (qName.equals("required-role")) {
                                                this.startRequiredRole(atts);
                                            } else if (qName.equals("membership-attributes")) {
                                                this.startMembershipAttributes(atts);
                                            } else if (qName.equals("local-properties")) {
                                                this.startPartitionProperties(atts, "local-properties");
                                            } else if (qName.equals("global-properties")) {
                                                this.startPartitionProperties(atts, "global-properties");
                                            } else if (!(qName.equals("cache-loader") || qName.equals("cache-writer") || qName.equals("eviction-attributes"))) {
                                                if (qName.equals("lru-entry-count")) {
                                                    this.startLRUEntryCount(atts);
                                                } else if (qName.equals("lru-memory-size")) {
                                                    this.startLRUMemorySize(atts);
                                                } else if (qName.equals("lru-heap-percentage")) {
                                                    this.startLRUHeapPercentage(atts);
                                                } else if (!(qName.equals("cache-listener") || qName.equals("async-event-listener") || qName.equals("key") || qName.equals("value") || qName.equals("string") || qName.equals("declarable"))) {
                                                    if (qName.equals("index")) {
                                                        this.startIndex(atts);
                                                    } else if (qName.equals("functional")) {
                                                        this.startFunctionalIndex(atts);
                                                    } else if (qName.equals("primary-key")) {
                                                        this.startPrimaryKeyIndex(atts);
                                                    } else if (qName.equals("cache-transaction-manager")) {
                                                        this.startCacheTransactionManager();
                                                    } else if (!(qName.equals("transaction-listener") || qName.equals("transaction-writer") || qName.equals("jndi-bindings"))) {
                                                        if (qName.equals("jndi-binding")) {
                                                            HashMap gfSpecific = new HashMap();
                                                            this.mapJNDI(atts, gfSpecific);
                                                            ArrayList vendorSpecific = new ArrayList();
                                                            this.stack.push(new BindingCreation(gfSpecific, vendorSpecific));
                                                        } else if (qName.equals("config-property")) {
                                                            BindingCreation bc = (BindingCreation)this.stack.peek();
                                                            List vendorSpecific = bc.getVendorSpecificList();
                                                            vendorSpecific.add(new ConfigProperty());
                                                        } else if (!(qName.equals("config-property-name") || qName.equals("config-property-value") || qName.equals("config-property-type") || qName.equals("partition-resolver") || qName.equals("partition-listener"))) {
                                                            if (qName.equals("function-service")) {
                                                                this.startFunctionService();
                                                            } else if (!qName.equals("function")) {
                                                                if (qName.equals("serialization-registration")) {
                                                                    this.startSerializerRegistration();
                                                                } else if (qName.equals("initializer")) {
                                                                    this.startInitializer();
                                                                } else if (qName.equals("instantiator")) {
                                                                    this.startInstantiator(atts);
                                                                } else if (!qName.equals("serializer")) {
                                                                    if (qName.equals("resource-manager")) {
                                                                        this.startResourceManager(atts);
                                                                    } else if (!qName.equals("backup")) {
                                                                        if (qName.equals("pdx")) {
                                                                            this.startPdx(atts);
                                                                        } else if (!qName.equals("pdx-serializer") && !qName.equals("compressor")) {
                                                                            XmlParser delegate = this.getDelegate(namespaceURI);
                                                                            if (null == delegate) {
                                                                                throw new CacheXmlException(LocalizedStrings.CacheXmlParser_UNKNOWN_XML_ELEMENT_0.toLocalizedString(qName));
                                                                            }
                                                                            delegate.startElement(namespaceURI, localName, qName, atts);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private XmlParser getDelegate(String namespaceUri) {
        XmlParser delegate = this.delegates.get(namespaceUri);
        if (null == delegate) {
            try {
                ServiceLoader<XmlParser> serviceLoader = ServiceLoader.load(XmlParser.class, ClassPathLoader.getLatestAsClassLoader());
                for (XmlParser xmlParser : serviceLoader) {
                    if (!xmlParser.getNamspaceUri().equals(namespaceUri)) continue;
                    delegate = xmlParser;
                    delegate.setStack(this.stack);
                    this.delegates.put(xmlParser.getNamspaceUri(), xmlParser);
                    break;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return delegate;
    }

    private void startPdx(Attributes atts) {
        String diskStoreName;
        String persistent;
        String ignoreUnreadFields;
        String readSerialized = atts.getValue("read-serialized");
        if (readSerialized != null) {
            this.cache.setPdxReadSerialized(Boolean.parseBoolean(readSerialized));
        }
        if ((ignoreUnreadFields = atts.getValue("ignore-unread-fields")) != null) {
            this.cache.setPdxIgnoreUnreadFields(Boolean.parseBoolean(ignoreUnreadFields));
        }
        if ((persistent = atts.getValue("persistent")) != null) {
            this.cache.setPdxPersistent(Boolean.parseBoolean(persistent));
        }
        if ((diskStoreName = atts.getValue("disk-store-name")) != null) {
            this.cache.setPdxDiskStore(diskStoreName);
        }
    }

    private void startClientHaQueue(Attributes atts) {
        String diskStoreName;
        String haCapacity;
        ClientHaQueueCreation clientHaQueue = new ClientHaQueueCreation();
        String haEvictionPolicy = atts.getValue("eviction-policy");
        if (haEvictionPolicy != null) {
            clientHaQueue.setEvictionPolicy(haEvictionPolicy);
        }
        if ((haCapacity = atts.getValue("capacity")) != null) {
            clientHaQueue.setCapacity(Integer.parseInt(haCapacity));
        }
        if ((diskStoreName = atts.getValue("disk-store-name")) != null) {
            clientHaQueue.setDiskStoreName(diskStoreName);
        } else {
            String haOverflowDirectory = atts.getValue("overflow-directory");
            if (haOverflowDirectory != null) {
                clientHaQueue.setOverflowDirectory(haOverflowDirectory);
            }
        }
        this.stack.push(clientHaQueue);
    }

    private void startPartitionProperties(Attributes atts, String localOrGlobal) {
        this.stack.push(localOrGlobal);
    }

    private void startDiskDir(Attributes atts) {
        String size2 = atts.getValue("dir-size");
        Integer diskSize = null;
        diskSize = size2 == null ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(size2);
        this.stack.push(diskSize);
    }

    private void startDiskWriteAttributes(Attributes atts) {
        String roll = atts.getValue("roll-oplogs");
        if (roll == null) {
            roll = "true";
        }
        String maxOp = atts.getValue("max-oplog-size");
        int maxOplogSize = 0;
        maxOplogSize = maxOp != null ? CacheXmlParser.parseInt(maxOp) : DiskWriteAttributesImpl.getDefaultMaxOplogSize();
        this.stack.push(roll);
        this.stack.push(maxOplogSize);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (qName.equals("cache")) {
                this.endCache();
            } else if (qName.equals("client-cache")) {
                this.endClientCache();
            } else if (qName.equals("bridge-server")) {
                this.endCacheServer();
            } else if (qName.equals("cache-server")) {
                this.endCacheServer();
            } else if (qName.equals("custom-load-probe")) {
                this.endLoadProbe();
            } else if (qName.equals("client-subscription")) {
                this.endClientHaQueue();
            } else if (qName.equals("pool")) {
                this.endPool();
            } else if (qName.equals("dynamic-region-factory")) {
                this.endDynamicRegionFactory();
            } else if (qName.equals("gateway-hub")) {
                this.endGatewayHub();
            } else if (qName.equals("gateway-sender")) {
                this.endSerialGatewaySender();
            } else if (qName.equals("gateway-receiver")) {
                this.endGatewayReceiver();
            } else if (qName.equals("gateway-event-filter")) {
                this.endGatewayEventFilter();
            } else if (qName.equals("gateway-event-substitution-filter")) {
                this.endGatewayEventSubstitutionFilter();
            } else if (qName.equals("gateway-transport-filter")) {
                this.endGatewayTransportFilter();
            } else if (qName.equals("gateway")) {
                this.endGateway();
            } else if (!qName.equals("gateway-endpoint")) {
                if (qName.equals("gateway-listener")) {
                    this.endGatewayListener();
                } else if (!qName.equals("gateway-queue")) {
                    if (qName.equals("async-event-queue")) {
                        this.endAsyncEventQueue();
                    } else if (qName.equals("gateway-conflict-resolver")) {
                        this.endGatewayConflictResolver();
                    } else if (qName.equals("region")) {
                        this.endRegion();
                    } else if (qName.equals("vm-root-region")) {
                        this.endRegion();
                    } else if (qName.equals("region-attributes")) {
                        this.endRegionAttributes();
                    } else if (qName.equals("disk-store")) {
                        this.endDiskStore();
                    } else if (qName.equals("key-constraint")) {
                        this.endKeyConstraint();
                    } else if (qName.equals("value-constraint")) {
                        this.endValueConstraint();
                    } else if (qName.equals("region-time-to-live")) {
                        this.endRegionTimeToLive();
                    } else if (qName.equals("region-idle-time")) {
                        this.endRegionIdleTime();
                    } else if (qName.equals("entry-time-to-live")) {
                        this.endEntryTimeToLive();
                    } else if (qName.equals("entry-idle-time")) {
                        this.endEntryIdleTime();
                    } else if (qName.equals("custom-expiry")) {
                        this.endCustomExpiry();
                    } else if (qName.equals("disk-write-attributes")) {
                        this.endDiskWriteAttributes();
                    } else if (!qName.equals("synchronous-writes") && !qName.equals("asynchronous-writes")) {
                        if (qName.equals("disk-dirs")) {
                            this.endDiskDirs();
                        } else if (qName.equals("disk-dir")) {
                            this.endDiskDir();
                        } else if (qName.equals("group")) {
                            this.endGroup();
                        } else if (qName.equals("partition-attributes")) {
                            this.endPartitionAttributes();
                        } else if (qName.equals("fixed-partition-attributes")) {
                            this.endFixedPartitionAttributes();
                        } else if (qName.equals("local-properties")) {
                            this.endPartitionProperites("local-properties");
                        } else if (qName.equals("global-properties")) {
                            this.endPartitionProperites("global-properties");
                        } else if (qName.equals("membership-attributes")) {
                            this.endMembershipAttributes();
                        } else if (qName.equals("required-role")) {
                            this.endRequiredRole();
                        } else if (!qName.equals("expiration-attributes")) {
                            if (qName.equals("custom-expiry")) {
                                this.endCustomExpiry();
                            } else if (!qName.equals("subscription-attributes")) {
                                if (qName.equals("entry")) {
                                    this.endEntry();
                                } else if (qName.equals("class-name")) {
                                    this.endClassName();
                                } else if (qName.equals("parameter")) {
                                    this.endParameter();
                                } else if (qName.equals("cache-loader")) {
                                    this.endCacheLoader();
                                } else if (qName.equals("cache-writer")) {
                                    this.endCacheWriter();
                                } else if (!qName.equals("eviction-attributes") && !qName.equals("lru-entry-count")) {
                                    if (qName.equals("lru-memory-size")) {
                                        this.endLRUMemorySize();
                                    } else if (qName.equals("lru-heap-percentage")) {
                                        this.endLRUHeapPercentage();
                                    } else if (qName.equals("cache-listener")) {
                                        this.endCacheListener();
                                    } else if (qName.equals("async-event-listener")) {
                                        this.endAsyncEventListener();
                                    } else if (!qName.equals("key") && !qName.equals("value")) {
                                        if (qName.equals("string")) {
                                            this.endString();
                                        } else if (qName.equals("declarable")) {
                                            this.endDeclarable();
                                        } else if (!qName.equals("functional")) {
                                            if (qName.equals("index")) {
                                                this.endIndex();
                                            } else if (!qName.equals("primary-key")) {
                                                if (qName.equals("cache-transaction-manager")) {
                                                    this.endCacheTransactionManager();
                                                } else if (qName.equals("transaction-listener")) {
                                                    this.endTransactionListener();
                                                } else if (qName.equals("transaction-writer")) {
                                                    this.endTransactionWriter();
                                                } else if (!qName.equals("jndi-bindings")) {
                                                    if (qName.equals("jndi-binding")) {
                                                        BindingCreation bc = (BindingCreation)this.stack.pop();
                                                        JNDIInvoker.mapDatasource(bc.getGFSpecificMap(), bc.getVendorSpecificList());
                                                    } else if (!qName.equals("config-property")) {
                                                        if (qName.equals("config-property-name")) {
                                                            String name = null;
                                                            if (this.stack.peek() instanceof StringBuffer) {
                                                                name = ((StringBuffer)this.stack.pop()).toString();
                                                            }
                                                            BindingCreation bc = (BindingCreation)this.stack.peek();
                                                            List vsList = bc.getVendorSpecificList();
                                                            ConfigProperty cp = (ConfigProperty)vsList.get(vsList.size() - 1);
                                                            if (name == null) {
                                                                String excep = LocalizedStrings.CacheXmlParser_EXCEPTION_IN_PARSING_ELEMENT_0_THIS_IS_A_REQUIRED_FIELD.toLocalizedString(qName);
                                                                throw new CacheXmlException(excep);
                                                            }
                                                            cp.setName(name);
                                                        } else if (qName.equals("config-property-value")) {
                                                            String value2 = null;
                                                            if (this.stack.peek() instanceof StringBuffer) {
                                                                value2 = ((StringBuffer)this.stack.pop()).toString();
                                                            }
                                                            BindingCreation bc = (BindingCreation)this.stack.peek();
                                                            List vsList = bc.getVendorSpecificList();
                                                            ConfigProperty cp = (ConfigProperty)vsList.get(vsList.size() - 1);
                                                            cp.setValue(value2);
                                                        } else if (qName.equals("config-property-type")) {
                                                            String type = null;
                                                            if (this.stack.peek() instanceof StringBuffer) {
                                                                type = ((StringBuffer)this.stack.pop()).toString();
                                                            }
                                                            BindingCreation bc = (BindingCreation)this.stack.peek();
                                                            List vsList = bc.getVendorSpecificList();
                                                            ConfigProperty cp = (ConfigProperty)vsList.get(vsList.size() - 1);
                                                            if (type == null) {
                                                                String excep = LocalizedStrings.CacheXmlParser_EXCEPTION_IN_PARSING_ELEMENT_0_THIS_IS_A_REQUIRED_FIELD.toLocalizedString(qName);
                                                                throw new CacheXmlException(excep);
                                                            }
                                                            cp.setType(type);
                                                        } else if (qName.equals("lru-memory-size")) {
                                                            this.endLRUMemorySize();
                                                        } else if (!qName.equals("locator") && !qName.equals("server")) {
                                                            if (qName.equals("partition-resolver")) {
                                                                this.endPartitionResolver();
                                                            } else if (qName.equals("partition-listener")) {
                                                                this.endPartitionListener();
                                                            } else if (qName.equals("function")) {
                                                                this.endFunctionName();
                                                            } else if (qName.equals("function-service")) {
                                                                this.endFunctionService();
                                                            } else if (qName.equals("serialization-registration")) {
                                                                this.endSerializerRegistration();
                                                            } else if (qName.equals("initializer")) {
                                                                this.endInitializer();
                                                            } else if (qName.equals("serializer")) {
                                                                this.endSerializer();
                                                            } else if (qName.equals("instantiator")) {
                                                                this.endInstantiator();
                                                            } else if (qName.equals("resource-manager")) {
                                                                this.endResourceManager();
                                                            } else if (qName.equals("backup")) {
                                                                this.endBackup();
                                                            } else if (!qName.equals("pdx")) {
                                                                if (qName.equals("pdx-serializer")) {
                                                                    this.endPdxSerializer();
                                                                } else if (qName.equals("compressor")) {
                                                                    this.endCompressor();
                                                                } else {
                                                                    XmlParser delegate = this.getDelegate(namespaceURI);
                                                                    if (null == delegate) {
                                                                        throw new CacheXmlException(LocalizedStrings.CacheXmlParser_UNKNOWN_XML_ELEMENT_0.toLocalizedString(qName));
                                                                    }
                                                                    delegate.endElement(namespaceURI, localName, qName);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (CacheException ex) {
            throw new SAXException(LocalizedStrings.CacheXmlParser_A_CACHEEXCEPTION_WAS_THROWN_WHILE_PARSING_XML.toLocalizedString(), ex);
        }
    }

    private void endGatewayTransportFilter() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof GatewayTransportFilter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "GatewayTransportFilter"));
        }
        Object a = this.stack.peek();
        if (a instanceof GatewaySenderFactory) {
            GatewaySenderFactory senderFactory = (GatewaySenderFactory)a;
            senderFactory.addGatewayTransportFilter((GatewayTransportFilter)((Object)d));
        } else if (a instanceof GatewayReceiverFactory) {
            GatewayReceiverFactory receiverFactory = (GatewayReceiverFactory)a;
            receiverFactory.addGatewayTransportFilter((GatewayTransportFilter)((Object)d));
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_GATEWAYSENDER_OR_GATEWAYRECEIVER.toLocalizedString("gateway-transport-filter"));
        }
    }

    private void endGatewayEventFilter() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof GatewayEventFilter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "GatewayEventFilter"));
        }
        Object obj = this.stack.peek();
        if (obj instanceof GatewaySenderFactory) {
            GatewaySenderFactory senderFactory = (GatewaySenderFactory)obj;
            senderFactory.addGatewayEventFilter((GatewayEventFilter)((Object)d));
        } else if (obj instanceof AsyncEventQueueCreation) {
            AsyncEventQueueCreation asyncEventQueueCreation = (AsyncEventQueueCreation)obj;
            asyncEventQueueCreation.addGatewayEventFilter((GatewayEventFilter)((Object)d));
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_GATEWAY_SENDER_OR_ASYNC_EVENT_QUEUE.toLocalizedString("GatewayEventFilter"));
        }
    }

    private void endGatewayEventSubstitutionFilter() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof GatewayEventSubstitutionFilter)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_1.toLocalizedString(d.getClass().getName(), "GatewayEventSubstitutionFilter"));
        }
        Object obj = this.stack.peek();
        if (obj instanceof GatewaySenderFactory) {
            GatewaySenderFactory senderFactory = (GatewaySenderFactory)obj;
            senderFactory.setGatewayEventSubstitutionFilter((GatewayEventSubstitutionFilter)((Object)d));
        } else if (obj instanceof AsyncEventQueueCreation) {
            AsyncEventQueueCreation asyncEventQueueCreation = (AsyncEventQueueCreation)obj;
            asyncEventQueueCreation.setGatewayEventSubstitutionFilter((GatewayEventSubstitutionFilter)((Object)d));
        } else {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_GATEWAY_SENDER_OR_ASYNC_EVENT_QUEUE.toLocalizedString("GatewayEventSubstitutionFilter"));
        }
    }

    private GatewaySenderFactory peekGatewaySender(String dependentElement) {
        Object a = this.stack.peek();
        if (!(a instanceof GatewaySenderFactory)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_MUST_BE_DEFINED_IN_THE_CONTEXT_OF_GATEWAY_SENDER.toLocalizedString(dependentElement));
        }
        return (GatewaySenderFactory)a;
    }

    private void endPdxSerializer() {
        Declarable d = this.createDeclarable();
        if (!(d instanceof PdxSerializer)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_A_0_IS_NOT_AN_INSTANCE_OF_A_PDX_SERIALIZER.toLocalizedString(d.getClass().getName()));
        }
        PdxSerializer serializer = (PdxSerializer)((Object)d);
        this.cache.setPdxSerializer(serializer);
    }

    private void startInitializer() {
    }

    private void endInitializer() {
        Object o;
        Properties props = new Properties();
        Object top = this.stack.pop();
        while (top instanceof Parameter) {
            Parameter param = (Parameter)top;
            props.put(param.getName(), param.getValue());
            top = this.stack.pop();
        }
        Assert.assertTrue(top instanceof String);
        String className = (String)top;
        try {
            Class<?> c = InternalDataSerializer.getCachedClass(className);
            o = c.newInstance();
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_WHILE_INSTANTIATING_A_0.toLocalizedString(className), ex);
        }
        if (!(o instanceof Declarable)) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_CLASS_0_IS_NOT_AN_INSTANCE_OF_DECLARABLE.toLocalizedString(className));
        }
        Declarable d = (Declarable)o;
        this.cache.setInitializer(d, props);
    }

    private void endClientHaQueue() {
    }

    private void endPartitionProperites(String globalOrLocal) {
        PartitionAttributesImpl pai;
        Properties props = new Properties();
        Object top = this.stack.pop();
        while (!top.equals(globalOrLocal)) {
            if (!(top instanceof Parameter)) {
                throw new CacheXmlException(LocalizedStrings.CacheXmlParser_ONLY_A_PARAMETER_IS_ALLOWED_IN_THE_CONTEXT_OF_0.toLocalizedString(globalOrLocal));
            }
            Parameter param = (Parameter)top;
            props.put(param.getName(), param.getValue());
            top = this.stack.pop();
        }
        if (globalOrLocal.equals("global-properties")) {
            pai = this.peekPartitionAttributesImpl("global-properties");
            pai.setGlobalProperties(props);
        } else if (globalOrLocal.equals("local-properties")) {
            pai = this.peekPartitionAttributesImpl("local-properties");
            pai.setLocalProperties(props);
        } else {
            Assert.assertTrue(false, "Argument globalOrLocal has unexpected value " + globalOrLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Object o = null;
        try {
            o = this.stack.peek();
        }
        catch (EmptyStackException firstTime) {
        }
        finally {
            StringBuffer chars = null;
            if (o instanceof StringBuffer) {
                chars = (StringBuffer)o;
                chars.append(ch, start, length);
                logger.trace(LogMarker.CACHE_XML_PARSER, LocalizedMessage.create(LocalizedStrings.CacheXmlParser_XML_PARSER_CHARACTERS_APPENDED_CHARACTER_DATA_0, chars));
            } else {
                chars = new StringBuffer(length);
                chars.append(ch, start, length);
                this.stack.push(chars);
                logger.trace(LogMarker.CACHE_XML_PARSER, LocalizedMessage.create(LocalizedStrings.CacheXmlParser_XML_PARSER_CHARACTERS_NEW_CHARACTER_DATA_0, chars));
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void mapJNDI(Attributes atts, Map gfSpecific) {
        int attsLen = atts.getLength();
        String key2 = "";
        String value2 = "";
        for (int i = 0; i < attsLen; ++i) {
            key2 = atts.getQName(i);
            value2 = atts.getValue(key2);
            gfSpecific.put(key2, value2);
        }
    }

    static class Parameter {
        private String name;
        private Object value;

        public Parameter(String name, Object value2) {
            this.name = name;
            this.value = value2;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    static class DefaultHandlerDelegate
    extends DefaultHandler2 {
        private CacheXmlParser handler;

        public DefaultHandlerDelegate(CacheXmlParser handler) {
            this.handler = handler;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.handler.resolveEntity(publicId, systemId);
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            return this.handler.resolveEntity(name, publicId, baseURI, systemId);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.handler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.handler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.handler.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.handler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.handler.endPrefixMapping(prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.handler.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.handler.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.handler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.handler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.handler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.handler.skippedEntity(name);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.handler.warning(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.handler.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.handler.fatalError(e);
        }
    }
}

