/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.serial.BatchDestroyOperation;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialSecondaryGatewayListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class SerialGatewaySenderQueue
implements RegionQueue {
    private static final Logger logger = LogService.getLogger();
    private long headKey = -1L;
    private final AtomicLong tailKey = new AtomicLong();
    private long currentKey;
    private final Deque<Long> peekedIds = new LinkedBlockingDeque<Long>();
    private final String regionName;
    private Region<Long, AsyncEvent> region;
    private String diskStoreName;
    private int batchSize;
    private int maximumQueueMemory;
    private boolean enableConflation;
    private boolean enablePersistence;
    private boolean isDiskSynchronous;
    private final Map<String, Map<Object, Long>> indexes;
    private final GatewaySenderStats stats;
    private static final long MAXIMUM_KEY = Long.MAX_VALUE;
    private static final boolean NO_ACK = Boolean.getBoolean("gemfire.gateway-queue-no-ack");
    private volatile long lastDispatchedKey = -1L;
    private volatile long lastDestroyedKey = -1L;
    public static final int DEFAULT_MESSAGE_SYNC_INTERVAL = 1;
    private static volatile int messageSyncInterval = 1;
    private BatchRemovalThread removalThread = null;
    private final boolean keyPutNoSync;
    private final int maxPendingPuts;
    private final PriorityQueue<Long> pendingPuts;
    private SerialGatewaySenderImpl sender = null;

    public SerialGatewaySenderQueue(AbstractGatewaySender abstractSender, String regionName, CacheListener listener) {
        this.regionName = regionName;
        this.headKey = -1L;
        this.tailKey.set(-1L);
        this.currentKey = -1L;
        this.indexes = new HashMap<String, Map<Object, Long>>();
        this.enableConflation = abstractSender.isBatchConflationEnabled();
        this.diskStoreName = abstractSender.getDiskStoreName();
        this.batchSize = abstractSender.getBatchSize();
        this.enablePersistence = abstractSender.isPersistenceEnabled();
        this.isDiskSynchronous = this.enablePersistence ? abstractSender.isDiskSynchronous() : false;
        if (Boolean.getBoolean("gemfire.gateway-queue-sync")) {
            this.keyPutNoSync = false;
            this.maxPendingPuts = 0;
            this.pendingPuts = null;
        } else {
            this.keyPutNoSync = true;
            this.maxPendingPuts = Math.max(this.batchSize, 100);
            this.pendingPuts = new PriorityQueue(this.maxPendingPuts + 5);
        }
        this.maximumQueueMemory = abstractSender.getMaximumMemeoryPerDispatcherQueue();
        this.stats = abstractSender.getStatistics();
        this.initializeRegion(abstractSender, listener);
        this.removalThread = new BatchRemovalThread((GemFireCacheImpl)abstractSender.getCache());
        this.removalThread.start();
        this.sender = (SerialGatewaySenderImpl)abstractSender;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Contains {} elements", this, this.size());
        }
    }

    @Override
    public Region<Long, AsyncEvent> getRegion() {
        return this.region;
    }

    public void destroy() {
        this.getRegion().localDestroyRegion();
    }

    @Override
    public synchronized void put(Object event) throws CacheException {
        GatewaySenderEventImpl eventImpl = (GatewaySenderEventImpl)event;
        Region<?, ?> r = eventImpl.getRegion();
        boolean isPDXRegion = r instanceof DistributedRegion && r.getName().equals("PdxTypes");
        boolean isWbcl = this.regionName.startsWith("AsyncEventQueue_");
        if (!isPDXRegion || !isWbcl) {
            this.putAndGetKey(event);
        }
    }

    private long putAndGetKey(Object object) throws CacheException {
        Long key2 = this.getTailKey();
        this.region.put(key2, (AsyncEvent)object);
        this.incrementTailKey();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Inserted {} -> {}", this, key2, object);
        }
        if (object instanceof Conflatable) {
            this.removeOldEntry((Conflatable)object, key2);
        }
        return key2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long putAndGetKeyNoSync(Object object) throws CacheException {
        var3_2 = this;
        synchronized (var3_2) {
            this.initializeKeys();
            ckey = this.currentKey;
            if (SerialGatewaySenderQueue.logger.isTraceEnabled()) {
                SerialGatewaySenderQueue.logger.trace("{}: Determined current key: {}", new Object[]{this, ckey});
            }
            key = ckey;
            this.currentKey = this.inc(ckey);
        }
        try {
            this.region.put(key, (AsyncEvent)object);
            if (SerialGatewaySenderQueue.logger.isDebugEnabled()) {
                SerialGatewaySenderQueue.logger.debug("{}: Inserted {} -> {}", new Object[]{this, key, object});
            }
            var4_4 = sync = this.pendingPuts;
        }
        catch (Throwable var10_13) {
            var12_15 = sync = this.pendingPuts;
            synchronized (var12_15) {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (key.longValue() == this.tailKey.get()) {
                        this.incrementTailKey();
                        notifyWaiters = false;
                        if (this.pendingPuts.size() > 0) {
                            itr = this.pendingPuts.iterator();
                            while (itr.hasNext() && (k = itr.next()).longValue() == this.tailKey.get()) {
                                this.incrementTailKey();
                                if (!notifyWaiters) {
                                    notifyWaiters = this.pendingPuts.size() >= this.maxPendingPuts;
                                }
                                itr.remove();
                            }
                        }
                        if (!notifyWaiters) ** break;
                        sync.notifyAll();
                        ** break;
                    }
                    if (this.pendingPuts.size() < this.maxPendingPuts) {
                        this.pendingPuts.add(key);
                        ** break;
                    }
                    interrupted = Thread.interrupted();
                    t = null;
                    try {
                        sync.wait(5L);
                    }
                    catch (InterruptedException ie) {
                        t = ie;
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        ((LocalRegion)this.region).getCancelCriterion().checkCancelInProgress(t);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
lbl96:
                // 3 sources

            }
            throw var10_13;
        }
        synchronized (var4_4) {
            while (true) lbl-1000:
            // 4 sources

            {
                if (key.longValue() == this.tailKey.get()) {
                    this.incrementTailKey();
                    notifyWaiters = false;
                    if (this.pendingPuts.size() > 0) {
                        itr = this.pendingPuts.iterator();
                        while (itr.hasNext() && (k = itr.next()).longValue() == this.tailKey.get()) {
                            this.incrementTailKey();
                            if (!notifyWaiters) {
                                notifyWaiters = this.pendingPuts.size() >= this.maxPendingPuts;
                            }
                            itr.remove();
                        }
                    }
                    if (!notifyWaiters) ** break;
                    sync.notifyAll();
                    ** break;
                }
                if (this.pendingPuts.size() < this.maxPendingPuts) {
                    this.pendingPuts.add(key);
                    ** break;
                }
                interrupted = Thread.interrupted();
                t = null;
                try {
                    sync.wait(5L);
                }
                catch (InterruptedException ie) {
                    t = ie;
                    interrupted = true;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    ((LocalRegion)this.region).getCancelCriterion().checkCancelInProgress(t);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl55:
            // 3 sources

        }
        if (object instanceof Conflatable) {
            this.removeOldEntry((Conflatable)object, key);
        }
        return key;
    }

    @Override
    public synchronized AsyncEvent take() throws CacheException {
        this.resetLastPeeked();
        AsyncEvent object = this.peekAhead();
        if (object != null) {
            Long key2 = this.peekedIds.remove();
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Retrieved {} -> {}", this, key2, object);
            }
            this.region.destroy(key2, "WAN_QUEUE_TOKEN");
            this.updateHeadKey(key2);
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Destroyed {} -> {}", this, key2, object);
            }
        }
        return object;
    }

    @Override
    public List<AsyncEvent> take(int batchSize) throws CacheException {
        AsyncEvent obj;
        ArrayList<AsyncEvent> batch = new ArrayList<AsyncEvent>(batchSize * 2);
        for (int i = 0; i < batchSize && (obj = this.take()) != null; ++i) {
            batch.add(obj);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Took a batch of {} entries", this, batch.size());
        }
        return batch;
    }

    @Override
    public synchronized void remove() throws CacheException {
        Long key2;
        block5: {
            if (this.peekedIds.isEmpty()) {
                return;
            }
            key2 = this.peekedIds.remove();
            try {
                this.updateHeadKey(key2);
                this.removeIndex(key2);
                this.region.localDestroy(key2, "WAN_QUEUE_TOKEN");
                this.stats.decQueueSize();
            }
            catch (EntryNotFoundException ok) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("{}: Did not destroy entry at {} it was not there. It should have been removed by conflation.", this, key2);
            }
        }
        boolean wasEmpty = this.lastDispatchedKey == this.lastDestroyedKey;
        this.lastDispatchedKey = key2;
        if (wasEmpty) {
            this.notify();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Destroyed entry at key {} setting the lastDispatched Key to {}. The last destroyed entry was {}", this, key2, this.lastDispatchedKey, this.lastDestroyedKey);
        }
    }

    @Override
    public void remove(int size2) throws CacheException {
        for (int i = 0; i < size2; ++i) {
            this.remove();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Removed a batch of {} entries", this, size2);
        }
    }

    public void remove(Object object) {
        this.remove();
    }

    @Override
    public Object peek() throws CacheException {
        AsyncEvent object = this.peekAhead();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Peeked {} -> {}", this, this.peekedIds, object);
        }
        return object;
    }

    @Override
    public List<AsyncEvent> peek(int size2) throws CacheException {
        return this.peek(size2, -1);
    }

    @Override
    public List<AsyncEvent> peek(int size2, int timeToWait) throws CacheException {
        boolean isTraceEnabled = logger.isTraceEnabled();
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        if (isTraceEnabled) {
            logger.trace("{}: Peek start time={} end time={} time to wait={}", this, start, end, timeToWait);
        }
        ArrayList<AsyncEvent> batch = new ArrayList<AsyncEvent>(size2 * 2);
        while (batch.size() < size2) {
            AsyncEvent object = this.peekAhead();
            if (object != null) {
                batch.add(object);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (isTraceEnabled) {
                logger.trace("{}: Peek current time: {}", this, currentTime);
            }
            if (timeToWait == -1 || end <= currentTime) {
                if (!isTraceEnabled) break;
                logger.trace("{}: Peek breaking", this);
                break;
            }
            if (isTraceEnabled) {
                logger.trace("{}: Peek continuing", this);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (isTraceEnabled) {
            logger.trace("{}: Peeked a batch of {} entries", this, batch.size());
        }
        return batch;
    }

    public String toString() {
        return "SerialGatewaySender queue :" + this.regionName;
    }

    @Override
    public int size() {
        int size2 = ((LocalRegion)this.region).entryCount();
        return size2 + this.sender.getTmpQueuedEventSize();
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        AttributesMutator<Long, AsyncEvent> mutator = this.region.getAttributesMutator();
        mutator.addCacheListener(listener);
    }

    @Override
    public void removeCacheListener() {
        AttributesMutator<Long, AsyncEvent> mutator = this.region.getAttributesMutator();
        CacheListener<Long, AsyncEvent>[] listeners = this.region.getAttributes().getCacheListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof SerialSecondaryGatewayListener)) continue;
            mutator.removeCacheListener(listeners[i]);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeOldEntry(Conflatable object, Long tailKey) throws CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean keepOldEntry = true;
        if (this.enableConflation && object.shouldBeConflated()) {
            Long previousIndex;
            if (isDebugEnabled) {
                logger.debug("{}: Conflating {} at queue index={} queue size={} head={} tail={}", this, object, tailKey, this.size(), this.headKey, tailKey);
            }
            String rName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            SerialGatewaySenderQueue serialGatewaySenderQueue = this;
            synchronized (serialGatewaySenderQueue) {
                Map<Object, Long> latestIndexesForRegion = this.indexes.get(rName);
                if (latestIndexesForRegion == null) {
                    latestIndexesForRegion = new HashMap<Object, Long>();
                    this.indexes.put(rName, latestIndexesForRegion);
                }
                previousIndex = latestIndexesForRegion.put(key2, tailKey);
            }
            if (isDebugEnabled) {
                logger.debug("{}: Adding index key={}->index={} for {} head={} tail={}", this, key2, tailKey, object, this.headKey, tailKey);
            }
            if (previousIndex != null) {
                if (isDebugEnabled) {
                    logger.debug("{}: Indexes contains index={} for key={} head={} tail={} and it can be used.", this, previousIndex, key2, this.headKey, tailKey);
                }
                keepOldEntry = false;
            } else {
                if (isDebugEnabled) {
                    logger.debug("{}: No old entry for key={} head={} tail={} not removing old entry.", this, key2, this.headKey, tailKey);
                }
                this.stats.incConflationIndexesMapSize();
                keepOldEntry = true;
            }
            if (!keepOldEntry) {
                Conflatable previous = (Conflatable)((Object)this.region.remove(previousIndex));
                this.stats.decQueueSize(1);
                if (isDebugEnabled) {
                    logger.debug("{}: Previous conflatable at key={} head={} tail={}: {}", this, previousIndex, this.headKey, tailKey, previous);
                    logger.debug("{}: Current conflatable at key={} head={} tail={}: {}", this, tailKey, this.headKey, tailKey, object);
                    if (previous != null) {
                        logger.debug("{}: Removed {} and added {} for key={} head={} tail={} in queue for region={} old event={}", this, this.deserialize(previous.getValueToConflate()), this.deserialize(object.getValueToConflate()), key2, this.headKey, tailKey, rName, previous);
                    }
                }
            }
        } else if (isDebugEnabled) {
            logger.debug("{}: Not conflating {} queue size: {} head={} tail={}", this, object, this.size(), this.headKey, tailKey);
        }
        return keepOldEntry;
    }

    private AsyncEvent optimalGet(Long k) {
        LocalRegion lr = (LocalRegion)this.region;
        Object o = null;
        try {
            o = lr.getValueInVMOrDiskWithoutFaultIn(k);
            if (o != null && o instanceof CachedDeserializable) {
                o = ((CachedDeserializable)o).getDeserializedValue(lr, lr.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException ok) {
            // empty catch block
        }
        if (o == Token.TOMBSTONE) {
            o = null;
        }
        return (AsyncEvent)o;
    }

    private void removeIndex(Long qkey) {
        Conflatable object;
        AsyncEvent o;
        if (this.enableConflation && (o = this.optimalGet(qkey)) instanceof Conflatable && (object = (Conflatable)((Object)o)).shouldBeConflated()) {
            String rName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            Map<Object, Long> latestIndexesForRegion = this.indexes.get(rName);
            if (latestIndexesForRegion != null) {
                Long index2 = latestIndexesForRegion.remove(key2);
                if (index2 != null) {
                    this.stats.decConflationIndexesMapSize();
                }
                if (logger.isDebugEnabled() && index2 != null) {
                    logger.debug("{}: Removed index {} for {}", this, index2, object);
                }
            }
        }
    }

    private Object deserialize(Object serializedBytes) {
        Object deserializedObject = serializedBytes;
        if (serializedBytes instanceof byte[]) {
            byte[] serializedBytesCast = (byte[])serializedBytes;
            try {
                deserializedObject = EntryEventImpl.deserialize(serializedBytesCast);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return deserializedObject;
    }

    private boolean before(long a, long b) {
        return a < b ^ a - b > 0x3FFFFFFFFFFFFFFFL;
    }

    private long inc(long value2) {
        long val = value2 + 1L;
        val = val == Long.MAX_VALUE ? 0L : val;
        return val;
    }

    public void resetLastPeeked() {
        this.peekedIds.clear();
    }

    private AsyncEvent peekAhead() throws CacheException {
        AsyncEvent object = null;
        long currentKey = -1L;
        if (this.peekedIds.isEmpty()) {
            currentKey = this.getHeadKey();
        } else {
            Long lastPeek = this.peekedIds.peekLast();
            if (lastPeek == null) {
                return null;
            }
            currentKey = lastPeek + 1L;
        }
        while (this.before(currentKey, this.getTailKey()) && (object = this.optimalGet(currentKey)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Trying head key + offset: {}", this, currentKey);
            }
            currentKey = this.inc(currentKey);
            if (this.stats == null) continue;
            this.stats.incEventsNotQueuedConflated();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peeked {}->{}", this, currentKey, object);
        }
        if (object != null) {
            this.peekedIds.add(currentKey);
        }
        return object;
    }

    private long getTailKey() throws CacheException {
        this.initializeKeys();
        long tlKey = this.tailKey.get();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Determined tail key: {}", this, tlKey);
        }
        return tlKey;
    }

    private void incrementTailKey() throws CacheException {
        this.tailKey.set(this.inc(this.tailKey.get()));
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Incremented TAIL_KEY for region {} to {}", this, this.region.getName(), this.tailKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeys() throws CacheException {
        if (this.tailKey.get() != -1L) {
            return;
        }
        SerialGatewaySenderQueue serialGatewaySenderQueue = this;
        synchronized (serialGatewaySenderQueue) {
            long largestKey = -1L;
            long largestKeyLessThanHalfMax = -1L;
            long smallestKey = -1L;
            long smallestKeyGreaterThanHalfMax = -1L;
            Set<Long> keySet = this.region.keySet();
            for (Long key2 : keySet) {
                long k = key2;
                if (k > largestKey) {
                    largestKey = k;
                }
                if (k > largestKeyLessThanHalfMax && k < 0x3FFFFFFFFFFFFFFFL) {
                    largestKeyLessThanHalfMax = k;
                }
                if (k < smallestKey || smallestKey == -1L) {
                    smallestKey = k;
                }
                if (k >= smallestKeyGreaterThanHalfMax && smallestKeyGreaterThanHalfMax != -1L || k <= 0x3FFFFFFFFFFFFFFFL) continue;
                smallestKeyGreaterThanHalfMax = k;
            }
            if (smallestKeyGreaterThanHalfMax != -1L && largestKeyLessThanHalfMax != -1L && smallestKeyGreaterThanHalfMax - largestKeyLessThanHalfMax > 0x3FFFFFFFFFFFFFFFL) {
                this.headKey = smallestKeyGreaterThanHalfMax;
                this.tailKey.set(this.inc(largestKeyLessThanHalfMax));
                logger.info(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_0_DURING_FAILOVER_DETECTED_THAT_KEYS_HAVE_WRAPPED, new Object[]{this, this.tailKey, this.headKey}));
            } else {
                this.headKey = smallestKey == -1L ? 0L : smallestKey;
                this.tailKey.set(this.inc(largestKey));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Initialized tail key to: {}, head key to: {}", this, this.tailKey, this.headKey);
            }
        }
    }

    private long getHeadKey() throws CacheException {
        this.initializeKeys();
        long hKey = this.headKey;
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Determined head key: {}", this, hKey);
        }
        return hKey;
    }

    private void updateHeadKey(long destroyedKey) throws CacheException {
        this.headKey = this.inc(destroyedKey);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Incremented HEAD_KEY for region {} to {}", this, this.region.getName(), this.headKey);
        }
    }

    private void initializeRegion(AbstractGatewaySender sender, CacheListener listener) {
        GemFireCacheImpl gemCache = (GemFireCacheImpl)sender.getCache();
        this.region = gemCache.getRegion(this.regionName);
        if (this.region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(NO_ACK ? Scope.DISTRIBUTED_NO_ACK : Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(this.enablePersistence ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE);
            if (logger.isDebugEnabled()) {
                logger.debug("The policy of region is {}", this.enablePersistence ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE);
            }
            if (listener != null) {
                factory.addCacheListener(listener);
            }
            EvictionAttributes ea = EvictionAttributes.createLIFOMemoryAttributes(this.maximumQueueMemory, EvictionAction.OVERFLOW_TO_DISK);
            factory.setEvictionAttributes(ea);
            factory.setConcurrencyChecksEnabled(false);
            factory.setDiskStoreName(this.diskStoreName);
            factory.setDiskSynchronous(this.isDiskSynchronous);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Attempting to create queue region: {}", this, this.regionName);
            }
            RegionAttributes ra = factory.create();
            try {
                SerialGatewaySenderQueueMetaRegion meta = new SerialGatewaySenderQueueMetaRegion(this.regionName, ra, null, gemCache, (SerialGatewaySenderImpl)sender);
                try {
                    this.region = gemCache.createVMRegion(this.regionName, ra, new InternalRegionArguments().setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForSerialGatewaySenderQueue(true).setSerialGatewaySender((SerialGatewaySenderImpl)sender));
                }
                catch (IOException veryUnLikely) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)veryUnLikely);
                }
                catch (ClassNotFoundException alsoUnlikely) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)alsoUnlikely);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Created queue region: {}", this, this.region);
                }
            }
            catch (CacheException e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_0_THE_QUEUE_REGION_NAMED_1_COULD_NOT_BE_CREATED, new Object[]{this, this.regionName}), (Throwable)e);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Retrieved queue region: {}. Since the region already exists, the sender must have been restarted after being stopped. Clearing the region.", this.region);
            this.region.clear();
        }
    }

    public void cleanUp() {
        if (this.removalThread != null) {
            this.removalThread.shutdown();
        }
    }

    private static class SerialGatewaySenderQueueMetaRegion
    extends DistributedRegion {
        SerialGatewaySenderImpl sender = null;

        protected SerialGatewaySenderQueueMetaRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, SerialGatewaySenderImpl sender) {
            super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForSerialGatewaySenderQueue(true).setSerialGatewaySender(sender));
            this.sender = sender;
        }

        @Override
        public final boolean supportsConcurrencyChecks() {
            return false;
        }

        @Override
        protected boolean isCopyOnRead() {
            return false;
        }

        @Override
        public final boolean isSecret() {
            return true;
        }

        @Override
        public void createEventTracker() {
        }

        @Override
        protected final boolean shouldNotifyBridgeClients() {
            return false;
        }

        @Override
        public final boolean generateEventID() {
            return false;
        }

        @Override
        public final boolean isUsedForSerialGatewaySenderQueue() {
            return true;
        }

        @Override
        public final SerialGatewaySenderImpl getSerialGatewaySender() {
            return this.sender;
        }
    }

    private class BatchRemovalThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final GemFireCacheImpl cache;

        public BatchRemovalThread(GemFireCacheImpl c) {
            this.setDaemon(true);
            this.cache = c;
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().cancelInProgress() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                InternalDistributedSystem ids = this.cache.getDistributedSystem();
                try {
                    while (true) {
                        try {
                            while (true) {
                                long temp;
                                if (this.checkCancelled()) {
                                    break block32;
                                }
                                boolean interrupted = Thread.interrupted();
                                try {
                                    BatchRemovalThread batchRemovalThread = this;
                                    synchronized (batchRemovalThread) {
                                        this.wait(messageSyncInterval * 1000);
                                    }
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                    if (this.checkCancelled()) {
                                        // empty if block
                                    }
                                    break block32;
                                }
                                finally {
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("BatchRemovalThread about to send the last Dispatched key {}", SerialGatewaySenderQueue.this.lastDispatchedKey);
                                }
                                SerialGatewaySenderQueue serialGatewaySenderQueue = SerialGatewaySenderQueue.this;
                                synchronized (serialGatewaySenderQueue) {
                                    boolean wasEmpty;
                                    temp = SerialGatewaySenderQueue.this.lastDispatchedKey;
                                    boolean bl = wasEmpty = temp == SerialGatewaySenderQueue.this.lastDestroyedKey;
                                    while (SerialGatewaySenderQueue.this.lastDispatchedKey == SerialGatewaySenderQueue.this.lastDestroyedKey) {
                                        SerialGatewaySenderQueue.this.wait();
                                        temp = SerialGatewaySenderQueue.this.lastDispatchedKey;
                                    }
                                    if (wasEmpty) {
                                        continue;
                                    }
                                }
                                EntryEventImpl event = new EntryEventImpl((LocalRegion)SerialGatewaySenderQueue.this.region, Operation.DESTROY, (Object)(SerialGatewaySenderQueue.this.lastDestroyedKey + 1L), null, null, false, this.cache.getMyId());
                                event.setTailKey(temp);
                                BatchDestroyOperation op = new BatchDestroyOperation(event);
                                op.distribute();
                                if (logger.isDebugEnabled()) {
                                    logger.debug("BatchRemovalThread completed destroy of keys from {} to {}", SerialGatewaySenderQueue.this.lastDestroyedKey, temp);
                                }
                                SerialGatewaySenderQueue.this.lastDestroyedKey = temp;
                            }
                        }
                        catch (CancelException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("BatchRemovalThread is exiting due to cancellation");
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            if (this.checkCancelled()) {
                                break;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("BatchRemovalThread: ignoring exception", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("BatchRemovalThread exiting due to cancellation: " + e);
                    }
                }
                finally {
                    logger.info(LocalizedMessage.create(LocalizedStrings.HARegionQueue_THE_QUEUEREMOVALTHREAD_IS_DONE));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.HARegionQueue_QUEUEREMOVALTHREAD_IGNORED_CANCELLATION));
            }
        }
    }
}

