/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Logger;

public class ConcurrentSerialGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    private final List<SerialGatewaySenderEventProcessor> processors = new ArrayList<SerialGatewaySenderEventProcessor>();
    private final SerialGatewaySenderImpl sender;
    private GemFireException ex = null;
    private final Set<RegionQueue> queues;

    public ConcurrentSerialGatewaySenderEventProcessor(SerialGatewaySenderImpl sender) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId(), logger), "Event Processor for GatewaySender_" + sender.getId(), sender);
        this.sender = sender;
        this.initializeMessageQueue(sender.getId());
        this.queues = new HashSet<RegionQueue>();
        for (SerialGatewaySenderEventProcessor processor : this.processors) {
            this.queues.add(processor.getQueue());
        }
        this.setDaemon(true);
    }

    @Override
    protected void initializeMessageQueue(String id) {
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors.add(new SerialGatewaySenderEventProcessor(this.sender, id + "." + i));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Created the SerialGatewayEventProcessor_{}->{}", i, this.processors.get(i));
        }
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        int index2 = Math.abs(this.getHashCode((EntryEventImpl)event) % this.processors.size());
        this.enqueueEvent(operation, event, substituteValue, index2);
    }

    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue, int index2) throws CacheException, IOException {
        SerialGatewaySenderEventProcessor serialProcessor = this.processors.get(index2);
        if (this.sender.getOrderPolicy() == Gateway.OrderPolicy.KEY || this.sender.getOrderPolicy() == Gateway.OrderPolicy.PARTITION) {
            EntryEventImpl clonedEvent = new EntryEventImpl((EntryEventImpl)event);
            EventID originalEventId = clonedEvent.getEventId();
            if (logger.isDebugEnabled()) {
                logger.debug("The original EventId is {}", originalEventId);
            }
            long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGateway(index2, originalEventId.getThreadID(), 0);
            EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Generated event id for event with key={}, index={}, original event id={}, threadId={}, new event id={}, newThreadId={}", this, event.getKey(), index2, originalEventId, originalEventId.getThreadID(), newEventId, newThreadId);
            }
            clonedEvent.setEventId(newEventId);
            serialProcessor.enqueueEvent(operation, clonedEvent, substituteValue);
        } else {
            serialProcessor.enqueueEvent(operation, event, substituteValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = 0; i < this.processors.size(); ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting the serialProcessor {}", i);
            }
            this.processors.get(i).start();
        }
        try {
            this.waitForRunningStatus();
        }
        catch (GatewaySenderException e) {
            this.ex = e;
        }
        Object e = this.runningStateLock;
        synchronized (e) {
            if (this.ex != null) {
                this.setException(this.ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.runningStateLock.notifyAll();
        }
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            try {
                serialProcessor.join();
            }
            catch (InterruptedException e2) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Got InterruptedException while waiting for child threads to finish.");
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void rebalance() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunningStatus() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            Object object = serialProcessor.runningStateLock;
            synchronized (object) {
                while (serialProcessor.getException() == null && serialProcessor.isStopped()) {
                    try {
                        serialProcessor.runningStateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Exception ex = serialProcessor.getException();
                if (ex != null) {
                    throw new GatewaySenderException(LocalizedStrings.Sender_COULD_NOT_START_GATEWAYSENDER_0_BECAUSE_OF_EXCEPTION_1.toLocalizedString(this.getId(), ex.getMessage()), ex.getCause());
                }
            }
        }
    }

    private int getHashCode(EntryEventImpl event) {
        int eventHashCode = 0;
        switch (this.sender.getOrderPolicy()) {
            case KEY: {
                eventHashCode = event.getKey().hashCode();
                break;
            }
            case THREAD: {
                EventID eventId = event.getEventId();
                byte[] memberId = eventId.getMembershipID();
                long threadId = eventId.getThreadID();
                int memberIdHashCode = Arrays.hashCode(memberId);
                int threadIdHashCode = (int)(threadId ^ threadId >>> 32);
                eventHashCode = memberIdHashCode + threadIdHashCode;
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated hashcode for event with key={}, memberId={}, threadId={}: {}", this, event.getKey(), Arrays.toString(memberId), threadId, eventHashCode);
                break;
            }
            case PARTITION: {
                int n = eventHashCode = PartitionRegionHelper.isPartitionedRegion(event.getRegion()) ? PartitionedRegionHelper.getHashKey(event) : event.getKey().hashCode();
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated partition hashcode for event with key={}: {}", this, event.getKey(), eventHashCode);
            }
        }
        return eventHashCode;
    }

    @Override
    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup("ConcurrentSerialGatewaySenderEventProcessor Logger Group", logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(loggingThreadGroup, task, "ConcurrentSerialGatewaySenderEventProcessor Stopper Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable> stopperCallables = new ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable>();
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            stopperCallables.add(new AbstractGatewaySenderEventProcessor.SenderStopperCallable(serialProcessor));
        }
        ExecutorService stopperService = Executors.newFixedThreadPool(this.processors.size(), threadFactory);
        try {
            List futures = stopperService.invokeAll(stopperCallables);
            for (Future f : futures) {
                try {
                    boolean b = (Boolean)f.get();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ConcurrentSerialGatewaySenderEventProcessor: {} stopped dispatching: {}", b ? "Successfully" : "Unsuccesfully", this);
                }
                catch (ExecutionException e) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewaySender_0_CAUGHT_EXCEPTION_WHILE_STOPPING_1, new Object[]{this.sender, e.getCause()}));
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalGemFireException(e.getMessage());
        }
        catch (RejectedExecutionException rejectedExecutionEx) {
            throw rejectedExecutionEx;
        }
        stopperService.shutdown();
        this.setIsStopped(true);
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Stopped dispatching: {}", this);
        }
    }

    @Override
    public void pauseDispatching() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.pauseDispatching();
        }
        super.pauseDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Paused dispatching: {}", this);
        }
    }

    @Override
    public void resumeDispatching() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.resumeDispatching();
        }
        super.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Resumed dispatching: {}", this);
        }
    }

    public Set<RegionQueue> getQueues() {
        return this.queues;
    }

    @Override
    public void removeCacheListener() {
        for (SerialGatewaySenderEventProcessor processor : this.processors) {
            processor.removeCacheListener();
        }
    }

    @Override
    public void waitForDispatcherToPause() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.waitForDispatcherToPause();
        }
    }

    @Override
    public GatewaySenderEventDispatcher getDispatcher() {
        return this.processors.get(0).getDispatcher();
    }
}

