/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketRegionQueue;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ParallelQueueBatchRemovalMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Map<Integer, List> bucketToTailKey;

    public ParallelQueueBatchRemovalMessage() {
    }

    public ParallelQueueBatchRemovalMessage(Set<InternalDistributedMember> recipient, int regionId, ReplyProcessor21 processor, Map bucketToTailKey) {
        super(recipient, regionId, processor);
        this.bucketToTailKey = bucketToTailKey;
    }

    @Override
    public int getDSFID() {
        return 2140;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException {
        for (Integer bucketId : this.bucketToTailKey.keySet()) {
            if (!pr2.getRegionAdvisor().getBucketAdvisor(bucketId).isHosting()) continue;
            List dispatchedKeys = this.bucketToTailKey.get(bucketId);
            try {
                BucketRegionQueue bucketRegionQueue = (BucketRegionQueue)pr2.getDataStore().getInitializedBucketForId(null, bucketId);
                for (Object key2 : dispatchedKeys) {
                    try {
                        for (GatewayEventFilter filter : pr2.getParallelGatewaySender().getGatewayEventFilters()) {
                            GatewayQueueEvent eventForFilter = (GatewayQueueEvent)bucketRegionQueue.get(key2);
                            try {
                                if (eventForFilter == null) continue;
                                filter.afterAcknowledgement(eventForFilter);
                            }
                            catch (Exception e) {
                                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventFilter_EXCEPTION_OCCURED_WHILE_HANDLING_CALL_TO_0_AFTER_ACKNOWLEDGEMENT_FOR_EVENT_1, new Object[]{filter.toString(), eventForFilter}), (Throwable)e);
                            }
                        }
                        bucketRegionQueue.destroyKey(key2);
                    }
                    catch (EntryNotFoundException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("WARNING! Got EntryNotFoundException while destroying the key {} for bucket {}", key2, bucketId);
                    }
                }
            }
            catch (ForceReattemptException fe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Got ForceReattemptException while getting bucket {} to destroyLocally the keys.", bucketId);
            }
        }
        BatchRemovalReplyMessage.sendWithException(this.getSender(), this.getProcessorId(), dm, null);
        return false;
    }

    public static ParallelQueueBatchRemovalResponse send(Set<InternalDistributedMember> recipients, PartitionedRegion pr2, Map<Integer, List> bucketToTailKey) {
        Assert.assertTrue(recipients != null, "BatchRemovalResponse NULL recipient");
        ParallelQueueBatchRemovalResponse response = new ParallelQueueBatchRemovalResponse(pr2.getSystem(), recipients, pr2);
        ParallelQueueBatchRemovalMessage msg = new ParallelQueueBatchRemovalMessage(recipients, pr2.getPRId(), response, bucketToTailKey);
        Set failures = pr2.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        pr2.getPrStats().incPartitionMessagesSent();
        return response;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.bucketToTailKey, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketToTailKey = (Map)DataSerializer.readObject(in);
    }

    public static class ParallelQueueBatchRemovalResponse
    extends PartitionMessage.PartitionResponse {
        public ParallelQueueBatchRemovalResponse(InternalDistributedSystem dm, Set<InternalDistributedMember> recipients) {
            super(dm, recipients);
        }

        public ParallelQueueBatchRemovalResponse(InternalDistributedSystem ds, Set<InternalDistributedMember> recipients, PartitionedRegion theRegion) {
            super(ds, recipients);
        }

        @Override
        public void process(DistributionMessage msg) {
            super.process(msg);
        }

        public void waitForResponse() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (EntryNotFoundException enfe) {
                throw enfe;
            }
            catch (ForceReattemptException e) {
                String msg = "GetResponse got ForceReattemptException; rethrowing";
                logger.debug("GetResponse got ForceReattemptException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (TransactionDataNotColocatedException e) {
                throw e;
            }
        }
    }

    public static final class BatchRemovalReplyMessage
    extends ReplyMessage {
        public BatchRemovalReplyMessage() {
        }

        public BatchRemovalReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private BatchRemovalReplyMessage(int processorId, ReplyException re) {
            this.setProcessorId(processorId);
            this.setException(re);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("BatchRemovalReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("BatchRemovalReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        private static void sendWithException(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "BecomePrimaryBucketReplyMessage NULL recipient");
            BatchRemovalReplyMessage m = new BatchRemovalReplyMessage(processorId, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public int getDSFID() {
            return 2141;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("BatchRemovalReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

