/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractBucketRegionQueue;
import com.gemstone.gemfire.internal.cache.BucketNotFoundException;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.BucketRegionQueue;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AsyncEventQueueConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.BucketRegionQueueUnavailableException;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelQueueBatchRemovalMessage;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelQueueRemovalMessage;
import com.gemstone.gemfire.internal.cache.wan.parallel.RREventIDResolver;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCondition;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantLock;
import com.gemstone.gnu.trove.THashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderQueue
implements RegionQueue {
    private static final Logger logger = LogService.getLogger();
    protected final Map<String, PartitionedRegion> userRegionNameToshadowPRMap = new ConcurrentHashMap<String, PartitionedRegion>();
    private static final Map regionToDispatchedKeysMap = new ConcurrentHashMap();
    protected static StoppableReentrantLock buckToDispatchLock;
    private static StoppableCondition regionToDispatchedKeysMapEmpty;
    protected final StoppableReentrantLock queueEmptyLock;
    private volatile boolean isQueueEmpty = true;
    private StoppableCondition queueEmptyCondition;
    protected final GatewaySenderStats stats;
    protected volatile boolean resetLastPeeked = false;
    private final ConcurrentMap<Integer, BlockingQueue<GatewaySenderEventImpl>> bucketToTempQueueMap = new ConcurrentHashMap<Integer, BlockingQueue<GatewaySenderEventImpl>>();
    public static final int DEFAULT_MESSAGE_SYNC_INTERVAL = 10;
    protected static volatile int messageSyncInterval;
    private static BatchRemovalThread removalThread;
    protected BlockingQueue<GatewaySenderEventImpl> peekedEvents = new LinkedBlockingQueue<GatewaySenderEventImpl>();
    public final ParallelGatewaySenderImpl sender;
    public static final int WAIT_CYCLE_SHADOW_BUCKET_LOAD = 10;
    public static final String QSTRING = "_PARALLEL_GATEWAY_SENDER_QUEUE";
    private static volatile ExecutorService conflationExecutor;
    protected final int index;
    protected final int nDispatcher;
    private int pickBucketId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParallelGatewaySenderQueue(AbstractGatewaySender sender, Set<Region> userRegions, int idx, int nDispatcher) {
        this.index = idx;
        this.nDispatcher = nDispatcher;
        this.stats = sender.getStatistics();
        this.sender = (ParallelGatewaySenderImpl)sender;
        ArrayList<Region> listOfRegions = new ArrayList<Region>(userRegions);
        Collections.sort(listOfRegions, new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                return o1.getFullPath().compareTo(o2.getFullPath());
            }
        });
        for (Region userRegion : listOfRegions) {
            if (userRegion instanceof PartitionedRegion) {
                this.addShadowPartitionedRegionForUserPR((PartitionedRegion)userRegion);
                continue;
            }
            if (this.sender.getId().contains("AsyncEventQueue_")) {
                throw new AsyncEventQueueConfigurationException(LocalizedStrings.ParallelAsyncEventQueue_0_CAN_NOT_BE_USED_WITH_REPLICATED_REGION_1.toLocalizedString(AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.sender.getId()), userRegion.getFullPath()));
            }
            throw new GatewaySenderConfigurationException(LocalizedStrings.ParallelGatewaySender_0_CAN_NOT_BE_USED_WITH_REPLICATED_REGION_1.toLocalizedString(this.sender.getId(), userRegion.getFullPath()));
        }
        if (buckToDispatchLock == null) {
            buckToDispatchLock = new StoppableReentrantLock(sender.getCancelCriterion());
        }
        if (regionToDispatchedKeysMapEmpty == null) {
            regionToDispatchedKeysMapEmpty = buckToDispatchLock.newCondition();
        }
        this.queueEmptyLock = new StoppableReentrantLock(sender.getCancelCriterion());
        this.queueEmptyCondition = this.queueEmptyLock.newCondition();
        Class<ParallelGatewaySenderQueue> clazz = ParallelGatewaySenderQueue.class;
        synchronized (ParallelGatewaySenderQueue.class) {
            if (removalThread == null) {
                removalThread = new BatchRemovalThread((GemFireCacheImpl)sender.getCache(), this);
                removalThread.start();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (sender.isBatchConflationEnabled()) {
                ParallelGatewaySenderQueue.initializeConflationThreadPool();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        block22: {
            PartitionedRegion prQ;
            block20: {
                block21: {
                    this.sender.lifeCycleLock.writeLock().lock();
                    prQ = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug("addShadowPartitionedRegionForUserRR: Going to create shadowpr for userRegion {}", userRegion.getFullPath());
                    }
                    String regionName = userRegion.getFullPath();
                    if (!this.userRegionNameToshadowPRMap.containsKey(regionName)) break block20;
                    if (prQ == null) break block21;
                    this.userRegionNameToshadowPRMap.put(userRegion.getFullPath(), prQ);
                }
                this.sender.lifeCycleLock.writeLock().unlock();
                return;
            }
            try {
                GemFireCacheImpl cache = (GemFireCacheImpl)this.sender.getCache();
                String prQName = ParallelGatewaySenderQueue.getQueueName(this.sender.getId(), userRegion.getFullPath());
                prQ = (PartitionedRegion)cache.getRegion(prQName);
                if (prQ == null) {
                    AttributesFactory fact = new AttributesFactory();
                    fact.setConcurrencyChecksEnabled(false);
                    PartitionAttributesFactory pfact = new PartitionAttributesFactory();
                    pfact.setTotalNumBuckets(this.sender.getMaxParallelismForReplicatedRegion());
                    int localMaxMemory = userRegion.getDataPolicy().withStorage() ? this.sender.getMaximumQueueMemory() : 0;
                    pfact.setLocalMaxMemory(localMaxMemory);
                    pfact.setRedundantCopies(3);
                    pfact.setPartitionResolver(new RREventIDResolver());
                    if (this.sender.isPersistenceEnabled()) {
                        fact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    }
                    fact.setDiskStoreName(this.sender.getDiskStoreName());
                    if (this.sender.isPersistenceEnabled()) {
                        fact.setDiskSynchronous(this.sender.isDiskSynchronous());
                    } else {
                        fact.setDiskSynchronous(false);
                    }
                    EvictionAttributes ea = EvictionAttributes.createLIFOMemoryAttributes(this.sender.getMaximumQueueMemory(), EvictionAction.OVERFLOW_TO_DISK);
                    fact.setEvictionAttributes(ea);
                    fact.setPartitionAttributes(pfact.create());
                    RegionAttributes ra = fact.create();
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Attempting to create queue region: {}", this, prQName);
                    }
                    ParallelGatewaySenderQueueMetaRegion meta = new ParallelGatewaySenderQueueMetaRegion(prQName, ra, null, cache, this.sender);
                    try {
                        prQ = (PartitionedRegion)cache.createVMRegion(prQName, ra, new InternalRegionArguments().setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null));
                        if (logger.isDebugEnabled()) {
                            logger.debug("Region created  : {} partition Attributes : {}", prQ, prQ.getPartitionAttributes());
                        }
                        prQ.enableConflation(this.sender.isBatchConflationEnabled());
                        if (prQ.getLocalMaxMemory() != 0) {
                            Iterator<Integer> itr = prQ.getRegionAdvisor().getBucketSet().iterator();
                            while (itr.hasNext()) {
                                itr.next();
                            }
                        }
                    }
                    catch (IOException veryUnLikely) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)veryUnLikely);
                    }
                    catch (ClassNotFoundException alsoUnlikely) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)alsoUnlikely);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Created queue region: {}", this, prQ);
                    }
                } else if (this.index == 0) {
                    this.handleShadowPRExistsScenario(cache, prQ);
                }
                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                    this.sender.enqueTempEvents();
                }
                if (prQ == null) break block22;
                this.userRegionNameToshadowPRMap.put(userRegion.getFullPath(), prQ);
            }
            catch (Throwable throwable) {
                if (prQ != null) {
                    this.userRegionNameToshadowPRMap.put(userRegion.getFullPath(), prQ);
                }
                this.sender.lifeCycleLock.writeLock().unlock();
                throw throwable;
            }
        }
        this.sender.lifeCycleLock.writeLock().unlock();
    }

    private static String convertPathToName(String fullPath) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void addShadowPartitionedRegionForUserPR(PartitionedRegion userPR) {
        block34: {
            block35: {
                block36: {
                    block33: {
                        block31: {
                            block32: {
                                block29: {
                                    block30: {
                                        block27: {
                                            block28: {
                                                if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                                                    ParallelGatewaySenderQueue.logger.debug("{} addShadowPartitionedRegionForUserPR: Attempting to create queue region: {}", new Object[]{this, userPR.getDisplayName()});
                                                }
                                                this.sender.lifeCycleLock.writeLock().lock();
                                                prQ = null;
                                                try {
                                                    regionName = userPR.getFullPath();
                                                    leaderRegionName = ColocationHelper.getLeaderRegion(userPR).getFullPath();
                                                    if (regionName.equals(leaderRegionName)) break block27;
                                                    if (!this.userRegionNameToshadowPRMap.containsKey(leaderRegionName)) {
                                                        this.addShadowPartitionedRegionForUserPR(ColocationHelper.getLeaderRegion(userPR));
                                                    }
                                                    if (prQ == null) break block28;
                                                    this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
                                                }
                                                catch (Throwable var15_16) {
                                                    if (prQ != null) {
                                                        this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
                                                    }
                                                    if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                                        this.sender.enqueTempEvents();
                                                    }
                                                    this.afterRegionAdd(userPR);
                                                    this.sender.lifeCycleLock.writeLock().unlock();
                                                    throw var15_16;
                                                }
                                            }
                                            if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                                this.sender.enqueTempEvents();
                                            }
                                            this.afterRegionAdd(userPR);
                                            this.sender.lifeCycleLock.writeLock().unlock();
                                            return;
                                        }
                                        if (!this.userRegionNameToshadowPRMap.containsKey(regionName)) break block29;
                                        if (prQ == null) break block30;
                                        this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
                                    }
                                    if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                        this.sender.enqueTempEvents();
                                    }
                                    this.afterRegionAdd(userPR);
                                    this.sender.lifeCycleLock.writeLock().unlock();
                                    return;
                                }
                                if (userPR.getDataPolicy().withPersistence() && !this.sender.isPersistenceEnabled()) {
                                    throw new GatewaySenderException(LocalizedStrings.ParallelGatewaySenderQueue_NON_PERSISTENT_GATEWAY_SENDER_0_CAN_NOT_BE_ATTACHED_TO_PERSISTENT_REGION_1.toLocalizedString(new Object[]{this.sender.getId(), userPR.getFullPath()}));
                                }
                                cache = (GemFireCacheImpl)this.sender.getCache();
                                isAccessor = userPR.getLocalMaxMemory() == 0;
                                prQName = this.sender.getId() + "_PARALLEL_GATEWAY_SENDER_QUEUE" + ParallelGatewaySenderQueue.convertPathToName(userPR.getFullPath());
                                prQ = (PartitionedRegion)cache.getRegion(prQName);
                                if (prQ != null) ** GOTO lbl108
                                fact = new AttributesFactory<K, V>();
                                fact.setConcurrencyChecksEnabled(false);
                                pfact = new PartitionAttributesFactory<K, V>();
                                pfact.setTotalNumBuckets(userPR.getTotalNumberOfBuckets());
                                pfact.setRedundantCopies(userPR.getRedundantCopies());
                                pfact.setColocatedWith(regionName);
                                localMaxMemory = isAccessor != false ? 0 : this.sender.getMaximumQueueMemory();
                                pfact.setLocalMaxMemory(localMaxMemory);
                                pfact.setStartupRecoveryDelay(userPR.getPartitionAttributes().getStartupRecoveryDelay());
                                pfact.setRecoveryDelay(userPR.getPartitionAttributes().getRecoveryDelay());
                                if (this.sender.isPersistenceEnabled() && !isAccessor) {
                                    fact.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                                }
                                fact.setDiskStoreName(this.sender.getDiskStoreName());
                                if (this.sender.isPersistenceEnabled()) {
                                    fact.setDiskSynchronous(this.sender.isDiskSynchronous());
                                } else {
                                    fact.setDiskSynchronous(false);
                                }
                                ea = EvictionAttributes.createLIFOMemoryAttributes(this.sender.getMaximumQueueMemory(), EvictionAction.OVERFLOW_TO_DISK);
                                fact.setEvictionAttributes(ea);
                                fact.setPartitionAttributes(pfact.create());
                                ra = fact.create();
                                if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                                    ParallelGatewaySenderQueue.logger.debug("{}: Attempting to create queue region: {}", new Object[]{this, prQName});
                                }
                                meta = new ParallelGatewaySenderQueueMetaRegion(prQName, ra, null, cache, this.sender);
                                prQ = (PartitionedRegion)cache.createVMRegion(prQName, ra, new InternalRegionArguments().setInternalMetaRegion(meta).setDestroyLockFlag(true).setSnapshotInputStream(null).setImageTarget(null));
                                prQ.enableConflation(this.sender.isBatchConflationEnabled());
                                if (!isAccessor) break block31;
                                if (prQ == null) break block32;
                                this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
                            }
                            if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                                this.sender.enqueTempEvents();
                            }
                            this.afterRegionAdd(userPR);
                            this.sender.lifeCycleLock.writeLock().unlock();
                            return;
                        }
                        if (!prQ.getCache().isUnInitializedMember(prQ.getDistributionManager().getId())) {
                            prQ.shadowPRWaitForBucketRecovery();
                        }
                        {
                            catch (IOException veryUnLikely) {
                                ParallelGatewaySenderQueue.logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)veryUnLikely);
                                break block33;
                            }
                            catch (ClassNotFoundException alsoUnlikely) {
                                ParallelGatewaySenderQueue.logger.fatal(LocalizedMessage.create(LocalizedStrings.SingleWriteSingleReadRegionQueue_UNEXPECTED_EXCEPTION_DURING_INIT_OF_0, this.getClass()), (Throwable)alsoUnlikely);
                            }
                        }
                    }
                    if (ParallelGatewaySenderQueue.logger.isDebugEnabled()) {
                        ParallelGatewaySenderQueue.logger.debug("{}: Created queue region: {}", new Object[]{this, prQ});
                    }
                    break block34;
lbl108:
                    // 1 sources

                    if (!isAccessor) break block35;
                    if (prQ == null) break block36;
                    this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
                }
                if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
                    this.sender.enqueTempEvents();
                }
                this.afterRegionAdd(userPR);
                this.sender.lifeCycleLock.writeLock().unlock();
                return;
            }
            if (this.index != 0) break block34;
            this.handleShadowPRExistsScenario(cache, prQ);
        }
        if (prQ != null) {
            this.userRegionNameToshadowPRMap.put(userPR.getFullPath(), prQ);
        }
        if (this.index == this.nDispatcher - 1 && this.sender.isRunning()) {
            this.sender.enqueTempEvents();
        }
        this.afterRegionAdd(userPR);
        this.sender.lifeCycleLock.writeLock().unlock();
    }

    private void handleShadowPRExistsScenario(Cache cache, PartitionedRegion prQ) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: No need to create the region as the region has been retrieved: {}", this, prQ);
        }
        Set<BucketRegion> localBucketRegions = prQ.getDataStore().getAllLocalBucketRegions();
        for (BucketRegion bucketRegion : localBucketRegions) {
            bucketRegion.clear();
        }
    }

    protected void afterRegionAdd(PartitionedRegion userPR) {
    }

    private static void initializeConflationThreadPool() {
        if (conflationExecutor == null) {
            final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup("WAN Queue Conflation Logger Group", logger);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable task) {
                    Thread thread = new Thread(loggingThreadGroup, task, "WAN Queue Conflation Thread");
                    thread.setDaemon(true);
                    return thread;
                }
            };
            conflationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
        }
    }

    private void cleanupConflationThreadPool() {
        conflationExecutor.shutdown();
        try {
            if (!conflationExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                conflationExecutor.shutdownNow();
                if (!conflationExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ParallelGatewaySenderQueue_COULD_NOT_TERMINATE_CONFLATION_THREADPOOL, this.sender));
                }
            }
        }
        catch (InterruptedException e) {
            conflationExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object object) throws InterruptedException, CacheException {
        block39: {
            boolean isDebugEnabled = logger.isDebugEnabled();
            GatewaySenderEventImpl value2 = (GatewaySenderEventImpl)object;
            boolean isDREvent = this.isDREvent(value2);
            Region<?, ?> region = value2.getRegion();
            String regionPath = null;
            regionPath = isDREvent ? region.getFullPath() : ColocationHelper.getLeaderRegion((PartitionedRegion)region).getFullPath();
            if (isDebugEnabled) {
                logger.debug("Put is for the region {}", region);
            }
            if (!this.userRegionNameToshadowPRMap.containsKey(regionPath)) {
                if (isDebugEnabled) {
                    logger.debug("The userRegionNameToshadowPRMap is {}", this.userRegionNameToshadowPRMap);
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.NOT_QUEUING_AS_USERPR_IS_NOT_YET_CONFIGURED, value2));
                return;
            }
            PartitionedRegion prQ = this.userRegionNameToshadowPRMap.get(regionPath);
            int bucketId = value2.getBucketId();
            Serializable key2 = null;
            if (!isDREvent) {
                key2 = value2.getShadowKey();
                if ((Long)key2 == -1L) {
                    if (isDebugEnabled) {
                        logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {}", key2, value2);
                    }
                    return;
                }
            } else {
                key2 = value2.getEventId();
            }
            if (isDebugEnabled) {
                logger.debug("ParallelGatewaySenderOrderedQueue putting key {} : Value : {}", key2, value2);
            }
            AbstractBucketRegionQueue brq = (AbstractBucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
            try {
                if (brq == null) {
                    int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
                    try {
                        String bucketFullPath = "/__PR/" + prQ.getBucketName(bucketId);
                        brq = (AbstractBucketRegionQueue)prQ.getCache().getRegionByPath(bucketFullPath);
                        if (isDebugEnabled) {
                            logger.debug("ParallelGatewaySenderOrderedQueue : The bucket in the cache is bucketRegionName : {} bucket : {}", bucketFullPath, brq);
                        }
                        if (brq != null) {
                            brq.getInitializationLock().readLock().lock();
                            try {
                                this.putIntoBucketRegionQueue(brq, key2, value2);
                                break block39;
                            }
                            finally {
                                brq.getInitializationLock().readLock().unlock();
                            }
                        }
                        if (isDREvent) {
                            break block39;
                        }
                        if (prQ.getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).getShadowBucketDestroyed()) {
                            if (isDebugEnabled) {
                                logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {} as shadowPR bucket is destroyed.", key2, value2);
                            }
                            break block39;
                        }
                        LinkedBlockingQueue<GatewaySenderEventImpl> tempQueue = null;
                        Object object2 = this.bucketToTempQueueMap;
                        synchronized (object2) {
                            tempQueue = (LinkedBlockingQueue<GatewaySenderEventImpl>)this.bucketToTempQueueMap.get(bucketId);
                            if (tempQueue == null) {
                                tempQueue = new LinkedBlockingQueue<GatewaySenderEventImpl>();
                                this.bucketToTempQueueMap.put(bucketId, tempQueue);
                            }
                        }
                        object2 = tempQueue;
                        synchronized (object2) {
                            brq = (AbstractBucketRegionQueue)prQ.getCache().getRegionByPath(bucketFullPath);
                            if (brq != null) {
                                brq.getInitializationLock().readLock().lock();
                                try {
                                    this.putIntoBucketRegionQueue(brq, key2, value2);
                                }
                                finally {
                                    brq.getInitializationLock().readLock().unlock();
                                }
                            } else {
                                tempQueue.add(value2);
                                if (isDebugEnabled) {
                                    logger.debug("The value {} is enqueued to the tempQueue for the BucketRegionQueue.", value2);
                                }
                            }
                            break block39;
                        }
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                    }
                }
                boolean thisbucketDestroyed = false;
                thisbucketDestroyed = !isDREvent ? prQ.getColocatedWithRegion().getRegionAdvisor().getBucketAdvisor(bucketId).getShadowBucketDestroyed() || brq.isDestroyed() : brq.isDestroyed();
                if (!thisbucketDestroyed) {
                    this.putIntoBucketRegionQueue(brq, key2, value2);
                } else if (isDebugEnabled) {
                    logger.debug("ParallelGatewaySenderOrderedQueue not putting key {} : Value : {} as shadowPR bucket is destroyed.", key2, value2);
                }
            }
            finally {
                this.notifyEventProcessorIfRequired();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEventProcessorIfRequired() {
        if (this.isQueueEmpty) {
            block6: {
                this.queueEmptyLock.lock();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Going to notify, isQueueEmpty {}", this.isQueueEmpty);
                    }
                    if (this.isQueueEmpty) {
                        this.isQueueEmpty = false;
                        this.queueEmptyCondition.signal();
                    }
                    if (!logger.isDebugEnabled()) break block6;
                }
                catch (Throwable throwable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Notified!, isQueueEmpty {}", this.isQueueEmpty);
                    }
                    this.queueEmptyLock.unlock();
                    throw throwable;
                }
                logger.debug("Notified!, isQueueEmpty {}", this.isQueueEmpty);
            }
            this.queueEmptyLock.unlock();
        }
    }

    private void putIntoBucketRegionQueue(AbstractBucketRegionQueue brq, Object key2, GatewaySenderEventImpl value2) {
        block5: {
            try {
                if (brq != null) {
                    brq.addToQueue(key2, value2);
                }
            }
            catch (BucketNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("For bucket {} the current bucket redundancy is {}", brq.getId(), brq.getPartitionedRegion().getRegionAdvisor().getBucketAdvisor(brq.getId()).getBucketRedundancy());
                }
            }
            catch (ForceReattemptException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("getInitializedBucketForId: Got ForceReattemptException for {} for bucket = {}", this, brq.getId());
            }
        }
    }

    @Override
    public Region getRegion() {
        return this.userRegionNameToshadowPRMap.size() == 1 ? (Region)this.userRegionNameToshadowPRMap.values().toArray()[0] : null;
    }

    public PartitionedRegion getRegion(String fullpath) {
        return this.userRegionNameToshadowPRMap.get(fullpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionedRegion removeShadowPR(String fullpath) {
        try {
            this.sender.lifeCycleLock.writeLock().lock();
            this.sender.setEnqueuedAllTempQueueEvents(false);
            PartitionedRegion partitionedRegion = this.userRegionNameToshadowPRMap.remove(fullpath);
            return partitionedRegion;
        }
        finally {
            this.sender.lifeCycleLock.writeLock().unlock();
        }
    }

    public ExecutorService getConflationExecutor() {
        return conflationExecutor;
    }

    public Set<PartitionedRegion> getRegions() {
        return new HashSet<PartitionedRegion>(this.userRegionNameToshadowPRMap.values());
    }

    protected PartitionedRegion getRandomShadowPR() {
        PartitionedRegion prQ = null;
        if (this.userRegionNameToshadowPRMap.values().size() > 0) {
            int randomIndex = new Random().nextInt(this.userRegionNameToshadowPRMap.size());
            prQ = (PartitionedRegion)this.userRegionNameToshadowPRMap.values().toArray()[randomIndex];
        }
        return prQ;
    }

    private boolean isDREvent(GatewaySenderEventImpl event) {
        return event.getRegion() instanceof DistributedRegion;
    }

    @Override
    public Object take() throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    private final BucketRegionQueue getRandomBucketRegionQueue() {
        PartitionedRegion prQ = this.getRandomShadowPR();
        if (prQ != null) {
            PartitionedRegionDataStore ds = prQ.getDataStore();
            ArrayList<Integer> buckets = new ArrayList<Integer>(ds.getAllLocalPrimaryBucketIds());
            if (buckets.isEmpty()) {
                return null;
            }
            int index2 = new Random().nextInt(buckets.size());
            int brqId = (Integer)buckets.get(index2);
            BucketRegionQueue brq = (BucketRegionQueue)ds.getLocalBucketById(brqId);
            if (brq.isReadyForPeek()) {
                return brq;
            }
        }
        return null;
    }

    private boolean areLocalBucketQueueRegionsPresent() {
        boolean bucketsAvailable = false;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            if (prQ.getDataStore().getAllLocalBucketRegions().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean areLocalBucketQueueRegionsPresent(PartitionedRegion prQ) {
        return prQ.getDataStore().isLocalBucketRegionPresent();
    }

    protected int getRandomPrimaryBucket(PartitionedRegion prQ) {
        if (prQ != null) {
            Set<Map.Entry<Integer, BucketRegion>> allBuckets = prQ.getDataStore().getAllLocalBuckets();
            ArrayList<Integer> thisProcessorBuckets = new ArrayList<Integer>();
            for (Map.Entry<Integer, BucketRegion> bucketEntry : allBuckets) {
                int bId;
                BucketRegion bucket = bucketEntry.getValue();
                if (!bucket.getBucketAdvisor().isPrimary() || (bId = bucket.getId()) % this.nDispatcher != this.index) continue;
                thisProcessorBuckets.add(bId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getRandomPrimaryBucket: total {} for this processor: {}", allBuckets.size(), thisProcessorBuckets.size());
            }
            int nTry = thisProcessorBuckets.size();
            while (nTry-- > 0) {
                BucketRegionQueue br;
                if (this.pickBucketId >= thisProcessorBuckets.size()) {
                    this.pickBucketId = 0;
                }
                if ((br = (BucketRegionQueue)prQ.getDataStore().getLocalBucketById((Integer)thisProcessorBuckets.get(this.pickBucketId++))) == null || !br.isReadyForPeek()) continue;
                return br.getId();
            }
        }
        return -1;
    }

    @Override
    public List take(int batchSize) throws CacheException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() throws CacheException {
        if (!this.peekedEvents.isEmpty()) {
            GatewaySenderEventImpl event = (GatewaySenderEventImpl)this.peekedEvents.remove();
            PartitionedRegion prQ = null;
            int bucketId = -1;
            Serializable key2 = null;
            if (event.getRegion() != null) {
                if (this.isDREvent(event)) {
                    prQ = this.userRegionNameToshadowPRMap.get(event.getRegion().getFullPath());
                    bucketId = event.getEventId().getBucketID();
                    key2 = event.getEventId();
                } else {
                    prQ = this.userRegionNameToshadowPRMap.get(ColocationHelper.getLeaderRegion((PartitionedRegion)event.getRegion()).getFullPath());
                    bucketId = event.getBucketId();
                    key2 = event.getShadowKey();
                }
            } else {
                String regionPath = event.getRegionPath();
                GemFireCacheImpl cache = (GemFireCacheImpl)this.sender.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionPath);
                if (region != null && !region.isDestroyed()) {
                    if (region instanceof DistributedRegion) {
                        prQ = this.userRegionNameToshadowPRMap.get(region.getFullPath());
                        event.getBucketId();
                        key2 = event.getEventId();
                    } else {
                        prQ = this.userRegionNameToshadowPRMap.get(ColocationHelper.getLeaderRegion(region).getFullPath());
                        event.getBucketId();
                        key2 = event.getShadowKey();
                    }
                }
            }
            if (prQ != null) {
                this.destroyEventFromQueue(prQ, bucketId, key2);
            }
        }
    }

    private void destroyEventFromQueue(PartitionedRegion prQ, int bucketId, Object key2) {
        boolean isPrimary = prQ.getRegionAdvisor().getBucketAdvisor(bucketId).isPrimary();
        if (isPrimary) {
            block8: {
                BucketRegionQueue brq = (BucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
                try {
                    if (brq != null) {
                        brq.destroyKey(key2);
                    }
                    this.stats.decQueueSize();
                }
                catch (EntryNotFoundException e) {
                    if (!this.sender.isBatchConflationEnabled() && logger.isDebugEnabled()) {
                        logger.debug("ParallelGatewaySenderQueue#remove: Got EntryNotFoundException while removing key {} for {} for bucket = {} for GatewaySender {}", key2, this, bucketId, this.sender);
                    }
                }
                catch (ForceReattemptException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Bucket :{} moved to other member", bucketId);
                    }
                }
                catch (PrimaryBucketException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("Primary bucket :{} moved to other member", bucketId);
                }
            }
            this.addRemovedEvent(prQ, bucketId, key2);
        }
    }

    public void resetLastPeeked() {
        this.resetLastPeeked = true;
    }

    @Override
    public Object peek() throws InterruptedException, CacheException {
        Object object;
        block4: {
            object = null;
            int bucketId = -1;
            PartitionedRegion prQ = this.getRandomShadowPR();
            if (prQ != null && prQ.getDataStore().getAllLocalBucketRegions().size() > 0 && (bucketId = this.getRandomPrimaryBucket(prQ)) != -1) {
                try {
                    BucketRegionQueue brq = (BucketRegionQueue)prQ.getDataStore().getInitializedBucketForId(null, bucketId);
                    object = brq.peek();
                }
                catch (BucketRegionQueueUnavailableException e) {
                    return object;
                }
                catch (ForceReattemptException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Remove: Got ForceReattemptException for {} for bucke = {}", this, bucketId);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvent(PartitionedRegion prQ, int bucketId, Object key2) {
        buckToDispatchLock.lock();
        boolean wasEmpty = regionToDispatchedKeysMap.isEmpty();
        try {
            ConcurrentHashMap bucketIdToDispatchedKeys = (ConcurrentHashMap)regionToDispatchedKeysMap.get(prQ.getFullPath());
            if (bucketIdToDispatchedKeys == null) {
                bucketIdToDispatchedKeys = new ConcurrentHashMap();
                regionToDispatchedKeysMap.put(prQ.getFullPath(), bucketIdToDispatchedKeys);
            }
            this.addRemovedEventToMap(bucketIdToDispatchedKeys, bucketId, key2);
            if (wasEmpty) {
                regionToDispatchedKeysMapEmpty.signal();
            }
        }
        finally {
            buckToDispatchLock.unlock();
        }
    }

    private void addRemovedEventToMap(Map bucketIdToDispatchedKeys, int bucketId, Object key2) {
        ArrayList<Object> dispatchedKeys = (ArrayList<Object>)bucketIdToDispatchedKeys.get(bucketId);
        if (dispatchedKeys == null) {
            dispatchedKeys = new ArrayList<Object>();
            bucketIdToDispatchedKeys.put(bucketId, dispatchedKeys);
        }
        dispatchedKeys.add(key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvents(PartitionedRegion prQ, int bucketId, List<Object> shadowKeys) {
        buckToDispatchLock.lock();
        boolean wasEmpty = regionToDispatchedKeysMap.isEmpty();
        try {
            ConcurrentHashMap bucketIdToDispatchedKeys = (ConcurrentHashMap)regionToDispatchedKeysMap.get(prQ.getFullPath());
            if (bucketIdToDispatchedKeys == null) {
                bucketIdToDispatchedKeys = new ConcurrentHashMap();
                regionToDispatchedKeysMap.put(prQ.getFullPath(), bucketIdToDispatchedKeys);
            }
            this.addRemovedEventsToMap(bucketIdToDispatchedKeys, bucketId, shadowKeys);
            if (wasEmpty) {
                regionToDispatchedKeysMapEmpty.signal();
            }
        }
        finally {
            buckToDispatchLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemovedEvents(String prQPath, int bucketId, List<Object> shadowKeys) {
        buckToDispatchLock.lock();
        boolean wasEmpty = regionToDispatchedKeysMap.isEmpty();
        try {
            ConcurrentHashMap bucketIdToDispatchedKeys = (ConcurrentHashMap)regionToDispatchedKeysMap.get(prQPath);
            if (bucketIdToDispatchedKeys == null) {
                bucketIdToDispatchedKeys = new ConcurrentHashMap();
                regionToDispatchedKeysMap.put(prQPath, bucketIdToDispatchedKeys);
            }
            this.addRemovedEventsToMap(bucketIdToDispatchedKeys, bucketId, shadowKeys);
            if (wasEmpty) {
                regionToDispatchedKeysMapEmpty.signal();
            }
        }
        finally {
            buckToDispatchLock.unlock();
        }
    }

    private void addRemovedEventsToMap(Map bucketIdToDispatchedKeys, int bucketId, List keys) {
        List dispatchedKeys = (List)bucketIdToDispatchedKeys.get(bucketId);
        if (dispatchedKeys == null) {
            dispatchedKeys = keys == null ? new ArrayList() : keys;
        } else {
            dispatchedKeys.addAll(keys);
        }
        bucketIdToDispatchedKeys.put(bucketId, dispatchedKeys);
    }

    @Override
    public List peek(int batchSize) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List peek(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        PartitionedRegion prQ = this.getRandomShadowPR();
        ArrayList<Object> batch = new ArrayList<Object>();
        if (prQ == null || prQ.getLocalMaxMemory() == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.blockProcesorThreadIfRequired();
            return batch;
        }
        long start = System.currentTimeMillis();
        long end = start + (long)timeToWait;
        Object object = null;
        int bId = -1;
        if (this.resetLastPeeked) {
            batch.addAll(this.peekedEvents);
            this.resetLastPeeked = false;
            if (isDebugEnabled) {
                StringBuffer buffer = new StringBuffer();
                for (GatewaySenderEventImpl ge : this.peekedEvents) {
                    buffer.append("event :");
                    buffer.append(ge);
                }
                logger.debug("Adding already peeked events to the batch {}", buffer);
            }
        }
        while (batch.size() < batchSize) {
            if (this.areLocalBucketQueueRegionsPresent() && (bId = this.getRandomPrimaryBucket(prQ)) != -1) {
                object = this.peekAhead(prQ, bId);
                if (object != null) {
                    if (isDebugEnabled) {
                        logger.debug("The gatewayEventImpl in peek is {}", object);
                    }
                    batch.add(object);
                    this.peekedEvents.add((GatewaySenderEventImpl)object);
                    BucketRegionQueue brq = (BucketRegionQueue)prQ.getDataStore().getLocalBucketById(bId);
                    continue;
                }
                long currentTime = System.currentTimeMillis();
                if (isDebugEnabled) {
                    logger.debug("{}: Peeked object was null. Peek current time: {}", this, currentTime);
                }
                if (timeToWait == -1 || end <= currentTime) {
                    if (!isDebugEnabled) break;
                    logger.debug("{}: Peeked object was null.. Peek breaking", this);
                    break;
                }
                if (!isDebugEnabled) continue;
                logger.debug("{}: Peeked object was null. Peek continuing", this);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (isDebugEnabled) {
                logger.debug("{}: Peek current time: {}", this, currentTime);
            }
            if (timeToWait == -1 || end <= currentTime) {
                if (!isDebugEnabled) break;
                logger.debug("{}: Peek breaking", this);
                break;
            }
            if (isDebugEnabled) {
                logger.debug("{}: Peek continuing", this);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (isDebugEnabled) {
            logger.debug("{}: Peeked a batch of {} entries. The size of the queue is {}. localSize is {}", this, batch.size(), this.size(), this.localSize());
        }
        if (batch.size() == 0) {
            this.blockProcesorThreadIfRequired();
        }
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void blockProcesorThreadIfRequired() throws InterruptedException {
        block5: {
            this.queueEmptyLock.lock();
            try {
                if (this.isQueueEmpty) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Going to wait, till notified.");
                    }
                    this.queueEmptyCondition.await(1000L);
                }
                boolean bl = this.isQueueEmpty = this.localSizeForProcessor() == 0;
                if (!logger.isDebugEnabled()) break block5;
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Going to unblock. isQueueEmpty {}", this.isQueueEmpty);
                }
                this.queueEmptyLock.unlock();
                throw throwable;
            }
            logger.debug("Going to unblock. isQueueEmpty {}", this.isQueueEmpty);
        }
        this.queueEmptyLock.unlock();
    }

    protected Object peekAhead(PartitionedRegion prQ, int bucketId) throws CacheException {
        Object object = null;
        BucketRegionQueue brq = (BucketRegionQueue)prQ.getDataStore().getLocalBucketById(bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peekahead for the bucket {}", this, bucketId);
        }
        try {
            object = brq.peek();
        }
        catch (BucketRegionQueueUnavailableException e) {
            return object;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Peeked object from bucket {} object: {}", this, bucketId, object);
        }
        if (object == null && this.stats != null) {
            this.stats.incEventsNotQueuedConflated();
        }
        return object;
    }

    public int localSize() {
        int size2 = 0;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            if (((PartitionedRegion)prQ.getRegion()).getDataStore() != null) {
                size2 += ((PartitionedRegion)prQ.getRegion()).getDataStore().getSizeOfLocalPrimaryBuckets();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("The name of the queue region is {} and the size is {}", prQ.getFullPath(), size2);
        }
        return size2;
    }

    public int localSizeForProcessor() {
        int size2 = 0;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            if (((PartitionedRegion)prQ.getRegion()).getDataStore() != null) {
                Set<BucketRegion> primaryBuckets = ((PartitionedRegion)prQ.getRegion()).getDataStore().getAllLocalPrimaryBucketRegions();
                for (BucketRegion br : primaryBuckets) {
                    if (br.getId() % this.nDispatcher != this.index) continue;
                    size2 += br.size();
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("The name of the queue region is {} and the size is {}", prQ.getFullPath(), size2);
        }
        return size2;
    }

    @Override
    public int size() {
        int size2 = 0;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            if (logger.isDebugEnabled()) {
                logger.debug("The name of the queue region is {} and the size is {}. keyset size is {}", prQ.getName(), prQ.size(), prQ.keys().size());
            }
            size2 += prQ.size();
        }
        return size2 + this.sender.getTmpQueuedEventSize();
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            AttributesMutator mutator = prQ.getAttributesMutator();
            mutator.addCacheListener(listener);
        }
    }

    @Override
    public void removeCacheListener() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int batchSize) throws CacheException {
        for (int i = 0; i < batchSize; ++i) {
            this.remove();
        }
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ConflationHandler conflationHandler = new ConflationHandler(conflatableObject, bucketId, tailKey);
        conflationExecutor.execute(conflationHandler);
    }

    public long getNumEntriesOverflowOnDiskTestOnly() {
        long numEntriesOnDisk = 0L;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            DiskRegionStats diskStats = prQ.getDiskRegionStats();
            if (diskStats == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: DiskRegionStats for shadow PR is null. Returning the numEntriesOverflowOnDisk as 0", this);
                }
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: DiskRegionStats for shadow PR is NOT null. Returning the numEntriesOverflowOnDisk obtained from DiskRegionStats", this);
            }
            numEntriesOnDisk += diskStats.getNumOverflowOnDisk();
        }
        return numEntriesOnDisk;
    }

    public long getNumEntriesInVMTestOnly() {
        long numEntriesInVM = 0L;
        for (PartitionedRegion prQ : this.userRegionNameToshadowPRMap.values()) {
            DiskRegionStats diskStats = prQ.getDiskRegionStats();
            if (diskStats == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: DiskRegionStats for shadow PR is null. Returning the numEntriesInVM as 0", this);
                }
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: DiskRegionStats for shadow PR is NOT null. Returning the numEntriesInVM obtained from DiskRegionStats", this);
            }
            numEntriesInVM += diskStats.getNumEntriesInVM();
        }
        return numEntriesInVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        if (buckToDispatchLock != null) {
            buckToDispatchLock = null;
        }
        if (regionToDispatchedKeysMapEmpty != null) {
            regionToDispatchedKeysMapEmpty = null;
        }
        regionToDispatchedKeysMap.clear();
        Class<ParallelGatewaySenderQueue> clazz = ParallelGatewaySenderQueue.class;
        synchronized (ParallelGatewaySenderQueue.class) {
            if (removalThread != null) {
                removalThread.shutdown();
                removalThread = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (conflationExecutor != null) {
                this.cleanupConflationThreadPool();
                conflationExecutor = null;
            }
            return;
        }
    }

    public Map<Integer, BlockingQueue<GatewaySenderEventImpl>> getBucketToTempQueueMap() {
        return this.bucketToTempQueueMap;
    }

    public static boolean isParallelQueue(String regionName) {
        return regionName.contains(QSTRING);
    }

    public static String getQueueName(String senderId, String regionPath) {
        return senderId + QSTRING + ParallelGatewaySenderQueue.convertPathToName(regionPath);
    }

    public static String getSenderId(String regionName) {
        int queueStringStart = regionName.indexOf(QSTRING);
        return regionName.substring(1, queueStringStart);
    }

    public long estimateMemoryFootprint(SingleObjectSizer sizer) {
        return sizer.sizeof(this) + sizer.sizeof(regionToDispatchedKeysMap) + sizer.sizeof(this.userRegionNameToshadowPRMap) + sizer.sizeof(this.bucketToTempQueueMap) + sizer.sizeof(this.peekedEvents) + sizer.sizeof(conflationExecutor);
    }

    public void clear(PartitionedRegion pr2, int bucketId) {
        throw new RuntimeException("This method(clear)is not supported by ParallelGatewaySenderQueue");
    }

    public int size(PartitionedRegion pr2, int bucketId) throws ForceReattemptException {
        throw new RuntimeException("This method(size)is not supported by ParallelGatewaySenderQueue");
    }

    static {
        messageSyncInterval = 10;
        removalThread = null;
    }

    protected class ParallelGatewaySenderQueueMetaRegion
    extends PartitionedRegion {
        ParallelGatewaySenderImpl sender;

        public ParallelGatewaySenderQueueMetaRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, AbstractGatewaySender pgSender) {
            super(regionName, attrs, parentRegion, cache, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForParallelGatewaySenderQueue(true).setParallelGatewaySender((ParallelGatewaySenderImpl)pgSender));
            this.sender = null;
            this.sender = (ParallelGatewaySenderImpl)pgSender;
        }

        @Override
        protected boolean isCopyOnRead() {
            return false;
        }

        @Override
        public final boolean isSecret() {
            return true;
        }

        @Override
        public final boolean supportsConcurrencyChecks() {
            return false;
        }

        @Override
        protected final boolean shouldNotifyBridgeClients() {
            return false;
        }

        @Override
        public final boolean generateEventID() {
            return false;
        }

        @Override
        public final boolean isUsedForParallelGatewaySenderQueue() {
            return true;
        }

        @Override
        public final ParallelGatewaySenderImpl getParallelGatewaySender() {
            return this.sender;
        }
    }

    private static class BatchRemovalThread
    extends Thread {
        private volatile boolean shutdown = false;
        private final GemFireCacheImpl cache;
        private final ParallelGatewaySenderQueue parallelQueue;

        public BatchRemovalThread(GemFireCacheImpl c, ParallelGatewaySenderQueue queue) {
            super("BatchRemovalThread");
            this.setDaemon(true);
            this.cache = c;
            this.parallelQueue = queue;
        }

        private boolean checkCancelled() {
            if (this.shutdown) {
                return true;
            }
            return this.cache.getCancelCriterion().cancelInProgress() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block40: {
                try {
                    InternalDistributedSystem ids = this.cache.getDistributedSystem();
                    DM dm = ids.getDistributionManager();
                    while (true) {
                        try {
                            while (true) {
                                if (this.checkCancelled()) {
                                    break block40;
                                }
                                boolean interrupted = Thread.interrupted();
                                try {
                                    BatchRemovalThread batchRemovalThread = this;
                                    synchronized (batchRemovalThread) {
                                        this.wait(messageSyncInterval);
                                    }
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                    if (this.checkCancelled()) {
                                        // empty if block
                                    }
                                    break block40;
                                }
                                finally {
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                if (logger.isDebugEnabled()) {
                                    buckToDispatchLock.lock();
                                    try {
                                        logger.debug("BatchRemovalThread about to query the batch removal map {}", regionToDispatchedKeysMap);
                                    }
                                    finally {
                                        buckToDispatchLock.unlock();
                                    }
                                }
                                HashMap temp = new HashMap();
                                buckToDispatchLock.lock();
                                try {
                                    boolean wasEmpty = regionToDispatchedKeysMap.isEmpty();
                                    while (regionToDispatchedKeysMap.isEmpty()) {
                                        regionToDispatchedKeysMapEmpty.await();
                                    }
                                    if (wasEmpty) continue;
                                    temp.putAll(regionToDispatchedKeysMap);
                                    regionToDispatchedKeysMap.clear();
                                }
                                finally {
                                    buckToDispatchLock.unlock();
                                    continue;
                                }
                                Set<InternalDistributedMember> recipients = this.getAllRecipients(this.cache, temp);
                                this.cache.getDistributionManager().removeMembersWithSameOrNewerVersion(recipients, Version.GFE_80);
                                if (!recipients.isEmpty()) {
                                    for (Map.Entry mapEntry : temp.entrySet()) {
                                        Set<InternalDistributedMember> tempOldVersionMembers = recipients;
                                        PartitionedRegion prQ = (PartitionedRegion)this.cache.getRegion((String)mapEntry.getKey());
                                        Set<InternalDistributedMember> memberForPRQ = prQ.getRegionAdvisor().adviseDataStore();
                                        memberForPRQ.retainAll(tempOldVersionMembers);
                                        ParallelQueueBatchRemovalMessage.ParallelQueueBatchRemovalResponse response = ParallelQueueBatchRemovalMessage.send(memberForPRQ, prQ, (Map)mapEntry.getValue());
                                        try {
                                            response.waitForResponse();
                                        }
                                        catch (ForceReattemptException e) {
                                            for (Integer bId : ((Map)mapEntry.getValue()).keySet()) {
                                                this.parallelQueue.addRemovedEvents(prQ, (int)bId, (List<Object>)((List)((Map)mapEntry.getValue()).get(bId)));
                                            }
                                            if (!logger.isDebugEnabled()) continue;
                                            logger.debug("ParallelQueueBatchRemovalMessage got ForceReattemptException. Will continue.");
                                        }
                                    }
                                }
                                recipients = this.getAllRecipients(this.cache, temp);
                                this.cache.getDistributionManager().retainMembersWithSameOrNewerVersion(recipients, Version.GFE_80);
                                if (recipients.isEmpty()) continue;
                                ParallelQueueRemovalMessage pqrm = new ParallelQueueRemovalMessage(temp);
                                pqrm.setRecipients(recipients);
                                dm.putOutgoing(pqrm);
                            }
                        }
                        catch (CancelException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("BatchRemovalThread is exiting due to cancellation");
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            Error err;
                            if (t instanceof Error && SystemFailure.isJVMFailureError(err = (Error)t)) {
                                SystemFailure.initiateFailure(err);
                                throw err;
                            }
                            SystemFailure.checkFailure();
                            if (this.checkCancelled()) {
                                break;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("BatchRemovalThread: ignoring exception", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (CancelException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("BatchRemovalThread exiting due to cancellation: " + e);
                    }
                }
                finally {
                    logger.info(LocalizedMessage.create(LocalizedStrings.HARegionQueue_THE_QUEUEREMOVALTHREAD_IS_DONE));
                }
            }
        }

        private Set<InternalDistributedMember> getAllRecipients(GemFireCacheImpl cache, Map map) {
            THashSet recipients = new THashSet();
            for (Object pr2 : map.keySet()) {
                recipients.addAll(((PartitionedRegion)cache.getRegion((String)pr2)).getRegionAdvisor().adviseDataStore());
            }
            return recipients;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            boolean interrupted = Thread.interrupted();
            try {
                this.join(15000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.HARegionQueue_QUEUEREMOVALTHREAD_IGNORED_CANCELLATION));
            }
        }
    }

    private class ConflationHandler
    implements Runnable {
        Conflatable conflatableObject;
        Long previousTailKeyTobeRemoved;
        int bucketId;

        public ConflationHandler(Conflatable conflatableObject, int bId, Long previousTailKey) {
            this.conflatableObject = conflatableObject;
            this.previousTailKeyTobeRemoved = previousTailKey;
            this.bucketId = bId;
        }

        @Override
        public void run() {
            PartitionedRegion prQ;
            block3: {
                prQ = null;
                try {
                    String regionPath = ColocationHelper.getLeaderRegion((PartitionedRegion)((GatewaySenderEventImpl)this.conflatableObject).getRegion()).getFullPath();
                    prQ = ParallelGatewaySenderQueue.this.userRegionNameToshadowPRMap.get(regionPath);
                    ParallelGatewaySenderQueue.this.destroyEventFromQueue(prQ, this.bucketId, this.previousTailKeyTobeRemoved);
                }
                catch (EntryNotFoundException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("{}: Not conflating {} due to EntryNotFoundException", this, this.conflatableObject.getKeyToConflate());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Conflated {} for key={} in queue for region={}", this, this.deserialize(this.conflatableObject.getValueToConflate()), this.conflatableObject.getKeyToConflate(), prQ.getName());
            }
        }

        private Object deserialize(Object serializedBytes) {
            Object deserializedObject = serializedBytes;
            if (serializedBytes instanceof byte[]) {
                byte[] serializedBytesCast = (byte[])serializedBytes;
                try {
                    deserializedObject = EntryEventImpl.deserialize(serializedBytesCast);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return deserializedObject;
        }
    }
}

