/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderImpl
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();
    final ThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Remote Site Discovery Logger Group", logger);

    public ParallelGatewaySenderImpl(Cache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.checkLicense();
        if (logger.isDebugEnabled()) {
            logger.debug("Done checking the license. Proceeding with the start... {}", this);
        }
        this.lifeCycleLock.writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.eventProcessor = new ConcurrentParallelGatewaySenderEventProcessor(this);
            this.eventProcessor.start();
            this.waitForRunningStatus();
            if (!this.isAsyncEventQueue()) {
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewaySenderStarted(this);
            }
            new UpdateAttributesProcessor(this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, this);
            logger.info(LocalizedMessage.create(LocalizedStrings.ParallelGatewaySenderImpl_STARTED__0, this));
            if (!this.tmpQueuedEvents.isEmpty()) {
                this.enqueTempEvents();
            }
        }
        finally {
            this.lifeCycleLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lifeCycleLock.writeLock().lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
            if (ev != null && !ev.isStopped()) {
                ev.stopProcessing();
            }
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            ((ConcurrentParallelGatewaySenderQueue)this.eventProcessor.getQueue()).cleanUp();
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_STOPPED__0, this));
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, this);
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.lifeCycleLock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ParallelGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = true;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        for (GatewayEventFilter gatewayEventFilter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(gatewayEventFilter.getClass().getName());
        }
        for (GatewayTransportFilter gatewayTransportFilter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(gatewayTransportFilter.getClass().getName());
        }
        for (AsyncEventListener asyncEventListener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(asyncEventListener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
    }

    @Override
    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        int bucketId = -1;
        bucketId = clonedEvent.getRegion() instanceof DistributedRegion ? PartitionedRegionHelper.getHashKey(clonedEvent.getKey(), this.getMaxParallelismForReplicatedRegion()) : PartitionedRegionHelper.getHashKey(clonedEvent);
        EventID originalEventId = clonedEvent.getEventId();
        long originatingThreadId = ThreadIdentifier.getRealThreadID(originalEventId.getThreadID());
        long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(bucketId, originatingThreadId, this.getEventIdIndex());
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID(), bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, bucketId={}, original event id={}, threadId={}, new event id={}, newThreadId={}", this, clonedEvent.getKey(), bucketId, originalEventId, originatingThreadId, newEventId, newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }
}

