/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.Logger;

public class ParallelGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    final int index;
    final int nDispatcher;

    protected ParallelGatewaySenderEventProcessor(ParallelGatewaySenderImpl sender) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId(), logger), "Event Processor for GatewaySender_" + sender.getId(), sender);
        this.index = 0;
        this.nDispatcher = 1;
        this.initializeMessageQueue(sender.getId());
        this.setDaemon(true);
    }

    protected ParallelGatewaySenderEventProcessor(ParallelGatewaySenderImpl sender, Set<Region> userRegions, int id, int nDispatcher) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId(), logger), "Event Processor for GatewaySender_" + sender.getId() + "_" + id, sender);
        this.index = id;
        this.nDispatcher = nDispatcher;
        this.initializeMessageQueue(sender.getId());
        this.setDaemon(true);
    }

    @Override
    protected void initializeMessageQueue(String id) {
        HashSet<Region> targetRs = new HashSet<Region>();
        for (LocalRegion region : ((GemFireCacheImpl)((ParallelGatewaySenderImpl)this.sender).getCache()).getApplicationRegions()) {
            if (!region.getAllGatewaySenderIds().contains(id)) continue;
            targetRs.add(region);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The target Regions are(PGSEP) {}", targetRs);
        }
        this.queue = new ParallelGatewaySenderQueue(this.sender, targetRs, this.index, this.nDispatcher);
        if (((ParallelGatewaySenderQueue)this.queue).localSize() > 0) {
            ((ParallelGatewaySenderQueue)this.queue).notifyEventProcessorIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        block8: {
            GatewaySenderEventImpl gatewayQueueEvent = null;
            Region region = event.getRegion();
            if (!(region instanceof DistributedRegion) && ((EntryEventImpl)event).getTailKey() == -1L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ParallelGatewaySenderEventProcessor not enqueing the following event since tailKey is not set. {}", event);
                }
                return;
            }
            EventID eventID = ((EntryEventImpl)event).getEventId();
            gatewayQueueEvent = new GatewaySenderEventImpl(operation, event, substituteValue, true, eventID.getBucketID());
            if (this.getSender().beforeEnque(gatewayQueueEvent)) {
                long start = this.getSender().getStatistics().startTime();
                try {
                    this.queue.put(gatewayQueueEvent);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.getSender().getStatistics().endPut(start);
                break block8;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The Event {} is filtered.", gatewayQueueEvent);
            }
            this.getSender().getStatistics().incEventsFiltered();
        }
    }

    public void clear(PartitionedRegion pr2, int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).clear(pr2, bucketId);
    }

    public void notifyEventProcessorIfRequired(int bucketId) {
        ((ParallelGatewaySenderQueue)this.queue).notifyEventProcessorIfRequired();
    }

    public BlockingQueue<GatewaySenderEventImpl> getBucketTmpQueue(int bucketId) {
        return ((ParallelGatewaySenderQueue)this.queue).getBucketToTempQueueMap().get(bucketId);
    }

    public PartitionedRegion getRegion(String prRegionName) {
        return ((ParallelGatewaySenderQueue)this.queue).getRegion(prRegionName);
    }

    public void removeShadowPR(String prRegionName) {
        ((ParallelGatewaySenderQueue)this.queue).removeShadowPR(prRegionName);
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        ((ParallelGatewaySenderQueue)this.queue).conflateEvent(conflatableObject, bucketId, tailKey);
    }

    public void addShadowPartitionedRegionForUserPR(PartitionedRegion pr2) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserPR(pr2);
    }

    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        ((ParallelGatewaySenderQueue)this.queue).addShadowPartitionedRegionForUserRR(userRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            GatewaySenderEventRemoteDispatcher remoteDispatcher;
            if (this.dispatcher instanceof GatewaySenderEventRemoteDispatcher && (remoteDispatcher = (GatewaySenderEventRemoteDispatcher)this.dispatcher).isConnected()) {
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }
}

