/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public class ConcurrentParallelGatewaySenderQueue
implements RegionQueue {
    private final ParallelGatewaySenderEventProcessor[] processors;

    public ConcurrentParallelGatewaySenderQueue(ParallelGatewaySenderEventProcessor[] pro) {
        this.processors = pro;
    }

    @Override
    public void put(Object object) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException("CPGAQ method(put) is not supported");
    }

    @Override
    public Region getRegion() {
        return this.processors[0].getQueue().getRegion();
    }

    public PartitionedRegion getRegion(String fullpath) {
        return this.processors[0].getRegion(fullpath);
    }

    public Set<PartitionedRegion> getRegions() {
        return ((ParallelGatewaySenderQueue)this.processors[0].getQueue()).getRegions();
    }

    @Override
    public Object take() throws CacheException, InterruptedException {
        throw new UnsupportedOperationException("This method(take) is not suported");
    }

    @Override
    public List take(int batchSize) throws CacheException, InterruptedException {
        throw new UnsupportedOperationException("This method(take) is not suported");
    }

    @Override
    public void remove() throws CacheException {
        throw new UnsupportedOperationException("This method(remove) is not suported");
    }

    @Override
    public Object peek() throws InterruptedException, CacheException {
        throw new UnsupportedOperationException("This method(peek) is not suported");
    }

    @Override
    public List peek(int batchSize) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException("This method(peek) is not suported");
    }

    @Override
    public List peek(int batchSize, int timeToWait) throws InterruptedException, CacheException {
        throw new UnsupportedOperationException("This method(peek) is not suported");
    }

    @Override
    public int size() {
        return this.processors[0].getQueue().size();
    }

    public int localSize() {
        return ((ParallelGatewaySenderQueue)this.processors[0].getQueue()).localSize();
    }

    @Override
    public void addCacheListener(CacheListener listener) {
        this.processors[0].getQueue().addCacheListener(listener);
    }

    @Override
    public void removeCacheListener() {
        this.processors[0].removeCacheListener();
    }

    @Override
    public void remove(int top) throws CacheException {
        throw new UnsupportedOperationException("This method(remove) is not suported");
    }

    public long estimateMemoryFootprint(SingleObjectSizer sizer) {
        long size2 = 0L;
        for (int i = 0; i < this.processors.length; ++i) {
            size2 += ((ParallelGatewaySenderQueue)this.processors[i].getQueue()).estimateMemoryFootprint(sizer);
        }
        return size2;
    }

    public void removeShadowPR(String prRegionName) {
        for (int i = 0; i < this.processors.length; ++i) {
            this.processors[i].removeShadowPR(prRegionName);
        }
    }

    public void addShadowPartitionedRegionForUserPR(PartitionedRegion pr2) {
        for (int i = 0; i < this.processors.length; ++i) {
            this.processors[i].addShadowPartitionedRegionForUserPR(pr2);
        }
    }

    private ParallelGatewaySenderEventProcessor getPGSProcessor(int bucketId) {
        int index2 = bucketId % this.processors.length;
        return this.processors[index2];
    }

    public BlockingQueue<GatewaySenderEventImpl> getBucketTmpQueue(int bucketId) {
        return this.getPGSProcessor(bucketId).getBucketTmpQueue(bucketId);
    }

    public void notifyEventProcessorIfRequired(int bucketId) {
        this.getPGSProcessor(bucketId).notifyEventProcessorIfRequired(bucketId);
    }

    public void clear(PartitionedRegion pr2, int bucketId) {
        this.getPGSProcessor(bucketId).clear(pr2, bucketId);
    }

    public void cleanUp() {
        for (int i = 0; i < this.processors.length; ++i) {
            ((ParallelGatewaySenderQueue)this.processors[i].getQueue()).cleanUp();
        }
    }

    public void conflateEvent(Conflatable conflatableObject, int bucketId, Long tailKey) {
        this.getPGSProcessor(bucketId).conflateEvent(conflatableObject, bucketId, tailKey);
    }

    public void addShadowPartitionedRegionForUserRR(DistributedRegion userRegion) {
        for (int i = 0; i < this.processors.length; ++i) {
            this.processors[i].addShadowPartitionedRegionForUserRR(userRegion);
        }
    }

    public long getNumEntriesInVMTestOnly() {
        return ((ParallelGatewaySenderQueue)this.processors[0].getQueue()).getNumEntriesInVMTestOnly();
    }

    public long getNumEntriesOverflowOnDiskTestOnly() {
        return ((ParallelGatewaySenderQueue)this.processors[0].getQueue()).getNumEntriesOverflowOnDiskTestOnly();
    }
}

