/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.SerializedCacheValue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.wan.EventSequenceID;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class GatewaySenderEventImpl
implements AsyncEvent,
DataSerializableFixedID,
Conflatable,
Sizeable {
    private static final long serialVersionUID = -5690172020872255422L;
    protected static final Object TOKEN_UN_INITIALIZED = new Object();
    protected static final Object TOKEN_NULL = new Object();
    protected static final short VERSION = 17;
    protected EnumListenerEvent operation;
    protected EntryEventImpl entryEvent;
    protected Object substituteValue;
    protected int action;
    protected int operationDetail;
    protected int numberOfParts;
    protected EventID id;
    private LocalRegion region;
    protected String regionPath;
    protected Object key = TOKEN_UN_INITIALIZED;
    protected byte[] value;
    protected byte valueIsObject;
    protected GatewaySenderEventCallbackArgument callbackArgument;
    protected long versionTimeStamp;
    protected boolean possibleDuplicate;
    protected volatile boolean isAcked;
    protected volatile boolean isDispatched;
    protected long creationTime;
    protected int bucketId;
    protected Long shadowKey = new Long(-1L);
    public static final ThreadLocal isSerializingValue = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final int CREATE_ACTION = 0;
    private static final int UPDATE_ACTION = 1;
    private static final int DESTROY_ACTION = 2;
    private static final int VERSION_ACTION = 3;
    private static final int OP_DETAIL_NONE = 10;
    private static final int OP_DETAIL_LOCAL_LOAD = 11;
    private static final int OP_DETAIL_NET_LOAD = 12;
    private static final int OP_DETAIL_PUTALL = 13;
    private static final int OP_DETAIL_REMOVEALL = 14;
    public static final ThreadLocal isDeserializingValue = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public GatewaySenderEventImpl() {
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent event, Object substituteValue) throws IOException {
        this(operation, event, substituteValue, true);
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent event, Object substituteValue, boolean initialize, int bucketId) throws IOException {
        this(operation, event, substituteValue, initialize);
        this.bucketId = bucketId;
    }

    public GatewaySenderEventImpl(EnumListenerEvent operation, CacheEvent event, Object substituteValue, boolean initialize) throws IOException {
        this.operation = operation;
        this.entryEvent = (EntryEventImpl)event;
        this.substituteValue = substituteValue;
        this.region = this.entryEvent.getRegion();
        this.regionPath = this.region.getFullPath();
        this.initializeId();
        this.possibleDuplicate = this.entryEvent.isPossibleDuplicate();
        this.isAcked = false;
        this.isDispatched = false;
        this.creationTime = System.currentTimeMillis();
        if (this.entryEvent.getVersionTag() != null) {
            this.versionTimeStamp = this.entryEvent.getVersionTag().getVersionTimeStamp();
        }
        if (initialize) {
            this.initialize();
        }
    }

    public int getAction() {
        return this.action;
    }

    @Override
    public Operation getOperation() {
        Operation op = null;
        block0 : switch (this.action) {
            case 0: {
                switch (this.operationDetail) {
                    case 11: {
                        op = Operation.LOCAL_LOAD_CREATE;
                        break block0;
                    }
                    case 12: {
                        op = Operation.NET_LOAD_CREATE;
                        break block0;
                    }
                    case 13: {
                        op = Operation.PUTALL_CREATE;
                        break block0;
                    }
                    case 10: {
                        op = Operation.CREATE;
                        break block0;
                    }
                }
                op = Operation.CREATE;
                break;
            }
            case 1: {
                switch (this.operationDetail) {
                    case 11: {
                        op = Operation.LOCAL_LOAD_UPDATE;
                        break block0;
                    }
                    case 12: {
                        op = Operation.NET_LOAD_UPDATE;
                        break block0;
                    }
                    case 13: {
                        op = Operation.PUTALL_UPDATE;
                        break block0;
                    }
                    case 10: {
                        op = Operation.UPDATE;
                        break block0;
                    }
                }
                op = Operation.UPDATE;
                break;
            }
            case 2: {
                if (this.operationDetail == 14) {
                    op = Operation.REMOVEALL_DESTROY;
                    break;
                }
                op = Operation.DESTROY;
                break;
            }
            case 3: {
                op = Operation.UPDATE_VERSION_STAMP;
            }
        }
        return op;
    }

    public EntryEvent getEntryEvent() {
        return this.entryEvent;
    }

    public Object getSubstituteValue() {
        return this.substituteValue;
    }

    public EnumListenerEvent getEnumListenerEvent() {
        return this.operation;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public Object getKey() {
        return this.key == TOKEN_UN_INITIALIZED ? null : this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte getValueIsObject() {
        return this.valueIsObject;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.getSenderCallbackArgument();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    public GatewaySenderEventCallbackArgument getSenderCallbackArgument() {
        return this.callbackArgument;
    }

    public int getNumberOfParts() {
        return this.numberOfParts;
    }

    @Override
    public Object getDeserializedValue() {
        isDeserializingValue.set(Boolean.TRUE);
        Object obj = this.deserialize(this.value);
        isDeserializingValue.set(Boolean.FALSE);
        return obj;
    }

    @Override
    public byte[] getSerializedValue() {
        return this.value;
    }

    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this.possibleDuplicate = possibleDuplicate;
    }

    @Override
    public boolean getPossibleDuplicate() {
        return this.possibleDuplicate;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getDSFID() {
        return -134;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.key == TOKEN_UN_INITIALIZED) {
            this.initialize();
        }
        out.writeShort(17);
        out.writeInt(this.action);
        out.writeInt(this.numberOfParts);
        DataSerializer.writeObject(this.id, out);
        DataSerializer.writeString(this.regionPath, out);
        out.writeByte(this.valueIsObject);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeByteArray(this.value, out);
        DataSerializer.writeObject(this.callbackArgument, out);
        out.writeBoolean(this.possibleDuplicate);
        out.writeLong(this.creationTime);
        out.writeInt(this.bucketId);
        out.writeLong(this.shadowKey);
        out.writeLong(this.getVersionTimeStamp());
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        short version = in.readShort();
        if (version != 17) {
            // empty if block
        }
        this.action = in.readInt();
        this.numberOfParts = in.readInt();
        if (version < 17 && in instanceof InputStream && InternalDataSerializer.getVersionForDataStream(in) == Version.CURRENT) {
            in = new VersionedDataInputStream((InputStream)((Object)in), Version.GFE_701);
        }
        this.id = (EventID)DataSerializer.readObject(in);
        this.regionPath = DataSerializer.readString(in);
        this.valueIsObject = in.readByte();
        this.key = DataSerializer.readObject(in);
        this.value = DataSerializer.readByteArray(in);
        this.callbackArgument = (GatewaySenderEventCallbackArgument)DataSerializer.readObject(in);
        this.possibleDuplicate = in.readBoolean();
        this.creationTime = in.readLong();
        this.bucketId = in.readInt();
        this.shadowKey = in.readLong();
        this.versionTimeStamp = in.readLong();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SenderEventImpl[").append("id=").append(this.id).append(";action=").append(this.action).append(";operation=").append(this.getOperation()).append(";region=").append(this.regionPath).append(";key=").append(this.key).append(";value=").append(this.deserialize(this.value)).append(";valueIsObject=").append(this.valueIsObject).append(";numberOfParts=").append(this.numberOfParts).append(";callbackArgument=").append(this.callbackArgument).append(";possibleDuplicate=").append(this.possibleDuplicate).append(";creationTime=").append(this.creationTime).append(";shadowKey= ").append(this.shadowKey).append(";timeStamp=").append(this.versionTimeStamp).append(";acked=").append(this.isAcked).append(";dispatched=").append(this.isDispatched).append("]");
        return buffer.toString();
    }

    public static boolean isSerializingValue() {
        return (Boolean)isSerializingValue.get();
    }

    public static boolean isDeserializingValue() {
        return (Boolean)isDeserializingValue.get();
    }

    public Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try {
            deserializedObject = this.valueIsObject == 0 ? serializedBytes : (Object)EntryEventImpl.deserialize(serializedBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    @Override
    public boolean shouldBeConflated() {
        return this.isUpdate();
    }

    @Override
    public String getRegionToConflate() {
        return this.regionPath;
    }

    @Override
    public Object getKeyToConflate() {
        return this.key;
    }

    @Override
    public Object getValueToConflate() {
        return this.value;
    }

    @Override
    public void setLatestValue(Object value2) {
        this.value = (byte[])value2;
    }

    protected boolean isUpdate() {
        return this.operation == null ? this.action == 1 : this.operation == EnumListenerEvent.AFTER_UPDATE;
    }

    protected boolean isCreate() {
        return this.operation == null ? this.action == 0 : this.operation == EnumListenerEvent.AFTER_CREATE;
    }

    protected boolean isDestroy() {
        return this.operation == null ? this.action == 2 : this.operation == EnumListenerEvent.AFTER_DESTROY;
    }

    private void initializeId() {
        this.id = this.entryEvent.getEventId();
        if (this.id == null) {
            throw new IllegalStateException(LocalizedStrings.GatewayEventImpl_NO_EVENT_ID_IS_AVAILABLE_FOR_THIS_GATEWAY_EVENT.toLocalizedString());
        }
    }

    public void initialize() throws IOException {
        if (this.key != TOKEN_UN_INITIALIZED) {
            return;
        }
        this.key = this.entryEvent.getKey();
        if (this.substituteValue == null) {
            this.valueIsObject = 1;
            SerializedCacheValue<?> serializedNewValue = this.entryEvent.getSerializedNewValue();
            if (serializedNewValue == null) {
                if (this.entryEvent.getCachedSerializedNewValue() != null) {
                    this.value = this.entryEvent.getCachedSerializedNewValue();
                } else {
                    Object newValue = this.entryEvent.getRawNewValue();
                    if (newValue instanceof byte[]) {
                        this.value = (byte[])newValue;
                        this.valueIsObject = 0;
                    } else {
                        isSerializingValue.set(Boolean.TRUE);
                        this.value = CacheServerHelper.serialize(newValue);
                        isSerializingValue.set(Boolean.FALSE);
                        this.entryEvent.setCachedSerializedNewValue(this.value);
                    }
                }
            } else {
                this.value = serializedNewValue.getSerializedValue();
            }
        } else if (this.substituteValue instanceof byte[]) {
            this.value = (byte[])this.substituteValue;
            this.valueIsObject = 0;
        } else if (this.substituteValue == TOKEN_NULL) {
            this.value = null;
            this.valueIsObject = 1;
        } else {
            isSerializingValue.set(Boolean.TRUE);
            this.value = CacheServerHelper.serialize(this.substituteValue);
            isSerializingValue.set(Boolean.FALSE);
            this.entryEvent.setCachedSerializedNewValue(this.value);
            this.valueIsObject = 1;
        }
        Object eventCallbackArg = this.entryEvent.getRawCallbackArgument();
        this.callbackArgument = eventCallbackArg instanceof GatewayEventCallbackArgument ? (GatewaySenderEventCallbackArgument)((GatewayEventCallbackArgument)eventCallbackArg).getOriginalCallbackArg() : (GatewaySenderEventCallbackArgument)this.entryEvent.getRawCallbackArgument();
        this.initializeAction(this.operation);
        this.initializeOperationDetail(this.entryEvent.getOperation());
        this.setShadowKey(this.entryEvent.getTailKey());
        this.entryEvent = null;
    }

    protected void initializeAction(EnumListenerEvent operation) {
        if (operation == EnumListenerEvent.AFTER_CREATE) {
            this.action = 0;
            this.numberOfParts = this.callbackArgument == null ? 8 : 9;
        } else if (operation == EnumListenerEvent.AFTER_UPDATE) {
            this.action = 1;
            this.numberOfParts = this.callbackArgument == null ? 8 : 9;
        } else if (operation == EnumListenerEvent.AFTER_DESTROY) {
            this.action = 2;
            this.numberOfParts = this.callbackArgument == null ? 7 : 8;
        } else if (operation == EnumListenerEvent.TIMESTAMP_UPDATE) {
            this.action = 3;
            this.numberOfParts = this.callbackArgument == null ? 7 : 8;
        }
    }

    private void initializeOperationDetail(Operation operation) {
        this.operationDetail = operation.isLocalLoad() ? 11 : (operation.isNetLoad() ? 12 : (operation.isPutAll() ? 13 : (operation.isRemoveAll() ? 14 : 10)));
    }

    @Override
    public EventID getEventId() {
        return this.id;
    }

    @Override
    public EventSequenceID getEventSequenceID() {
        return new EventSequenceID(this.id.getMembershipID(), this.id.getThreadID(), this.id.getSequenceID());
    }

    public long getVersionTimeStamp() {
        return this.versionTimeStamp;
    }

    @Override
    public int getSizeInBytes() {
        int size2 = 0;
        size2 += 8;
        size2 += 28;
        size2 += 30;
        size2 += 64;
        if (this.value != null) {
            size2 += CachedDeserializableFactory.calcMemSize(this.value);
        }
        size2 += 202;
        size2 += 8 + this.sizeOf(this.getCallbackArgument());
        return size2 += 8;
    }

    private int sizeOf(Object obj) {
        int size2 = 0;
        if (obj == null) {
            return size2;
        }
        size2 = obj instanceof String ? ObjectSizer.DEFAULT.sizeof(obj) : (obj instanceof Integer ? 4 : (obj instanceof Long ? 8 : CachedDeserializableFactory.calcMemSize(obj) - 8));
        return size2;
    }

    @Override
    public Region<?, ?> getRegion() {
        return this.region != null ? this.region : CacheFactory.getAnyInstance().getRegion(this.regionPath);
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setShadowKey(Long tailKey) {
        this.shadowKey = tailKey;
    }

    public Long getShadowKey() {
        return this.shadowKey;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

