/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueStats;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorDiscovery;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorResponse;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.GatewayCancelledException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GatewayEventFilter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HasCachePerfStats;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.org.jgroups.stack.tcpserver.TcpClient;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGatewaySender
implements GatewaySender,
DistributionAdvisee {
    private static final Logger logger = LogService.getLogger();
    protected final Cache cache;
    protected final String id;
    protected long startTime;
    protected PoolImpl proxy;
    protected final int remoteDSId;
    protected String locName;
    protected final int socketBufferSize;
    protected final int socketReadTimeout;
    protected final int queueMemory;
    protected final int maxMemoryPerDispatcherQueue;
    protected final int batchSize;
    protected final int batchTimeInterval;
    protected boolean isConflation;
    protected final boolean isPersistence;
    protected final int alertThreshold;
    protected final boolean manualStart;
    protected final boolean isParallel;
    protected final boolean isForInternalUse;
    protected final boolean isDiskSynchronous;
    protected final String diskStoreName;
    protected List<com.gemstone.gemfire.cache.wan.GatewayEventFilter> eventFilters;
    protected List<GatewayTransportFilter> transFilters;
    protected List<AsyncEventListener> listeners;
    protected GatewayEventSubstitutionFilter substitutionFilter;
    protected LocatorDiscoveryCallback locatorDiscoveryCallback;
    public final ReentrantReadWriteLock lifeCycleLock = new ReentrantReadWriteLock();
    protected GatewaySenderAdvisor senderAdvisor;
    private int serialNumber;
    private GatewaySenderStats statistics;
    private Stopper stopper;
    private Gateway.OrderPolicy policy;
    private int dispatcherThreads;
    protected boolean isBucketSorted;
    private int parallelismForReplicatedRegion;
    protected AbstractGatewaySenderEventProcessor eventProcessor;
    private GatewayEventFilter filter = DefaultGatewayEventFilter.getInstance();
    private ServerLocation serverLocation;
    protected final Object queuedEventsSync = new Object();
    protected volatile boolean enqueuedAllTempQueueEvents = false;
    protected volatile ConcurrentLinkedQueue<GatewaySenderEventImpl> tmpQueuedEvents = new ConcurrentLinkedQueue();
    public static int MAXIMUM_SHUTDOWN_WAIT_TIME = Integer.getInteger("GatewaySender.MAXIMUM_SHUTDOWN_WAIT_TIME", 0);
    protected static final int MAXIMUM_SHUTDOWN_PEEKS = Integer.getInteger("GatewaySender.MAXIMUM_SHUTDOWN_PEEKS", 20);
    public static final int QUEUE_SIZE_THRESHOLD = Integer.getInteger("GatewaySender.QUEUE_SIZE_THRESHOLD", 5000);
    public static int TOKEN_TIMEOUT = Integer.getInteger("GatewaySender.TOKEN_TIMEOUT", 15000);
    public static final String LOCK_SERVICE_NAME = "gatewayEventIdIndexMetaData_lockService";
    protected static final String META_DATA_REGION_NAME = "gatewayEventIdIndexMetaData";
    protected int myDSId = -1;
    private int connectionIdleTimeOut = GATEWAY_CONNECTION_IDLE_TIMEOUT;
    private boolean removeFromQueueOnException = GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION;
    private int proxyFailureTries = 0;
    private int eventIdIndex;
    private Region<String, Integer> eventIdIndexMetaDataRegion;

    protected AbstractGatewaySender(Cache cache, GatewaySenderAttributes attrs) {
        this.cache = cache;
        this.id = attrs.getId();
        this.socketBufferSize = attrs.getSocketBufferSize();
        this.socketReadTimeout = attrs.getSocketReadTimeout();
        this.queueMemory = attrs.getMaximumQueueMemory();
        this.batchSize = attrs.getBatchSize();
        this.batchTimeInterval = attrs.getBatchTimeInterval();
        this.isConflation = attrs.isBatchConflationEnabled();
        this.isPersistence = attrs.isPersistenceEnabled();
        this.alertThreshold = attrs.getAlertThreshold();
        this.manualStart = attrs.isManualStart();
        this.isParallel = attrs.isParallel();
        this.isForInternalUse = attrs.isForInternalUse();
        this.diskStoreName = attrs.getDiskStoreName();
        this.remoteDSId = attrs.getRemoteDSId();
        this.eventFilters = attrs.getGatewayEventFilters();
        this.transFilters = attrs.getGatewayTransportFilters();
        this.listeners = attrs.getAsyncEventListeners();
        this.substitutionFilter = attrs.getGatewayEventSubstitutionFilter();
        this.locatorDiscoveryCallback = attrs.getGatewayLocatoDiscoveryCallback();
        this.isDiskSynchronous = attrs.isDiskSynchronous();
        this.policy = attrs.getOrderPolicy();
        this.dispatcherThreads = attrs.getDispatcherThreads();
        this.parallelismForReplicatedRegion = attrs.getParallelismForReplicatedRegion();
        this.maxMemoryPerDispatcherQueue = this.queueMemory / this.dispatcherThreads;
        this.myDSId = InternalDistributedSystem.getAnyInstance().getDistributionManager().getDistributedSystemId();
        this.serialNumber = DistributionAdvisor.createSerialNumber();
        if (!(this.cache instanceof CacheCreation)) {
            this.stopper = new Stopper(cache.getCancelCriterion());
            this.senderAdvisor = GatewaySenderAdvisor.createGatewaySenderAdvisor(this);
            this.statistics = !this.isForInternalUse() ? new GatewaySenderStats(cache.getDistributedSystem(), this.id) : new AsyncEventQueueStats(cache.getDistributedSystem(), AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.id));
            this.initializeEventIdIndex();
        }
        this.isBucketSorted = attrs.isBucketSorted();
    }

    public GatewaySenderAdvisor getSenderAdvisor() {
        return this.senderAdvisor;
    }

    public GatewaySenderStats getStatistics() {
        return this.statistics;
    }

    public synchronized void initProxy() {
        if (this.remoteDSId == -1 || this.proxy != null && !this.proxy.isDestroyed()) {
            return;
        }
        Properties props = new Properties();
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.setPRSingleHopEnabled(false);
        if (this.locatorDiscoveryCallback != null) {
            pf.setLocatorDiscoveryCallback(this.locatorDiscoveryCallback);
        }
        pf.setReadTimeout(this.socketReadTimeout);
        pf.setIdleTimeout(this.connectionIdleTimeOut);
        pf.setSocketBufferSize(this.socketBufferSize);
        pf.setServerGroup("__recv__group");
        RemoteLocatorRequest request = new RemoteLocatorRequest(this.remoteDSId, pf.getPoolAttributes().getServerGroup());
        String locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators();
        if (logger.isDebugEnabled()) {
            logger.debug("Gateway Sender is attempting to configure pool with remote locator information");
        }
        StringTokenizer locatorsOnThisVM = new StringTokenizer(locators, ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            String localLocator = locatorsOnThisVM.nextToken();
            DistributionLocatorId locatorID = new DistributionLocatorId(localLocator);
            try {
                RemoteLocatorResponse response = (RemoteLocatorResponse)TcpClient.requestToServer(locatorID.getHost(), locatorID.getPort(), request, LocatorDiscovery.WAN_LOCATOR_CONNECTION_TIMEOUT);
                if (response == null) continue;
                if (response.getLocators() == null) {
                    if (!this.logProxyFailure()) continue;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_REMOTE_LOCATOR_FOR_REMOTE_SITE_0_IS_NOT_AVAILABLE_IN_LOCAL_LOCATOR_1, new Object[]{this.remoteDSId, localLocator}));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Received the remote site {} location information:", this.remoteDSId, response.getLocators());
                }
                StringBuffer strBuffer = new StringBuffer();
                Iterator<String> itr = response.getLocators().iterator();
                while (itr.hasNext()) {
                    strBuffer.append(itr.next()).append(",");
                }
                strBuffer = strBuffer.deleteCharAt(strBuffer.length() - 1);
                props.setProperty("locators", strBuffer.toString());
                break;
            }
            catch (IOException ioe2) {
                Throwable ioe2;
                if (!this.logProxyFailure()) continue;
                String ioeStr = "";
                if (!logger.isDebugEnabled() && ioe2 instanceof ConnectException) {
                    ioeStr = ": " + ioe2.toString();
                    ioe2 = null;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_SENDER_0_IS_NOT_ABLE_TO_CONNECT_TO_LOCAL_LOCATOR_1, new Object[]{this.id, localLocator + ioeStr}), ioe2);
            }
            catch (ClassNotFoundException e) {
                if (!this.logProxyFailure()) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_SENDER_0_IS_NOT_ABLE_TO_CONNECT_TO_LOCAL_LOCATOR_1, new Object[]{this.id, localLocator}), (Throwable)e);
            }
        }
        if (props.isEmpty()) {
            if (this.logProxyFailure()) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_SENDER_0_COULD_NOT_GET_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1, new Object[]{this.id, this.remoteDSId}));
            }
            ++this.proxyFailureTries;
            throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_SENDER_0_COULD_NOT_GET_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1.toLocalizedString(this.id, this.remoteDSId));
        }
        pf.init(props, false, true, this);
        this.proxy = (PoolImpl)pf.create(this.getId());
        if (this.proxyFailureTries > 0) {
            logger.info(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_SENDER_0_GOT_REMOTE_LOCATOR_INFORMATION_FOR_SITE_1, new Object[]{this.id, this.remoteDSId, this.proxyFailureTries}));
            this.proxyFailureTries = 0;
        }
    }

    public boolean isPrimary() {
        return this.getSenderAdvisor().isPrimary();
    }

    public void setIsPrimary(boolean isPrimary) {
        this.getSenderAdvisor().setIsPrimary(isPrimary);
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public int getAlertThreshold() {
        return this.alertThreshold;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public List<com.gemstone.gemfire.cache.wan.GatewayEventFilter> getGatewayEventFilters() {
        return this.eventFilters;
    }

    @Override
    public GatewayEventSubstitutionFilter getGatewayEventSubstitutionFilter() {
        return this.substitutionFilter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getRemoteDSId() {
        return this.remoteDSId;
    }

    @Override
    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.transFilters;
    }

    public List<AsyncEventListener> getAsyncEventListeners() {
        return this.listeners;
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public boolean isManualStart() {
        return this.manualStart;
    }

    @Override
    public int getMaximumQueueMemory() {
        return this.queueMemory;
    }

    public int getMaximumMemeoryPerDispatcherQueue() {
        return this.maxMemoryPerDispatcherQueue;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public int getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    @Override
    public boolean isBatchConflationEnabled() {
        return this.isConflation;
    }

    public void test_setBatchConflationEnabled(boolean enableConflation) {
        this.isConflation = enableConflation;
    }

    @Override
    public boolean isPersistenceEnabled() {
        return this.isPersistence;
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.isDiskSynchronous;
    }

    @Override
    public int getMaxParallelismForReplicatedRegion() {
        return this.parallelismForReplicatedRegion;
    }

    public LocatorDiscoveryCallback getLocatorDiscoveryCallback() {
        return this.locatorDiscoveryCallback;
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.senderAdvisor;
    }

    @Override
    public DM getDistributionManager() {
        return this.getSystem().getDistributionManager();
    }

    @Override
    public String getFullPath() {
        return this.getId();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public int getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    @Override
    public Gateway.OrderPolicy getOrderPolicy() {
        return this.policy;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.senderAdvisor.createProfile();
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    public boolean getBucketSorted() {
        return this.isBucketSorted;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return (InternalDistributedSystem)this.cache.getDistributedSystem();
    }

    public int getEventIdIndex() {
        return this.eventIdIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GatewaySender)) {
            return false;
        }
        AbstractGatewaySender sender = (AbstractGatewaySender)obj;
        return sender.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public PoolImpl getProxy() {
        return this.proxy;
    }

    @Override
    public void removeGatewayEventFilter(com.gemstone.gemfire.cache.wan.GatewayEventFilter filter) {
        this.eventFilters.remove(filter);
    }

    @Override
    public void addGatewayEventFilter(com.gemstone.gemfire.cache.wan.GatewayEventFilter filter) {
        if (this.eventFilters.isEmpty()) {
            this.eventFilters = new ArrayList<com.gemstone.gemfire.cache.wan.GatewayEventFilter>();
        }
        if (filter == null) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderImpl_NULL_CANNNOT_BE_ADDED_TO_GATEWAY_EVENT_FILTER_LIST.toLocalizedString());
        }
        this.eventFilters.add(filter);
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    public boolean isForInternalUse() {
        return this.isForInternalUse;
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block11: {
            try {
                this.lifeCycleLock.writeLock().lock();
                Set<LocalRegion> regions = ((GemFireCacheImpl)this.cache).getApplicationRegions();
                for (LocalRegion region : regions) {
                    if (!region.getAttributes().getGatewaySenderIds().contains(this.id)) continue;
                    throw new GatewaySenderException(LocalizedStrings.GatewaySender_COULD_NOT_DESTROY_SENDER_AS_IT_IS_STILL_IN_USE.toLocalizedString(this));
                }
                GatewaySenderAdvisor advisor = this.getSenderAdvisor();
                if (advisor != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Stopping the GatewaySender advisor");
                    }
                    advisor.close();
                }
                ((GemFireCacheImpl)this.cache).removeGatewaySender(this);
                Set<RegionQueue> regionQueues = this.getQueues();
                if (regionQueues == null) break block11;
                for (RegionQueue regionQueue : regionQueues) {
                    try {
                        if (regionQueue instanceof ConcurrentParallelGatewaySenderQueue) {
                            Set<PartitionedRegion> queueRegions = ((ConcurrentParallelGatewaySenderQueue)regionQueue).getRegions();
                            for (PartitionedRegion queueRegion : queueRegions) {
                                queueRegion.destroyRegion();
                            }
                            continue;
                        }
                        regionQueue.getRegion().localDestroyRegion();
                    }
                    catch (RegionDestroyedException e) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.AbstractGatewaySender_REGION_0_UNDERLYING_GATEWAYSENDER_1_IS_ALREADY_DESTROYED, new Object[]{e.getRegionFullPath(), this}));
                    }
                }
            }
            finally {
                this.lifeCycleLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebalance() {
        try {
            this.pause();
            if (this.eventProcessor != null) {
                this.eventProcessor.rebalance();
            }
        }
        finally {
            this.resume();
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_0_HAS_BEEN_REBALANCED, this));
    }

    public boolean beforeEnque(GatewayQueueEvent gatewayEvent) {
        boolean enque = true;
        for (com.gemstone.gemfire.cache.wan.GatewayEventFilter filter : this.getGatewayEventFilters()) {
            enque = filter.beforeEnqueue(gatewayEvent);
            if (enque) continue;
            return enque;
        }
        return enque;
    }

    protected void stompProxyDead() {
        Runnable stomper = new Runnable(){

            @Override
            public void run() {
                PoolImpl bpi = AbstractGatewaySender.this.proxy;
                if (bpi != null) {
                    try {
                        bpi.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        LoggingThreadGroup tg = LoggingThreadGroup.createThreadGroup("Proxy Stomper Group", logger);
        Thread t = new Thread(tg, stomper, "GatewaySender Proxy Stomper");
        t.setDaemon(true);
        t.start();
        try {
            t.join(GATEWAY_SENDER_TIMEOUT * 1000L);
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_0_IS_NOT_CLOSING_CLEANLY_FORCING_CANCELLATION, this));
            t.interrupt();
            this.proxy.emergencyClose();
            this.proxy = null;
            return;
        }
    }

    public int getMyDSId() {
        return this.myDSId;
    }

    public void setRemoveFromQueueOnException(boolean removeFromQueueOnException) {
        this.removeFromQueueOnException = removeFromQueueOnException;
    }

    public boolean isRemoveFromQueueOnException() {
        return this.removeFromQueueOnException;
    }

    public CancelCriterion getStopper() {
        return this.stopper;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public synchronized ServerLocation getServerLocation() {
        return this.serverLocation;
    }

    public synchronized boolean setServerLocation(ServerLocation location) {
        this.serverLocation = location;
        return true;
    }

    public final Set<RegionQueue> getQueues() {
        if (this.eventProcessor != null) {
            if (!(this.eventProcessor instanceof ConcurrentSerialGatewaySenderEventProcessor)) {
                HashSet<RegionQueue> queues = new HashSet<RegionQueue>();
                queues.add(this.eventProcessor.getQueue());
                return queues;
            }
            return ((ConcurrentSerialGatewaySenderEventProcessor)this.eventProcessor).getQueues();
        }
        return null;
    }

    public final Set<RegionQueue> getQueuesForConcurrentSerialGatewaySender() {
        if (this.eventProcessor != null && this.eventProcessor instanceof ConcurrentSerialGatewaySenderEventProcessor) {
            return ((ConcurrentSerialGatewaySenderEventProcessor)this.eventProcessor).getQueues();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForRunningStatus() {
        Object object = this.eventProcessor.runningStateLock;
        synchronized (object) {
            while (this.eventProcessor.getException() == null && this.eventProcessor.isStopped()) {
                try {
                    this.eventProcessor.runningStateLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            Exception ex = this.eventProcessor.getException();
            if (ex != null) {
                throw new GatewaySenderException(LocalizedStrings.Sender_COULD_NOT_START_GATEWAYSENDER_0_BECAUSE_OF_EXCEPTION_1.toLocalizedString(this.getId(), ex.getMessage()), ex.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void pause() {
        if (this.eventProcessor != null) {
            this.lifeCycleLock.writeLock().lock();
            try {
                if (this.eventProcessor.isStopped()) {
                    return;
                }
                this.eventProcessor.pauseDispatching();
                InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
                system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_PAUSE, this);
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewaySender_PAUSED__0, this));
                this.enqueTempEvents();
            }
            finally {
                this.lifeCycleLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resume() {
        if (this.eventProcessor != null) {
            this.lifeCycleLock.writeLock().lock();
            try {
                if (this.eventProcessor.isStopped()) {
                    return;
                }
                this.eventProcessor.resumeDispatching();
                InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
                system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_RESUME, this);
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewaySender_RESUMED__0, this));
                this.enqueTempEvents();
            }
            finally {
                this.lifeCycleLock.writeLock().unlock();
            }
        }
    }

    @Override
    public final boolean isPaused() {
        if (this.eventProcessor != null) {
            return this.eventProcessor.isPaused();
        }
        return false;
    }

    @Override
    public final boolean isRunning() {
        if (this.eventProcessor != null) {
            return !this.eventProcessor.isStopped();
        }
        return false;
    }

    public final AbstractGatewaySenderEventProcessor getEventProcessor() {
        return this.eventProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(EnumListenerEvent operation, EntryEventImpl event, List<Integer> allRemoteDSIds) {
        Object geCallbackArg;
        boolean isDebugEnabled = logger.isDebugEnabled();
        GatewaySenderStats stats = this.getStatistics();
        stats.incEventsReceived();
        if (event.getOperation().isExpiration() || event.getRegion().getDataPolicy().equals(DataPolicy.NORMAL)) {
            this.getStatistics().incEventsNotQueued();
            return;
        }
        if (!this.filter.enqueueEvent(event)) {
            this.getStatistics().incEventsFiltered();
            return;
        }
        EntryEventImpl clonedEvent = new EntryEventImpl(event);
        this.setModifiedEventId(clonedEvent);
        Object callbackArg = clonedEvent.getRawCallbackArgument();
        if (isDebugEnabled) {
            logger.debug("{} : About to notify {} to perform operation {} for {} callback arg {}", this.isPrimary(), this.getId(), operation, clonedEvent, callbackArg);
        }
        if (callbackArg instanceof GatewayEventCallbackArgument) {
            GatewayEventCallbackArgument geca = (GatewayEventCallbackArgument)callbackArg;
            if (isDebugEnabled) {
                logger.debug("{}: Received event from 6.6 gateway: {}. Determining whether it should be distributed to {}.", this, geca, this.getId());
            }
            if (geca.getOriginatingGatewayHubId() != null && geca.getOriginatingGatewayHubId().equals(this.getId())) {
                if (isDebugEnabled) {
                    logger.debug("{}: Event originated in {}. It is bering dropped", this, this.getId());
                }
                return;
            }
            if (geca.getRecipientGateways() != null && geca.getRecipientGateways().contains(this.getId())) {
                if (isDebugEnabled) {
                    logger.debug("{}: Event has already been sent to {}. It is being dropped.", this, this.getId());
                }
                return;
            }
            callbackArg = ((GatewayEventCallbackArgument)callbackArg).getOriginalCallbackArg();
        }
        if (callbackArg instanceof GatewaySenderEventCallbackArgument) {
            GatewaySenderEventCallbackArgument seca = (GatewaySenderEventCallbackArgument)callbackArg;
            if (isDebugEnabled) {
                logger.debug("{}: Event originated in {}. My DS id is {}. The remote DS id is {}. The recipients are: {}", this, seca.getOriginatingDSId(), this.getMyDSId(), this.getRemoteDSId(), seca.getRecipientDSIds());
            }
            if (seca.getOriginatingDSId() == -1) {
                if (isDebugEnabled) {
                    logger.debug("{}: Event originated in {}. My DS id is {}. The remote DS id is {}. The recipients are: {}", this, seca.getOriginatingDSId(), this.getMyDSId(), this.getRemoteDSId(), seca.getRecipientDSIds());
                }
                seca.setOriginatingDSId(this.getMyDSId());
                seca.initializeReceipientDSIds(allRemoteDSIds);
            } else {
                if (this.getEventProcessor() != null && !(this.getEventProcessor().getDispatcher() instanceof GatewaySenderEventCallbackDispatcher)) {
                    if (seca.getOriginatingDSId() == this.getRemoteDSId()) {
                        if (isDebugEnabled) {
                            logger.debug("{}: Event originated in {}. My DS id is {}. It is being dropped as remote is originator.", this, seca.getOriginatingDSId(), this.getMyDSId());
                        }
                        return;
                    }
                    if (seca.getRecipientDSIds().contains(this.getRemoteDSId())) {
                        if (isDebugEnabled) {
                            logger.debug("{}: Event originated in {}. My DS id is {}. The remote DS id is {}.. It is being dropped as remote ds is already a recipient. Recipients are: {}", this, seca.getOriginatingDSId(), this.getMyDSId(), this.getRemoteDSId(), seca.getRecipientDSIds());
                        }
                        return;
                    }
                }
                seca.getRecipientDSIds().addAll(allRemoteDSIds);
            }
        } else {
            geCallbackArg = new GatewaySenderEventCallbackArgument(callbackArg, this.getMyDSId(), allRemoteDSIds, true);
            clonedEvent.setCallbackArgument(geCallbackArg);
        }
        if (!this.lifeCycleLock.readLock().tryLock()) {
            try {
                geCallbackArg = this.queuedEventsSync;
                synchronized (geCallbackArg) {
                    if (!this.enqueuedAllTempQueueEvents && !this.lifeCycleLock.readLock().tryLock()) {
                        Object substituteValue = this.getSubstituteValue(clonedEvent, operation);
                        GatewaySenderEventImpl senderEvent = new GatewaySenderEventImpl(operation, clonedEvent, substituteValue, false);
                        if (isDebugEnabled) {
                            logger.debug("Event : {} is added to TempQueue", clonedEvent);
                        }
                        this.tmpQueuedEvents.add(senderEvent);
                        stats.incTempQueueSize();
                        return;
                    }
                }
            }
            catch (IOException e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, clonedEvent}), (Throwable)e);
                return;
            }
            if (this.enqueuedAllTempQueueEvents) {
                this.lifeCycleLock.readLock().lock();
            }
        }
        try {
            if (!this.isRunning()) {
                if (isDebugEnabled) {
                    logger.debug("Returning back without putting into the gateway sender queue");
                }
                return;
            }
            try {
                AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
                if (ev == null) {
                    this.getStopper().checkCancelInProgress(null);
                    this.getCache().getDistributedSystem().getCancelCriterion().checkCancelInProgress(null);
                    if (ev == null) {
                        throw new GatewayCancelledException("Event processor thread is gone");
                    }
                }
                Object substituteValue = this.getSubstituteValue(clonedEvent, operation);
                ev.enqueueEvent(operation, clonedEvent, substituteValue);
            }
            catch (CancelException e) {
                logger.debug("caught cancel exception", (Throwable)e);
            }
            catch (RegionDestroyedException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, clonedEvent}), (Throwable)e);
            }
            catch (Exception e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, clonedEvent}), (Throwable)e);
            }
        }
        finally {
            this.lifeCycleLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueTempEvents() {
        if (this.eventProcessor != null) {
            GatewaySenderEventImpl nextEvent = null;
            GatewaySenderStats stats = this.getStatistics();
            try {
                Object object = this.queuedEventsSync;
                synchronized (object) {
                    while ((nextEvent = this.tmpQueuedEvents.poll()) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Event :{} is enqueued to GatewaySenderQueue from TempQueue", nextEvent);
                        }
                        stats.decTempQueueSize();
                        this.eventProcessor.enqueueEvent(nextEvent.getEnumListenerEvent(), nextEvent.getEntryEvent(), nextEvent.getSubstituteValue());
                    }
                    this.enqueuedAllTempQueueEvents = true;
                }
            }
            catch (CacheException e) {
                logger.debug("caught cancel exception", (Throwable)e);
            }
            catch (IOException e) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), nextEvent.getEnumListenerEvent(), nextEvent}), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromTempQueueEvents(Object tailKey) {
        Object object = this.queuedEventsSync;
        synchronized (object) {
            Iterator<GatewaySenderEventImpl> itr = this.tmpQueuedEvents.iterator();
            while (itr.hasNext()) {
                GatewaySenderEventImpl event = itr.next();
                if (!tailKey.equals(((EntryEventImpl)event.getEntryEvent()).getTailKey())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("shadowKey {} is found in tmpQueueEvents at AbstractGatewaySender level. Removing from there..", tailKey);
                }
                itr.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTempEventsAfterSenderStopped() {
        this.tmpQueuedEvents.clear();
        Object object = this.queuedEventsSync;
        synchronized (object) {
            this.tmpQueuedEvents.clear();
            this.enqueuedAllTempQueueEvents = false;
        }
    }

    public void checkLicense() throws LicenseException {
        LicenseChecker licenseChecker;
        if (!this.isForInternalUse() && (licenseChecker = ((InternalDistributedSystem)this.cache.getDistributedSystem()).getLicenseChecker()) != null) {
            licenseChecker.checkWanEnabled();
        }
    }

    public Object getSubstituteValue(EntryEventImpl clonedEvent, EnumListenerEvent operation) {
        Object substituteValue = null;
        if (this.substitutionFilter != null) {
            try {
                substituteValue = this.substitutionFilter.getSubstituteValue(clonedEvent);
                if (substituteValue == null) {
                    substituteValue = GatewaySenderEventImpl.TOKEN_NULL;
                }
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_AN_EXCEPTION_OCCURRED_WHILE_QUEUEING_1_TO_PERFORM_OPERATION_2_FOR_3, new Object[]{this, this.getId(), operation, clonedEvent}), (Throwable)e);
            }
        }
        return substituteValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeEventIdIndex() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean gotLock = false;
        try {
            gotLock = ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().lock(META_DATA_REGION_NAME, -1L, -1L);
            if (!gotLock) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_FAILED_TO_LOCK_META_REGION_0.toLocalizedString(this));
            }
            if (isDebugEnabled) {
                logger.debug("{}: Locked the metadata region", this);
            }
            Region<String, Integer> region = this.getEventIdIndexMetaDataRegion();
            int index2 = 0;
            String messagePrefix = null;
            if (region.containsKey(this.getId())) {
                index2 = region.get(this.getId());
                if (isDebugEnabled) {
                    messagePrefix = "Using existing";
                }
            } else {
                index2 = region.size();
                region.put(this.getId(), index2);
                if (isDebugEnabled) {
                    messagePrefix = "Created new";
                }
            }
            this.eventIdIndex = index2;
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} event id index: {}", this, messagePrefix, this.eventIdIndex);
            }
            if (!gotLock) return;
        }
        catch (Throwable throwable) {
            if (!gotLock) throw throwable;
            ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().unlock(META_DATA_REGION_NAME);
            if (!isDebugEnabled) throw throwable;
            logger.debug("{}: Unlocked the metadata region", this);
            throw throwable;
        }
        ((GemFireCacheImpl)this.getCache()).getGatewaySenderLockService().unlock(META_DATA_REGION_NAME);
        if (!isDebugEnabled) return;
        logger.debug("{}: Unlocked the metadata region", this);
    }

    private Region<String, Integer> getEventIdIndexMetaDataRegion() {
        if (this.eventIdIndexMetaDataRegion == null) {
            this.eventIdIndexMetaDataRegion = AbstractGatewaySender.initializeEventIdIndexMetaDataRegion(this);
        }
        return this.eventIdIndexMetaDataRegion;
    }

    private static synchronized Region<String, Integer> initializeEventIdIndexMetaDataRegion(AbstractGatewaySender sender) {
        final Cache cache = sender.getCache();
        Region<String, Integer> region = cache.getRegion(META_DATA_REGION_NAME);
        if (region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes ra = factory.create();
            HasCachePerfStats statsHolder = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(cache.getDistributedSystem(), AbstractGatewaySender.META_DATA_REGION_NAME);
                }
            };
            InternalRegionArguments ira = new InternalRegionArguments().setIsUsedForMetaRegion(true).setCachePerfStatsHolder(statsHolder);
            try {
                region = ((GemFireCacheImpl)cache).createVMRegion(META_DATA_REGION_NAME, ra, ira);
            }
            catch (RegionExistsException e) {
                region = cache.getRegion(META_DATA_REGION_NAME);
            }
            catch (Exception e) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_META_REGION_CREATION_EXCEPTION_0.toLocalizedString(sender), e);
            }
        }
        return region;
    }

    protected abstract void setModifiedEventId(EntryEventImpl var1);

    public int getTmpQueuedEventSize() {
        if (this.tmpQueuedEvents != null) {
            return this.tmpQueuedEvents.size();
        }
        return 0;
    }

    protected boolean logProxyFailure() {
        assert (Thread.holdsLock(this));
        if (logger.isDebugEnabled() || this.proxyFailureTries == 0) {
            return true;
        }
        if (this.proxyFailureTries >= 3000) {
            return this.proxyFailureTries % 3000 == 0;
        }
        return this.proxyFailureTries == 30 || this.proxyFailureTries == 300;
    }

    public void setEnqueuedAllTempQueueEvents(boolean enqueuedAllTempQueueEvents) {
        this.enqueuedAllTempQueueEvents = enqueuedAllTempQueueEvents;
    }

    protected boolean isAsyncEventQueue() {
        return this.getAsyncEventListeners() != null && !this.getAsyncEventListeners().isEmpty();
    }

    public static class DefaultGatewayEventFilter
    implements GatewayEventFilter {
        private static final DefaultGatewayEventFilter singleton = new DefaultGatewayEventFilter();

        private DefaultGatewayEventFilter() {
        }

        public static GatewayEventFilter getInstance() {
            return singleton;
        }

        @Override
        public boolean enqueueEvent(EntryEventImpl event) {
            return true;
        }
    }

    private class Stopper
    extends CancelCriterion {
        final CancelCriterion stper;

        Stopper(CancelCriterion stopper) {
            this.stper = stopper;
        }

        @Override
        public String cancelInProgress() {
            return this.stper.cancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            RuntimeException result = this.stper.generateCancelledException(e);
            return result;
        }
    }
}

