/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.versions;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class DiskRegionVersionVector
extends RegionVersionVector<DiskStoreID> {
    public DiskRegionVersionVector() {
    }

    public DiskRegionVersionVector(DiskStoreID ownerId, LocalRegion owner) {
        super(ownerId, owner);
    }

    public DiskRegionVersionVector(DiskStoreID ownerId) {
        super(ownerId);
    }

    @Override
    public void recordVersion(DiskStoreID member, long version) {
        super.recordVersion(member, version);
    }

    @Override
    public void recordGCVersion(DiskStoreID mbr, long regionVersion) {
        super.recordGCVersion(mbr, regionVersion);
    }

    public DiskRegionVersionVector(DiskStoreID ownerId, ConcurrentHashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> vector, long version, ConcurrentHashMap<DiskStoreID, Long> gcVersions, long gcVersion, boolean singleMember, RegionVersionHolder<DiskStoreID> localExceptions) {
        super(ownerId, vector, version, gcVersions, gcVersion, singleMember, localExceptions);
    }

    @Override
    protected RegionVersionVector<DiskStoreID> createCopy(DiskStoreID ownerId, ConcurrentHashMap<DiskStoreID, RegionVersionHolder<DiskStoreID>> vector, long version, ConcurrentHashMap<DiskStoreID, Long> gcVersions, long gcVersion, boolean singleMember, RegionVersionHolder<DiskStoreID> localExceptions) {
        return new DiskRegionVersionVector(ownerId, vector, version, gcVersions, gcVersion, singleMember, localExceptions);
    }

    @Override
    protected void writeMember(DiskStoreID member, DataOutput out) throws IOException {
        out.writeLong(member.getMostSignificantBits());
        out.writeLong(member.getLeastSignificantBits());
    }

    @Override
    protected DiskStoreID readMember(DataInput in) throws IOException {
        long mostSignificantBits = in.readLong();
        long leastSignificantBits = in.readLong();
        DiskStoreID member = new DiskStoreID(mostSignificantBits, leastSignificantBits);
        return member;
    }

    @Override
    public int getDSFID() {
        return 2132;
    }
}

