/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.versions;

import com.gemstone.gemfire.internal.cache.versions.VersionHolder;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;

public class CompactVersionHolder<T extends VersionSource>
implements VersionHolder<T> {
    private final T memberID;
    private final short entryVersionLowBytes;
    private final short regionVersionHighBytes;
    private final int regionVersionLowBytes;
    private final byte entryVersionHighByte;
    private final byte distributedSystemId;
    private final long versionTimeStamp;

    public CompactVersionHolder(VersionHolder<T> tag) {
        int eVersion = tag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = tag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = tag.getRegionVersionLowBytes();
        this.versionTimeStamp = tag.getVersionTimeStamp();
        this.distributedSystemId = (byte)(tag.getDistributedSystemId() & 0xFF);
        this.memberID = tag.getMemberID();
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.versionTimeStamp;
    }

    @Override
    public T getMemberID() {
        return this.memberID;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberID);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{v").append(this.getEntryVersion());
        s.append("; rv").append(this.getRegionVersion());
        if (this.memberID != null) {
            s.append("; mbr=").append(this.memberID);
        }
        if (this.distributedSystemId >= 0) {
            s.append("; ds=").append(this.distributedSystemId);
        }
        s.append("; time=").append(this.getVersionTimeStamp());
        s.append("}");
        return s.toString();
    }
}

