/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tx;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketNotFoundException;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.TXStateStub;
import com.gemstone.gemfire.internal.cache.partitioned.PutAllPRMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RemoteSizeMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.tx.AbstractPeerTXRegionStub;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PartitionedTXRegionStub
extends AbstractPeerTXRegionStub {
    private Map<Integer, Boolean> buckets = new HashMap<Integer, Boolean>();

    public PartitionedTXRegionStub(TXStateStub txstate, LocalRegion r) {
        super(txstate, r);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        try {
            pr2.destroyRemotely(this.state.getTarget(), event.getKeyInfo().getBucketId(), event, expectedOldValue);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
    }

    private RuntimeException getTransactionException(KeyInfo keyInfo, Throwable cause) {
        Throwable ex;
        this.region.getCancelCriterion().checkCancelInProgress(cause);
        for (ex = cause; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof CacheClosedException)) continue;
            return new TransactionDataNodeHasDepartedException(ex.getMessage());
        }
        if (keyInfo != null && !this.buckets.isEmpty() && !this.buckets.containsKey(keyInfo.getBucketId())) {
            return new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(keyInfo.getKey()));
        }
        for (ex = cause; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof PrimaryBucketException)) continue;
            return new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
        }
        return new TransactionDataNodeHasDepartedException(cause.getLocalizedMessage());
    }

    private void waitToRetry() {
        new PartitionedRegion.RetryTimeKeeper(2000).waitForBucketsRecovery();
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, boolean allowTombstones) {
        PartitionedRegion pr2 = (PartitionedRegion)this.region;
        try {
            EntrySnapshot e = pr2.getEntryRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey(), false, allowTombstones);
            this.trackBucketForTx(keyInfo);
            return e;
        }
        catch (EntryNotFoundException enfe) {
            return null;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
    }

    private void trackBucketForTx(KeyInfo keyInfo) {
        if (this.region.getCache().getLoggerI18n().fineEnabled()) {
            this.region.getCache().getLoggerI18n().fine("adding bucket:" + keyInfo.getBucketId() + " for tx:" + this.state.getTransactionId());
        }
        if (keyInfo.getBucketId() >= 0) {
            this.buckets.put(keyInfo.getBucketId(), Boolean.TRUE);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        PartitionedRegion pr2 = (PartitionedRegion)event.getLocalRegion();
        try {
            pr2.invalidateRemotely(this.state.getTarget(), event.getKeyInfo().getBucketId(), event);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            TransactionException re = this.isBucketNotFoundException(e) ? new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString()) : new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            this.waitToRetry();
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        PartitionedRegion pr2 = (PartitionedRegion)this.region;
        try {
            boolean retVal = pr2.containsKeyRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey());
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                return false;
            }
            this.waitToRetry();
            TransactionDataNodeHasDepartedException re = new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            throw re;
        }
    }

    private boolean isBucketNotFoundException(ForceReattemptException e) {
        ForceReattemptException fre = e;
        while (fre.getCause() != null && fre.getCause() instanceof ForceReattemptException) {
            fre = (ForceReattemptException)fre.getCause();
        }
        return fre instanceof BucketNotFoundException;
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        PartitionedRegion pr2 = (PartitionedRegion)this.region;
        try {
            boolean retVal = pr2.containsValueForKeyRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), keyInfo.getKey());
            this.trackBucketForTx(keyInfo);
            return retVal;
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                return false;
            }
            this.waitToRetry();
            TransactionDataNodeHasDepartedException re = new TransactionDataNodeHasDepartedException(LocalizedStrings.PartitionedRegion_TRANSACTION_DATA_NODE_0_HAS_DEPARTED_TO_PROCEED_ROLLBACK_THIS_TRANSACTION_AND_BEGIN_A_NEW_ONE.toLocalizedString(this.state.getTarget()));
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value2, boolean peferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent) {
        Object retVal = null;
        Object key2 = keyInfo.getKey();
        Object callbackArgument = keyInfo.getCallbackArg();
        PartitionedRegion pr2 = (PartitionedRegion)this.region;
        try {
            retVal = pr2.getRemotely((InternalDistributedMember)this.state.getTarget(), keyInfo.getBucketId(), key2, callbackArgument, peferCD, requestingClient, clientEvent, false);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            if (this.isBucketNotFoundException(e)) {
                return null;
            }
            this.waitToRetry();
            RuntimeException re = this.getTransactionException(keyInfo, e);
            re.initCause(e);
            throw re;
        }
        this.trackBucketForTx(keyInfo);
        return retVal;
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstones) {
        PartitionedRegion pr2 = (PartitionedRegion)this.region;
        InternalDistributedMember primary = pr2.getBucketPrimary(keyInfo.getBucketId());
        if (primary.equals(this.state.getTarget())) {
            return this.getEntry(keyInfo, allowTombstones);
        }
        return pr2.getSharedDataView().getEntry(keyInfo, pr2, allowTombstones);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        boolean retVal = false;
        LocalRegion r = event.getLocalRegion();
        PartitionedRegion pr2 = (PartitionedRegion)r;
        try {
            retVal = pr2.putRemotely(this.state.getTarget(), event, ifNew, ifOld, expectedOldValue, requireOldValue);
        }
        catch (TransactionException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e.getCause());
            throw re;
        }
        catch (PrimaryBucketException e) {
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        catch (ForceReattemptException e) {
            this.waitToRetry();
            RuntimeException re = this.getTransactionException(event.getKeyInfo(), e);
            re.initCause(e);
            throw re;
        }
        this.trackBucketForTx(event.getKeyInfo());
        return retVal;
    }

    @Override
    public int entryCount() {
        try {
            RemoteSizeMessage.SizeResponse response = RemoteSizeMessage.send(Collections.singleton(this.state.getTarget()), this.region);
            return response.waitForSize();
        }
        catch (Exception e) {
            throw this.getTransactionException(null, e);
        }
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallO, VersionedObjectList successfulPuts, LocalRegion r) throws TransactionException {
        if (r.getCache().isCacheAtShutdownAll()) {
            throw new CacheClosedException("Cache is shutting down");
        }
        PartitionedRegion pr2 = (PartitionedRegion)r;
        long startTime = PartitionedRegionStats.startTime();
        HashMap prMsgMap = putallO.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(putallO.putAllDataSize);
        successfulPuts.clear();
        for (Map.Entry mapEntry : prMsgMap.entrySet()) {
            Integer bucketId = (Integer)mapEntry.getKey();
            PutAllPRMessage prMsg = (PutAllPRMessage)mapEntry.getValue();
            pr2.checkReadiness();
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg, pr2);
                partialKeys.addKeysAndVersions(versions);
                successfulPuts.addAll(versions);
            }
            catch (PutAllPartialResultException pre) {
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                EntryEventImpl firstEvent = prMsg.getFirstEvent(pr2);
                partialKeys.saveFailedKey(firstEvent.getKey(), ex);
            }
        }
        pr2.prStats.endPutAll(startTime);
        if (partialKeys.hasFailure()) {
            pr2.getCache().getLoggerI18n().info(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{pr2.getFullPath(), partialKeys});
            if (putallO.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion r) {
        if (r.getCache().isCacheAtShutdownAll()) {
            throw new CacheClosedException("Cache is shutting down");
        }
        PartitionedRegion pr2 = (PartitionedRegion)r;
        long startTime = PartitionedRegionStats.startTime();
        HashMap<Integer, RemoveAllPRMessage> prMsgMap = op.createPRMessages();
        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(op.removeAllDataSize);
        successfulOps.clear();
        for (Map.Entry<Integer, RemoveAllPRMessage> mapEntry : prMsgMap.entrySet()) {
            Integer bucketId = mapEntry.getKey();
            RemoveAllPRMessage prMsg = mapEntry.getValue();
            pr2.checkReadiness();
            try {
                VersionedObjectList versions = this.sendMsgByBucket(bucketId, prMsg, pr2);
                partialKeys.addKeysAndVersions(versions);
                successfulOps.addAll(versions);
            }
            catch (PutAllPartialResultException pre) {
                partialKeys.consolidate(pre.getResult());
            }
            catch (Exception ex) {
                EntryEventImpl firstEvent = prMsg.getFirstEvent(pr2);
                partialKeys.saveFailedKey(firstEvent.getKey(), ex);
            }
        }
        pr2.prStats.endRemoveAll(startTime);
        if (partialKeys.hasFailure()) {
            pr2.getCache().getLoggerI18n().info(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_0_1, new Object[]{pr2.getFullPath(), partialKeys});
            if (op.isBridgeOperation()) {
                if (partialKeys.getFailure() instanceof CancelException) {
                    throw (CancelException)partialKeys.getFailure();
                }
                throw new PutAllPartialResultException(partialKeys);
            }
            if (partialKeys.getFailure() instanceof RuntimeException) {
                throw (RuntimeException)partialKeys.getFailure();
            }
            throw new RuntimeException(partialKeys.getFailure());
        }
    }

    private VersionedObjectList sendMsgByBucket(Integer bucketId, PutAllPRMessage prMsg, PartitionedRegion pr2) {
        InternalDistributedMember currentTarget = pr2.getOrCreateNodeForBucketWrite(bucketId, null);
        if (!currentTarget.equals(this.state.getTarget())) {
            EntryEventImpl firstEvent = prMsg.getFirstEvent(pr2);
            throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(firstEvent.getKey()));
        }
        try {
            return pr2.tryToSendOnePutAllMessage(prMsg, currentTarget);
        }
        catch (ForceReattemptException prce) {
            pr2.checkReadiness();
            throw new TransactionDataNotColocatedException(prce.getMessage());
        }
        catch (PrimaryBucketException notPrimary) {
            TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
            re.initCause(notPrimary);
            throw re;
        }
        catch (DataLocationException dle) {
            throw new TransactionException(dle);
        }
    }

    private VersionedObjectList sendMsgByBucket(Integer bucketId, RemoveAllPRMessage prMsg, PartitionedRegion pr2) {
        InternalDistributedMember currentTarget = pr2.getOrCreateNodeForBucketWrite(bucketId, null);
        if (!currentTarget.equals(this.state.getTarget())) {
            EntryEventImpl firstEvent = prMsg.getFirstEvent(pr2);
            throw new TransactionDataNotColocatedException(LocalizedStrings.PartitionedRegion_KEY_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(firstEvent.getKey()));
        }
        try {
            return pr2.tryToSendOneRemoveAllMessage(prMsg, currentTarget);
        }
        catch (ForceReattemptException prce) {
            pr2.checkReadiness();
            throw new TransactionDataNotColocatedException(prce.getMessage());
        }
        catch (PrimaryBucketException notPrimary) {
            TransactionDataRebalancedException re = new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TRANSACTIONAL_DATA_MOVED_DUE_TO_REBALANCING.toLocalizedString());
            re.initCause(notPrimary);
            throw re;
        }
        catch (DataLocationException dle) {
            throw new TransactionException(dle);
        }
    }

    @Override
    public void cleanup() {
    }
}

