/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tx;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.internal.ServerRegionDataAccess;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXLockRequest;
import com.gemstone.gemfire.internal.cache.TXRegionLockRequestImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TXStateStub;
import com.gemstone.gemfire.internal.cache.locks.TXRegionLockRequest;
import com.gemstone.gemfire.internal.cache.tx.ClientTXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.TXRegionStub;
import com.gemstone.gemfire.internal.cache.tx.TransactionalOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class ClientTXStateStub
extends TXStateStub {
    private static final Logger logger = LogService.getLogger();
    private static ThreadLocal<List<TransactionalOperation>> recordedTransactionalOperations = null;
    private final ServerRegionProxy firstProxy;
    private ServerLocation serverAffinityLocation;
    private List<TransactionalOperation> recordedOperations = Collections.synchronizedList(new LinkedList());
    private TXLockRequest lockReq;
    private Runnable internalAfterLocalLocks;
    private static final boolean DISABLE_CONFLICT_CHECK_ON_CLIENT = Boolean.getBoolean("gemfire.disableConflictChecksOnClient");

    public static boolean transactionRecordingEnabled() {
        return !DISABLE_CONFLICT_CHECK_ON_CLIENT || recordedTransactionalOperations != null;
    }

    public static void setTransactionalOperationContainer(ThreadLocal<List<TransactionalOperation>> t) {
        recordedTransactionalOperations = t;
    }

    public ClientTXStateStub(TXStateProxy stateProxy, DistributedMember target, LocalRegion firstRegion) {
        super(stateProxy, target);
        this.firstProxy = firstRegion.getServerProxy();
        this.firstProxy.getPool().setupServerAffinity(true);
        if (recordedTransactionalOperations != null) {
            recordedTransactionalOperations.set(this.recordedOperations);
        }
    }

    @Override
    public void commit() throws CommitConflictException {
        this.obtainLocalLocks();
        try {
            TXCommitMessage txcm = this.firstProxy.commit(this.proxy.getTxId().getUniqId());
            this.afterServerCommit(txcm);
        }
        catch (TransactionDataNodeHasDepartedException e) {
            throw new TransactionInDoubtException(e);
        }
        finally {
            this.lockReq.releaseLocal();
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    private void obtainLocalLocks() {
        this.lockReq = new TXLockRequest();
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting("");
        for (TransactionalOperation txOp : this.recordedOperations) {
            if (!TransactionalOperation.ServerRegionOperation.lockKeyForTx(txOp.getOperation())) continue;
            TXRegionLockRequest rlr = this.lockReq.getRegionLockRequest(txOp.getRegionName());
            if (rlr == null) {
                rlr = new TXRegionLockRequestImpl(cache.getRegionByPath(txOp.getRegionName()));
                this.lockReq.addLocalRequest(rlr);
            }
            if (txOp.getOperation() == TransactionalOperation.ServerRegionOperation.PUT_ALL || txOp.getOperation() == TransactionalOperation.ServerRegionOperation.REMOVE_ALL) {
                rlr.addEntryKeys(txOp.getKeys());
                continue;
            }
            rlr.addEntryKey(txOp.getKey());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TX: client localLockRequest: {}", this.lockReq);
        }
        try {
            this.lockReq.obtain();
        }
        catch (CommitConflictException e) {
            this.rollback();
            throw e;
        }
        if (this.internalAfterLocalLocks != null) {
            this.internalAfterLocalLocks.run();
        }
    }

    private void afterServerCommit(TXCommitMessage txcm) {
        GemFireCacheImpl cache;
        if (this.internalAfterSendCommit != null) {
            this.internalAfterSendCommit.run();
        }
        if ((cache = GemFireCacheImpl.getInstance()) == null) {
            return;
        }
        cache.getCancelCriterion().checkCancelInProgress(null);
        InternalDistributedSystem ds = cache.getDistributedSystem();
        DM dm = ds.getDistributionManager();
        txcm.setDM(dm);
        txcm.setAckRequired(false);
        txcm.setDisableListeners(true);
        cache.getTxManager().setTXState(null);
        txcm.hookupRegions(dm);
        txcm.basicProcess();
    }

    @Override
    protected TXRegionStub generateRegionStub(LocalRegion region) {
        return new ClientTXRegionStub(region);
    }

    @Override
    protected void validateRegionCanJoinTransaction(LocalRegion region) throws TransactionException {
        if (!region.hasServerProxy()) {
            throw new TransactionException("Region " + region.getName() + " is local to this client and cannot be used in a transaction.");
        }
        if (this.firstProxy != null && this.firstProxy.getPool() != region.getServerProxy().getPool()) {
            throw new TransactionException("Region " + region.getName() + " is using a different server pool than other regions in this transaction.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        if (this.internalAfterSendRollback != null) {
            this.internalAfterSendRollback.run();
        }
        try {
            this.firstProxy.rollback(this.proxy.getTxId().getUniqId());
        }
        finally {
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCompletion(int status) {
        try {
            TXCommitMessage txcm = this.firstProxy.afterCompletion(status, this.proxy.getTxId().getUniqId());
            if (status == 3) {
                if (txcm == null) {
                    throw new TransactionInDoubtException(LocalizedStrings.ClientTXStateStub_COMMIT_FAILED_ON_SERVER.toLocalizedString());
                }
                this.afterServerCommit(txcm);
            } else if (status == 4) {
                if (this.internalAfterSendRollback != null) {
                    this.internalAfterSendRollback.run();
                }
                this.firstProxy.getPool().releaseServerAffinity();
            }
        }
        finally {
            if (status == 3) {
                this.lockReq.releaseLocal();
            }
            this.firstProxy.getPool().releaseServerAffinity();
        }
    }

    @Override
    public void beforeCompletion() {
        this.obtainLocalLocks();
        this.firstProxy.beforeCompletion(this.proxy.getTxId().getUniqId());
    }

    @Override
    public InternalDistributedMember getOriginatingMember() {
        return null;
    }

    @Override
    public boolean isMemberIdForwardingRequired() {
        return false;
    }

    @Override
    public TXCommitMessage getCommitMessage() {
        return null;
    }

    @Override
    public void suspend() {
        this.serverAffinityLocation = this.firstProxy.getPool().getServerAffinityLocation();
        this.firstProxy.getPool().releaseServerAffinity();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: suspending transaction: {} server delegate: {}", this.getTransactionId(), this.serverAffinityLocation);
        }
    }

    @Override
    public void resume() {
        this.firstProxy.getPool().setupServerAffinity(true);
        this.firstProxy.getPool().setServerAffinityLocation(this.serverAffinityLocation);
        if (logger.isDebugEnabled()) {
            logger.debug("TX: resuming transaction: {} server delegate: {}", this.getTransactionId(), this.serverAffinityLocation);
        }
    }

    @Override
    public void recordTXOperation(ServerRegionDataAccess region, TransactionalOperation.ServerRegionOperation op, Object key2, Object[] arguments) {
        if (ClientTXStateStub.transactionRecordingEnabled()) {
            this.recordedOperations.add(new TransactionalOperation(this, region.getRegionName(), op, key2, arguments));
        }
    }

    public void setAfterLocalLocks(Runnable afterLocalLocks) {
        this.internalAfterLocalLocks = afterLocalLocks;
    }
}

