/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tx;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionDataNotColocatedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateStub;
import com.gemstone.gemfire.internal.cache.partitioned.RemoteFetchKeysMessage;
import com.gemstone.gemfire.internal.cache.tx.TXRegionStub;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Set;

public abstract class AbstractPeerTXRegionStub
implements TXRegionStub {
    protected final TXStateStub state;
    protected final LocalRegion region;

    public AbstractPeerTXRegionStub(TXStateStub txstate, LocalRegion r) {
        this.state = txstate;
        this.region = r;
    }

    @Override
    public Set getRegionKeysForIteration(LocalRegion currRegion) {
        try {
            RemoteFetchKeysMessage.FetchKeysResponse response = RemoteFetchKeysMessage.send(currRegion, this.state.getTarget());
            return response.waitForKeys();
        }
        catch (RegionDestroyedException e) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(e.getRegionFullPath()), e);
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }
}

