/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;

public class Size
extends BaseCommand {
    private static final Size singleton = new Size();

    public static Command getCommand() {
        return singleton;
    }

    private Size() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Object keyPart = null;
        Object callbackArgPart = null;
        String regionName = null;
        Object eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadSizeRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        if (regionName == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL, "size"));
            errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("size"));
            Size.writeErrorResponse(msg, 82, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.BaseCommand__0_WAS_NOT_FOUND_DURING_1_REQUEST.toLocalizedString(regionName, "size");
                Size.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                try {
                    Size.writeSizeResponse(region.size(), msg, servConn);
                    servConn.setAsTrue(1);
                }
                catch (RegionDestroyedException rde) {
                    block15: {
                        Size.writeException(msg, rde, false, servConn);
                        servConn.setAsTrue(1);
                        if (!logger.isDebugEnabled()) break block15;
                        logger.debug("{}: Sent size response for region {}", servConn.getName(), regionName);
                    }
                    stats.incWriteSizeResponseTime(DistributionStats.getStatTime() - start);
                    return;
                }
                catch (Exception e) {
                    block16: {
                        Size.checkForInterrupt(servConn, e);
                        Size.writeException(msg, e, false, servConn);
                        servConn.setAsTrue(1);
                        if (e instanceof GemFireSecurityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{}: Unexpected Security exception", servConn.getName(), e);
                            }
                        } else {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                        }
                        servConn.setAsTrue(1);
                        if (!logger.isDebugEnabled()) break block16;
                        {
                            catch (Throwable throwable) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("{}: Sent size response for region {}", servConn.getName(), regionName);
                                }
                                stats.incWriteSizeResponseTime(DistributionStats.getStatTime() - start);
                                throw throwable;
                            }
                        }
                        logger.debug("{}: Sent size response for region {}", servConn.getName(), regionName);
                    }
                    stats.incWriteSizeResponseTime(DistributionStats.getStatTime() - start);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent size response for region {}", servConn.getName(), regionName);
                }
                stats.incWriteSizeResponseTime(DistributionStats.getStatTime() - start);
                return;
            }
        }
    }

    private static void writeSizeResponse(Integer sizeCount, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.addObjPart(sizeCount);
        responseMsg.send(servConn, origMsg.getTransactionId());
    }
}

